/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcArrayLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcEnumLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcRealLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcStructLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcFuncApplStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcReturnStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcSelectionStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;

public class ModelTextGenerator {
    public String toString(PlcExpression expr) {
        return this.toString(expr, FuncApplPreference.PREFER_INFIX);
    }

    public String toString(PlcExpression expr, FuncApplPreference funcApplPreference) {
        StringBuilder textBuilder = new StringBuilder();
        this.toText(expr, textBuilder, funcApplPreference);
        return textBuilder.toString();
    }

    private void toText(PlcExpression expr, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        this.toText(expr, textBuilder, PlcBasicFuncDescription.ExprBinding.NO_PRIORITY, false, false, funcApplPreference);
    }

    /*
     * WARNING - void declaration
     */
    private void toText(PlcExpression expr, StringBuilder textBuilder, PlcBasicFuncDescription.ExprBinding parentBinding, boolean atParentLeft, boolean atParentRight, FuncApplPreference funcApplPreference) {
        PlcExpression plcExpression = expr;
        if (plcExpression instanceof PlcBoolLiteral) {
            void boolLit;
            PlcBoolLiteral plcBoolLiteral = (PlcBoolLiteral)plcExpression;
            PlcBoolLiteral cfr_ignored_0 = (PlcBoolLiteral)plcExpression;
            this.toText((PlcBoolLiteral)boolLit, textBuilder);
        } else {
            PlcExpression plcExpression2 = expr;
            if (plcExpression2 instanceof PlcIntLiteral) {
                void intLit;
                PlcIntLiteral plcIntLiteral = (PlcIntLiteral)plcExpression2;
                PlcIntLiteral cfr_ignored_1 = (PlcIntLiteral)plcExpression2;
                this.toText((PlcIntLiteral)intLit, textBuilder);
            } else {
                PlcExpression plcExpression3 = expr;
                if (plcExpression3 instanceof PlcRealLiteral) {
                    void realLit;
                    PlcRealLiteral plcRealLiteral = (PlcRealLiteral)plcExpression3;
                    PlcRealLiteral cfr_ignored_2 = (PlcRealLiteral)plcExpression3;
                    this.toText((PlcRealLiteral)realLit, textBuilder);
                } else {
                    PlcExpression plcExpression4 = expr;
                    if (plcExpression4 instanceof PlcEnumLiteral) {
                        void enumLit;
                        PlcEnumLiteral plcEnumLiteral = (PlcEnumLiteral)plcExpression4;
                        PlcEnumLiteral cfr_ignored_3 = (PlcEnumLiteral)plcExpression4;
                        this.toText((PlcEnumLiteral)enumLit, textBuilder);
                    } else {
                        PlcExpression plcExpression5 = expr;
                        if (plcExpression5 instanceof PlcArrayLiteral) {
                            void arrayLit;
                            PlcArrayLiteral plcArrayLiteral = (PlcArrayLiteral)plcExpression5;
                            PlcArrayLiteral cfr_ignored_4 = (PlcArrayLiteral)plcExpression5;
                            this.toText((PlcArrayLiteral)arrayLit, textBuilder, funcApplPreference);
                        } else {
                            PlcExpression plcExpression6 = expr;
                            if (plcExpression6 instanceof PlcStructLiteral) {
                                void structLit;
                                PlcStructLiteral plcStructLiteral = (PlcStructLiteral)plcExpression6;
                                PlcStructLiteral cfr_ignored_5 = (PlcStructLiteral)plcExpression6;
                                this.toText((PlcStructLiteral)structLit, textBuilder, funcApplPreference);
                            } else {
                                PlcExpression plcExpression7 = expr;
                                if (plcExpression7 instanceof PlcFuncAppl) {
                                    void funcAppl;
                                    PlcFuncAppl plcFuncAppl = (PlcFuncAppl)plcExpression7;
                                    PlcFuncAppl cfr_ignored_6 = (PlcFuncAppl)plcExpression7;
                                    this.toText((PlcFuncAppl)funcAppl, textBuilder, parentBinding, atParentLeft, atParentRight, funcApplPreference);
                                } else {
                                    PlcExpression plcExpression8 = expr;
                                    if (plcExpression8 instanceof PlcVarExpression) {
                                        void varExpr;
                                        PlcVarExpression plcVarExpression = (PlcVarExpression)plcExpression8;
                                        PlcVarExpression cfr_ignored_7 = (PlcVarExpression)plcExpression8;
                                        this.toText((PlcVarExpression)varExpr, textBuilder, funcApplPreference);
                                    } else {
                                        throw new AssertionError((Object)("Unexpected PLC expression \"" + expr + "\" found."));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void toText(PlcBoolLiteral boolLit, StringBuilder textBuilder) {
        textBuilder.append(boolLit.value ? "TRUE" : "FALSE");
    }

    private void toText(PlcIntLiteral intLit, StringBuilder textBuilder) {
        textBuilder.append(String.valueOf(intLit.value));
    }

    private void toText(PlcRealLiteral realLit, StringBuilder textBuilder) {
        String rslt = realLit.value;
        int idx = rslt.indexOf(46);
        if (idx == -1) {
            idx = rslt.indexOf(101);
            if (idx == -1 && (idx = rslt.indexOf(69)) == -1) {
                idx = rslt.length();
            }
            rslt = String.valueOf(rslt.substring(0, idx)) + ".0" + rslt.substring(idx);
        }
        textBuilder.append(rslt);
    }

    private void toText(PlcEnumLiteral enumLit, StringBuilder textBuilder) {
        textBuilder.append(enumLit.value);
    }

    private void toText(PlcArrayLiteral arrayLit, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append("[");
        boolean first = true;
        for (PlcExpression value : arrayLit.values) {
            if (!first) {
                textBuilder.append(", ");
            }
            first = false;
            this.toText(value, textBuilder, funcApplPreference);
        }
        textBuilder.append("]");
    }

    private void toText(PlcStructLiteral structLit, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append("(");
        boolean first = true;
        for (PlcNamedValue namedValue : structLit.values) {
            if (!first) {
                textBuilder.append(", ");
            }
            first = false;
            textBuilder.append(namedValue.name);
            textBuilder.append(" := ");
            this.toText(namedValue.value, textBuilder, funcApplPreference);
        }
        textBuilder.append(")");
    }

    private void toText(PlcFuncAppl funcAppl, StringBuilder textBuilder, PlcBasicFuncDescription.ExprBinding parentBinding, boolean atParentLeft, boolean atParentRight, FuncApplPreference funcApplPreference) {
        PlcBasicFuncDescription function = funcAppl.function;
        List<PlcNamedValue> arguments = funcAppl.arguments;
        if (funcApplPreference.equals((Object)FuncApplPreference.PREFER_INFIX) && function.infixFuncName != null) {
            boolean needsParentheses = function.infixBinding.needsParentheses(parentBinding, atParentLeft, atParentRight);
            textBuilder.append(needsParentheses ? "(" : "");
            int lastArgumentIndex = arguments.size() - 1;
            if (lastArgumentIndex == 0) {
                textBuilder.append(function.infixFuncName);
            }
            String infixString = " " + function.infixFuncName + " ";
            int i = 0;
            while (i <= lastArgumentIndex) {
                textBuilder.append(i > 0 ? infixString : "");
                this.toText(arguments.get((int)i).value, textBuilder, function.infixBinding, i == 0, i == lastArgumentIndex, FuncApplPreference.PREFER_INFIX);
                ++i;
            }
            textBuilder.append(needsParentheses ? ")" : "");
        } else {
            Assert.notNull((Object)function.prefixFuncName);
            textBuilder.append(function.prefixFuncName);
            textBuilder.append("(");
            boolean first = true;
            for (PlcNamedValue namedValue : arguments) {
                if (!first) {
                    textBuilder.append(", ");
                }
                first = false;
                PlcBasicFuncDescription.PlcParameterDescription paramDesc = function.prefixParameters.get(namedValue.name);
                Assert.notNull((Object)paramDesc, (Object)("Parameter name \"" + String.valueOf(namedValue.name) + "\" is not defined for function \"" + function.prefixFuncName + "\"'"));
                textBuilder.append(namedValue.name);
                textBuilder.append(paramDesc.direction == PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY ? " => " : " := ");
                this.toText(namedValue.value, textBuilder, FuncApplPreference.PREFER_INFIX);
            }
            textBuilder.append(")");
        }
    }

    private void toText(PlcVarExpression varExpr, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append(varExpr.variable.name);
        for (PlcVarExpression.PlcProjection proj : varExpr.projections) {
            this.toText(proj, textBuilder, funcApplPreference);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void toText(PlcVarExpression.PlcProjection proj, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        PlcVarExpression.PlcProjection plcProjection = proj;
        if (plcProjection instanceof PlcVarExpression.PlcStructProjection) {
            void structProj;
            PlcVarExpression.PlcStructProjection plcStructProjection = (PlcVarExpression.PlcStructProjection)plcProjection;
            PlcVarExpression.PlcStructProjection cfr_ignored_0 = (PlcVarExpression.PlcStructProjection)plcProjection;
            textBuilder.append(".");
            textBuilder.append(structProj.fieldName);
        } else {
            PlcVarExpression.PlcProjection plcProjection2 = proj;
            if (plcProjection2 instanceof PlcVarExpression.PlcArrayProjection) {
                void arrayProj;
                PlcVarExpression.PlcArrayProjection plcArrayProjection = (PlcVarExpression.PlcArrayProjection)plcProjection2;
                PlcVarExpression.PlcArrayProjection cfr_ignored_1 = (PlcVarExpression.PlcArrayProjection)plcProjection2;
                textBuilder.append('[');
                boolean first = true;
                for (PlcExpression indexExpr : arrayProj.indexExpressions) {
                    if (!first) {
                        textBuilder.append(", ");
                    }
                    first = false;
                    this.toText(indexExpr, textBuilder, funcApplPreference);
                }
                textBuilder.append(']');
            } else {
                throw new AssertionError((Object)("Unexpected PLC prjection \"" + proj + "\" found."));
            }
        }
    }

    public String toString(List<PlcStatement> plcStats, String pouName, boolean fixCodeBlcok) {
        MemoryCodeBox boxBuilder = new MemoryCodeBox();
        this.toText(plcStats, (CodeBox)boxBuilder, pouName, fixCodeBlcok);
        return boxBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void toText(List<PlcStatement> plcStats, CodeBox boxBuilder, String pouName, boolean fixCodeBlcok) {
        boolean foundStat = false;
        for (PlcStatement plcStat : plcStats) {
            this.toText(plcStat, boxBuilder, pouName);
            PlcStatement plcStatement = plcStat;
            if (plcStatement instanceof PlcCommentLine) {
                void cmtLine;
                PlcCommentLine cfr_ignored_0 = (PlcCommentLine)plcStatement;
                PlcCommentLine cfr_ignored_1 = (PlcCommentLine)plcStatement;
                if (!cmtLine.isEmptyStatement) continue;
            }
            foundStat = true;
        }
        if (!foundStat) {
            if (fixCodeBlcok) {
                this.toText(new PlcCommentLine("Nothing to do.", true), boxBuilder, pouName);
            } else {
                throw new AssertionError((Object)"Code block does not have a proper PLC statement.");
            }
        }
    }

    public String toString(PlcStatement plcStat, String pouName) {
        MemoryCodeBox boxBuilder = new MemoryCodeBox();
        this.toText(plcStat, (CodeBox)boxBuilder, pouName);
        return boxBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void toText(PlcStatement plcStat, CodeBox boxBuilder, String pouName) {
        PlcStatement plcStatement = plcStat;
        if (plcStatement instanceof PlcAssignmentStatement) {
            void asgStat;
            PlcAssignmentStatement plcAssignmentStatement = (PlcAssignmentStatement)plcStatement;
            PlcAssignmentStatement cfr_ignored_0 = (PlcAssignmentStatement)plcStatement;
            this.toText((PlcAssignmentStatement)asgStat, boxBuilder, pouName);
        } else {
            PlcStatement plcStatement2 = plcStat;
            if (plcStatement2 instanceof PlcCommentLine) {
                void cmtLine;
                PlcCommentLine plcCommentLine = (PlcCommentLine)plcStatement2;
                PlcCommentLine cfr_ignored_1 = (PlcCommentLine)plcStatement2;
                this.toText((PlcCommentLine)cmtLine, boxBuilder, pouName);
            } else {
                PlcStatement plcStatement3 = plcStat;
                if (plcStatement3 instanceof PlcReturnStatement) {
                    void retStat;
                    PlcReturnStatement plcReturnStatement = (PlcReturnStatement)plcStatement3;
                    PlcReturnStatement cfr_ignored_2 = (PlcReturnStatement)plcStatement3;
                    this.toText((PlcReturnStatement)retStat, boxBuilder, pouName);
                } else {
                    PlcStatement plcStatement4 = plcStat;
                    if (plcStatement4 instanceof PlcSelectionStatement) {
                        void selStat;
                        PlcSelectionStatement plcSelectionStatement = (PlcSelectionStatement)plcStatement4;
                        PlcSelectionStatement cfr_ignored_3 = (PlcSelectionStatement)plcStatement4;
                        this.toText((PlcSelectionStatement)selStat, boxBuilder, pouName);
                    } else {
                        PlcStatement plcStatement5 = plcStat;
                        if (plcStatement5 instanceof PlcFuncApplStatement) {
                            void funcApplStat;
                            PlcFuncApplStatement plcFuncApplStatement = (PlcFuncApplStatement)plcStatement5;
                            PlcFuncApplStatement cfr_ignored_4 = (PlcFuncApplStatement)plcStatement5;
                            this.toText((PlcFuncApplStatement)funcApplStat, boxBuilder, pouName);
                        } else {
                            throw new AssertionError((Object)("Unexpected PLC statement \"" + plcStat + "\" found."));
                        }
                    }
                }
            }
        }
    }

    private void toText(PlcAssignmentStatement asgStat, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("%s := %s;", new Object[]{this.toString(asgStat.lhs), this.toString(asgStat.value)});
    }

    private void toText(PlcCommentLine cmtLine, CodeBox boxBuilder, String pouName) {
        String emptyStat = cmtLine.isEmptyStatement ? " ;" : "";
        boxBuilder.add("(* %s *)%s", new Object[]{cmtLine.commentText, emptyStat});
    }

    private void toText(PlcFuncApplStatement funcApplStat, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("%s;", new Object[]{this.toString(funcApplStat.funcApplExpr, FuncApplPreference.OUTER_PREFIX)});
    }

    private void toText(PlcReturnStatement retStat, CodeBox boxBuilder, String pouName) {
        if (retStat.returnValue != null) {
            boxBuilder.add("%s := %s;", new Object[]{pouName, this.toString(retStat.returnValue)});
        }
        boxBuilder.add("RETURN;");
    }

    private void toText(PlcSelectionStatement selStat, CodeBox boxBuilder, String pouName) {
        if (selStat.condChoices.isEmpty()) {
            this.toText(selStat.elseStats, boxBuilder, pouName, true);
            return;
        }
        String testText = "IF";
        for (PlcSelectionStatement.PlcSelectChoice condChoice : selStat.condChoices) {
            boxBuilder.add("%s %s THEN", new Object[]{testText, this.toString(condChoice.guard)});
            testText = "ELSIF";
            boxBuilder.indent();
            this.toText(condChoice.thenStats, boxBuilder, pouName, true);
            boxBuilder.dedent();
        }
        if (!selStat.elseStats.isEmpty()) {
            boxBuilder.add("ELSE");
            boxBuilder.indent();
            this.toText(selStat.elseStats, boxBuilder, pouName, true);
            boxBuilder.dedent();
        }
        boxBuilder.add("END_IF;");
    }

    public static enum FuncApplPreference {
        PREFER_INFIX,
        OUTER_PREFIX;

    }
}

