/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcCastFunction;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.functions.PlcSemanticFuncDescription;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;

public class PlcFunctionAppls {
    private final PlcTarget target;
    private static final PlcBasicFuncDescription.PlcParameterDescription[] ONE_INPUT_PARAMETER = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("OUT", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY)};
    private static final PlcBasicFuncDescription.PlcParameterDescription[] TWO_INPUT_PARAMATERS = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN1", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("IN2", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("OUT", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY)};

    public PlcFunctionAppls(PlcTarget target) {
        this.target = target;
    }

    public PlcFuncAppl negateFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.NEGATE_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.NEGATE_OP, null, ONE_INPUT_PARAMETER, "-", PlcBasicFuncDescription.ExprBinding.UNARY_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl powerFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.POWER_OP));
        String infixText = this.target.supportsInfixNotation(PlcFuncOperation.POWER_OP) ? "**" : null;
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.POWER_OP, "EXPT", TWO_INPUT_PARAMATERS, infixText, PlcBasicFuncDescription.ExprBinding.POWER_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl multiplyFuncAppl(PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.MULTIPLY_OP));
        Assert.check((inN.length > 1 ? 1 : 0) != 0);
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.MULTIPLY_OP, "MUL", PlcFunctionAppls.makeParamList(inN.length), "*", PlcBasicFuncDescription.ExprBinding.MUL_EXPR);
        List<PlcNamedValue> arguments = IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + String.valueOf(i + 1), inN[i])).collect(Collectors.toList());
        return new PlcFuncAppl(func, arguments);
    }

    public PlcFuncAppl divideFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.DIVIDE_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.DIVIDE_OP, "DIV", TWO_INPUT_PARAMATERS, "/", PlcBasicFuncDescription.ExprBinding.MUL_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl moduloFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.MODULO_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.MODULO_OP, "MOD", TWO_INPUT_PARAMATERS, null, PlcBasicFuncDescription.ExprBinding.MUL_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl addFuncAppl(PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.ADD_OP));
        Assert.check((inN.length > 1 ? 1 : 0) != 0);
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.ADD_OP, "ADD", PlcFunctionAppls.makeParamList(inN.length), "+", PlcBasicFuncDescription.ExprBinding.ADD_EXPR);
        List<PlcNamedValue> arguments = IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + String.valueOf(i + 1), inN[i])).collect(Collectors.toList());
        return new PlcFuncAppl(func, arguments);
    }

    public PlcFuncAppl subtractFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.SUBTRACT_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.SUBTRACT_OP, "SUB", TWO_INPUT_PARAMATERS, "-", PlcBasicFuncDescription.ExprBinding.ADD_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl lessThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.LESS_THAN_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.LESS_THAN_OP, "LT", TWO_INPUT_PARAMATERS, "<", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl lessEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.LESS_EQUAL_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.LESS_EQUAL_OP, "LE", TWO_INPUT_PARAMATERS, "<=", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl greaterThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.GREATER_THAN_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.GREATER_THAN_OP, "GT", TWO_INPUT_PARAMATERS, ">", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl greaterEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.GREATER_EQUAL_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.GREATER_EQUAL_OP, "GE", TWO_INPUT_PARAMATERS, ">=", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl equalFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.EQUAL_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.EQUAL_OP, "EQ", TWO_INPUT_PARAMATERS, "=", PlcBasicFuncDescription.ExprBinding.EQUAL_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl unEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.UNEQUAL_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.UNEQUAL_OP, "NE", TWO_INPUT_PARAMATERS, "<>", PlcBasicFuncDescription.ExprBinding.EQUAL_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN1", in1), new PlcNamedValue("IN2", in2)));
    }

    public PlcFuncAppl complementFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.COMPLEMENT_OP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.COMPLEMENT_OP, "NOT", ONE_INPUT_PARAMETER, null, PlcBasicFuncDescription.ExprBinding.UNARY_EXPR);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl andFuncAppl(PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.AND_OP));
        Assert.check((inN.length > 1 ? 1 : 0) != 0);
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.AND_OP, "AND", PlcFunctionAppls.makeParamList(inN.length), "AND", PlcBasicFuncDescription.ExprBinding.CONJUNCT_EXPR);
        List<PlcNamedValue> arguments = IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + String.valueOf(i + 1), inN[i])).collect(Collectors.toList());
        return new PlcFuncAppl(func, arguments);
    }

    public PlcFuncAppl xorFuncAppl(PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.XOR_OP));
        Assert.check((inN.length > 1 ? 1 : 0) != 0);
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.XOR_OP, "XOR", PlcFunctionAppls.makeParamList(inN.length), "XOR", PlcBasicFuncDescription.ExprBinding.EXCL_DISJUNCT_EXPR);
        List<PlcNamedValue> arguments = IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + String.valueOf(i + 1), inN[i])).collect(Collectors.toList());
        return new PlcFuncAppl(func, arguments);
    }

    public PlcFuncAppl orFuncAppl(PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.OR_OP));
        Assert.check((inN.length > 1 ? 1 : 0) != 0);
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.OR_OP, "OR", PlcFunctionAppls.makeParamList(inN.length), "OR", PlcBasicFuncDescription.ExprBinding.DISJUNCT_EXPR);
        List<PlcNamedValue> arguments = IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + String.valueOf(i + 1), inN[i])).collect(Collectors.toList());
        return new PlcFuncAppl(func, arguments);
    }

    private static PlcBasicFuncDescription.PlcParameterDescription[] makeParamList(int length) {
        PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[length + 1];
        int i = 0;
        while (i < length) {
            params[i] = new PlcBasicFuncDescription.PlcParameterDescription("IN" + String.valueOf(i + 1), PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY);
            ++i;
        }
        params[length] = new PlcBasicFuncDescription.PlcParameterDescription("OUT", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY);
        return params;
    }

    public PlcFuncAppl castFunctionAppl(PlcExpression in, PlcElementaryType inType, PlcElementaryType outType) {
        PlcCastFunction func = new PlcCastFunction(inType, outType);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl selFuncAppl(PlcExpression g, PlcExpression in0, PlcExpression in1) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.SEL_OP));
        PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("G", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("IN0", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("IN1", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY)};
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.SEL_OP, "SEL", params);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("G", g), new PlcNamedValue("IN0", in0), new PlcNamedValue("IN1", in1)));
    }

    public PlcFuncAppl normalizeArrayIndex(PlcExpression indexExpr, int arraySize) {
        PlcFuncAppl g = this.greaterEqualFuncAppl(indexExpr, new PlcIntLiteral(0));
        PlcFuncAppl in0 = this.addFuncAppl(indexExpr, new PlcIntLiteral(arraySize));
        PlcExpression in1 = indexExpr;
        return this.selFuncAppl(g, in0, in1);
    }

    public PlcFuncAppl absFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_ABS));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_ABS, "ABS", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl expFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_EXP));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_EXP, "EXP", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl lnFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_LN));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_LN, "LN", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl logFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_LOG));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_LOG, "LOG", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl minFuncAppl(PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_MIN));
        Assert.check((inN.length > 1 ? 1 : 0) != 0);
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_MIN, "MIN", PlcFunctionAppls.makeParamList(inN.length));
        List<PlcNamedValue> arguments = IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + String.valueOf(i + 1), inN[i])).collect(Collectors.toList());
        return new PlcFuncAppl(func, arguments);
    }

    public PlcFuncAppl maxFuncAppl(PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_MAX));
        Assert.check((inN.length > 1 ? 1 : 0) != 0);
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_MAX, "MAX", PlcFunctionAppls.makeParamList(inN.length));
        List<PlcNamedValue> arguments = IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + String.valueOf(i + 1), inN[i])).collect(Collectors.toList());
        return new PlcFuncAppl(func, arguments);
    }

    public PlcFuncAppl sqrtFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_SQRT));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_SQRT, "SQRT", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl acosFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_ACOS));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_ACOS, "ACOS", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl asinFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_ASIN));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_ASIN, "ASIN", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl atanFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_ATAN));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_ATAN, "ATAN", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl cosFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_COS));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_COS, "COS", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl sinFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_SIN));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_SIN, "SIN", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl tanFuncAppl(PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.STDLIB_TAN));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(PlcFuncOperation.STDLIB_TAN, "TAN", ONE_INPUT_PARAMETER);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }
}

