/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class CifEventTransition {
    public final Event event;
    public final List<TransitionAutomaton> senders;
    public final List<TransitionAutomaton> receivers;
    public final List<TransitionAutomaton> syncers;
    public final List<TransitionAutomaton> monitors;

    public CifEventTransition(Event event) {
        this(event, Lists.list(), Lists.list(), Lists.list(), Lists.list());
    }

    public CifEventTransition(Event event, List<TransitionAutomaton> senders, List<TransitionAutomaton> receivers, List<TransitionAutomaton> syncers, List<TransitionAutomaton> monitors) {
        this.event = event;
        this.senders = senders;
        this.receivers = receivers;
        this.syncers = syncers;
        this.monitors = monitors;
    }

    public Set<Declaration> collectAssignedVariables() {
        Set assignedVariables = Sets.set();
        for (TransitionAutomaton sender : this.senders) {
            sender.collectAssignedVariables(assignedVariables);
        }
        for (TransitionAutomaton receiver : this.receivers) {
            receiver.collectAssignedVariables(assignedVariables);
        }
        for (TransitionAutomaton syncer : this.syncers) {
            syncer.collectAssignedVariables(assignedVariables);
        }
        for (TransitionAutomaton monitor : this.monitors) {
            monitor.collectAssignedVariables(assignedVariables);
        }
        return assignedVariables;
    }

    public static class TransitionAutomaton {
        public final Automaton aut;
        public final List<TransitionEdge> transitionEdges;

        public TransitionAutomaton(Automaton aut, List<TransitionEdge> transitionEdges) {
            this.aut = aut;
            this.transitionEdges = transitionEdges;
        }

        public void collectAssignedVariables(Set<Declaration> assignedVariables) {
            for (TransitionEdge transEdge : this.transitionEdges) {
                CifAddressableUtils.collectAddrVars(transEdge.updates, assignedVariables);
            }
        }
    }

    public static class TransitionEdge {
        public final Location sourceLoc;
        public final Location targetLoc;
        public final Expression sendValue;
        public final List<Expression> guards;
        public final List<Update> updates;

        public TransitionEdge(Location sourceLoc, Location targetLoc, Expression sendValue, List<Expression> guards, List<Update> updates) {
            this.sourceLoc = sourceLoc;
            this.targetLoc = targetLoc;
            this.sendValue = sendValue;
            this.guards = guards;
            this.updates = updates;
        }
    }
}

