/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifPreconditionChecker;
import org.eclipse.escet.cif.checkers.checks.AutOnlyWithOneInitLocCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoInitPredsCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.EqnNotAllowedCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoTauCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificBinaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificUnaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificIntUserDefFuncStatsCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificStdLibCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificUserDefCheck;
import org.eclipse.escet.cif.checkers.checks.InvNoSpecificInvsCheck;
import org.eclipse.escet.cif.checkers.checks.LocNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.SpecAutomataCountsCheck;
import org.eclipse.escet.cif.checkers.checks.TypeNoSpecificTypesCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoDiscWithMultiInitValuesCheck;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.EnumsToConsts;
import org.eclipse.escet.cif.cif2cif.EnumsToInts;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyOthers;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.WarnOutput;
import org.eclipse.escet.cif.plcgen.generators.CifEventTransition;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class CifProcessor {
    private final PlcTarget target;
    private final String inputPath;
    private final String absInputPath;
    private final boolean simplifyValues;
    private final ConvertEnums enumConversion;
    private final WarnOutput warnOutput;

    public CifProcessor(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.inputPath = settings.inputPath;
        this.absInputPath = settings.absInputPath;
        this.simplifyValues = settings.simplifyValues;
        this.enumConversion = settings.enumConversion;
        this.warnOutput = settings.warnOutput;
    }

    /*
     * WARNING - void declaration
     */
    public void process() {
        Specification spec = (Specification)((CifReader)new CifReader().init(this.inputPath, this.absInputPath, false)).read();
        this.widenSpec(spec);
        this.preCheckSpec(spec, this.absInputPath);
        this.normalizeSpec(spec);
        for (Declaration decl : (List)CifCollectUtils.collectDeclarations((ComplexComponent)spec, (Collection)Lists.list())) {
            void enumDecl;
            Declaration declaration = decl;
            if (declaration instanceof DiscVariable) {
                void discVar;
                DiscVariable cfr_ignored_0 = (DiscVariable)declaration;
                DiscVariable cfr_ignored_1 = (DiscVariable)declaration;
                this.target.getVarStorage().addStateVariable(decl, discVar.getType());
                continue;
            }
            Declaration declaration2 = decl;
            if (declaration2 instanceof InputVariable) {
                void inpVar;
                InputVariable cfr_ignored_2 = (InputVariable)declaration2;
                InputVariable cfr_ignored_3 = (InputVariable)declaration2;
                this.target.getVarStorage().addStateVariable(decl, inpVar.getType());
                continue;
            }
            Declaration declaration3 = decl;
            if (!(declaration3 instanceof EnumDecl)) continue;
            EnumDecl cfr_ignored_4 = (EnumDecl)declaration3;
            EnumDecl cfr_ignored_5 = (EnumDecl)declaration3;
            this.target.getTypeGenerator().convertEnumDecl((EnumDecl)enumDecl);
        }
        Map eventTransitions = Maps.map();
        for (Automaton aut : (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list())) {
            Map<Event, AutomatonRoleInfo> autRoleInfoPerEvent = this.classifyAutomatonRole(aut);
            for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
                CifEventTransition eventTrans = eventTransitions.computeIfAbsent(autRoleInfo.event, evt -> new CifEventTransition((Event)evt));
                if (autRoleInfo.isSenderAutomaton()) {
                    eventTrans.senders.add(new CifEventTransition.TransitionAutomaton(aut, autRoleInfo.getSenderEdges()));
                    continue;
                }
                if (autRoleInfo.isReceiverAutomaton()) {
                    eventTrans.receivers.add(new CifEventTransition.TransitionAutomaton(aut, autRoleInfo.getReceiverEdges()));
                    continue;
                }
                if (autRoleInfo.isSyncerAutomaton()) {
                    eventTrans.syncers.add(new CifEventTransition.TransitionAutomaton(aut, autRoleInfo.getSyncerEdges()));
                    continue;
                }
                if (autRoleInfo.isMonitorAutomaton()) {
                    eventTrans.monitors.add(new CifEventTransition.TransitionAutomaton(aut, autRoleInfo.getMonitorEdges()));
                    continue;
                }
                throw new AssertionError((Object)"Undecided automaton role.");
            }
        }
        List cifEventTransitions = Lists.listc((int)eventTransitions.values().size());
        cifEventTransitions.addAll(eventTransitions.values());
        this.target.getTransitionGenerator().setTransitions(cifEventTransitions);
    }

    private static AutomatonRoleInfo getAutRoleInfo(Map<Event, AutomatonRoleInfo> autRoleInfoPerEvent, Event event) {
        return autRoleInfoPerEvent.computeIfAbsent(event, evt -> new AutomatonRoleInfo((Event)evt));
    }

    /*
     * WARNING - void declaration
     */
    private Map<Event, AutomatonRoleInfo> classifyAutomatonRole(Automaton aut) {
        Map autRoleInfoPerEvent = Maps.map();
        if (aut.getAlphabet() != null) {
            for (Expression expr2 : aut.getAlphabet().getEvents()) {
                EventExpression eve = (EventExpression)expr2;
                CifProcessor.getAutRoleInfo(autRoleInfoPerEvent, eve.getEvent());
            }
        }
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                Location destLoc = CifEdgeUtils.getTarget((Edge)edge);
                Assert.check((!edge.getEvents().isEmpty() ? 1 : 0) != 0);
                for (EdgeEvent ee : edge.getEvents()) {
                    CifEventTransition.TransitionEdge te;
                    Expression eventRef = ee.getEvent();
                    Assert.check((!(eventRef instanceof TauExpression) ? 1 : 0) != 0);
                    EventExpression eve = (EventExpression)eventRef;
                    AutomatonRoleInfo autRoleInfo = CifProcessor.getAutRoleInfo(autRoleInfoPerEvent, eve.getEvent());
                    EdgeEvent edgeEvent = ee;
                    if (edgeEvent instanceof EdgeSend) {
                        void es;
                        EdgeSend cfr_ignored_0 = (EdgeSend)edgeEvent;
                        EdgeSend cfr_ignored_1 = (EdgeSend)edgeEvent;
                        te = new CifEventTransition.TransitionEdge(loc, destLoc, es.getValue(), (List<Expression>)edge.getGuards(), (List<Update>)edge.getUpdates());
                        autRoleInfo.addEdge(te, AutomatonRole.SENDER);
                        continue;
                    }
                    if (ee instanceof EdgeReceive) {
                        te = new CifEventTransition.TransitionEdge(loc, destLoc, null, (List<Expression>)edge.getGuards(), (List<Update>)edge.getUpdates());
                        autRoleInfo.addEdge(te, AutomatonRole.RECEIVER);
                        continue;
                    }
                    te = new CifEventTransition.TransitionEdge(loc, destLoc, null, (List<Expression>)edge.getGuards(), (List<Update>)edge.getUpdates());
                    autRoleInfo.addEdge(te, AutomatonRole.SYNCER_OR_MONITOR);
                }
            }
        }
        if (aut.getMonitors() != null) {
            Monitors mons = aut.getMonitors();
            if (mons.getEvents().isEmpty()) {
                for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
                    autRoleInfo.setIsMonitor(true);
                }
            } else {
                Set monitorEvents = (Set)mons.getEvents().stream().map(expr -> ((EventExpression)expr).getEvent()).collect(Sets.toSet());
                for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
                    autRoleInfo.setIsMonitor(monitorEvents.contains(autRoleInfo.event));
                }
            }
        }
        for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
            if (!EnumSet.of(AutomatonRole.UNKNOWN, AutomatonRole.SYNCER_OR_MONITOR).contains((Object)autRoleInfo.autRole)) continue;
            autRoleInfo.setIsSyncer();
        }
        for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
            autRoleInfo.checkAutRoleIsDecided();
        }
        return autRoleInfoPerEvent;
    }

    private void widenSpec(Specification spec) {
        new ElimComponentDefInst().transform(spec);
        new ElimStateEvtExclInvs().transform(spec);
        if (this.simplifyValues) {
            new SimplifyValues().transform(spec);
            new ElimConsts().transform(spec);
        }
        new SimplifyOthers().transform(spec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            this.warnOutput.warn("The specification contains CIF/SVG input declarations. These will be ignored.");
        }
    }

    private void preCheckSpec(Specification spec, String absSpecPath) {
        PlcGenPreChecker checker = new PlcGenPreChecker(this.target.supportsArrays());
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF PLC code generator");
    }

    private void normalizeSpec(Specification spec) {
        new AddDefaultInitialValues().transform(spec);
        new ElimLocRefExprs(a -> "", a -> "location", loc -> loc.getName(), false, true, false, null, true, true).transform(spec);
        if (this.simplifyValues) {
            new SimplifyValues().transform(spec);
            new ElimConsts().transform(spec);
        }
        if (this.enumConversion == ConvertEnums.INTS) {
            new EnumsToInts().transform(spec);
        } else if (this.enumConversion == ConvertEnums.CONSTS) {
            new EnumsToConsts().transform(spec);
        } else if (!this.target.supportsEnumerations()) {
            String msg = Strings.fmt((String)"Enumerations are not converted, while this is required for %s code. Please set the \"Convert enumerations\" option accordingly.", (Object[])new Object[]{this.target.getTargetType().dialogText});
            throw new InvalidInputException(msg);
        }
    }

    public static enum AutomatonRole {
        UNKNOWN,
        SENDER,
        RECEIVER,
        SYNCER,
        MONITOR,
        SYNCER_OR_MONITOR;

    }

    private static class AutomatonRoleInfo {
        public final Event event;
        private AutomatonRole autRole;
        private final List<CifEventTransition.TransitionEdge> edges = Lists.list();

        public AutomatonRoleInfo(Event event) {
            this.event = event;
            this.autRole = event.getType() == null ? AutomatonRole.SYNCER_OR_MONITOR : AutomatonRole.UNKNOWN;
        }

        public void addEdge(CifEventTransition.TransitionEdge transEdge, AutomatonRole edgeAutRole) {
            Assert.check((boolean)EnumSet.of(AutomatonRole.SENDER, AutomatonRole.RECEIVER, AutomatonRole.SYNCER_OR_MONITOR).contains((Object)edgeAutRole));
            this.edges.add(transEdge);
            switch (this.autRole) {
                case UNKNOWN: {
                    this.autRole = edgeAutRole;
                    break;
                }
                case SYNCER: 
                case MONITOR: 
                case SYNCER_OR_MONITOR: {
                    Assert.check((boolean)edgeAutRole.equals((Object)AutomatonRole.SYNCER_OR_MONITOR));
                    break;
                }
                case SENDER: 
                case RECEIVER: {
                    Assert.check((boolean)edgeAutRole.equals((Object)this.autRole));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected automaton role \"" + (Object)((Object)this.autRole) + "\"."));
                }
            }
        }

        public void setIsMonitor(boolean isMonitor) {
            AutomatonRole resultRole;
            if (EnumSet.of(AutomatonRole.SENDER, AutomatonRole.RECEIVER).contains((Object)this.autRole)) {
                Assert.check((!isMonitor ? 1 : 0) != 0);
                return;
            }
            AutomatonRole automatonRole = resultRole = isMonitor ? AutomatonRole.MONITOR : AutomatonRole.SYNCER;
            if (this.autRole.equals((Object)resultRole)) {
                return;
            }
            if (EnumSet.of(AutomatonRole.SYNCER_OR_MONITOR, AutomatonRole.UNKNOWN).contains((Object)this.autRole)) {
                this.autRole = resultRole;
                return;
            }
            throw new AssertionError((Object)("Encountered unexpected automaton role \"" + (Object)((Object)this.autRole) + "\"."));
        }

        public void setIsSyncer() {
            Assert.check((boolean)EnumSet.of(AutomatonRole.UNKNOWN, AutomatonRole.SYNCER_OR_MONITOR).contains((Object)this.autRole));
            this.autRole = AutomatonRole.SYNCER;
        }

        private void checkAutRoleIsDecided() {
            Assert.check((boolean)EnumSet.of(AutomatonRole.SENDER, AutomatonRole.RECEIVER, AutomatonRole.SYNCER, AutomatonRole.MONITOR).contains((Object)this.autRole));
        }

        public boolean isSenderAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole.equals((Object)AutomatonRole.SENDER);
        }

        public boolean isReceiverAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole.equals((Object)AutomatonRole.RECEIVER);
        }

        public boolean isSyncerAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole.equals((Object)AutomatonRole.SYNCER);
        }

        public boolean isMonitorAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole.equals((Object)AutomatonRole.MONITOR);
        }

        public List<CifEventTransition.TransitionEdge> getSenderEdges() {
            Assert.check((boolean)this.isSenderAutomaton());
            return this.edges;
        }

        public List<CifEventTransition.TransitionEdge> getReceiverEdges() {
            Assert.check((boolean)this.isReceiverAutomaton());
            return this.edges;
        }

        public List<CifEventTransition.TransitionEdge> getSyncerEdges() {
            Assert.check((boolean)this.isSyncerAutomaton());
            return this.edges;
        }

        public List<CifEventTransition.TransitionEdge> getMonitorEdges() {
            Assert.check((boolean)this.isMonitorAutomaton());
            return this.edges;
        }
    }

    private static class PlcGenPreChecker
    extends CifPreconditionChecker {
        public PlcGenPreChecker(boolean supportArrays) {
            super(new CifCheck[]{new SpecAutomataCountsCheck().setMinMaxAuts(1, -1), new CompNoInitPredsCheck(true), new VarNoDiscWithMultiInitValuesCheck(), new AutOnlyWithOneInitLocCheck(), new InvNoSpecificInvsCheck().ignoreNeverBlockingInvariants().disallow(NoInvariantSupKind.ALL_KINDS, NoInvariantKind.STATE, NoInvariantPlaceKind.ALL_PLACES), new EventNoTauCheck(), new EqnNotAllowedCheck(), new LocNoUrgentCheck(), new EdgeNoUrgentCheck(), new FuncNoSpecificUserDefCheck(new FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc[]{FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.EXTERNAL, FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.NO_PARAMETER}), new FuncNoSpecificIntUserDefFuncStatsCheck(new FuncNoSpecificIntUserDefFuncStatsCheck.NoSpecificStatement[]{FuncNoSpecificIntUserDefFuncStatsCheck.NoSpecificStatement.ASSIGN_MULTI_PARTS_SAME_VAR, FuncNoSpecificIntUserDefFuncStatsCheck.NoSpecificStatement.CONTINUE}), new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.DICT_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES_AS_DATA, TypeNoSpecificTypesCheck.NoSpecificType.SET_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.STRING_TYPES, supportArrays ? TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES_NON_ARRAY : TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES}), new ExprNoSpecificExprsCheck(new ExprNoSpecificExprsCheck.NoSpecificExpr[]{ExprNoSpecificExprsCheck.NoSpecificExpr.CAST_EXPRS_FROM_STRING, ExprNoSpecificExprsCheck.NoSpecificExpr.CAST_EXPRS_TO_STRING, ExprNoSpecificExprsCheck.NoSpecificExpr.DICT_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_REFS_USER_DEF_AS_DATA, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_DICTS, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_LISTS_NON_ARRAY, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_STRINGS, ExprNoSpecificExprsCheck.NoSpecificExpr.SET_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.STRING_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.SLICE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.TIME_VAR_REFS}), new ExprNoSpecificUnaryExprsCheck(new ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp[]{ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.SAMPLE}), new ExprNoSpecificBinaryExprsCheck(new ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp[]{ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_STRINGS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ELEMENT_OF, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_TUPLE, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBSET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.CONJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DISJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_TUPLE}), new FuncNoSpecificStdLibCheck(new FuncNoSpecificStdLibCheck.NoSpecificStdLib[]{FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_STOCHASTIC_GROUP, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_ACOSH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_ASINH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_ATANH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_COSH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_SINH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_TANH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_CEIL, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_DELETE, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_EMPTY, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_FLOOR, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_FORMAT, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_POP, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_ROUND, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_SCALE, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_SIGN, FuncNoSpecificStdLibCheck.NoSpecificStdLib.STD_LIB_SIZE})});
        }
    }
}

