/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.WarnOutput;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultNameGenerator
implements NameGenerator {
    static final char DEFAULT_CHAR = 'x';
    private static final Set<String> PLC_LANGUAGE_KEYWORDS;
    private final boolean warnOnRename;
    private final WarnOutput warnOutput;
    private Map<String, Integer> globalSuffixes;

    static {
        String[] languageKeywords = new String[]{"action", "end_action", "array", "of", "at", "case", "of", "else", "end_case", "configuration", "end_configuration", "constant", "exit", "false", "f_edge", "for", "to", "by", "do", "end_for", "function", "end_function", "function_block", "end_function_block", "if", "then", "elsif", "else", "end_if", "initial_step", "end_step", "not", "mod", "and", "xor", "or", "program", "with", "program", "end_program", "r_edge", "read_only", "read_write", "repeat", "until", "end_repeat", "resource", "on", "end_resource", "retain", "end_retain", "return", "step", "end_step", "struct", "end_struct", "task", "transition", "from", "to", "end_transition", "true", "type", "end_type", "var", "end_var", "var_input", "var_output", "var_in_out", "var_temp", "var_external", "var_access", "var_config", "var_gloval", "while", "do", "end_while", "with"};
        String[] typeKeywords = new String[]{"bool", "sint", "int", "dint", "lint", "usint", "uint", "ulint", "udint", "real", "lreal", "time", "date", "time_of_day", "tod", "date_and_time", "dt", "string", "byte", "word", "dword", "lword", "wstring"};
        String[] genericTypeKeywords = new String[]{"any", "and_derived", "any_elementary", "any_magnitude", "any_num", "any_real", "any_int", "any_bit", "any_string", "any_date"};
        int numTypes = genericTypeKeywords.length;
        int keywordCount = languageKeywords.length + typeKeywords.length + genericTypeKeywords.length + numTypes * (numTypes - 1);
        Set keywords = Sets.setc((int)keywordCount);
        keywords.addAll(Arrays.asList(languageKeywords));
        keywords.addAll(Arrays.asList(typeKeywords));
        keywords.addAll(Arrays.asList(genericTypeKeywords));
        int i = 0;
        while (i < typeKeywords.length) {
            int j = 0;
            while (j < typeKeywords.length) {
                if (i != j) {
                    keywords.add(String.valueOf(typeKeywords[i]) + "_to_" + typeKeywords[j]);
                }
                ++j;
            }
            ++i;
        }
        PLC_LANGUAGE_KEYWORDS = Collections.unmodifiableSet(keywords);
    }

    public DefaultNameGenerator(PlcGenSettings settings) {
        this.warnOnRename = settings.warnOnRename;
        this.warnOutput = settings.warnOutput;
        this.globalSuffixes = Maps.map();
        for (String name : PLC_LANGUAGE_KEYWORDS) {
            this.globalSuffixes.put(name, 0);
        }
    }

    @Override
    public String generateGlobalName(PositionObject posObject) {
        Assert.check((boolean)CifTextUtils.hasName((PositionObject)posObject), (Object)("Missing name for \"" + String.valueOf(posObject) + "\"."));
        return this.generateName(CifTextUtils.getAbsName((PositionObject)posObject, (boolean)false), true, null);
    }

    @Override
    public String generateGlobalName(String initialName, boolean initialIsCifName) {
        return this.generateName(initialName, initialIsCifName, null);
    }

    @Override
    public String generateLocalName(String initialName, Map<String, Integer> localSuffixes) {
        return this.generateName(initialName, false, localSuffixes);
    }

    private String generateName(String initialName, boolean initialIsCifName, Map<String, Integer> localSuffixes) {
        StringBuilder cleanedName = new StringBuilder(initialName.length() + 1 + 2 + 8);
        boolean needsUnderscore = false;
        int index = 0;
        while (index < initialName.length()) {
            char c = initialName.charAt(index);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                if (needsUnderscore) {
                    cleanedName.append('_');
                    needsUnderscore = false;
                }
                cleanedName.append(c);
            } else if (c >= '0' && c <= '9') {
                if (cleanedName.isEmpty()) {
                    cleanedName.append('x');
                } else if (needsUnderscore) {
                    cleanedName.append('_');
                }
                cleanedName.append(c);
                needsUnderscore = false;
            } else {
                needsUnderscore = !cleanedName.isEmpty();
            }
            ++index;
        }
        if (cleanedName.isEmpty()) {
            cleanedName.append('x');
        }
        String lowerCleanedName = cleanedName.toString().toLowerCase(Locale.US);
        int maxUsedNumber = this.globalSuffixes.getOrDefault(lowerCleanedName, -1);
        if (localSuffixes != null) {
            maxUsedNumber = Math.max(maxUsedNumber, localSuffixes.getOrDefault(lowerCleanedName, -1));
        }
        if (maxUsedNumber < 0) {
            if (localSuffixes != null) {
                localSuffixes.put(lowerCleanedName, 0);
            } else {
                this.globalSuffixes.put(lowerCleanedName, 0);
            }
            return cleanedName.toString();
        }
        ++maxUsedNumber;
        if (localSuffixes != null) {
            localSuffixes.put(lowerCleanedName, maxUsedNumber);
        } else {
            this.globalSuffixes.put(lowerCleanedName, maxUsedNumber);
        }
        cleanedName.append("__");
        cleanedName.append(maxUsedNumber);
        String newName = cleanedName.toString();
        if (initialIsCifName && this.warnOnRename) {
            this.warnOutput.warn("Renaming \"%s\" to \"%s\".", initialName, newName);
        }
        return newName;
    }
}

