/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprAddressableResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.generators.CifEventTransition;
import org.eclipse.escet.cif.plcgen.generators.TransitionGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcSelectionStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultTransitionGenerator
implements TransitionGenerator {
    private final PlcTarget target;
    private List<CifEventTransition> eventTransitions = null;
    private ExprGenerator mainExprGen;
    private PlcFunctionAppls funcAppls;

    public DefaultTransitionGenerator(PlcTarget target) {
        this.target = target;
    }

    @Override
    public void setTransitions(List<CifEventTransition> eventTransitions) {
        this.eventTransitions = eventTransitions;
    }

    @Override
    public void generate() {
        List<PlcStatement> statements = this.generateCode();
        this.target.getCodeStorage().addEventTransitions(statements);
    }

    List<PlcStatement> generateCode() {
        this.mainExprGen = this.target.getCodeStorage().getExprGenerator();
        this.funcAppls = new PlcFunctionAppls(this.target);
        PlcVariable isProgressVar = this.target.getCodeStorage().getIsProgressVariable();
        List statements = Lists.list();
        for (CifEventTransition eventTransition : this.eventTransitions) {
            statements.addAll(this.generateEventTransitionCode(eventTransition, isProgressVar));
        }
        this.mainExprGen.releaseTempVariable(isProgressVar);
        return statements;
    }

    private List<PlcStatement> generateEventTransitionCode(CifEventTransition eventTransition, PlcVariable isProgressVar) {
        List testCode = Lists.list();
        List performCode = Lists.list();
        List createdTempVariables = Lists.list();
        PlcVariable eventEnabledVar = this.mainExprGen.getTempVariable("eventEnabled", PlcElementaryType.BOOL_TYPE);
        createdTempVariables.add(eventEnabledVar);
        boolean eventEnabledAlwaysHolds = true;
        String absEventName = CifTextUtils.getAbsName((PositionObject)eventTransition.event, (boolean)false);
        testCode.add(new PlcCommentLine("Try to perform event \"" + absEventName + "\"."));
        testCode.add(new PlcAssignmentStatement(eventEnabledVar, (PlcExpression)new PlcBoolLiteral(true)));
        performCode.add(new PlcAssignmentStatement(isProgressVar, (PlcExpression)new PlcBoolLiteral(true)));
        CifDataProvider performProvider = this.generateCopiedState(eventTransition.collectAssignedVariables(), performCode, createdTempVariables);
        CifType channelType = eventTransition.event.getType();
        if (channelType != null) {
            PlcVariable channelValueVar;
            if ((channelType = CifTypeUtils.normalizeType((CifType)channelType)) instanceof VoidType) {
                channelValueVar = null;
            } else {
                channelValueVar = this.mainExprGen.getTempVariable("channelValue", channelType);
                createdTempVariables.add(channelValueVar);
            }
            this.generateSendReceiveCode(eventTransition.senders, testCode, performProvider, performCode, "sender", createdTempVariables, eventEnabledVar, channelValueVar, eventEnabledAlwaysHolds);
            eventEnabledAlwaysHolds = false;
            this.mainExprGen.setChannelValueVariable(channelValueVar);
            this.generateSendReceiveCode(eventTransition.receivers, testCode, performProvider, performCode, "receiver", createdTempVariables, eventEnabledVar, null, eventEnabledAlwaysHolds);
            this.mainExprGen.setChannelValueVariable(null);
        }
        this.generateSyncCode(eventTransition.syncers, testCode, performProvider, performCode, createdTempVariables, eventEnabledVar, eventEnabledAlwaysHolds);
        this.generateMonitorCode(eventTransition.monitors, performProvider, performCode, createdTempVariables);
        List resultCode = testCode;
        PlcVarExpression guard = new PlcVarExpression(eventEnabledVar, new PlcVarExpression.PlcProjection[0]);
        resultCode.add(this.generateIfGuardThenCode((PlcExpression)guard, performCode));
        this.mainExprGen.releaseTempVariables(createdTempVariables);
        return resultCode;
    }

    /*
     * WARNING - void declaration
     */
    private CifDataProvider generateCopiedState(Set<Declaration> assignedVariables, List<PlcStatement> codeStorage, List<PlcVariable> createdTempVariables) {
        if (assignedVariables.isEmpty()) {
            return null;
        }
        List assignedVarList = Lists.set2list(assignedVariables);
        Collections.sort(assignedVarList, (a, b) -> CifTextUtils.getAbsName((PositionObject)a, (boolean)false).compareTo(CifTextUtils.getAbsName((PositionObject)b, (boolean)false)));
        CifDataProvider rootProvider = this.mainExprGen.getScopeCifDataProvider();
        Map redirectedDecls = Maps.map();
        for (Declaration assignedVar : assignedVarList) {
            Declaration declaration = assignedVar;
            if (declaration instanceof DiscVariable) {
                void dv;
                DiscVariable cfr_ignored_0 = (DiscVariable)declaration;
                DiscVariable cfr_ignored_1 = (DiscVariable)declaration;
                Object currentVar = this.mainExprGen.getTempVariable("current_" + CifTextUtils.getAbsName((PositionObject)dv, (boolean)false), dv.getType());
                createdTempVariables.add((PlcVariable)currentVar);
                redirectedDecls.put(dv, new PlcVarExpression((PlcVariable)currentVar, new PlcVarExpression.PlcProjection[0]));
                codeStorage.add(new PlcAssignmentStatement(new PlcVarExpression((PlcVariable)currentVar, new PlcVarExpression.PlcProjection[0]), rootProvider.getValueForDiscVar((DiscVariable)dv)));
                continue;
            }
            Declaration declaration2 = assignedVar;
            if (declaration2 instanceof ContVariable) {
                void cv;
                ContVariable cfr_ignored_2 = (ContVariable)declaration2;
                ContVariable cfr_ignored_3 = (ContVariable)declaration2;
                PlcVariable currentVar = this.mainExprGen.getTempVariable("current_" + CifTextUtils.getAbsName((PositionObject)cv, (boolean)false), this.target.getRealType());
                createdTempVariables.add(currentVar);
                redirectedDecls.put(cv, new PlcVarExpression(currentVar, new PlcVarExpression.PlcProjection[0]));
                codeStorage.add(new PlcAssignmentStatement(new PlcVarExpression(currentVar, new PlcVarExpression.PlcProjection[0]), rootProvider.getValueForContvar((ContVariable)cv, false)));
                continue;
            }
            throw new AssertionError((Object)("Unexpected kind of assigned variable \"" + assignedVar + "\"."));
        }
        return new TransitionDataProvider(redirectedDecls, rootProvider);
    }

    private void generateSendReceiveCode(List<CifEventTransition.TransitionAutomaton> autTransitions, List<PlcStatement> testCode, CifDataProvider performProvider, List<PlcStatement> performCode, String varPrefix, List<PlcVariable> createdTempVariables, PlcVariable eventEnabledVar, PlcVariable channelValueVar, boolean eventEnabledAlwaysHolds) {
        List autTestCode = Lists.list();
        PlcVariable autVar = this.mainExprGen.getTempVariable(String.valueOf(varPrefix) + "Aut", PlcElementaryType.DINT_TYPE);
        PlcVariable edgeVar = this.mainExprGen.getTempVariable(String.valueOf(varPrefix) + "Edge", PlcElementaryType.DINT_TYPE);
        createdTempVariables.add(autVar);
        createdTempVariables.add(edgeVar);
        autTestCode.add(this.generatePlcIntAssignment(autVar, 0));
        PlcSelectionStatement performSelectStat = new PlcSelectionStatement();
        int autIndex = 1;
        for (CifEventTransition.TransitionAutomaton transAut : autTransitions) {
            autTestCode.addAll(this.generateEdgesTestCode(transAut, autIndex, autVar, edgeVar, eventEnabledVar));
            this.mainExprGen.setCurrentCifDataProvider(performProvider);
            List<PlcStatement> innerPerformCode = this.generateAutPerformCode(transAut, edgeVar, channelValueVar);
            if (!innerPerformCode.isEmpty()) {
                performSelectStat.condChoices.add(new PlcSelectionStatement.PlcSelectChoice(this.generateCompareVarWithVal(autVar, autIndex), innerPerformCode));
            }
            this.mainExprGen.setCurrentCifDataProvider(null);
            ++autIndex;
        }
        if (!performSelectStat.condChoices.isEmpty()) {
            performCode.add(performSelectStat);
        }
        PlcExpression guard = this.generateCompareVarWithVal(autVar, 0);
        PlcAssignmentStatement assignment = this.generatePlcBoolAssignment(eventEnabledVar, false);
        autTestCode.add(this.generateIfGuardThenCode(guard, assignment));
        if (eventEnabledAlwaysHolds) {
            testCode.addAll(autTestCode);
        } else {
            guard = new PlcVarExpression(eventEnabledVar, new PlcVarExpression.PlcProjection[0]);
            testCode.add(this.generateIfGuardThenCode(guard, autTestCode));
        }
    }

    private void generateSyncCode(List<CifEventTransition.TransitionAutomaton> autTransitions, List<PlcStatement> testCode, CifDataProvider performProvider, List<PlcStatement> performCode, List<PlcVariable> createdTempVariables, PlcVariable eventEnabledVar, boolean eventEnabledAlwaysHolds) {
        for (CifEventTransition.TransitionAutomaton transAut : autTransitions) {
            List autTestCode = Lists.list();
            PlcVariable autEdgeVar = this.mainExprGen.getTempVariable("syncAutEdge", PlcElementaryType.DINT_TYPE);
            autTestCode.addAll(this.generateEdgesTestCode(transAut, -1, null, autEdgeVar, eventEnabledVar));
            this.mainExprGen.setCurrentCifDataProvider(performProvider);
            performCode.addAll(this.generateAutPerformCode(transAut, autEdgeVar, null));
            this.mainExprGen.setCurrentCifDataProvider(null);
            if (eventEnabledAlwaysHolds) {
                testCode.addAll(autTestCode);
            } else {
                PlcVarExpression guard = new PlcVarExpression(eventEnabledVar, new PlcVarExpression.PlcProjection[0]);
                testCode.add(this.generateIfGuardThenCode((PlcExpression)guard, autTestCode));
            }
            eventEnabledAlwaysHolds = false;
        }
    }

    private void generateMonitorCode(List<CifEventTransition.TransitionAutomaton> autTransitions, CifDataProvider performProvider, List<PlcStatement> testAndPerformCode, List<PlcVariable> createdTempVariables) {
        this.mainExprGen.setCurrentCifDataProvider(performProvider);
        for (CifEventTransition.TransitionAutomaton transAut : autTransitions) {
            PlcSelectionStatement selStat = null;
            for (CifEventTransition.TransitionEdge edge : transAut.transitionEdges) {
                if (edge.updates.isEmpty()) continue;
                Supplier<List<PlcStatement>> thenStats = () -> this.generateUpdates(transitionEdge.updates);
                selStat = this.mainExprGen.addBranch(edge.guards, thenStats, selStat, testAndPerformCode);
            }
        }
        this.mainExprGen.setCurrentCifDataProvider(null);
    }

    private List<PlcStatement> generateEdgesTestCode(CifEventTransition.TransitionAutomaton transAut, int autIndex, PlcVariable autVar, PlcVariable edgeVar, PlcVariable eventEnabledVar) {
        List testCode = Lists.list();
        PlcSelectionStatement selStat = null;
        int edgeIndex = 1;
        for (CifEventTransition.TransitionEdge edge : transAut.transitionEdges) {
            int finalEdgeIndex = edgeIndex++;
            Supplier<List<PlcStatement>> thenStats = () -> {
                if (autVar != null) {
                    return List.of(this.generatePlcIntAssignment(autVar, autIndex), this.generatePlcIntAssignment(edgeVar, finalEdgeIndex));
                }
                return List.of(this.generatePlcIntAssignment(edgeVar, finalEdgeIndex));
            };
            selStat = this.mainExprGen.addBranch(edge.guards, thenStats, selStat, testCode);
        }
        if (autVar != null) {
            PlcExpression guard = this.generateCompareVarWithVal(autVar, 0);
            return List.of(this.generateIfGuardThenCode(guard, testCode));
        }
        if (selStat == null) {
            testCode.add(this.generatePlcBoolAssignment(eventEnabledVar, false));
        } else {
            selStat.elseStats.add(this.generatePlcBoolAssignment(eventEnabledVar, false));
        }
        return testCode;
    }

    private List<PlcStatement> generateAutPerformCode(CifEventTransition.TransitionAutomaton transAut, PlcVariable edgeVar, PlcVariable channelValueVar) {
        List performCode = Lists.list();
        PlcSelectionStatement selStat = null;
        int edgeIndex = 1;
        for (CifEventTransition.TransitionEdge edge : transAut.transitionEdges) {
            if (channelValueVar != null || !edge.updates.isEmpty()) {
                Supplier<List<PlcStatement>> thenStats = () -> {
                    List thenStatements = Lists.list();
                    if (channelValueVar != null) {
                        this.genAssignExpr(new PlcVarExpression(channelValueVar, new PlcVarExpression.PlcProjection[0]), transitionEdge.sendValue, thenStatements);
                    }
                    thenStatements.addAll(this.generateUpdates(transitionEdge.updates));
                    return thenStatements;
                };
                PlcExpression guard = this.generateCompareVarWithVal(edgeVar, edgeIndex);
                selStat = this.mainExprGen.addPlcBranch(List.of((ExprValueResult)new ExprValueResult(this.mainExprGen, new ExprGenResult[0]).setValue(guard)), thenStats, selStat, performCode);
            }
            ++edgeIndex;
        }
        return performCode;
    }

    /*
     * WARNING - void declaration
     */
    private List<PlcStatement> generateUpdates(List<Update> updates) {
        List statements = Lists.list();
        for (Update upd : updates) {
            Update update = upd;
            if (update instanceof IfUpdate) {
                void ipUpd;
                IfUpdate cfr_ignored_0 = (IfUpdate)update;
                IfUpdate cfr_ignored_1 = (IfUpdate)update;
                this.genIfUpdate((IfUpdate)ipUpd, statements);
                continue;
            }
            Update update2 = upd;
            if (update2 instanceof Assignment) {
                void asg;
                Assignment cfr_ignored_2 = (Assignment)update2;
                Assignment cfr_ignored_3 = (Assignment)update2;
                this.genUpdateAssignment(asg.getAddressable(), asg.getValue(), statements);
                continue;
            }
            throw new AssertionError((Object)("Unexpected kind of update \"" + upd + "\" found."));
        }
        return statements;
    }

    private void genIfUpdate(IfUpdate ifUpd, List<PlcStatement> statements) {
        PlcSelectionStatement selStat = null;
        selStat = this.mainExprGen.addBranch((List<Expression>)ifUpd.getGuards(), () -> this.generateUpdates((List<Update>)ifUpd.getThens()), selStat, statements);
        for (ElifUpdate elifUpd : ifUpd.getElifs()) {
            selStat = this.mainExprGen.addBranch((List<Expression>)elifUpd.getGuards(), () -> this.generateUpdates((List<Update>)elifUpd.getThens()), selStat, statements);
        }
        this.mainExprGen.addBranch(null, () -> this.generateUpdates((List<Update>)ifUpd.getElses()), selStat, statements);
    }

    /*
     * WARNING - void declaration
     */
    private void genUpdateAssignment(Expression lhs, Expression rhs, List<PlcStatement> statements) {
        Expression expression = lhs;
        if (!(expression instanceof TupleExpression)) {
            ExprAddressableResult lhsResult = this.mainExprGen.convertAddressable(lhs);
            statements.addAll(lhsResult.code);
            lhsResult.releaseCodeVariables();
            this.genAssignExpr((PlcVarExpression)lhsResult.value, rhs, statements);
            lhsResult.releaseValueVariables();
            return;
        }
        TupleExpression tupleExpression = (TupleExpression)expression;
        TupleExpression cfr_ignored_0 = (TupleExpression)expression;
        Expression expression2 = rhs;
        if (expression2 instanceof TupleExpression) {
            void rhsTuple;
            void lhsTuple;
            TupleExpression lhsResult = (TupleExpression)expression2;
            TupleExpression cfr_ignored_1 = (TupleExpression)expression2;
            Assert.check((lhsTuple.getFields().size() == rhsTuple.getFields().size() ? 1 : 0) != 0);
            int i = 0;
            while (i < lhsTuple.getFields().size()) {
                this.genUpdateAssignment((Expression)lhsTuple.getFields().get(i), (Expression)rhsTuple.getFields().get(i), statements);
                ++i;
            }
            return;
        }
        PlcVariable rhsVariable = this.mainExprGen.getTempVariable("rightValue", rhs.getType());
        ExprValueResult rhsValueResult = this.mainExprGen.convertValue(rhs);
        statements.addAll(rhsValueResult.code);
        rhsValueResult.releaseCodeVariables();
        statements.add(new PlcAssignmentStatement(rhsVariable, rhsValueResult.value));
        rhsValueResult.releaseValueVariables();
        this.genUpdateAssignment(lhs, rhsVariable, List.of(), statements);
        this.mainExprGen.releaseTempVariable(rhsVariable);
    }

    /*
     * WARNING - void declaration
     */
    private void genUpdateAssignment(Expression lhs, PlcVariable rhsVariable, List<PlcVarExpression.PlcStructProjection> rhsProjections, List<PlcStatement> statements) {
        Expression expression = lhs;
        if (!(expression instanceof TupleExpression)) {
            ExprAddressableResult lhsResult = this.mainExprGen.convertAddressable(lhs);
            statements.addAll(lhsResult.code);
            lhsResult.releaseCodeVariables();
            PlcVarExpression rhsValue = new PlcVarExpression(rhsVariable, Lists.cast(rhsProjections));
            statements.add(new PlcAssignmentStatement((PlcVarExpression)lhsResult.value, (PlcExpression)rhsValue));
            lhsResult.releaseValueVariables();
            return;
        }
        TupleExpression tupleExpression = (TupleExpression)expression;
        TupleExpression cfr_ignored_0 = (TupleExpression)expression;
        PlcType lhsType = this.target.getTypeGenerator().convertType(lhs.getType());
        PlcStructType lhsStructType = this.target.getTypeGenerator().getStructureType(lhsType);
        int idx = 0;
        while (idx < lhsStructType.fields.size()) {
            void lhsTuple;
            List projs = Lists.listc((int)(rhsProjections.size() + 1));
            projs.addAll(rhsProjections);
            projs.add(new PlcVarExpression.PlcStructProjection(lhsStructType.fields.get((int)idx).name));
            this.genUpdateAssignment((Expression)lhsTuple.getFields().get(idx), rhsVariable, projs, statements);
            ++idx;
        }
    }

    private PlcSelectionStatement generateIfGuardThenCode(PlcExpression guard, PlcStatement statement) {
        return this.generateIfGuardThenCode(guard, Lists.list((Object)statement));
    }

    private PlcSelectionStatement generateIfGuardThenCode(PlcExpression guard, List<PlcStatement> statements) {
        PlcSelectionStatement selStat = new PlcSelectionStatement();
        selStat.condChoices.add(new PlcSelectionStatement.PlcSelectChoice(guard, statements));
        return selStat;
    }

    private List<PlcStatement> genAssignExpr(PlcVarExpression lhsVarExpr, Expression value, List<PlcStatement> statements) {
        statements = statements == null ? Lists.list() : statements;
        ExprValueResult rhsResult = this.mainExprGen.convertValue(value);
        statements.addAll(rhsResult.code);
        rhsResult.releaseCodeVariables();
        statements.add(new PlcAssignmentStatement(lhsVarExpr, rhsResult.value));
        rhsResult.releaseValueVariables();
        return statements;
    }

    private PlcExpression generateCompareVarWithVal(PlcVariable variable, int value) {
        PlcVarExpression varExpr = new PlcVarExpression(variable, new PlcVarExpression.PlcProjection[0]);
        PlcIntLiteral valExpr = new PlcIntLiteral(value);
        return this.funcAppls.equalFuncAppl(varExpr, valExpr);
    }

    private PlcAssignmentStatement generatePlcIntAssignment(PlcVariable variable, int value) {
        return new PlcAssignmentStatement(variable, (PlcExpression)new PlcIntLiteral(value));
    }

    private PlcAssignmentStatement generatePlcBoolAssignment(PlcVariable variable, boolean value) {
        return new PlcAssignmentStatement(variable, (PlcExpression)new PlcBoolLiteral(value));
    }

    private static class TransitionDataProvider
    extends CifDataProvider {
        private final Map<Declaration, PlcExpression> redirectedDecls;
        private final CifDataProvider rootProvider;

        public TransitionDataProvider(Map<Declaration, PlcExpression> redirectedDecls, CifDataProvider rootProvider) {
            this.redirectedDecls = redirectedDecls;
            this.rootProvider = rootProvider;
        }

        @Override
        public PlcExpression getValueForInputVar(InputVariable variable) {
            return this.rootProvider.getValueForInputVar(variable);
        }

        @Override
        public PlcExpression getValueForDiscVar(DiscVariable variable) {
            return this.redirectedDecls.getOrDefault(variable, this.rootProvider.getValueForDiscVar(variable));
        }

        @Override
        public PlcExpression getValueForContvar(ContVariable variable, boolean getDerivative) {
            if (getDerivative) {
                return this.rootProvider.getValueForContvar(variable, getDerivative);
            }
            return this.redirectedDecls.getOrDefault(variable, this.rootProvider.getValueForContvar(variable, getDerivative));
        }

        @Override
        public PlcExpression getValueForConstant(Constant constant) {
            return this.rootProvider.getValueForConstant(constant);
        }

        @Override
        public PlcVarExpression getAddressableForDiscVar(DiscVariable variable) {
            return this.rootProvider.getAddressableForDiscVar(variable);
        }

        @Override
        public PlcVarExpression getAddressableForContvar(ContVariable variable, boolean getDerivative) {
            return this.rootProvider.getAddressableForContvar(variable, getDerivative);
        }
    }
}

