/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEnumUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTypeDecl;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcEnumLiteral;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultTypeGenerator
implements TypeGenerator {
    private final PlcTarget target;
    private final PlcElementaryType standardIntType;
    private final PlcElementaryType standardRealType;
    private final ConvertEnums enumConversion;
    private final Map<TypeEqHashWrap, String> structNames = Maps.map();
    private final Map<String, PlcStructType> structTypes = Maps.map();
    private final Map<CifEnumUtils.EnumDeclEqHashWrap, EnumDeclData> enumDeclNames = Maps.map();

    public DefaultTypeGenerator(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.standardIntType = target.getIntegerType();
        this.standardRealType = target.getRealType();
        this.enumConversion = settings.enumConversion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PlcType convertType(CifType type) {
        if (type instanceof BoolType) {
            return PlcElementaryType.BOOL_TYPE;
        }
        if (type instanceof IntType) {
            return this.standardIntType;
        }
        if (type instanceof RealType) {
            return this.standardRealType;
        }
        CifType cifType = type;
        if (cifType instanceof TypeRef) {
            void typeRef;
            TypeRef typeRef2 = (TypeRef)cifType;
            TypeRef cfr_ignored_0 = (TypeRef)cifType;
            return this.convertType(typeRef.getType().getType());
        }
        CifType cifType2 = type;
        if (cifType2 instanceof TupleType) {
            void tupleType;
            TupleType tupleType2 = (TupleType)cifType2;
            TupleType cfr_ignored_1 = (TupleType)cifType2;
            return this.convertTupleType((TupleType)tupleType);
        }
        CifType cifType3 = type;
        if (cifType3 instanceof EnumType) {
            void enumType;
            EnumType enumType2 = (EnumType)cifType3;
            EnumType cfr_ignored_2 = (EnumType)cifType3;
            return this.convertEnumDecl(enumType.getEnum());
        }
        CifType cifType4 = type;
        if (cifType4 instanceof ListType) {
            void arrayType;
            ListType listType = (ListType)cifType4;
            ListType cfr_ignored_3 = (ListType)cifType4;
            int size = arrayType.getLower();
            Assert.check((boolean)CifTypeUtils.isArrayType((ListType)arrayType));
            Assert.check((!(arrayType.getElementType() instanceof ListType) ? 1 : 0) != 0);
            PlcType elemType = this.convertType(arrayType.getElementType());
            return new PlcArrayType(0, size == 0 ? 0 : size - 1, elemType);
        }
        throw new RuntimeException("Unexpected type: " + type);
    }

    private PlcType convertTupleType(TupleType tupleType) {
        TypeEqHashWrap typeWrap = new TypeEqHashWrap((CifType)tupleType, true, false);
        String sname = this.structNames.get(typeWrap);
        if (sname == null) {
            PlcStructType structType = new PlcStructType();
            int fieldNumber = 1;
            for (Field field : tupleType.getFields()) {
                String fieldName = "field" + String.valueOf(fieldNumber);
                PlcType ftype = this.convertType(field.getType());
                structType.fields.add(new PlcVariable(fieldName, ftype));
                ++fieldNumber;
            }
            sname = this.target.getNameGenerator().generateGlobalName("TupleStruct", false);
            PlcTypeDecl typeDecl = new PlcTypeDecl(sname, structType);
            this.structNames.put(typeWrap, sname);
            this.structTypes.put(sname, structType);
            this.target.getCodeStorage().addTypeDecl(typeDecl);
        }
        return new PlcDerivedType(sname);
    }

    @Override
    public PlcStructType getStructureType(PlcType type) {
        Assert.check((boolean)(type instanceof PlcDerivedType));
        PlcStructType structType = this.structTypes.get(((PlcDerivedType)type).name);
        Assert.notNull((Object)structType);
        return structType;
    }

    @Override
    public PlcType convertEnumDecl(EnumDecl enumDecl) {
        return this.ensureEnumDecl((EnumDecl)enumDecl).enumDeclType;
    }

    private EnumDeclData ensureEnumDecl(EnumDecl enumDecl) {
        CifEnumUtils.EnumDeclEqHashWrap wrappedEnumDecl = new CifEnumUtils.EnumDeclEqHashWrap(enumDecl);
        EnumDeclData declData = this.enumDeclNames.get(wrappedEnumDecl);
        if (declData == null) {
            declData = this.makeEnumDeclData(enumDecl);
            this.enumDeclNames.put(wrappedEnumDecl, declData);
        }
        return declData;
    }

    @Override
    public PlcEnumLiteral getPlcEnumLiteral(EnumLiteral enumLit) {
        EnumDecl enumDecl = (EnumDecl)enumLit.eContainer();
        return this.ensureEnumDecl(enumDecl).getLiteral(enumLit);
    }

    public EnumDeclData makeEnumDeclData(EnumDecl enumDecl) {
        Assert.check((boolean)this.enumConversion.equals((Object)ConvertEnums.NO));
        EList cifLiterals = enumDecl.getLiterals();
        PlcEnumLiteral[] literals = new PlcEnumLiteral[cifLiterals.size()];
        int litIndex = 0;
        for (EnumLiteral lit : cifLiterals) {
            String litName = this.target.getNameGenerator().generateGlobalName(CifTextUtils.getAbsName((PositionObject)lit, (boolean)false), true);
            literals[litIndex] = new PlcEnumLiteral(litName);
            ++litIndex;
        }
        String declName = this.target.getNameGenerator().generateGlobalName(CifTextUtils.getAbsName((PositionObject)enumDecl, (boolean)false), true);
        PlcDerivedType declType = new PlcDerivedType(declName);
        PlcEnumType plcEnumType = new PlcEnumType(Arrays.stream(literals).map(v -> v.value).collect(Collectors.toList()));
        this.target.getCodeStorage().addTypeDecl(new PlcTypeDecl(declName, plcEnumType));
        return new EnumDeclData(declType, literals);
    }

    private static class EnumDeclData {
        public final PlcType enumDeclType;
        private final PlcEnumLiteral[] values;

        public EnumDeclData(PlcType enumDeclType, PlcEnumLiteral[] values) {
            this.enumDeclType = enumDeclType;
            this.values = values;
        }

        public PlcEnumLiteral getLiteral(EnumLiteral literal) {
            EnumDecl enumDecl = (EnumDecl)literal.eContainer();
            return this.values[enumDecl.getLiterals().indexOf((Object)literal)];
        }
    }
}

