/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.StateInitVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.generators.VariableStorage;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultVariableStorage
implements VariableStorage {
    private final PlcTarget target;
    private final Map<Declaration, PlcVariable> variables = Maps.map();

    public DefaultVariableStorage(PlcTarget target) {
        this.target = target;
    }

    @Override
    public void addStateVariable(Declaration decl, CifType type) {
        PlcType varType = this.target.getTypeGenerator().convertType(type);
        String varName = this.target.getNameGenerator().generateGlobalName((PositionObject)decl);
        PlcVariable plcVar = new PlcVariable(varName, varType);
        this.variables.put(decl, plcVar);
        this.target.getCodeStorage().addStateVariable(plcVar);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process() {
        ExprGenerator exprGen = this.target.getCodeStorage().getExprGenerator();
        StateInitVarOrderer varOrderer = new StateInitVarOrderer();
        for (Declaration decl : this.variables.keySet()) {
            if (!(decl instanceof DiscVariable)) continue;
            varOrderer.addObject((Object)decl);
        }
        List statements = Lists.list();
        statements.add(new PlcCommentLine("Initialize the state variables."));
        for (Declaration decl : varOrderer.computeOrder(true)) {
            void discVar;
            Declaration declaration = decl;
            if (!(declaration instanceof DiscVariable)) {
                throw new AssertionError((Object)("Unexpected kind of variable " + decl));
            }
            DiscVariable cfr_ignored_0 = (DiscVariable)declaration;
            DiscVariable cfr_ignored_1 = (DiscVariable)declaration;
            ExprValueResult exprResult = exprGen.convertValue((Expression)Lists.first((List)discVar.getValue().getValues()));
            statements.addAll(exprResult.code);
            exprGen.releaseTempVariables(exprResult.codeVariables);
            PlcVarExpression lhs = new PlcVarExpression(this.variables.get(decl), new PlcVarExpression.PlcProjection[0]);
            statements.add(new PlcAssignmentStatement(lhs, exprResult.value));
            exprGen.releaseTempVariables(exprResult.valueVariables);
        }
        this.target.getCodeStorage().addStateInitialization(statements);
    }

    @Override
    public CifDataProvider getRootCifDataProvider() {
        return new CifDataProvider(){

            @Override
            public PlcExpression getValueForConstant(Constant constant) {
                return new PlcVarExpression(new PlcVariable("someConstantvariable", PlcElementaryType.LREAL_TYPE), new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForDiscVar(DiscVariable variable) {
                PlcVariable plcDiscvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcDiscvar);
                return new PlcVarExpression(plcDiscvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForDiscVar(DiscVariable variable) {
                PlcVariable plcDiscvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcDiscvar);
                return new PlcVarExpression(plcDiscvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForContvar(ContVariable variable, boolean getDerivative) {
                return new PlcVarExpression(new PlcVariable("someContvariable", PlcElementaryType.LREAL_TYPE), new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForContvar(ContVariable variable, boolean getDerivative) {
                return new PlcVarExpression(new PlcVariable("someContvariable", PlcElementaryType.LREAL_TYPE), new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForInputVar(InputVariable variable) {
                PlcVariable plcInpvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcInpvar);
                return new PlcVarExpression(plcInpvar, new PlcVarExpression.PlcProjection[0]);
            }
        };
    }
}

