/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.model.PlcModelUtils;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouInstance;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTask;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTypeDecl;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;

public class PlcCodeStorage {
    private final PlcTarget target;
    private final PlcProject project;
    private final PlcResource resource;
    private final PlcTask task;
    private PlcGlobalVarList globalConstants = null;
    private PlcGlobalVarList globalInputs = null;
    private PlcGlobalVarList globalOutputs = null;
    private PlcGlobalVarList globalStateVars = null;
    private ExprGenerator exprGenerator = null;
    private PlcVariable isProgressVariable = null;
    private List<PlcStatement> stateInitializationCode = null;
    private List<PlcStatement> eventTransitionsIterationCode = null;

    public PlcCodeStorage(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.project = new PlcProject(settings.projectName);
        PlcConfiguration config = new PlcConfiguration(settings.configurationName);
        this.project.configurations.add(config);
        this.resource = new PlcResource(settings.resourceName);
        config.resources.add(this.resource);
        this.task = new PlcTask(settings.taskName, settings.taskCycleTime, settings.taskPriority);
        this.resource.tasks.add(this.task);
    }

    public ExprGenerator getExprGenerator() {
        if (this.exprGenerator == null) {
            this.exprGenerator = new ExprGenerator(this.target, this.target.getVarStorage().getRootCifDataProvider());
        }
        return this.exprGenerator;
    }

    public PlcVariable getIsProgressVariable() {
        if (this.isProgressVariable == null) {
            this.isProgressVariable = this.getExprGenerator().getTempVariable("isProgress", PlcElementaryType.BOOL_TYPE);
        }
        return this.isProgressVariable;
    }

    public void addConstant(PlcVariable var) {
        Assert.check((boolean)this.target.supportsConstants());
        if (this.globalConstants == null) {
            this.globalConstants = new PlcGlobalVarList("CONSTANTS", true);
        }
        this.globalConstants.variables.add(var);
    }

    public void addInputVariable(PlcVariable var) {
        if (this.globalInputs == null) {
            this.globalInputs = new PlcGlobalVarList("INPUTS", false);
        }
        this.globalInputs.variables.add(var);
    }

    public void addOutputVariable(PlcVariable var) {
        if (this.globalOutputs == null) {
            this.globalOutputs = new PlcGlobalVarList("OUTPUTS", false);
        }
        this.globalOutputs.variables.add(var);
    }

    public void addStateVariable(PlcVariable var) {
        if (this.globalStateVars == null) {
            this.globalStateVars = new PlcGlobalVarList("STATE", false);
        }
        this.globalStateVars.variables.add(var);
    }

    public void addTypeDecl(PlcTypeDecl decl) {
        this.project.typeDecls.add(decl);
    }

    public void addStateInitialization(List<PlcStatement> stateInitializationCode) {
        Assert.check((this.stateInitializationCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(stateInitializationCode)) {
            this.stateInitializationCode = stateInitializationCode;
        }
    }

    public void addEventTransitions(List<PlcStatement> eventTransitionsIterationCode) {
        Assert.check((this.eventTransitionsIterationCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(eventTransitionsIterationCode)) {
            this.eventTransitionsIterationCode = eventTransitionsIterationCode;
        }
    }

    public void finishPlcProgram() {
        this.addGlobalVariableTable(this.globalConstants);
        this.addGlobalVariableTable(this.globalInputs);
        this.addGlobalVariableTable(this.globalOutputs);
        this.addGlobalVariableTable(this.globalStateVars);
        PlcPou main = new PlcPou("MAIN", PlcPouType.PROGRAM, null);
        this.project.pous.add(main);
        PlcGlobalVarList mainVariables = new PlcGlobalVarList("TIMERS", false);
        this.addGlobalVariableTable(mainVariables);
        ExprGenerator exprGen = this.getExprGenerator();
        if (this.stateInitializationCode != null) {
            PlcVariable firstFlag = exprGen.makeLocalVariable("firstRun", PlcElementaryType.BOOL_TYPE, null, new PlcBoolLiteral(true));
            mainVariables.variables.add(firstFlag);
            CodeBox box = main.body;
            box.add("IF %s THEN", new Object[]{firstFlag.name});
            box.indent();
            box.add("%s := FALSE;", new Object[]{firstFlag.name});
            box.add();
            this.target.getModelTextGenerator().toText(this.stateInitializationCode, box, main.name, false);
            box.dedent();
            box.add("END_IF;");
            if (this.eventTransitionsIterationCode != null) {
                String progressVarName = this.getIsProgressVariable().name;
                box.add();
                box.add("%s := TRUE;", new Object[]{progressVarName});
                box.add("WHILE %s DO", new Object[]{progressVarName});
                box.indent();
                box.add("%s := FALSE;", new Object[]{progressVarName});
                box.add();
                this.target.getModelTextGenerator().toText(this.eventTransitionsIterationCode, box, main.name, false);
                box.dedent();
                box.add("END_WHILE;");
            }
        }
        exprGen.releaseTempVariable(this.isProgressVariable);
        PlcDerivedType tonType = new PlcDerivedType("TON");
        mainVariables.variables.add(exprGen.makeLocalVariable("timer0", tonType));
        mainVariables.variables.add(exprGen.makeLocalVariable("timer1", tonType));
        mainVariables.variables.add(exprGen.makeLocalVariable("curTimer", PlcElementaryType.INT_TYPE, null, new PlcIntLiteral(0)));
        main.tempVars = exprGen.getCreatedTempVariables();
        this.task.pouInstances.add(new PlcPouInstance("MAIN", main));
    }

    private void addGlobalVariableTable(PlcGlobalVarList varTable) {
        if (varTable != null) {
            this.resource.globalVarLists.add(varTable);
        }
    }

    public void writeOutput() {
        this.target.writeOutput(this.project);
    }
}

