/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.functions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;

public abstract class PlcBasicFuncDescription {
    public final String prefixFuncName;
    public final Map<String, PlcParameterDescription> prefixParameters;
    public final String infixFuncName;
    public final ExprBinding infixBinding;

    public PlcBasicFuncDescription(String prefixFuncName, PlcParameterDescription[] prefixParameters, String infixFuncName, ExprBinding infixBinding) {
        this(prefixFuncName, Arrays.asList(prefixParameters), infixFuncName, infixBinding);
    }

    public PlcBasicFuncDescription(String prefixFuncName, List<PlcParameterDescription> prefixParameters, String infixFuncName, ExprBinding infixBinding) {
        this.prefixFuncName = prefixFuncName;
        this.infixFuncName = infixFuncName;
        this.infixBinding = infixBinding;
        this.prefixParameters = Maps.mapc((int)prefixParameters.size());
        for (PlcParameterDescription prefixParam : prefixParameters) {
            this.prefixParameters.put(prefixParam.name, prefixParam);
        }
        Assert.areEqual((Object)this.prefixParameters.size(), (Object)prefixParameters.size());
    }

    public static enum ExprAssociativity {
        LEFT,
        RIGHT,
        NONE,
        ALWAYS;


        boolean needsParentheses(boolean atLeft, boolean atRight) {
            return this == ALWAYS || this == LEFT && !atLeft || this == RIGHT && !atRight;
        }
    }

    public static enum ExprBinding {
        UNARY_EXPR(1, ExprAssociativity.RIGHT),
        POWER_EXPR(2, ExprAssociativity.ALWAYS),
        MUL_EXPR(3, ExprAssociativity.LEFT),
        ADD_EXPR(4, ExprAssociativity.LEFT),
        ORDER_EXPR(5, ExprAssociativity.ALWAYS),
        EQUAL_EXPR(6, ExprAssociativity.ALWAYS),
        CONJUNCT_EXPR(7, ExprAssociativity.LEFT),
        EXCL_DISJUNCT_EXPR(8, ExprAssociativity.LEFT),
        DISJUNCT_EXPR(9, ExprAssociativity.LEFT),
        NO_PRIORITY(Integer.MAX_VALUE, ExprAssociativity.NONE);

        public final int priority;
        public final ExprAssociativity associativity;

        private ExprBinding(int priority, ExprAssociativity associativity) {
            this.priority = priority;
            this.associativity = associativity;
        }

        public boolean needsParentheses(ExprBinding parentBinding, boolean atLeft, boolean atRight) {
            if (parentBinding.priority != this.priority) {
                return parentBinding.priority < this.priority;
            }
            return parentBinding.associativity.needsParentheses(atLeft, atRight);
        }

        public boolean needsParentheses(ExprBinding parentBinding) {
            return this.needsParentheses(parentBinding, false, false);
        }
    }

    public static enum PlcParamDirection {
        OUTPUT_ONLY,
        INPUT_OUTPUT,
        INPUT_ONLY;

    }

    public static class PlcParameterDescription {
        public final String name;
        public final PlcParamDirection direction;

        public PlcParameterDescription(String name, PlcParamDirection direction) {
            this.name = name;
            this.direction = direction;
        }
    }
}

