/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.types;

import org.eclipse.escet.cif.plcgen.model.types.PlcType;

public class PlcElementaryType
extends PlcType {
    public static final PlcElementaryType BOOL_TYPE = new PlcElementaryType("BOOL");
    public static final PlcElementaryType INT_TYPE = new PlcElementaryType("INT");
    public static final PlcElementaryType DINT_TYPE = new PlcElementaryType("DINT");
    public static final PlcElementaryType LINT_TYPE = new PlcElementaryType("LINT");
    public static final PlcElementaryType REAL_TYPE = new PlcElementaryType("REAL");
    public static final PlcElementaryType LREAL_TYPE = new PlcElementaryType("LREAL");
    public static final PlcElementaryType TIME_TYPE = new PlcElementaryType("TIME");
    public final String name;

    public PlcElementaryType(String name) {
        this.name = name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void elementaryType;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!(object instanceof PlcElementaryType)) {
            return false;
        }
        PlcElementaryType plcElementaryType = (PlcElementaryType)object;
        PlcElementaryType cfr_ignored_0 = (PlcElementaryType)object;
        return this.name.equals(elementaryType.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    public static PlcElementaryType getIntTypeBySize(int numBits) {
        switch (numBits) {
            case 16: {
                return INT_TYPE;
            }
            case 32: {
                return DINT_TYPE;
            }
            case 64: {
                return LINT_TYPE;
            }
        }
        throw new AssertionError((Object)("Unexpected integer size " + String.valueOf(numBits) + " found."));
    }

    public static PlcElementaryType getRealTypeBySize(int numBits) {
        switch (numBits) {
            case 32: {
                return REAL_TYPE;
            }
            case 64: {
                return LREAL_TYPE;
            }
        }
        throw new AssertionError((Object)("Unexpected real size " + String.valueOf(numBits) + " found."));
    }
}

