/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.targets;

import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.generators.CifProcessor;
import org.eclipse.escet.cif.plcgen.generators.DefaultNameGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultTransitionGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultTypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultVariableStorage;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcCodeStorage;
import org.eclipse.escet.cif.plcgen.generators.TransitionGenerator;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.VariableStorage;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.options.PlcNumberBits;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.Writer;

public abstract class PlcBaseTarget
implements PlcTarget {
    public static final int CIF_INTEGER_SIZE = 32;
    public static final int CIF_REAL_SIZE = 64;
    public final PlcTargetType targetType;
    private PlcNumberBits intTypeSize;
    private PlcNumberBits realTypeSize;
    private String outputPath;
    private final ModelTextGenerator modelTextGenerator = new ModelTextGenerator();
    protected CifProcessor cifProcessor;
    protected TransitionGenerator transitionGenerator;
    protected VariableStorage varStorage;
    protected TypeGenerator typeGenerator;
    protected PlcCodeStorage codeStorage;
    protected NameGenerator nameGenerator;

    public PlcBaseTarget(PlcTargetType targetType) {
        this.targetType = targetType;
    }

    public void setup(PlcGenSettings settings) {
        this.intTypeSize = settings.intTypeSize;
        this.realTypeSize = settings.realTypeSize;
        this.outputPath = settings.outputPath;
        if (settings.intTypeSize.getTypeSize(32) < 32) {
            settings.warnOutput.warn("Configured integer type size is less than the CIF integer type size. Some values in the program may be truncated.");
        } else if (this.getMaxIntegerTypeSize() < 32) {
            settings.warnOutput.warn("Maximum integer type size supported by the PLC is less than the CIF integer type size. Some values in the program may be truncated.");
        }
        if (settings.realTypeSize.getTypeSize(64) < 64) {
            settings.warnOutput.warn("Configured real type size is less than the CIF real type size. Some values in the program may be truncated.");
        } else if (this.getMaxRealTypeSize() < 64) {
            settings.warnOutput.warn("Maximum real type size supported by the PLC is less than the CIF real type size. Some values in the program may be truncated.");
        }
    }

    public void generate(PlcGenSettings settings) {
        this.setup(settings);
        this.nameGenerator = new DefaultNameGenerator(settings);
        this.codeStorage = new PlcCodeStorage(this, settings);
        this.typeGenerator = new DefaultTypeGenerator(this, settings);
        this.varStorage = new DefaultVariableStorage(this);
        this.cifProcessor = new CifProcessor(this, settings);
        this.transitionGenerator = new DefaultTransitionGenerator(this);
        this.cifProcessor.process();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.varStorage.process();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.transitionGenerator.generate();
        this.codeStorage.finishPlcProgram();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.codeStorage.writeOutput();
    }

    protected abstract Writer getPlcCodeWriter();

    @Override
    public PlcTargetType getTargetType() {
        return this.targetType;
    }

    @Override
    public ModelTextGenerator getModelTextGenerator() {
        return this.modelTextGenerator;
    }

    @Override
    public CifProcessor getCifProcessor() {
        return this.cifProcessor;
    }

    @Override
    public TransitionGenerator getTransitionGenerator() {
        return this.transitionGenerator;
    }

    @Override
    public VariableStorage getVarStorage() {
        return this.varStorage;
    }

    @Override
    public TypeGenerator getTypeGenerator() {
        return this.typeGenerator;
    }

    @Override
    public PlcCodeStorage getCodeStorage() {
        return this.codeStorage;
    }

    @Override
    public NameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    @Override
    public boolean supportsOperation(PlcFuncOperation funcOper) {
        return true;
    }

    @Override
    public boolean supportsInfixNotation(PlcFuncOperation funcOper) {
        return true;
    }

    @Override
    public boolean supportsPower(boolean baseIsInt, boolean exponentIsInt) {
        return !baseIsInt;
    }

    protected abstract int getMaxIntegerTypeSize();

    @Override
    public PlcElementaryType getIntegerType() {
        int generatorBestIntSize = Math.min(32, this.getMaxIntegerTypeSize());
        int userSpecifiedIntSize = this.intTypeSize.getTypeSize(generatorBestIntSize);
        return PlcElementaryType.getIntTypeBySize(userSpecifiedIntSize);
    }

    protected abstract int getMaxRealTypeSize();

    @Override
    public PlcElementaryType getRealType() {
        int generatorBestRealSize = Math.min(64, this.getMaxRealTypeSize());
        int userSpecifiedRealSize = this.realTypeSize.getTypeSize(generatorBestRealSize);
        return PlcElementaryType.getRealTypeBySize(userSpecifiedRealSize);
    }

    @Override
    public void writeOutput(PlcProject project) {
        Writer writer = this.getPlcCodeWriter();
        writer.write(project, this.outputPath);
    }
}

