/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.targets;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.targets.PlcBaseTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.S7Writer;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.java.Assert;

public class SiemensS7Target
extends PlcBaseTarget {
    private static final Map<PlcTargetType, String> OUT_SUFFIX_REPLACEMENTS = Map.of(PlcTargetType.S7_300, "_s7_300", PlcTargetType.S7_400, "_s7_400", PlcTargetType.S7_1200, "_s7_1200", PlcTargetType.S7_1500, "_s7_1500");
    private static final Map<PlcTargetType, Integer> MAX_INTEGER_SIZES = Map.of(PlcTargetType.S7_300, 32, PlcTargetType.S7_400, 32, PlcTargetType.S7_1200, 32, PlcTargetType.S7_1500, 64);
    private static final Map<PlcTargetType, Integer> MAX_REAL_SIZES = Map.of(PlcTargetType.S7_300, 32, PlcTargetType.S7_400, 32, PlcTargetType.S7_1200, 64, PlcTargetType.S7_1500, 64);

    public SiemensS7Target(PlcTargetType targetType) {
        super(targetType);
        Assert.check((boolean)OUT_SUFFIX_REPLACEMENTS.containsKey((Object)targetType));
    }

    @Override
    public Writer getPlcCodeWriter() {
        return new S7Writer(this);
    }

    @Override
    public boolean supportsArrays() {
        return false;
    }

    @Override
    public boolean supportsConstants() {
        return true;
    }

    @Override
    public boolean supportsEnumerations() {
        return false;
    }

    @Override
    public boolean supportsPower(boolean baseIsInt, boolean exponentIsInt) {
        if (EnumSet.of(PlcTargetType.S7_300, PlcTargetType.S7_400).contains((Object)this.targetType)) {
            return !baseIsInt && !exponentIsInt;
        }
        return super.supportsPower(baseIsInt, exponentIsInt);
    }

    @Override
    public boolean supportsOperation(PlcFuncOperation funcOper) {
        return funcOper != PlcFuncOperation.STDLIB_LOG;
    }

    @Override
    public int getMaxIntegerTypeSize() {
        return MAX_INTEGER_SIZES.get((Object)this.targetType);
    }

    @Override
    public int getMaxRealTypeSize() {
        return MAX_REAL_SIZES.get((Object)this.targetType);
    }

    @Override
    public String getPathSuffixReplacement() {
        return OUT_SUFFIX_REPLACEMENTS.get((Object)this.targetType);
    }
}

