/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTypeDecl;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.Box;

public class Iec611313Writer
extends Writer {
    public Iec611313Writer(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, String outPath) {
        this.ensureDirectory(outPath);
        for (PlcConfiguration config : project.configurations) {
            this.write(config, outPath);
        }
        for (PlcPou pou : project.pous) {
            this.write(pou, outPath);
        }
        for (PlcTypeDecl typeDecl : project.typeDecls) {
            this.write(typeDecl, outPath);
        }
    }

    private void write(PlcConfiguration config, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, String.valueOf(config.name) + ".plccfg"});
        Box code = this.toBox(config);
        code.writeToFile(path);
    }

    private void write(PlcPou pou, String outPath) {
        String ext = pou.retType == null ? ".plcprog" : ".plcfunc";
        String path = Paths.join((String[])new String[]{outPath, String.valueOf(pou.name) + ext});
        Box code = this.toBox(pou);
        code.writeToFile(path);
    }

    private void write(PlcTypeDecl typeDecl, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, String.valueOf(typeDecl.name) + ".plctype"});
        Box code = this.toBox(typeDecl);
        code.writeToFile(path);
    }
}

