/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEnumUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.simulator.compiler.AlgVarCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.AutomatonCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.DebugSimulatorCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.EventCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.FuncCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.StateCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.TupleTypeCodeGenerator;
import org.eclipse.escet.cif.simulator.options.CompileOnlyOption;
import org.eclipse.escet.cif.simulator.options.CompiledCodeFileOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputType;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.javacompiler.JavaCompilerOption;
import org.eclipse.escet.common.app.framework.javacompiler.ResourceClassLoader;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeClassLoader;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompiler;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompilerException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.PairTextComparer;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.ui.PlatformUI;

public class CifCompilerContext {
    public static final String VERSION_RES_NAME = "version.dat";
    public static final String ALG_MTHD_PREFIX = "a";
    public static final String AUT_CLS_PREFIX = "Aut";
    public static final String CONST_FLD_PREFIX = "C";
    public static final String DER_MTHD_PREFIX = "d";
    public static final String ENUM_DECL_CLS_PREFIX = "E";
    public static final String ENUM_LIT_CONST_PREFIX = "elit";
    public static final String EVENT_CLS_PREFIX = "Event";
    public static final String EVENT_FLD_PREFIX = "evt";
    public static final String FUNC_CLS_PREFIX = "F";
    public static final String FUNC_FLD_PREFIX = "f";
    public static final String TUPLE_TYPE_FLD_PREFIX = "field";
    public static final String FUNC_TYPE_CLS_PREFIX = "FuncType";
    public static final String DEFAULT_VALUE_MTHD_PREFIX = "dv";
    public static final String LP_FLD_PREFIX = "lp";
    public static final String FUNC_PARAM_MTHD_PARAM_PREFIX = "p";
    public static final String AUT_SUB_STATE_FLD_PREFIX = "s";
    public static final String TUPLE_TYPE_CLS_PREFIX = "TupleType";
    public static final String CONT_VAR_FLD_PREFIX = "v";
    public static final String DISC_VAR_FLD_PREFIX = "v";
    public static final String FUNCVAR_VAR_PREFIX = "v";
    public static final String INPUT_VAR_FLD_PREFIX = "v";
    public static final String LITERAL_READER_CLS_NAME = "LiteralReader";
    public static final String LITERAL_READER_MTHD_PREFIX = "read";
    public static final String LITERAL_FILE_PREFIX = "literal";
    public static final String RCVD_VALUE_VAR_NAME = "rcvd";
    public static final String PACKAGE = "cifcode";
    public static final String LOC_POINTER_TYPE = "int";
    public static final String CONT_SUB_STATE_FIELD_NAME = "s";
    public static final String INPUT_SUB_STATE_FIELD_NAME = "i";
    public static final String DBG_PROJ_NAME = "org.eclipse.escet.cif.simulator.debug";
    public static final String DBG_SIM_CLS_NAME = "DebugSimulator";
    public static final String FILE_EXT_LOC_NAMES = "locnames";
    public static final String FILE_EXT_EDGE_DATA = "edgedata";
    public final Event tauEvent = CifConstructors.newEvent(null, null, (String)"tau", null, null);
    public Application<?> app;
    private Specification spec;
    private String specFileDir;
    private List<Event> events = null;
    private List<InputVariable> inputVariables = null;
    private List<AlgVariable> algVars = null;
    private List<Declaration> stateVars = null;
    private List<Automaton> automata = null;
    private Map<Automaton, Set<Event>> alphabets = Maps.map();
    private Map<Automaton, Set<Event>> sendAlphabets = Maps.map();
    private Map<Automaton, Set<Event>> receiveAlphabets = Maps.map();
    private Map<Automaton, Set<Event>> monitors = Maps.map();
    private Map<Event, List<Automaton>> syncAuts = Maps.map();
    private Map<Event, List<Automaton>> sendAuts = Maps.map();
    private Map<Event, List<Automaton>> recvAuts = Maps.map();
    public boolean hasTauEdge = false;
    private Map<EnumDecl, EnumDecl> enumDeclReprs = null;
    private Map<TypeEqHashWrap, String> defaultValueNames = Maps.map();
    private int defaultValueNamesCount = 0;
    private int literalDataFileCount = 0;
    private Map<TypeEqHashWrap, String> funcTypes = Maps.map();
    public Map<TypeEqHashWrap, String> literalTypes = Maps.map();
    private Map<TypeEqHashWrap, String> tupleTypes = Maps.map();
    private int funcTypeCount = 0;
    private int tupleTypeCount = 0;
    private List<InternalFunction> funcTypeDefaultValueFuncs = Lists.list();
    private final Specification dummyFuncSpec = CifConstructors.newSpecification();
    public int svgFileCount = -1;
    public int printFileCount = -1;
    public boolean needSampler = false;
    private Map<String, JavaCodeFile> code = Maps.map();
    private Map<String, ByteArrayOutputStream> resources = Maps.map();
    private Set<String> usedNames = Sets.set();
    private Map<String, Map<PositionObject, String>> objects = Maps.map();
    private RuntimeJavaCompiler compiler;

    public void setSpecification(Specification spec, String specFileDir) {
        Assert.check((this.spec == null ? 1 : 0) != 0);
        Assert.notNull((Object)spec);
        this.spec = spec;
        this.specFileDir = specFileDir;
    }

    public String getSpecFileDir() {
        if (this.specFileDir == null) {
            throw new IllegalStateException();
        }
        return this.specFileDir;
    }

    public JavaCodeFile addCodeFile(String name) {
        JavaCodeFile file = new JavaCodeFile(PACKAGE, name);
        file.imports.addAll(this.getImports());
        JavaCodeFile previous = this.code.put(name, file);
        Assert.check((previous == null ? 1 : 0) != 0);
        return file;
    }

    public ByteArrayOutputStream addResourceFile(String resPath) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteArrayOutputStream previous = this.resources.put(resPath, stream);
        Assert.check((previous == null ? 1 : 0) != 0);
        return stream;
    }

    public static String getLocNamesResourcePath(String className) {
        return String.valueOf(className.replace('.', '/')) + "." + FILE_EXT_LOC_NAMES;
    }

    public static String getEdgeDataResourcePath(String className) {
        return String.valueOf(className.replace('.', '/')) + "." + FILE_EXT_EDGE_DATA;
    }

    private String getName(PositionObject obj, String prefix, boolean abs) {
        String name;
        Map prefixMap = this.objects.get(prefix);
        if (prefixMap == null) {
            prefixMap = Maps.map();
            this.objects.put(prefix, prefixMap);
        }
        if ((name = (String)prefixMap.get(obj)) == null) {
            name = obj == this.tauEvent ? "tau" : (abs ? CifTextUtils.getAbsName((PositionObject)obj, (boolean)false).replace('.', '_') : CifTextUtils.getName((PositionObject)obj));
            name = String.valueOf(prefix) + "_" + name;
            if (this.usedNames.contains(name)) {
                name = CifScopeUtils.getUniqueName((String)name, this.usedNames, Collections.emptySet());
            }
            this.usedNames.add(name);
            prefixMap.put(obj, name);
        }
        return name;
    }

    public String getEnumClassName(EnumDecl enumDecl) {
        return this.getName((PositionObject)this.getEnumDeclReprs().get(enumDecl), ENUM_DECL_CLS_PREFIX, true);
    }

    public String getEnumConstName(EnumLiteral enumLit) {
        return "elit_" + enumLit.getName();
    }

    public String getEventClassName(Event event) {
        return this.getName((PositionObject)event, EVENT_CLS_PREFIX, true);
    }

    public String getEventFieldName(Event event) {
        return this.getName((PositionObject)event, EVENT_FLD_PREFIX, true);
    }

    public String getAutClassName(Automaton aut) {
        return this.getName((PositionObject)aut, AUT_CLS_PREFIX, true);
    }

    public String getAutSubStateFieldName(Automaton aut) {
        return this.getName((PositionObject)aut, "s", true);
    }

    public String getLocationPointerFieldName(Automaton aut) {
        return this.getName((PositionObject)aut, LP_FLD_PREFIX, true);
    }

    public String getDiscVarFieldName(DiscVariable var) {
        return this.getName((PositionObject)var, "v", false);
    }

    public String getInputVarFieldName(InputVariable var) {
        return this.getName((PositionObject)var, "v", true);
    }

    public String getContVarFieldName(ContVariable var) {
        EObject parent = var.eContainer();
        if (parent instanceof Automaton) {
            return this.getName((PositionObject)var, "v", false);
        }
        return this.getName((PositionObject)var, "v", true);
    }

    public String getContVarSubStateName(ContVariable var) {
        EObject parent = var.eContainer();
        if (parent instanceof Automaton) {
            return this.getAutSubStateFieldName((Automaton)parent);
        }
        return "s";
    }

    public String getDerivativeMethodName(ContVariable var) {
        return this.getName((PositionObject)var, DER_MTHD_PREFIX, true);
    }

    public String getAlgVarMethodName(AlgVariable var) {
        return this.getName((PositionObject)var, ALG_MTHD_PREFIX, true);
    }

    public String getConstFieldName(Constant constant) {
        return this.getName((PositionObject)constant, CONST_FLD_PREFIX, true);
    }

    public String getFuncClassName(Function function) {
        return this.getName((PositionObject)function, FUNC_CLS_PREFIX, true);
    }

    public String getFuncFieldName(Function function) {
        return this.getName((PositionObject)function, FUNC_FLD_PREFIX, true);
    }

    public String getFuncParamMethodParamName(DiscVariable param) {
        return "p_" + param.getName();
    }

    public String getFuncLocalVarName(DiscVariable var) {
        return "v_" + var.getName();
    }

    public String getFuncTypeClassName(FuncType funcType) {
        TypeEqHashWrap wrap = new TypeEqHashWrap((CifType)funcType, true);
        String name = this.funcTypes.get(wrap);
        if (name == null) {
            ++this.funcTypeCount;
            name = "FuncType_" + this.funcTypeCount;
            this.funcTypes.put(wrap, name);
            FuncCodeGenerator.gencodeFuncType(funcType, name, this);
        }
        return name;
    }

    public String getLiteralReadMethodName(CifType type) {
        if ((type = CifTypeUtils.normalizeType((CifType)type)) instanceof BoolType) {
            return "RuntimeLiteralReader.readBoolLiteral";
        }
        if (type instanceof RealType) {
            return "RuntimeLiteralReader.readRealLiteral";
        }
        if (type instanceof StringType) {
            return "RuntimeLiteralReader.readStringLiteral";
        }
        if (type instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)type))) {
            return "RuntimeLiteralReader.readIntLiteral";
        }
        TypeEqHashWrap wrap = new TypeEqHashWrap(type, false);
        String name = this.literalTypes.get(wrap);
        if (name == null) {
            name = LITERAL_READER_MTHD_PREFIX + this.literalTypes.size();
            this.literalTypes.put(wrap, name);
            if (!(type instanceof IntType) && !(type instanceof EnumType)) {
                if (type instanceof ListType) {
                    this.getLiteralReadMethodName(((ListType)type).getElementType());
                } else if (type instanceof SetType) {
                    this.getLiteralReadMethodName(((SetType)type).getElementType());
                } else if (type instanceof TupleType) {
                    for (Field field : ((TupleType)type).getFields()) {
                        this.getLiteralReadMethodName(field.getType());
                    }
                } else if (type instanceof DictType) {
                    this.getLiteralReadMethodName(((DictType)type).getKeyType());
                    this.getLiteralReadMethodName(((DictType)type).getValueType());
                } else {
                    throw new RuntimeException("Unexpected literal type: " + type);
                }
            }
        }
        return "LiteralReader." + name;
    }

    public String getTupleTypeClassName(TupleType tupleType) {
        TypeEqHashWrap wrap = new TypeEqHashWrap((CifType)tupleType, true);
        String name = this.tupleTypes.get(wrap);
        if (name == null) {
            ++this.tupleTypeCount;
            name = "TupleType_" + this.tupleTypeCount;
            this.tupleTypes.put(wrap, name);
            TupleTypeCodeGenerator.gencodeTupleType(tupleType, name, this);
        }
        return name;
    }

    public String getTupleTypeFieldFieldName(Field field) {
        TupleType tupleType = (TupleType)field.eContainer();
        int idx = tupleType.getFields().indexOf((Object)field);
        return this.getTupleTypeFieldFieldName(tupleType, idx);
    }

    public String getTupleTypeFieldFieldName(TupleType tupleType, int idx) {
        return "field_" + idx;
    }

    public String getLocationValueText(Location loc) {
        Automaton aut = (Automaton)loc.eContainer();
        int idx = aut.getLocations().indexOf((Object)loc);
        return this.getLocationValueText(loc, idx);
    }

    public String getLocationValueText(Location loc, int idx) {
        return Integer.toString(idx);
    }

    public List<Event> getEvents() {
        if (this.events == null) {
            List eventTuples = Lists.list();
            EventCodeGenerator.collectEvents((ComplexComponent)this.spec, eventTuples);
            Collections.sort(eventTuples, new PairTextComparer());
            this.events = Lists.listc((int)(eventTuples.size() + 1));
            for (Pair eventTuple : eventTuples) {
                this.events.add((Event)eventTuple.right);
            }
            this.events.add(this.tauEvent);
        }
        return this.events;
    }

    public List<AlgVariable> getAlgVars() {
        if (this.algVars == null) {
            List algTuples = Lists.list();
            AlgVarCodeGenerator.collectAlgVars((ComplexComponent)this.spec, algTuples);
            Collections.sort(algTuples, new PairTextComparer());
            this.algVars = Lists.listc((int)algTuples.size());
            for (Pair algTuple : algTuples) {
                this.algVars.add((AlgVariable)algTuple.right);
            }
        }
        return this.algVars;
    }

    public List<InputVariable> getInputVariables() {
        if (this.inputVariables == null) {
            List iVarTuples = Lists.list();
            StateCodeGenerator.collectInputVars((ComplexComponent)this.spec, iVarTuples);
            Collections.sort(iVarTuples, new PairTextComparer());
            this.inputVariables = Lists.listc((int)iVarTuples.size());
            for (Pair ivarTuple : iVarTuples) {
                this.inputVariables.add((InputVariable)ivarTuple.right);
            }
        }
        return this.inputVariables;
    }

    public List<Declaration> getStateVars() {
        if (this.stateVars == null) {
            List varTuples = Lists.list();
            StateCodeGenerator.collectStateVars((ComplexComponent)this.spec, varTuples);
            Collections.sort(varTuples, new PairTextComparer());
            this.stateVars = Lists.listc((int)varTuples.size());
            for (Pair varTuple : varTuples) {
                this.stateVars.add((Declaration)varTuple.right);
            }
        }
        return this.stateVars;
    }

    public List<Automaton> getAutomata() {
        if (this.automata == null) {
            List autTuples = Lists.list();
            AutomatonCodeGenerator.collectAutomata((ComplexComponent)this.spec, autTuples);
            Collections.sort(autTuples, new PairTextComparer());
            this.automata = Lists.listc((int)autTuples.size());
            for (Pair autTuple : autTuples) {
                this.automata.add((Automaton)autTuple.right);
            }
        }
        return this.automata;
    }

    public Set<Event> getAlphabet(Automaton aut) {
        Set alphabet = this.alphabets.get(aut);
        if (alphabet == null) {
            alphabet = CifEventUtils.getAlphabet((Automaton)aut);
            this.alphabets.put(aut, alphabet);
        }
        return alphabet;
    }

    public Set<Event> getSendAlphabet(Automaton aut) {
        Set alphabet = this.sendAlphabets.get(aut);
        if (alphabet == null) {
            alphabet = CifEventUtils.getSendAlphabet((Automaton)aut);
            this.sendAlphabets.put(aut, alphabet);
        }
        return alphabet;
    }

    public Set<Event> getReceiveAlphabet(Automaton aut) {
        Set alphabet = this.receiveAlphabets.get(aut);
        if (alphabet == null) {
            alphabet = CifEventUtils.getReceiveAlphabet((Automaton)aut);
            this.receiveAlphabets.put(aut, alphabet);
        }
        return alphabet;
    }

    public Set<Event> getMonitors(Automaton aut) {
        Set monitorsAut = this.monitors.get(aut);
        if (monitorsAut == null) {
            Set<Event> alphabet = this.getAlphabet(aut);
            monitorsAut = CifEventUtils.getMonitors((Automaton)aut, alphabet);
            this.monitors.put(aut, monitorsAut);
        }
        return monitorsAut;
    }

    public List<Automaton> getSyncAuts(Event event) {
        List rslt = this.syncAuts.get(event);
        if (rslt == null) {
            rslt = Lists.list();
            List<Automaton> automata = this.getAutomata();
            for (Automaton aut : automata) {
                Set<Event> alphabet = this.getAlphabet(aut);
                if (!alphabet.contains(event)) continue;
                rslt.add(aut);
            }
            this.syncAuts.put(event, rslt);
        }
        return rslt;
    }

    public List<Automaton> getSendAuts(Event event) {
        List rslt = this.sendAuts.get(event);
        if (rslt == null) {
            rslt = Lists.list();
            List<Automaton> automata = this.getAutomata();
            for (Automaton aut : automata) {
                Set<Event> alphabet = this.getSendAlphabet(aut);
                if (!alphabet.contains(event)) continue;
                rslt.add(aut);
            }
            this.sendAuts.put(event, rslt);
        }
        return rslt;
    }

    public List<Automaton> getRecvAuts(Event event) {
        List rslt = this.recvAuts.get(event);
        if (rslt == null) {
            rslt = Lists.list();
            List<Automaton> automata = this.getAutomata();
            for (Automaton aut : automata) {
                Set<Event> alphabet = this.getReceiveAlphabet(aut);
                if (!alphabet.contains(event)) continue;
                rslt.add(aut);
            }
            this.recvAuts.put(event, rslt);
        }
        return rslt;
    }

    public Map<EnumDecl, EnumDecl> getEnumDeclReprs() {
        if (this.enumDeclReprs == null) {
            List enumDecls = Lists.list();
            CifCollectUtils.collectEnumDecls((ComplexComponent)this.spec, (Collection)enumDecls);
            this.enumDeclReprs = CifEnumUtils.getEnumDeclReprs((List)enumDecls);
        }
        return this.enumDeclReprs;
    }

    public Map<TypeEqHashWrap, String> getDefaultMethodNames() {
        return this.defaultValueNames;
    }

    public String getDefaultValueMethodName(CifType type) {
        if (!CifTypeUtils.isContainerType((CifType)(type = CifTypeUtils.normalizeType((CifType)type)))) {
            return null;
        }
        TypeEqHashWrap wrap = new TypeEqHashWrap(type, false);
        String name = this.defaultValueNames.get(wrap);
        if (name == null) {
            ++this.defaultValueNamesCount;
            name = DEFAULT_VALUE_MTHD_PREFIX + this.defaultValueNamesCount;
            this.defaultValueNames.put(wrap, name);
            if (type instanceof DictType) {
                DictType dtype = (DictType)type;
                this.getDefaultValueMethodName(dtype.getKeyType());
                this.getDefaultValueMethodName(dtype.getValueType());
            } else if (type instanceof ListType) {
                ListType ltype = (ListType)type;
                this.getDefaultValueMethodName(ltype.getElementType());
            } else if (type instanceof SetType) {
                SetType stype = (SetType)type;
                this.getDefaultValueMethodName(stype.getElementType());
            } else if (type instanceof TupleType) {
                TupleType ttype = (TupleType)type;
                for (Field field : ttype.getFields()) {
                    this.getDefaultValueMethodName(field.getType());
                }
            } else {
                throw new RuntimeException("Unknown container type: " + type);
            }
        }
        return name;
    }

    public String getLiteralDataFileName() {
        ++this.literalDataFileCount;
        return LITERAL_FILE_PREFIX + Strings.str((Object)this.literalDataFileCount) + ".dat";
    }

    public Expression getDefaultValue(CifType type) {
        int countBefore = this.funcTypeDefaultValueFuncs.size();
        Expression rslt = CifValueUtils.getDefaultValue((CifType)type, this.funcTypeDefaultValueFuncs);
        int countAfter = this.funcTypeDefaultValueFuncs.size();
        if (countBefore != countAfter) {
            InternalFunction func;
            int i = countBefore;
            while (i < countAfter) {
                func = this.funcTypeDefaultValueFuncs.get(i);
                Assert.check((func.getName() == null ? 1 : 0) != 0);
                func.setName("defaultValueFunc");
                this.dummyFuncSpec.getDeclarations().add((Object)func);
                ++i;
            }
            i = countBefore;
            while (i < countAfter) {
                func = this.funcTypeDefaultValueFuncs.get(i);
                FuncCodeGenerator.gencodeFunc((Function)func, this);
                ++i;
            }
            Assert.check((this.funcTypeDefaultValueFuncs.size() == countAfter ? 1 : 0) != 0);
        }
        return rslt;
    }

    public List<String> getImports() {
        return Lists.list((Object[])new String[]{"java.util.*", "java.util.Map.Entry", "org.eclipse.escet.common.app.framework.exceptions.InputOutputException", "org.eclipse.escet.common.app.framework.exceptions.UnsupportedException", "static org.eclipse.escet.common.app.framework.output.OutputProvider.warn", "org.eclipse.escet.common.java.Assert", "org.eclipse.escet.common.java.Lists", "org.eclipse.escet.common.java.Sets", "static org.eclipse.escet.common.java.ArrayUtils.array", "static org.eclipse.escet.common.java.Lists.list", "static org.eclipse.escet.common.java.Lists.listc", "static org.eclipse.escet.common.java.Maps.mapc", "static org.eclipse.escet.common.java.Sets.set", "static org.eclipse.escet.common.java.Strings.fmt", "org.eclipse.escet.common.svg.SvgUtils", "org.apache.commons.lang3.StringUtils", "org.eclipse.escet.cif.simulator.input.*", "org.eclipse.escet.cif.simulator.runtime.*", "org.eclipse.escet.cif.simulator.runtime.distributions.*", "org.eclipse.escet.cif.simulator.runtime.io.*", "org.eclipse.escet.cif.simulator.runtime.meta.*", "org.eclipse.escet.cif.simulator.runtime.model.*", "org.eclipse.escet.cif.simulator.runtime.ode.*", "org.eclipse.escet.cif.simulator.runtime.transitions.*", "org.eclipse.escet.cif.simulator.output.print.*", "org.eclipse.escet.cif.simulator.output.svgviz.*", "static org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath.*", "static org.eclipse.escet.cif.simulator.runtime.io.RuntimeValueToString.runtimeToString", "static cifcode.Spec.SPEC", "static cifcode.Spec.MONITOR_EDGE", "static cifcode.AlgVars.*", "static cifcode.Constants.*", "static cifcode.Derivatives.*"});
    }

    public static String getClassName(String className) {
        Assert.check((!PACKAGE.isEmpty() ? 1 : 0) != 0);
        return "cifcode." + className;
    }

    /*
     * WARNING - void declaration
     */
    public void writeSourceCode() {
        IWorkspaceRoot root;
        IProject project;
        String filePath;
        void var8_13;
        IPath path;
        IFolder folder;
        IWorkspaceRoot root2;
        IProject project2;
        if (!DebugOutputOption.doPrint(DebugOutputType.GEN_CODE)) {
            return;
        }
        Assert.check((!PACKAGE.isEmpty() ? 1 : 0) != 0);
        String pkgPath = PACKAGE.replace('.', '/');
        String dirPath = null;
        if (Platform.isRunning() && PlatformUI.isWorkbenchRunning() && (project2 = (root2 = ResourcesPlugin.getWorkspace().getRoot()).getProject(DBG_PROJ_NAME)).exists() && (folder = project2.getFolder("src")).exists() && (path = folder.getLocation()) != null) {
            Assert.check((boolean)path.isAbsolute());
            dirPath = path.toString();
        }
        if (dirPath == null) {
            dirPath = Paths.resolve((String)".");
        }
        pkgPath = Paths.join((String[])new String[]{dirPath, pkgPath});
        File pkgFile = new File(pkgPath);
        pkgFile.mkdirs();
        if (!pkgFile.exists() || !pkgFile.isDirectory()) {
            String msg = Strings.fmt((String)"Failed to create directory \"%s\", to which the generated code is to be written, for debugging.", (Object[])new Object[]{pkgPath});
            throw new InputOutputException(msg);
        }
        String[] filters = new String[]{"*.java", "*.dat", "*.locnames", "*.edgedata"};
        WildcardFileFilter filter = new WildcardFileFilter(filters);
        File[] files = pkgFile.listFiles((FilenameFilter)filter);
        if (files == null) {
            String msg = Strings.fmt((String)"Failed to list the files in directory \"%s\", to which the generated code is to be written, for debugging.", (Object[])new Object[]{pkgPath});
            throw new InputOutputException(msg);
        }
        File[] fileArray = files;
        int n = files.length;
        boolean n2 = false;
        while (var8_13 < n) {
            File file = fileArray[var8_13];
            if (!file.isDirectory()) {
                file.delete();
            }
            ++var8_13;
        }
        String classesPath = Paths.resolve((String)"../../target/classes", (String)pkgPath);
        DebugSimulatorCodeGenerator.gencodeDebugSimulator(classesPath, this);
        for (JavaCodeFile javaCodeFile : this.code.values()) {
            filePath = Paths.join((String[])new String[]{pkgPath, String.valueOf(javaCodeFile.name) + ".java"});
            try {
                javaCodeFile.toBox().writeToFile(filePath);
            }
            catch (InputOutputException e) {
                String msg = Strings.fmt((String)"Failed to write generated code file \"%s\", for debugging.", (Object[])new Object[]{filePath});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
        for (Map.Entry entry : this.resources.entrySet()) {
            filePath = Paths.join((String[])new String[]{dirPath, (String)entry.getKey()});
            ByteArrayOutputStream resStream = (ByteArrayOutputStream)entry.getValue();
            FileOutputStream fileStream = null;
            try {
                try {
                    fileStream = new FileOutputStream(filePath);
                    resStream.writeTo(fileStream);
                }
                catch (IOException e) {
                    String msg = Strings.fmt((String)"Failed to write generated resource file \"%s\", for debugging.", (Object[])new Object[]{filePath});
                    throw new InputOutputException(msg, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        fileStream.close();
                    }
                }
                catch (IOException e) {
                    String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{filePath});
                    throw new InputOutputException(msg, (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (fileStream == null) continue;
                fileStream.close();
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{filePath});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
        JavaCodeFile javaCodeFile = this.code.remove(DBG_SIM_CLS_NAME);
        Assert.notNull((Object)((Object)javaCodeFile));
        if (Platform.isRunning() && PlatformUI.isWorkbenchRunning() && (project = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(DBG_PROJ_NAME)).exists()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void writeCompiledCode() {
        if (!CompileOnlyOption.isEnabled()) {
            return;
        }
        String path = CompiledCodeFileOption.getPath();
        String absPath = Paths.resolve((String)path);
        this.compiler.writeJarFile(absPath, null, this.resources);
    }

    public ClassLoader getClassLoader() {
        Assert.notNull((Object)this.compiler);
        RuntimeClassLoader classLoader = this.compiler.getClassLoader();
        if (this.resources.isEmpty()) {
            return classLoader;
        }
        ResourceClassLoader resLoader = new ResourceClassLoader((ClassLoader)classLoader);
        for (Map.Entry<String, ByteArrayOutputStream> res : this.resources.entrySet()) {
            String resPath = res.getKey();
            byte[] resData = res.getValue().toByteArray();
            resLoader.resources.put(resPath, resData);
        }
        return resLoader;
    }

    protected void compile() {
        if (this.compiler == null) {
            String name = JavaCompilerOption.getCompilerName();
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.compiler = new RuntimeJavaCompiler(name, classLoader);
        }
        Map sources = Maps.map();
        for (Map.Entry<String, JavaCodeFile> entry : this.code.entrySet()) {
            JavaCodeFile file = entry.getValue();
            sources.put(file.getAbsClassName(), file);
        }
        try {
            this.compiler.compile(sources);
        }
        catch (RuntimeJavaCompilerException e) {
            throw new RuntimeException("Compilation error.", e);
        }
    }
}

