/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifSvgCodeGenerator {
    private CifSvgCodeGenerator() {
    }

    public static void gencodeCifSvg(Specification spec, CifCompilerContext ctxt) {
        Map decls = Maps.map();
        CifSvgCodeGenerator.collect((ComplexComponent)spec, null, ctxt.getSpecFileDir(), decls);
        Set entries = decls.entrySet();
        int idx = -1;
        for (Map.Entry entry : entries) {
            String svgAbsPath = (String)entry.getKey();
            CifSvgDecls cifSvgDecls = (CifSvgDecls)entry.getValue();
            CifSvgCodeGenerator.gencodeCifSvg(svgAbsPath, ++idx, cifSvgDecls, ctxt);
        }
        ctxt.svgFileCount = idx + 1;
    }

    private static void collect(ComplexComponent comp, String svgAbsPath, String cifSpecFileDir, Map<String, CifSvgDecls> decls) {
        for (IoDecl ioDecl : comp.getIoDecls()) {
            if (!(ioDecl instanceof SvgFile)) continue;
            svgAbsPath = CifSvgCodeGenerator.collect((SvgFile)ioDecl, cifSpecFileDir, decls);
            break;
        }
        for (IoDecl ioDecl : comp.getIoDecls()) {
            String declSvgAbsPath;
            if (ioDecl instanceof SvgCopy) {
                SvgCopy svgCopy = (SvgCopy)ioDecl;
                declSvgAbsPath = svgAbsPath;
                if (svgCopy.getSvgFile() != null) {
                    declSvgAbsPath = CifSvgCodeGenerator.collect(svgCopy.getSvgFile(), cifSpecFileDir, decls);
                }
                decls.get((Object)declSvgAbsPath).svgCopies.add(svgCopy);
                continue;
            }
            if (ioDecl instanceof SvgMove) {
                SvgMove svgMove = (SvgMove)ioDecl;
                declSvgAbsPath = svgAbsPath;
                if (svgMove.getSvgFile() != null) {
                    declSvgAbsPath = CifSvgCodeGenerator.collect(svgMove.getSvgFile(), cifSpecFileDir, decls);
                }
                decls.get((Object)declSvgAbsPath).svgMoves.add(svgMove);
                continue;
            }
            if (ioDecl instanceof SvgOut) {
                SvgOut svgOut = (SvgOut)ioDecl;
                declSvgAbsPath = svgAbsPath;
                if (svgOut.getSvgFile() != null) {
                    declSvgAbsPath = CifSvgCodeGenerator.collect(svgOut.getSvgFile(), cifSpecFileDir, decls);
                }
                decls.get((Object)declSvgAbsPath).svgOuts.add(svgOut);
                continue;
            }
            if (!(ioDecl instanceof SvgIn)) continue;
            SvgIn svgIn = (SvgIn)ioDecl;
            declSvgAbsPath = svgAbsPath;
            if (svgIn.getSvgFile() != null) {
                declSvgAbsPath = CifSvgCodeGenerator.collect(svgIn.getSvgFile(), cifSpecFileDir, decls);
            }
            decls.get((Object)declSvgAbsPath).svgIns.add(svgIn);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifSvgCodeGenerator.collect((ComplexComponent)child, svgAbsPath, cifSpecFileDir, decls);
            }
        }
    }

    private static String collect(SvgFile svgFile, String cifSpecFileDir, Map<String, CifSvgDecls> decls) {
        String svgAbsPath = Paths.resolve((String)svgFile.getPath(), (String)cifSpecFileDir);
        if (!decls.containsKey(svgAbsPath)) {
            decls.put(svgAbsPath, new CifSvgDecls());
        }
        return svgAbsPath;
    }

    private static void gencodeCifSvg(String svgAbsPath, int idx, CifSvgDecls cifSvgDecls, CifCompilerContext ctxt) {
        SvgOut svgOut;
        String svgRelPath = Paths.getRelativePath((String)svgAbsPath, (String)ctxt.getSpecFileDir());
        if (cifSvgDecls.svgOuts.isEmpty() && cifSvgDecls.svgIns.isEmpty()) {
            OutputProvider.warn((String)"SVG file \"%s\" has no CIF/SVG input/output mappings that apply to it.", (Object[])new Object[]{svgRelPath});
        }
        JavaCodeFile file = ctxt.addCodeFile("CifSvg" + Strings.str((Object)idx));
        file.imports.add("org.w3c.dom.Element");
        file.imports.add("org.w3c.dom.Text");
        file.imports.add("org.w3c.dom.svg.SVGStylable");
        file.imports.add("org.eclipse.escet.common.svg.SvgUtils");
        CodeBox h = file.header;
        h.add("/** CIF/SVG mappings. */");
        h.add("public final class CifSvg%d extends RuntimeCifSvgDecls {", new Object[]{idx});
        CodeBox c = file.body;
        List copyIds = Lists.listc((int)cifSvgDecls.svgCopies.size());
        List copyPres = Lists.listc((int)cifSvgDecls.svgCopies.size());
        List copyPosts = Lists.listc((int)cifSvgDecls.svgCopies.size());
        List moveIds = Lists.listc((int)cifSvgDecls.svgMoves.size());
        List moveXs = Lists.listc((int)cifSvgDecls.svgMoves.size());
        List moveYs = Lists.listc((int)cifSvgDecls.svgMoves.size());
        List outIds = Lists.listc((int)cifSvgDecls.svgOuts.size());
        List inIds = Lists.listc((int)cifSvgDecls.svgIns.size());
        for (SvgCopy svgCopy : cifSvgDecls.svgCopies) {
            copyIds.add(CifSvgCodeGenerator.evalSvgStringExpr(svgCopy.getId()));
            copyPres.add(svgCopy.getPre() == null ? "" : CifSvgCodeGenerator.evalSvgStringExpr(svgCopy.getPre()));
            copyPosts.add(svgCopy.getPost() == null ? "" : CifSvgCodeGenerator.evalSvgStringExpr(svgCopy.getPost()));
        }
        for (SvgMove svgMove : cifSvgDecls.svgMoves) {
            moveIds.add(CifSvgCodeGenerator.evalSvgStringExpr(svgMove.getId()));
            moveXs.add(CifSvgCodeGenerator.evalSvgNumberExpr(svgMove.getX()));
            moveYs.add(CifSvgCodeGenerator.evalSvgNumberExpr(svgMove.getY()));
        }
        for (SvgOut svgOut2 : cifSvgDecls.svgOuts) {
            outIds.add(CifSvgCodeGenerator.evalSvgStringExpr(svgOut2.getId()));
        }
        for (SvgIn svgIn : cifSvgDecls.svgIns) {
            inIds.add(CifSvgCodeGenerator.evalSvgStringExpr(svgIn.getId()));
        }
        c.add("public static final Map<String, Integer> ID_TO_INPUT_IDX;");
        c.add();
        c.add("static {");
        c.indent();
        c.add("ID_TO_INPUT_IDX = mapc(%d);", new Object[]{cifSvgDecls.svgIns.size()});
        int i = 0;
        while (i < cifSvgDecls.svgIns.size()) {
            c.add("ID_TO_INPUT_IDX.put(%s, %d);", new Object[]{Strings.stringToJava((String)((String)inIds.get(i))), i});
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add();
        i = 0;
        while (i < cifSvgDecls.svgOuts.size()) {
            svgOut = cifSvgDecls.svgOuts.get(i);
            c.add("private Element outElem%d;", new Object[]{i});
            if (svgOut.getAttr() != null) {
                c.add("private SVGStylable outStyle%d;", new Object[]{i});
            } else {
                c.add("private Text outText%d;", new Object[]{i});
            }
            c.add();
            ++i;
        }
        c.add("@Override");
        c.add("public String getSvgRelPath() {");
        c.indent();
        c.add("return %s;", new Object[]{Strings.stringToJava((String)svgRelPath)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String getSvgAbsPath() {");
        c.indent();
        c.add("return %s;", new Object[]{Strings.stringToJava((String)svgAbsPath)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected int getCopyCount() {");
        c.indent();
        c.add("return %d;", new Object[]{copyIds.size()});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected boolean applyCopy(int idx) {");
        c.indent();
        c.add("switch (idx) {");
        c.indent();
        i = 0;
        while (i < copyIds.size()) {
            c.add("case %d: return applyCopy(%s, %s, %s);", new Object[]{i, Strings.stringToJava((String)((String)copyIds.get(i))), Strings.stringToJava((String)((String)copyPres.get(i))), Strings.stringToJava((String)((String)copyPosts.get(i)))});
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add("throw new RuntimeException(\"Unknown idx: \" + idx);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected void applyMoves() {");
        c.indent();
        i = 0;
        while (i < moveIds.size()) {
            c.add("applyMove(%s, %s, %s);", new Object[]{Strings.stringToJava((String)((String)moveIds.get(i))), CifSimulatorMath.realToStr((Double)moveXs.get(i)), CifSimulatorMath.realToStr((Double)moveYs.get(i))});
            ++i;
        }
        if (!moveIds.isEmpty()) {
            c.add();
            c.add("if (debug) dbg.println();");
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add();
        c.add("@Override");
        c.add("protected void initCaches() {");
        c.indent();
        i = 0;
        while (i < cifSvgDecls.svgOuts.size()) {
            svgOut = cifSvgDecls.svgOuts.get(i);
            c.add("outElem%d = document.getElementById(%s);", new Object[]{i, Strings.stringToJava((String)((String)outIds.get(i)))});
            if (svgOut.getAttr() != null) {
                c.add("outStyle%d = SvgUtils.isCssAttr(outElem%d, %s) ? (SVGStylable)outElem%d : null;", new Object[]{i, i, Strings.stringToJava((String)svgOut.getAttr()), i});
            } else {
                c.add("outText%d = SvgUtils.getTextNode(outElem%d);", new Object[]{i, i});
            }
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add();
        c.add("@Override");
        c.add("protected void applyOutputInternal(RuntimeState _state) {");
        c.indent();
        c.add("State state = (State)_state;");
        i = 0;
        while (i < cifSvgDecls.svgOuts.size()) {
            c.add("applyOutput%d(state);", new Object[]{i});
            ++i;
        }
        if (!cifSvgDecls.svgOuts.isEmpty()) {
            c.add();
            c.add("if (debug) dbg.println();");
        }
        c.dedent();
        c.add("}");
        c.add();
        i = 0;
        while (i < cifSvgDecls.svgOuts.size()) {
            svgOut = cifSvgDecls.svgOuts.get(i);
            c.add();
            c.add("private void applyOutput%d(State state) {", new Object[]{i});
            c.indent();
            CifSvgCodeGenerator.gencodeSvgOut(svgOut, i, (String)outIds.get(i), c, ctxt);
            c.dedent();
            c.add("}");
            ++i;
        }
        c.add();
        c.add();
        c.add("@Override");
        c.add("public Set<String> getInteractiveIds() {");
        c.indent();
        List interactiveIds = Lists.listc((int)cifSvgDecls.svgIns.size());
        for (String inId : inIds) {
            interactiveIds.add(Strings.stringToJava((String)inId));
        }
        if (interactiveIds.isEmpty()) {
            c.add("return Collections.emptySet();");
        } else {
            c.add("return set(%s);", new Object[]{String.join((CharSequence)", ", interactiveIds)});
        }
        c.dedent();
        c.add("}");
        c.add();
        List<Event> events = ctxt.getEvents();
        Map eventMap = Maps.mapc((int)events.size());
        int i2 = 0;
        while (i2 < events.size()) {
            eventMap.put(events.get(i2), i2);
            ++i2;
        }
        c.add();
        c.add("@Override");
        c.add("public boolean[] getInteractiveEvents() {");
        c.indent();
        CifSvgCodeGenerator.gencodeGetInteractiveEvents(cifSvgDecls.svgIns, events, eventMap, c, ctxt);
        c.dedent();
        c.add("}");
        c.add();
        c.add();
        c.add("@Override");
        c.add("public int applyInput(String id, RuntimeState _state) {");
        c.indent();
        CifSvgCodeGenerator.gencodeSvgIns(cifSvgDecls.svgIns, inIds, eventMap, c, ctxt);
        c.dedent();
        c.add("}");
    }

    private static void gencodeSvgOut(SvgOut svgOut, int idx, String id, CodeBox c, CifCompilerContext ctxt) {
        c.add("try {");
        c.indent();
        Expression value = svgOut.getValue();
        CifType type = value.getType();
        CifType ntype = CifTypeUtils.normalizeType((CifType)type);
        c.add("%s value;", new Object[]{TypeCodeGenerator.gencodeType(ntype, ctxt)});
        c.add("try {");
        c.indent();
        c.add("value = %s;", new Object[]{ExprCodeGenerator.gencodeExpr(value, ctxt, "state")});
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Evaluation of SVG output mapping value \\\"%s\\\" failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)value))});
        c.dedent();
        c.add("}");
        c.add();
        if (ntype instanceof StringType) {
            c.add("String txt = value;");
        } else {
            c.add("String txt = runtimeToString(value);");
        }
        if (svgOut.getAttr() != null) {
            c.add("if (outStyle%d == null) {", new Object[]{idx});
            c.indent();
            c.add("outElem%d.setAttribute(%s, txt);", new Object[]{idx, Strings.stringToJava((String)svgOut.getAttr())});
            c.add("if (debug) dbg.println(fmt(\"SVG output (\\\"%%s\\\") id \\\"%s\\\" attr \\\"%s\\\" (SVG attr): \\\"%%s\\\"\", getSvgRelPath(), txt));", new Object[]{StringEscapeUtils.escapeJava((String)id), StringEscapeUtils.escapeJava((String)svgOut.getAttr())});
            c.dedent();
            c.add("} else {");
            c.indent();
            c.add("outStyle%d.getStyle().setProperty(%s, txt, \"\");", new Object[]{idx, Strings.stringToJava((String)svgOut.getAttr())});
            c.add("if (debug) dbg.println(fmt(\"SVG output (\\\"%%s\\\") id \\\"%s\\\" attr \\\"%s\\\" (CSS attr): \\\"%%s\\\"\", getSvgRelPath(), txt));", new Object[]{StringEscapeUtils.escapeJava((String)id), StringEscapeUtils.escapeJava((String)svgOut.getAttr())});
            c.dedent();
            c.add("}");
        } else {
            c.add("outText%d.setNodeValue(txt);", new Object[]{idx});
            c.add("if (debug) dbg.println(fmt(\"SVG output (\\\"%%s\\\") id \\\"%s\\\" text: \\\"%%s\\\"\", getSvgRelPath(), txt));", new Object[]{StringEscapeUtils.escapeJava((String)id)});
        }
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        String attrText = svgOut.getAttr() != null ? Strings.fmt((String)"attribute \\\"%s\\\"", (Object[])new Object[]{StringEscapeUtils.escapeJava((String)svgOut.getAttr())}) : "the text";
        c.add("throw new CifSimulatorException(fmt(\"Evaluation of the SVG output mapping (\\\"%%s\\\") for %s of the SVG element with id \\\"%s\\\" failed.\", getSvgRelPath()), e, state);", new Object[]{attrText, StringEscapeUtils.escapeJava((String)id)});
        c.dedent();
        c.add("}");
    }

    private static void gencodeGetInteractiveEvents(List<SvgIn> svgIns, List<Event> events, Map<Event, Integer> eventMap, CodeBox c, CifCompilerContext ctxt) {
        List interactiveEvents = Lists.listc((int)events.size());
        int i = 0;
        while (i < events.size()) {
            interactiveEvents.add(false);
            ++i;
        }
        for (SvgIn svgIn : svgIns) {
            SvgInEvent event = svgIn.getEvent();
            if (event instanceof SvgInEventSingle) {
                SvgInEventSingle singleEvt = (SvgInEventSingle)event;
                Event evt = ((EventExpression)singleEvt.getEvent()).getEvent();
                interactiveEvents.set(eventMap.get(evt), true);
                continue;
            }
            if (event instanceof SvgInEventIf) {
                SvgInEventIf ifEvent = (SvgInEventIf)event;
                for (SvgInEventIfEntry entry : ifEvent.getEntries()) {
                    Event evt = ((EventExpression)entry.getEvent()).getEvent();
                    interactiveEvents.set(eventMap.get(evt), true);
                }
                continue;
            }
            throw new RuntimeException("Unknown svgin event: " + event);
        }
        String boolValues = interactiveEvents.stream().map(b -> b.toString()).collect(Collectors.joining(", "));
        c.add("return new boolean[] {%s};", new Object[]{boolValues});
    }

    private static void gencodeSvgIns(List<SvgIn> svgIns, List<String> inIds, Map<Event, Integer> eventMap, CodeBox c, CifCompilerContext ctxt) {
        c.add("State state = (State)_state;");
        c.add("int idx = ID_TO_INPUT_IDX.get(id);");
        c.add("boolean g;");
        c.add("switch (idx) {");
        c.indent();
        int i = 0;
        while (i < svgIns.size()) {
            SvgIn svgIn = svgIns.get(i);
            String id = inIds.get(i);
            c.add("case %d:", new Object[]{i});
            c.indent();
            SvgInEvent event = svgIn.getEvent();
            if (event instanceof SvgInEventSingle) {
                SvgInEventSingle singleEvt = (SvgInEventSingle)event;
                Event evt = ((EventExpression)singleEvt.getEvent()).getEvent();
                c.add("return %d; // %s", new Object[]{eventMap.get(evt), CifTextUtils.getAbsName((PositionObject)evt)});
            } else if (event instanceof SvgInEventIf) {
                SvgInEventIf ifEvent = (SvgInEventIf)event;
                c.add("try {");
                c.indent();
                boolean hasElse = false;
                for (SvgInEventIfEntry entry : ifEvent.getEntries()) {
                    Event evt = ((EventExpression)entry.getEvent()).getEvent();
                    int eventIdx = eventMap.get(evt);
                    String eventName = CifTextUtils.getAbsName((PositionObject)evt);
                    if (entry.getGuard() == null) {
                        hasElse = true;
                        c.add("return %d; // %s", new Object[]{eventIdx, eventName});
                        continue;
                    }
                    c.add("try {");
                    c.indent();
                    c.add("g = %s;", new Object[]{ExprCodeGenerator.gencodeExpr(entry.getGuard(), ctxt, "state")});
                    c.dedent();
                    c.add("} catch (CifSimulatorException e) {");
                    c.indent();
                    c.add("throw new CifSimulatorException(\"Evaluation of guard value \\\"%s\\\" failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)entry.getGuard()))});
                    c.dedent();
                    c.add("}");
                    c.add("if (g) return %d; // %s", new Object[]{eventIdx, eventName});
                    c.add();
                }
                if (!hasElse) {
                    c.add("throw new CifSimulatorException(\"Incomplete SVG input mapping: none of the guards are satisfied (evaluate to value \\\"true\\\").\", state);");
                }
                c.dedent();
                c.add("} catch (CifSimulatorException e) {");
                c.indent();
                c.add("throw new CifSimulatorException(fmt(\"Evaluation of the SVG input mapping (\\\"%%s\\\") for the SVG element with id \\\"%s\\\" failed.\", getSvgRelPath()), e, state);", new Object[]{StringEscapeUtils.escapeJava((String)id)});
                c.dedent();
                c.add("}");
            } else {
                throw new RuntimeException("Unknown svgin event: " + event);
            }
            c.dedent();
            c.add();
            ++i;
        }
        c.add("default:");
        c.indent();
        c.add("throw new RuntimeException(\"Unknown input mapping idx: \" + idx);");
        c.dedent();
        c.dedent();
        c.add("}");
    }

    private static String evalSvgStringExpr(Expression expr) {
        try {
            return (String)CifEvalUtils.eval((Expression)expr, (boolean)false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    private static double evalSvgNumberExpr(Expression expr) {
        try {
            Object rslt = CifEvalUtils.eval((Expression)expr, (boolean)false);
            if (rslt instanceof Integer) {
                return ((Integer)rslt).intValue();
            }
            if (rslt instanceof Double) {
                return (Double)rslt;
            }
            throw new RuntimeException("Number expected: " + rslt);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CifSvgDecls {
        public final List<SvgCopy> svgCopies = Lists.list();
        public final List<SvgMove> svgMoves = Lists.list();
        public final List<SvgOut> svgOuts = Lists.list();
        public final List<SvgIn> svgIns = Lists.list();

        private CifSvgDecls() {
        }
    }
}

