/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionValue;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class DebugSimulatorCodeGenerator {
    private DebugSimulatorCodeGenerator() {
    }

    public static void gencodeDebugSimulator(String classesPath, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("DebugSimulator");
        List args = Lists.list();
        Map opts = Options.getOptionMap();
        for (Map.Entry optPair : opts.entrySet()) {
            Option opt = (Option)optPair.getKey();
            OptionValue value = (OptionValue)optPair.getValue();
            String[] stringArray = opt.getCmdLine(value.getValue());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                args.add(arg);
                ++n2;
            }
        }
        Collections.sort(args, Strings.SORTER);
        int i = 0;
        while (i < args.size()) {
            String arg = (String)args.get(i);
            arg = StringEscapeUtils.escapeJava((String)arg);
            arg = "\"" + arg + "\"";
            args.set(i, arg);
            ++i;
        }
        String curWorkingDirPath = StringEscapeUtils.escapeJava((String)Paths.getCurWorkingDir());
        Assert.check((boolean)Paths.isAbsolute((String)classesPath));
        classesPath = StringEscapeUtils.escapeJava((String)classesPath);
        args.add(Strings.fmt((String)"\"--debug-code=%s\"", (Object[])new Object[]{classesPath}));
        args.add("\"--option-dialog=1\"");
        file.imports.add("org.eclipse.escet.cif.simulator.CifSimulatorApp");
        file.imports.add("org.eclipse.escet.common.app.framework.AppProperties");
        file.imports.add("org.junit.jupiter.api.Test");
        CodeBox h = file.header;
        h.add("/** Starts simulator for debugging and contains the simulator options. */");
        h.add("public class %s {", new Object[]{"DebugSimulator"});
        CodeBox c = file.body;
        c.add("@Test");
        c.add("public void debug() {");
        c.indent();
        c.add("AppProperties properties = new AppProperties();");
        c.add("properties.set(\"user.dir\", \"%s\");", new Object[]{curWorkingDirPath});
        c.add("CifSimulatorApp app = new CifSimulatorApp(null, null, null, properties);");
        c.add();
        c.add("String[] arguments = {" + String.join((CharSequence)", ", args) + "};");
        c.add("app.run(arguments);");
        c.dedent();
        c.add("}");
    }
}

