/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;

public class OdeStateEventsCodeGenerator {
    private OdeStateEventsCodeGenerator() {
    }

    public static void gencodeOdeStateEvents(Specification spec, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("OdeStateEvents");
        CodeBox h = file.header;
        h.add("/** ODE state events. */");
        h.add("public final class OdeStateEvents {");
        CodeBox c = file.body;
        Map preds = Maps.map();
        OdeStateEventsCodeGenerator.collectTimedPreds((ComplexComponent)spec, preds, 0);
        int i = 0;
        while (i < preds.size()) {
            c.add("public static OdeStateEvent<State> STATE_EVENT%d = new StateEvent%d();", new Object[]{i, i});
            ++i;
        }
        c.add();
        c.add("public static List<OdeStateEvent<State>> getOdeStateEvents(State state) {");
        c.indent();
        c.add("List<OdeStateEvent<State>> rslt = list();");
        OdeStateEventsCodeGenerator.gencodeOdeStateEventsComponent((ComplexComponent)spec, preds, ctxt, c);
        c.add();
        c.add("return rslt;");
        c.dedent();
        c.add("}");
        for (Map.Entry entry : preds.entrySet()) {
            Expression pred = (Expression)entry.getKey();
            int number = (Integer)((Pair)entry.getValue()).left;
            int predOrigin = (Integer)((Pair)entry.getValue()).right;
            c.add();
            c.add("public static final class StateEvent%d extends OdeStateEvent<State> {", new Object[]{number});
            c.indent();
            c.add("public StateEvent%d() {", new Object[]{number});
            c.indent();
            c.add("super(Solver.getSolver());");
            c.dedent();
            c.add("}");
            c.add();
            c.add("@Override");
            c.add("public String getPredText() {");
            c.indent();
            c.add("return \"%s\";", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)pred))});
            c.dedent();
            c.add("}");
            c.add();
            c.add("@Override");
            c.add("public boolean eval(State state) {");
            c.indent();
            c.add("try {");
            c.indent();
            c.add("return %s;", new Object[]{ExprCodeGenerator.gencodeExpr(pred, ctxt, "state")});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(fmt(\"Evaluation of timed %s \\\"%%s\\\" at time %%s failed.\", getPredText(), realToStr(state.%s.time)), e, state);", new Object[]{switch (predOrigin) {
                case 0 -> "guard";
                case 1 -> "state/event exclusion invariant";
                default -> throw new RuntimeException("Unknown pred origin: " + predOrigin);
            }, "s"});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
        }
    }

    private static void gencodeOdeStateEventsComponent(ComplexComponent comp, Map<Expression, Pair<Integer, Integer>> preds, CifCompilerContext ctxt, CodeBox c) {
        for (Invariant inv : comp.getInvariants()) {
            Expression pred;
            Pair<Integer, Integer> info;
            if (inv.getInvKind() == InvKind.STATE || (info = preds.get(pred = inv.getPredicate())) == null) continue;
            int number = (Integer)info.left;
            c.add("rslt.add(STATE_EVENT%d);", new Object[]{number});
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
            c.indent();
            EList locs = aut.getLocations();
            int locIdx = 0;
            while (locIdx < locs.size()) {
                Location loc = (Location)locs.get(locIdx);
                boolean caseAdded = false;
                for (Edge edge : loc.getEdges()) {
                    for (Expression pred : edge.getGuards()) {
                        Pair<Integer, Integer> info = preds.get(pred);
                        if (info == null) continue;
                        int number = (Integer)info.left;
                        if (!caseAdded) {
                            caseAdded = true;
                            c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                            c.indent();
                        }
                        c.add("rslt.add(STATE_EVENT%d);", new Object[]{number});
                    }
                }
                for (Invariant inv : loc.getInvariants()) {
                    Pair<Integer, Integer> info;
                    Expression pred;
                    if (inv.getInvKind() == InvKind.STATE || (info = preds.get(pred = inv.getPredicate())) == null) continue;
                    int number = (Integer)info.left;
                    if (!caseAdded) {
                        caseAdded = true;
                        c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                        c.indent();
                    }
                    c.add("rslt.add(STATE_EVENT%d);", new Object[]{number});
                }
                if (caseAdded) {
                    c.add("break;");
                    c.dedent();
                }
                ++locIdx;
            }
            c.dedent();
            c.add("}");
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                OdeStateEventsCodeGenerator.gencodeOdeStateEventsComponent((ComplexComponent)child, preds, ctxt, c);
            }
        }
    }

    private static int collectTimedPreds(ComplexComponent comp, Map<Expression, Pair<Integer, Integer>> preds, int number) {
        for (Invariant inv : comp.getInvariants()) {
            Expression pred;
            if (inv.getInvKind() == InvKind.STATE || CifValueUtils.isTimeConstant((Expression)(pred = inv.getPredicate()), (Boolean)true)) continue;
            preds.put(pred, (Pair<Integer, Integer>)Pair.pair((Object)number, (Object)1));
            ++number;
        }
        if (comp instanceof Automaton) {
            for (Location loc : ((Automaton)comp).getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (Expression guard : edge.getGuards()) {
                        if (CifValueUtils.isTimeConstant((Expression)guard, (Boolean)true)) continue;
                        preds.put(guard, (Pair<Integer, Integer>)Pair.pair((Object)number, (Object)0));
                        ++number;
                    }
                }
                for (Invariant inv : loc.getInvariants()) {
                    Expression pred;
                    if (inv.getInvKind() == InvKind.STATE || CifValueUtils.isTimeConstant((Expression)(pred = inv.getPredicate()), (Boolean)true)) continue;
                    preds.put(pred, (Pair<Integer, Integer>)Pair.pair((Object)number, (Object)1));
                    ++number;
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                number = OdeStateEventsCodeGenerator.collectTimedPreds((ComplexComponent)child, preds, number);
            }
        }
        return number;
    }
}

