/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.cif.simulator.output.print.PrintTransitionKind;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class PrintCodeGenerator {
    private PrintCodeGenerator() {
    }

    public static void gencodePrint(Specification spec, CifCompilerContext ctxt) {
        Map decls = Maps.map();
        PrintCodeGenerator.collect(":stdout", ctxt.getSpecFileDir(), decls);
        PrintCodeGenerator.collect((ComplexComponent)spec, ":stdout", ctxt.getSpecFileDir(), decls);
        int idx = -1;
        for (Map.Entry entry : decls.entrySet()) {
            String absPath = (String)entry.getKey();
            List prints = (List)entry.getValue();
            if (absPath.equals(":stdout") && prints.isEmpty()) continue;
            PrintCodeGenerator.gencodePrints(absPath, ++idx, prints, ctxt);
        }
        ctxt.printFileCount = idx + 1;
    }

    private static void collect(ComplexComponent comp, String absPath, String cifSpecFileDir, Map<String, List<Print>> decls) {
        for (IoDecl ioDecl : comp.getIoDecls()) {
            if (!(ioDecl instanceof PrintFile)) continue;
            PrintFile printFile = (PrintFile)ioDecl;
            absPath = PrintCodeGenerator.collect(printFile.getPath(), cifSpecFileDir, decls);
            break;
        }
        for (IoDecl ioDecl : comp.getIoDecls()) {
            if (!(ioDecl instanceof Print)) continue;
            Print print = (Print)ioDecl;
            String declAbsPath = absPath;
            if (print.getFile() != null) {
                declAbsPath = PrintCodeGenerator.collect(print.getFile().getPath(), cifSpecFileDir, decls);
            }
            decls.get(declAbsPath).add(print);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                PrintCodeGenerator.collect((ComplexComponent)child, absPath, cifSpecFileDir, decls);
            }
        }
    }

    private static String collect(String relPath, String cifSpecFileDir, Map<String, List<Print>> decls) {
        String absPath;
        String string = absPath = relPath.startsWith(":") ? relPath : Paths.resolve((String)relPath, (String)cifSpecFileDir);
        if (!decls.containsKey(absPath)) {
            decls.put(absPath, Lists.list());
        }
        return absPath;
    }

    private static void gencodePrints(String absPath, int idx, List<Print> prints, CifCompilerContext ctxt) {
        Print print;
        String relPath = absPath.startsWith(":") ? absPath : Paths.getRelativePath((String)absPath, (String)ctxt.getSpecFileDir());
        if (prints.isEmpty()) {
            OutputProvider.warn((String)"Print file \"%s\" has no print declarations that apply to it.", (Object[])new Object[]{relPath});
        }
        JavaCodeFile file = ctxt.addCodeFile("CifPrint" + Strings.str((Object)idx));
        file.imports.add("static org.eclipse.escet.cif.simulator.output.print.PrintTransitionKind.*");
        CodeBox h = file.header;
        h.add("/** Print declarations. */");
        h.add("public final class CifPrint%d extends RuntimePrintDecls {", new Object[]{idx});
        CodeBox c = file.body;
        boolean[] eventBits = new boolean[prints.size()];
        boolean anyBits = false;
        int i = 0;
        while (i < prints.size()) {
            boolean bits;
            print = prints.get(i);
            eventBits[i] = bits = PrintCodeGenerator.gencodeEventBits(print, i, c, ctxt);
            if (bits) {
                anyBits = true;
            }
            ++i;
        }
        if (anyBits) {
            c.add();
            c.add("public CifPrint%d() {", new Object[]{idx});
            c.indent();
            i = 0;
            while (i < prints.size()) {
                if (eventBits[i]) {
                    c.add("initEventBits%d();", new Object[]{i});
                }
                ++i;
            }
            c.dedent();
            c.add("}");
        }
        c.add();
        c.add("@Override");
        c.add("public String getRelPath() {");
        c.indent();
        c.add("return %s;", new Object[]{Strings.stringToJava((String)relPath)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String getAbsPath() {");
        c.indent();
        c.add("return %s;", new Object[]{Strings.stringToJava((String)absPath)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public void print(RuntimeState preState, RuntimeState postState, PrintTransitionKind kind, int eventIdx) {");
        c.indent();
        c.add("printPre(preState, postState, kind, eventIdx);");
        c.add("printPost(preState, postState, kind, eventIdx);");
        c.add("stream.flush();");
        c.dedent();
        c.add("}");
        c.add();
        c.add("private void printPre(RuntimeState preState, RuntimeState postState, PrintTransitionKind kind, int eventIdx) {");
        c.indent();
        i = 0;
        while (i < prints.size()) {
            print = prints.get(i);
            if (print.getTxtPre() != null) {
                c.add("print%d(true, preState, postState, kind, eventIdx);", new Object[]{i});
            }
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("private void printPost(RuntimeState preState, RuntimeState postState, PrintTransitionKind kind, int eventIdx) {");
        c.indent();
        i = 0;
        while (i < prints.size()) {
            print = prints.get(i);
            if (print.getTxtPost() != null) {
                c.add("print%d(false, preState, postState, kind, eventIdx);", new Object[]{i});
            }
            ++i;
        }
        c.dedent();
        c.add("}");
        i = 0;
        while (i < prints.size()) {
            print = prints.get(i);
            c.add();
            c.add("private void print%d(boolean pre, RuntimeState _preState, RuntimeState _postState, PrintTransitionKind kind, int eventIdx) {", new Object[]{i});
            c.indent();
            c.add("State preState = (State)_preState;");
            c.add("State postState = (State)_postState;");
            c.add();
            PrintCodeGenerator.gencodePrint(print, i, c, ctxt);
            c.dedent();
            c.add("}");
            ++i;
        }
    }

    private static boolean gencodeEventBits(Print print, int idx, CodeBox c, CifCompilerContext ctxt) {
        List filterEvents = Lists.list();
        for (PrintFor printFor : print.getFors()) {
            Expression eventRef = printFor.getEvent();
            if (eventRef == null) continue;
            Event event = ((EventExpression)eventRef).getEvent();
            filterEvents.add(event);
        }
        if (filterEvents.isEmpty()) {
            return false;
        }
        List<Event> events = ctxt.getEvents();
        c.add();
        c.add("private final BitSet EVENT_BITS%d = new BitSet(%d);", new Object[]{idx, events.size()});
        c.add();
        c.add("private void initEventBits%d() {", new Object[]{idx});
        c.indent();
        for (Event event : filterEvents) {
            int eventIdx = events.indexOf(event);
            c.add("EVENT_BITS%d.set(%d);", new Object[]{idx, eventIdx});
        }
        c.dedent();
        c.add("}");
        return true;
    }

    private static void gencodePrint(Print print, int idx, CodeBox c, CifCompilerContext ctxt) {
        Expression whenPost;
        Expression whenPre;
        Set kinds = Sets.set();
        PrintTransitionKind[] printTransitionKindArray = PrintTransitionKind.values();
        int n = printTransitionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrintTransitionKind kind = printTransitionKindArray[n2];
            kinds.add(kind);
            ++n2;
        }
        boolean allEvents = false;
        for (PrintFor printFor : print.getFors()) {
            switch (printFor.getKind()) {
                case NAME: {
                    kinds.remove((Object)PrintTransitionKind.EVENT);
                    break;
                }
                case EVENT: {
                    kinds.remove((Object)PrintTransitionKind.EVENT);
                    allEvents = true;
                    break;
                }
                case TIME: {
                    kinds.remove((Object)PrintTransitionKind.TIME);
                    break;
                }
                case INITIAL: {
                    kinds.remove((Object)PrintTransitionKind.INITIAL);
                    break;
                }
                case FINAL: {
                    kinds.remove((Object)PrintTransitionKind.FINAL);
                }
            }
        }
        if (print.getFors().isEmpty()) {
            kinds.remove((Object)PrintTransitionKind.INITIAL);
            kinds.remove((Object)PrintTransitionKind.EVENT);
            kinds.remove((Object)PrintTransitionKind.TIME);
            allEvents = true;
        }
        for (PrintTransitionKind kind : kinds) {
            c.add("if (kind == %s) return;", new Object[]{kind.name()});
        }
        if (!kinds.contains((Object)PrintTransitionKind.EVENT) && !allEvents) {
            c.add("if (kind == EVENT && !EVENT_BITS%d.get(eventIdx)) return;", new Object[]{idx});
        }
        if ((whenPre = print.getWhenPre()) != null) {
            c.add();
            c.add("boolean whenPre;");
            c.add("try {");
            c.indent();
            c.add("whenPre = %s;", new Object[]{ExprCodeGenerator.gencodeExpr(whenPre, ctxt, "preState")});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of print declaration \\\"when pre\\\" filter \\\"%s\\\" failed.\", e, preState);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)whenPre))});
            c.dedent();
            c.add("}");
            c.add("if (!whenPre) return;");
        }
        if ((whenPost = print.getWhenPost()) != null) {
            c.add();
            c.add("boolean whenPost;");
            c.add("try {");
            c.indent();
            c.add("whenPost = %s;", new Object[]{ExprCodeGenerator.gencodeExpr(whenPost, ctxt, "postState")});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of print declaration \\\"when post\\\" filter \\\"%s\\\" failed.\", e, postState);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)whenPost))});
            c.dedent();
            c.add("}");
            c.add("if (!whenPost) return;");
        }
        c.add();
        c.add("String txt;");
        c.add("if (pre) {");
        c.indent();
        Expression txtPre = print.getTxtPre();
        if (txtPre == null) {
            c.add("throw new RuntimeException(); // Should't get here.");
        } else {
            CifType type = txtPre.getType();
            CifType ntype = CifTypeUtils.normalizeType((CifType)type);
            c.add("%s value;", new Object[]{TypeCodeGenerator.gencodeType(ntype, ctxt)});
            c.add("try {");
            c.indent();
            c.add("value = %s;", new Object[]{ExprCodeGenerator.gencodeExpr(txtPre, ctxt, "preState")});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of print declaration \\\"pre\\\" text \\\"%s\\\" failed.\", e, preState);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)txtPre))});
            c.dedent();
            c.add("}");
            c.add();
            if (ntype instanceof StringType) {
                c.add("txt = value;");
            } else {
                c.add("txt = runtimeToString(value);");
            }
        }
        c.dedent();
        c.add("} else {");
        c.indent();
        Expression txtPost = print.getTxtPost();
        if (txtPost == null) {
            c.add("throw new RuntimeException(); // Should't get here.");
        } else {
            CifType type = txtPost.getType();
            CifType ntype = CifTypeUtils.normalizeType((CifType)type);
            c.add("%s value;", new Object[]{TypeCodeGenerator.gencodeType(ntype, ctxt)});
            c.add("try {");
            c.indent();
            c.add("value = %s;", new Object[]{ExprCodeGenerator.gencodeExpr(txtPost, ctxt, "postState")});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of print declaration \\\"post\\\" text \\\"%s\\\" failed.\", e, postState);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)txtPost))});
            c.dedent();
            c.add("}");
            c.add();
            if (ntype instanceof StringType) {
                c.add("txt = value;");
            } else {
                c.add("txt = runtimeToString(value);");
            }
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("stream.println(txt);");
    }
}

