/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Collection;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.StateInitOrderer;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.DefaultValueCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.LiteralCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class StateInitCodeGenerator {
    private StateInitCodeGenerator() {
    }

    public static void gencodeStateInit(CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("StateInit");
        CodeBox h = file.header;
        h.add("/** Runtime state initializer. */");
        h.add("public final class StateInit extends RuntimeStateInit {");
        CodeBox c = file.body;
        StateInitCodeGenerator.gencodeInitState(c, ctxt);
        StateInitCodeGenerator.gencodeInitOpt(c, ctxt);
    }

    private static void gencodeInitState(CodeBox c, CifCompilerContext ctxt) {
        List<Declaration> variables = ctxt.getStateVars();
        List<Automaton> automata = ctxt.getAutomata();
        List objs = Lists.concat(variables, automata);
        objs = new StateInitOrderer().computeOrder((Collection)objs, false);
        Assert.notNull((Object)objs);
        c.add();
        c.add("public void initState(RuntimeSpec<?> spec, State state) {");
        c.indent();
        c.add("processInitOption(spec, state);");
        c.add("state.%s.time = 0.0;", new Object[]{"s"});
        c.add();
        for (Automaton aut : automata) {
            c.add("state.%s.%s = -1;", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        }
        c.add();
        int maxObjCount = 100;
        int subMethodCount = (int)Math.ceil((double)objs.size() / (double)maxObjCount);
        int i = 0;
        while (i < subMethodCount) {
            c.add("initState%d(state, optionVarValues, optionLocIndices);", new Object[]{i});
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("private static void initState0(State state, Object[] optValues, Integer[] optLocIndices) {");
        c.indent();
        c.add("boolean b;");
        i = 0;
        while (i < objs.size()) {
            if (i > 0 && i % maxObjCount == 0) {
                c.dedent();
                c.add("}");
                c.add();
                c.add("private static void initState%d(State state, Object[] optValues, Integer[] optLocIndices) {", new Object[]{i / maxObjCount});
                c.indent();
                c.add("boolean b;");
            }
            c.add();
            PositionObject obj = (PositionObject)objs.get(i);
            if (obj instanceof DiscVariable) {
                StateInitCodeGenerator.gencodeInitDiscVar(variables, (DiscVariable)obj, c, ctxt);
            } else if (obj instanceof InputVariable) {
                StateInitCodeGenerator.gencodeInitInputVar(variables, (InputVariable)obj, c, ctxt);
            } else if (obj instanceof ContVariable) {
                StateInitCodeGenerator.gencodeInitContVar((ContVariable)obj, c, ctxt);
            } else if (obj instanceof Location) {
                Location loc = (Location)obj;
                StateInitCodeGenerator.gencodeInitLoc(automata, loc, c, ctxt);
            } else if (obj instanceof Automaton) {
                StateInitCodeGenerator.gencodeInitAut((Automaton)obj, c, ctxt);
            } else {
                throw new RuntimeException("Unexpected obj: " + obj);
            }
            ++i;
        }
        c.dedent();
        c.add("}");
    }

    private static void gencodeInitDiscVar(List<Declaration> vars, DiscVariable var, CodeBox c, CifCompilerContext ctxt) {
        boolean any;
        VariableValue values = var.getValue();
        List initValues = values == null ? Lists.list(null) : values.getValues();
        c.add("{");
        c.indent();
        int varIdx = vars.indexOf(var);
        Assert.check((varIdx >= 0 ? 1 : 0) != 0);
        c.add("Object optValue = optValues[%d];", new Object[]{varIdx});
        String typeCode = TypeCodeGenerator.gencodeType(var.getType(), ctxt);
        c.add("%s v;", new Object[]{typeCode});
        c.add("b = false;");
        String subStateName = ctxt.getAutSubStateFieldName((Automaton)var.eContainer());
        String varName = ctxt.getDiscVarFieldName(var);
        String fieldTxt = Strings.fmt((String)"state.%s.%s", (Object[])new Object[]{subStateName, varName});
        for (Expression initValue : initValues) {
            if (initValue == null) {
                c.add("v = %s;", new Object[]{DefaultValueCodeGenerator.getDefaultValueCode(var.getType(), ctxt)});
            } else {
                c.add("try {");
                c.indent();
                c.add("v = %s;", new Object[]{ExprCodeGenerator.gencodeExpr(initValue, ctxt, "state")});
                c.dedent();
                c.add("} catch (CifSimulatorException e) {");
                c.indent();
                c.add("throw new CifSimulatorException(\"Evaluation of initial value \\\"%s\\\" of discrete variable \\\"%s\\\" failed.\", e);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)initValue)), CifTextUtils.getAbsName((PositionObject)var)});
                c.dedent();
                c.add("}");
            }
            c.add("if (optValue == null || optValue.equals(v)) {");
            c.indent();
            c.add("if (!b) {");
            c.indent();
            c.add("%s = v;", new Object[]{fieldTxt});
            c.add("b = true;");
            c.dedent();
            c.add("} else {");
            c.indent();
            c.add("throw new UnsupportedException(\"Discrete variable \\\"%s\\\" has multiple possible initial values, which is currently not supported by the CIF simulator. Restrict the initialization using the appropriate simulation option.\");", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
        }
        boolean bl = any = values != null && values.getValues().isEmpty();
        if (any) {
            c.add("if (optValue != null) {");
            c.indent();
            c.add("%s = (%s)optValue;", new Object[]{fieldTxt, typeCode});
            c.dedent();
            c.add("} else {");
            c.indent();
            c.add("warn(\"Discrete variable \\\"%s\\\" is not initialized.\");", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            c.add("throw new SimulatorExitException(SimulationResult.INIT_FAILED);");
            c.dedent();
            c.add("}");
        }
        if (!any) {
            c.add("if (!b) {");
            c.indent();
            c.add("warn(\"Discrete variable \\\"%s\\\" could not be initialized, due to conflicting initial values being provided by the declaration of the variable and the simulation option.\");", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            c.add("throw new SimulatorExitException(SimulationResult.INIT_FAILED);");
            c.dedent();
            c.add("}");
        }
        c.dedent();
        c.add("}");
    }

    private static void gencodeInitInputVar(List<Declaration> vars, InputVariable var, CodeBox c, CifCompilerContext ctxt) {
        c.add("{");
        c.indent();
        int varIdx = vars.indexOf(var);
        Assert.check((varIdx >= 0 ? 1 : 0) != 0);
        c.add("Object optValue = optValues[%d];", new Object[]{varIdx});
        String typeCode = TypeCodeGenerator.gencodeType(var.getType(), ctxt);
        String subStateName = "i";
        String varName = ctxt.getInputVarFieldName(var);
        String fieldTxt = Strings.fmt((String)"state.%s.%s", (Object[])new Object[]{subStateName, varName});
        c.add("if (optValue != null) {");
        c.indent();
        c.add("%s = (%s)optValue;", new Object[]{fieldTxt, typeCode});
        c.dedent();
        c.add("} else {");
        c.indent();
        c.add("warn(\"No initial value provided for input variable \\\"%s\\\", via the simulation option.\");", new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        c.add("throw new SimulatorExitException(SimulationResult.INIT_FAILED);");
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
    }

    private static void gencodeInitContVar(ContVariable var, CodeBox c, CifCompilerContext ctxt) {
        String subStateName = var.eContainer() instanceof Automaton ? ctxt.getAutSubStateFieldName((Automaton)var.eContainer()) : "s";
        String varName = ctxt.getContVarFieldName(var);
        Expression valueExpr = var.getValue();
        if (valueExpr == null) {
            c.add("state.%s.%s = 0.0;", new Object[]{subStateName, varName});
        } else {
            c.add("try {");
            c.indent();
            c.add("state.%s.%s = %s;", new Object[]{subStateName, varName, ExprCodeGenerator.gencodeExpr(valueExpr, ctxt, "state")});
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of initial value \\\"%s\\\" of continuous variable \\\"%s\\\" failed.\", e);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprToStr((Expression)valueExpr)), CifTextUtils.getAbsName((PositionObject)var)});
            c.dedent();
            c.add("}");
        }
    }

    private static void gencodeInitLoc(List<Automaton> automata, Location loc, CodeBox c, CifCompilerContext ctxt) {
        EList initials = loc.getInitials();
        c.add("try {");
        c.indent();
        c.add("b = %s;", new Object[]{ExprCodeGenerator.gencodePreds((List<Expression>)initials, ctxt, "state", "false")});
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Evaluation of initialization predicates \\\"%s\\\" of %s failed.\", e);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.exprsToStr((List)initials)), StringEscapeUtils.escapeJava((String)CifTextUtils.getLocationText2((Location)loc))});
        c.dedent();
        c.add("}");
        Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
        int autIdx = automata.indexOf(aut);
        int locIdx = aut.getLocations().indexOf((Object)loc);
        Assert.check((autIdx >= 0 ? 1 : 0) != 0);
        Assert.check((locIdx >= 0 ? 1 : 0) != 0);
        c.add("if (b && (optLocIndices[%d] == null || optLocIndices[%d].equals(%d))) {", new Object[]{autIdx, autIdx, locIdx});
        c.indent();
        String fieldTxt = Strings.fmt((String)"state.%s.%s", (Object[])new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.add("if (%s == -1) {", new Object[]{fieldTxt});
        c.indent();
        c.add("%s = %d;", new Object[]{fieldTxt, locIdx});
        c.dedent();
        c.add("} else {");
        c.indent();
        c.add("throw new UnsupportedException(\"Automaton \\\"%s\\\" has multiple possible initial locations, which is currently not supported by the CIF simulator. Restrict the initialization using the appropriate simulation option.\");", new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
    }

    private static void gencodeInitAut(Automaton aut, CodeBox c, CifCompilerContext ctxt) {
        c.add("if (state.%s.%s == -1) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        int autIdx = ctxt.getAutomata().indexOf(aut);
        Assert.check((autIdx >= 0 ? 1 : 0) != 0);
        c.add("if (optLocIndices[%d] != null) {", new Object[]{autIdx});
        c.indent();
        c.add("warn(\"Automaton \\\"%s\\\" could not be initialized, as the location provided by the simulation option is not an initial location.\");", new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
        c.dedent();
        c.add("} else {");
        c.indent();
        c.add("warn(\"Automaton \\\"%s\\\" is not initialized.\");", new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
        c.dedent();
        c.add("}");
        c.add("throw new SimulatorExitException(SimulationResult.INIT_FAILED);");
        c.dedent();
        c.add("}");
    }

    private static void gencodeInitOpt(CodeBox c, CifCompilerContext ctxt) {
        List<Declaration> stateVars = ctxt.getStateVars();
        c.add();
        c.add("@Override");
        c.add("protected Object processVarValue(RuntimeStateObjectMeta obj,");
        c.add("                                 String valueTxt)");
        c.add("{");
        c.indent();
        c.add("switch (obj.idx) {");
        c.indent();
        int i = 0;
        while (i < stateVars.size()) {
            Declaration decl = stateVars.get(i);
            if (!(decl instanceof ContVariable)) {
                String objectType;
                CifType type;
                if (decl instanceof DiscVariable) {
                    var = (DiscVariable)decl;
                    type = var.getType();
                    objectType = "discrete";
                } else {
                    var = (InputVariable)decl;
                    type = var.getType();
                    objectType = "input";
                }
                c.add("case %d: {", new Object[]{i});
                c.indent();
                if (!LiteralCodeGenerator.isSerializableType(type)) {
                    String typeTxt = CifTextUtils.typeToStr((CifType)type);
                    c.add("String msg = \"Specifying initialization using the simulation option is not supported for %s variable \\\"%s\\\", as its type \\\"%s\\\" is not serializable.\";", new Object[]{objectType, CifTextUtils.getAbsName((PositionObject)decl), StringEscapeUtils.escapeJava((String)typeTxt)});
                    c.add("throw new UnsupportedException(msg);");
                } else {
                    c.add("try {");
                    c.indent();
                    String readName = ctxt.getLiteralReadMethodName(type);
                    c.add("return %s(valueTxt);", new Object[]{readName});
                    c.dedent();
                    c.add("} catch (InputOutputException ex) {");
                    c.indent();
                    c.add("String msg = \"Failed to read value of type \\\"%s\\\".\";", new Object[]{CifTextUtils.typeToStr((CifType)type)});
                    c.add("throw new InputOutputException(msg, ex);");
                    c.dedent();
                    c.add("}");
                }
                c.dedent();
                c.add("}");
            }
            ++i;
        }
        c.add("default:");
        c.indent();
        c.add("throw new RuntimeException(\"Invalid state var idx: \" + obj.idx);");
        c.dedent();
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
    }
}

