/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.annotations.AAnnotation;
import org.eclipse.escet.cif.parser.ast.annotations.AAnnotationArgument;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class CifAnnotationsTypeChecker {
    private CifAnnotationsTypeChecker() {
    }

    public static List<Annotation> transAnnotations(List<AAnnotation> astAnnos, SymbolTableEntry annotatedObject, SymbolScope<?> scope, CifTypeChecker tchecker) {
        List mmAnnos = Lists.listc((int)astAnnos.size());
        for (AAnnotation astAnno : astAnnos) {
            mmAnnos.add(CifAnnotationsTypeChecker.transAnnotation(astAnno, annotatedObject, scope, tchecker));
        }
        Map nameToAnno = Maps.mapc((int)mmAnnos.size());
        for (Annotation mmAnno : mmAnnos) {
            Annotation prev = nameToAnno.put(mmAnno.getName(), mmAnno);
            if (prev == null) continue;
            tchecker.addProblem(ErrMsg.OBJ_DUPL_ANNO, prev.getPosition(), mmAnno.getName(), annotatedObject.getAbsName());
            tchecker.addProblem(ErrMsg.OBJ_DUPL_ANNO, mmAnno.getPosition(), mmAnno.getName(), annotatedObject.getAbsName());
        }
        return mmAnnos;
    }

    private static Annotation transAnnotation(AAnnotation astAnno, SymbolTableEntry annotatedObject, SymbolScope<?> scope, CifTypeChecker tchecker) {
        Annotation mmAnno = CifConstructors.newAnnotation();
        mmAnno.setName(astAnno.name.text.substring(1));
        mmAnno.setPosition(astAnno.createPosition());
        for (AAnnotationArgument astArg : astAnno.arguments) {
            Expression mmValue = CifExprsTypeChecker.transExpression(astArg.value, null, scope, null, tchecker);
            AnnotationArgument mmArg = CifConstructors.newAnnotationArgument();
            mmArg.setName(astArg.name.text.replace("$", ""));
            mmArg.setPosition(astArg.createPosition());
            mmArg.setValue(mmValue);
            mmAnno.getArguments().add((Object)mmArg);
        }
        Map nameToArg = Maps.mapc((int)mmAnno.getArguments().size());
        for (AnnotationArgument mmArg : mmAnno.getArguments()) {
            AnnotationArgument prev = nameToArg.put(mmArg.getName(), mmArg);
            if (prev == null) continue;
            tchecker.addProblem(ErrMsg.ANNO_DUPL_ARG, prev.getPosition(), mmArg.getName(), mmAnno.getName());
            tchecker.addProblem(ErrMsg.ANNO_DUPL_ARG, mmArg.getPosition(), mmArg.getName(), mmAnno.getName());
        }
        return mmAnno;
    }
}

