/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations;

import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.common.app.framework.exceptions.InvalidModelException;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class DocAnnotationProvider
extends AnnotationProvider {
    public DocAnnotationProvider(String annotationName) {
        super(annotationName);
    }

    @Override
    public final void checkAnnotation(Annotation annotation, AnnotationProblemReporter reporter) {
        if (annotation.getArguments().isEmpty()) {
            reporter.reportProblem(annotation, "missing mandatory \"text\" argument.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
        }
        for (AnnotationArgument arg : annotation.getArguments()) {
            if (!arg.getName().equals("text")) {
                reporter.reportProblem(annotation, Strings.fmt((String)"unsupported argument \"%s\".", (Object[])new Object[]{arg.getName()}), arg.getPosition(), SemanticProblemSeverity.ERROR);
                continue;
            }
            boolean doEvaluationCheck = true;
            CifType valueType = CifTypeUtils.normalizeType((CifType)arg.getValue().getType());
            if (!(valueType instanceof StringType)) {
                reporter.reportProblem(annotation, Strings.fmt((String)"argument \"text\" must have a value of type \"string\", but has a value of type \"%s\".", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)valueType)}), arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
                doEvaluationCheck = false;
            }
            if (!CifValueUtils.hasSingleValue((Expression)arg.getValue(), (boolean)false, (boolean)true)) {
                reporter.reportProblem(annotation, "argument \"text\" cannot be evaluated statically.", arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
                doEvaluationCheck = false;
            }
            if (!doEvaluationCheck) continue;
            try {
                DocAnnotationProvider.getDoc(annotation);
            }
            catch (InvalidModelException e) {
                CifEvalException evalErr = (CifEvalException)e.getCause();
                String evalErrMsg = evalErr.toString();
                if (!evalErrMsg.endsWith(".")) {
                    evalErrMsg = String.valueOf(evalErrMsg) + ".";
                }
                reporter.reportProblem(annotation, Strings.fmt((String)"argument \"text\" cannot be evaluated statically, as evaluating it results in an evaluation error: %s", (Object[])new Object[]{evalErrMsg}), arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
            }
        }
    }

    @Override
    public final void checkGlobal(Specification spec, AnnotationProblemReporter reporter) {
    }

    public static String getDoc(AnnotatedObject obj) {
        for (Annotation anno : obj.getAnnotations()) {
            if (!anno.getName().equals("doc")) continue;
            return DocAnnotationProvider.getDoc(anno);
        }
        return null;
    }

    public static String getDoc(Annotation docAnno) {
        try {
            Object value = CifEvalUtils.eval((Expression)((AnnotationArgument)docAnno.getArguments().get(0)).getValue(), (boolean)false);
            return (String)value;
        }
        catch (CifEvalException e) {
            AnnotatedObject annotatedObj = (AnnotatedObject)docAnno.eContainer();
            throw new InvalidModelException(Strings.fmt((String)"Failed to evaluate the \"text\" argument of the \"doc\" annotation of \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)annotatedObj)}), (Throwable)e);
        }
    }
}

