/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.EventRefSet;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EventsPostChecker {
    private Map<Event, List<Pair<EventExpression, Expression>>> eventPredicatesNeeds = Maps.map();
    private Map<Event, List<Pair<EventExpression, Expression>>> eventPredicatesDisables = Maps.map();

    public void check(ComplexComponent comp, CifPostCheckEnv env) {
        this.check((List<Invariant>)comp.getInvariants(), true, env);
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.check((ComplexComponent)child, env);
            }
        } else if (comp instanceof Automaton) {
            this.check((Automaton)comp, env);
        }
    }

    private void check(Automaton aut, CifPostCheckEnv env) {
        EventRefSet actualAlphabet;
        for (Location loc : aut.getLocations()) {
            this.check((List<Invariant>)loc.getInvariants(), false, env);
        }
        EventRefSet explicitAlphabetSet = null;
        Alphabet explicitAalphabet = aut.getAlphabet();
        if (explicitAalphabet != null) {
            explicitAlphabetSet = new EventRefSet();
            for (Expression eventRef : explicitAalphabet.getEvents()) {
                Expression duplicate = explicitAlphabetSet.add(eventRef);
                if (duplicate == null) continue;
                env.addProblem(ErrMsg.ALPHABET_DUPL_EVENT, eventRef.getPosition(), CifTextUtils.exprToStr((Expression)eventRef), CifTextUtils.getAbsName((PositionObject)aut));
                env.addProblem(ErrMsg.ALPHABET_DUPL_EVENT, duplicate.getPosition(), CifTextUtils.exprToStr((Expression)eventRef), CifTextUtils.getAbsName((PositionObject)aut));
            }
        }
        EventRefSet monitorSet = null;
        Monitors monitors = aut.getMonitors();
        if (monitors != null) {
            monitorSet = new EventRefSet();
            for (Expression eventRef : monitors.getEvents()) {
                Iterator duplicate = monitorSet.add(eventRef);
                if (duplicate == null) continue;
                env.addProblem(ErrMsg.MONITORS_DUPL_EVENT, eventRef.getPosition(), CifTextUtils.exprToStr((Expression)eventRef), CifTextUtils.getAbsName((PositionObject)aut));
                env.addProblem(ErrMsg.MONITORS_DUPL_EVENT, duplicate.getPosition(), CifTextUtils.exprToStr((Expression)eventRef), CifTextUtils.getAbsName((PositionObject)aut));
            }
        }
        EventRefSet implicitAlphabetSet = new EventRefSet();
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                EventRefSet edgeEventRefs = new EventRefSet();
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    Expression duplicate;
                    boolean isComm;
                    Expression eventRef = edgeEvent.getEvent();
                    boolean isTau = eventRef instanceof TauExpression;
                    boolean bl = isComm = edgeEvent instanceof EdgeSend || edgeEvent instanceof EdgeReceive;
                    if (!(explicitAlphabetSet == null || isTau || isComm || explicitAlphabetSet.contains(eventRef))) {
                        PositionObject evt = CifScopeUtils.getRefObjFromRef((Expression)eventRef);
                        env.addProblem(ErrMsg.EVENT_NOT_IN_ALPHABET, eventRef.getPosition(), CifTextUtils.getAbsName((PositionObject)evt), CifTextUtils.getAbsName((PositionObject)aut));
                    }
                    if (!isTau && !isComm) {
                        implicitAlphabetSet.add(eventRef);
                    }
                    if (edgeEvent instanceof EdgeSend || (duplicate = edgeEventRefs.add(eventRef)) == null) continue;
                    env.addProblem(ErrMsg.EDGE_DUPL_EVENT, eventRef.getPosition(), CifTextUtils.exprToStr((Expression)eventRef), CifTextUtils.getAbsName((PositionObject)aut));
                    env.addProblem(ErrMsg.EDGE_DUPL_EVENT, duplicate.getPosition(), CifTextUtils.exprToStr((Expression)eventRef), CifTextUtils.getAbsName((PositionObject)aut));
                }
            }
        }
        if (explicitAlphabetSet != null) {
            EventRefSet unusedExplicitAlphabetEvents = new EventRefSet(explicitAlphabetSet);
            unusedExplicitAlphabetEvents.removeAll(implicitAlphabetSet);
            for (Expression eventRef : unusedExplicitAlphabetEvents) {
                boolean monitored;
                boolean bl = monitored = monitorSet != null && (monitorSet.isEmpty() || monitorSet.contains(eventRef));
                if (monitored) {
                    env.addProblem(ErrMsg.MONITOR_EVENT_NO_EDGE, eventRef.getPosition(), CifTextUtils.getAbsName((PositionObject)aut), CifTextUtils.exprToStr((Expression)eventRef));
                    continue;
                }
                env.addProblem(ErrMsg.ALPHABET_DISABLED_EVENT, eventRef.getPosition(), CifTextUtils.getAbsName((PositionObject)aut), CifTextUtils.exprToStr((Expression)eventRef));
            }
        }
        EventRefSet eventRefSet = actualAlphabet = explicitAlphabetSet == null ? implicitAlphabetSet : explicitAlphabetSet;
        if (monitorSet != null) {
            for (Expression eventRef : monitorSet) {
                if (actualAlphabet.contains(eventRef)) continue;
                env.addProblem(ErrMsg.MONITOR_EVENT_NOT_IN_ALPHABET, eventRef.getPosition(), CifTextUtils.exprToStr((Expression)eventRef), CifTextUtils.getAbsName((PositionObject)aut));
            }
        }
        if (monitorSet != null && monitorSet.isEmpty() && actualAlphabet.isEmpty()) {
            env.addProblem(ErrMsg.MONITOR_EMPTY_ALPHABET, aut.getMonitors().getPosition(), CifTextUtils.getAbsName((PositionObject)aut));
        }
    }

    private void check(List<Invariant> invariants, boolean checkGlobalDuplication, CifPostCheckEnv env) {
        Map<Event, List<Pair<EventExpression, Expression>>> localEventPredicatesDisables = Maps.map();
        Map<Event, List<Pair<EventExpression, Expression>>> localEventPredicatesNeeds = Maps.map();
        block5: for (Invariant invariant : invariants) {
            Map<Event, List<Pair<EventExpression, Expression>>> eventPredicates;
            switch (invariant.getInvKind()) {
                case EVENT_DISABLES: {
                    eventPredicates = checkGlobalDuplication ? this.eventPredicatesDisables : localEventPredicatesDisables;
                    break;
                }
                case EVENT_NEEDS: {
                    eventPredicates = checkGlobalDuplication ? this.eventPredicatesNeeds : localEventPredicatesNeeds;
                    break;
                }
                case STATE: {
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unknown invariant kind: " + invariant.getInvKind());
                }
            }
            EventExpression eventExpresion = (EventExpression)invariant.getEvent();
            Event event = eventExpresion.getEvent();
            List<Pair<EventExpression, Expression>> previousPredicates = eventPredicates.getOrDefault(event, Lists.list());
            for (Pair<EventExpression, Expression> previousPredicate : previousPredicates) {
                if (!CifValueUtils.areStructurallySameExpression((Expression)invariant.getPredicate(), (Expression)((Expression)previousPredicate.right)).booleanValue()) continue;
                env.addProblem(ErrMsg.INV_DUPL_EVENT, eventExpresion.getPosition(), CifTextUtils.getAbsName((PositionObject)event));
                env.addProblem(ErrMsg.INV_DUPL_EVENT, ((EventExpression)previousPredicate.left).getPosition(), CifTextUtils.getAbsName((PositionObject)event));
            }
            Pair currentPredicate = Pair.pair((Object)eventExpresion, (Object)invariant.getPredicate());
            previousPredicates.add((Pair<EventExpression, Expression>)currentPredicate);
            eventPredicates.put(event, previousPredicates);
        }
    }
}

