/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class Paths {
    private Paths() {
    }

    public static String getCurWorkingDir() {
        String rslt = AppEnv.getProperty("user.dir");
        Assert.notNull((Object)rslt);
        Assert.check((boolean)new File(rslt).isAbsolute());
        return rslt;
    }

    public static String setCurWorkingDir(String path) {
        Assert.notNull((Object)path);
        Assert.check((boolean)new File(path).isAbsolute());
        Assert.check((path.indexOf(Paths.getNonPlatformSeparator()) == -1 ? 1 : 0) != 0);
        return (String)AppEnv.setProperty("user.dir", path);
    }

    public static boolean isAbsolute(String path) {
        char c3;
        if (path.startsWith("\\")) {
            return true;
        }
        if (path.startsWith("/")) {
            return true;
        }
        return path.length() >= 3 && path.charAt(1) == ':' && ((c3 = path.charAt(2)) == '\\' || c3 == '/');
    }

    public static String resolve(String path) {
        return Paths.resolve(path, Paths.getCurWorkingDir());
    }

    public static String resolve(String path, String curWorkingDir) {
        if (Paths.isAbsolute(path)) {
            return Paths.join(path, ".");
        }
        return Paths.join(curWorkingDir, path);
    }

    public static String join(String ... paths) {
        Assert.check((paths.length > 1 ? 1 : 0) != 0);
        List segments = Lists.list();
        boolean first = true;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            path = path.replace('\\', '/');
            int cnt = 0;
            if (first) {
                while (path.startsWith("/")) {
                    ++cnt;
                    path = path.substring(1);
                }
            }
            first = false;
            if (cnt > 0) {
                segments.add(Strings.duplicate((String)"/", (int)cnt));
                cnt = 0;
            }
            String[] stringArray2 = path.split("[/]");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String segment = stringArray2[n4];
                segments.add(segment);
                ++n4;
            }
            ++n2;
        }
        int segmentIdx = 0;
        while (segmentIdx < segments.size()) {
            String prevSegment;
            String segment = (String)segments.get(segmentIdx);
            if (segment.isEmpty()) {
                segments.remove(segmentIdx);
                continue;
            }
            if (segment.equals(".")) {
                segments.remove(segmentIdx);
                continue;
            }
            boolean removeDotDot = true;
            if (removeDotDot && !segment.equals("..")) {
                removeDotDot = false;
            }
            if (removeDotDot && segmentIdx == 0) {
                removeDotDot = false;
            }
            if (removeDotDot && ((String)segments.get(segmentIdx - 1)).equals("..")) {
                removeDotDot = false;
            }
            if (removeDotDot && segmentIdx == 1 && ((prevSegment = (String)segments.get(0)).startsWith("/") || prevSegment.length() == 2 && prevSegment.charAt(1) == ':')) {
                removeDotDot = false;
            }
            if (removeDotDot) {
                segments.remove(--segmentIdx);
                segments.remove(segmentIdx);
                continue;
            }
            ++segmentIdx;
        }
        if (segments.isEmpty()) {
            segments.add(".");
        }
        StringBuilder joined = new StringBuilder((String)segments.get(0));
        int i = 1;
        while (i < segments.size()) {
            String segment = (String)segments.get(i);
            char lastChar = joined.charAt(joined.length() - 1);
            if (lastChar != '/') {
                joined.append("/");
            }
            joined.append(segment);
            ++i;
        }
        String rslt = joined.toString();
        if (rslt.length() == 2 && rslt.charAt(1) == ':') {
            rslt = String.valueOf(rslt) + "/";
        }
        return rslt.replace('/', Paths.getPlatformSeparator());
    }

    public static java.net.URI createJavaURI(String absPath) {
        java.net.URI rslt;
        String fileUriPath = URI.createFileURI((String)absPath).toString();
        try {
            rslt = new java.net.URI(fileUriPath);
        }
        catch (URISyntaxException e) {
            String msg = Strings.fmt((String)"Invalid absolute local file system path: \"%s\".", (Object[])new Object[]{absPath});
            throw new RuntimeException(msg, e);
        }
        return rslt;
    }

    public static URI createEmfURI(String resourcePath) {
        URI resourceURI = URI.createURI((String)resourcePath);
        if (resourceURI.isPlatform()) {
            if (resourceURI.segment(0).equals("auto")) {
                String[] segments = resourceURI.segments();
                URIHandlerImpl handler = new URIHandlerImpl();
                resourceURI = resourceURI.trimSegments(segments.length);
                segments[0] = "resource";
                if (handler.exists(resourceURI = resourceURI.appendSegments(segments), Collections.emptyMap())) {
                    return resourceURI;
                }
                resourceURI = resourceURI.trimSegments(segments.length);
                segments[0] = "plugin";
                if (handler.exists(resourceURI = resourceURI.appendSegments(segments), Collections.emptyMap())) {
                    return resourceURI;
                }
                String msg = Strings.fmt((String)"Could not find resource \"%s\": resource could not be resolved in the workspace, and also not in the plug-ins.", (Object[])new Object[]{resourcePath});
                throw new InvalidInputException(msg);
            }
            return resourceURI;
        }
        String filePath = resourcePath;
        if (filePath.startsWith("file:")) {
            filePath = filePath.substring("file:".length());
        }
        filePath = Paths.resolve(filePath);
        resourceURI = URI.createFileURI((String)filePath);
        return resourceURI;
    }

    public static URI createEmfURI(String bundleName, String localPath) {
        return Paths.createEmfURI("platform:/auto/" + bundleName + "/" + localPath);
    }

    public static char getPlatformSeparator() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return '\\';
        }
        return '/';
    }

    public static char getNonPlatformSeparator() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return '/';
        }
        return '\\';
    }

    public static String getExtension(String path) {
        int idx = Math.max(path.lastIndexOf(92), path.lastIndexOf(47));
        path = idx == -1 ? path : path.substring(idx + 1);
        idx = path.lastIndexOf(".");
        return idx == -1 ? "" : path.substring(idx + 1);
    }

    public static boolean pathHasExtension(String path, String ext) {
        String fullExt = "." + ext.toLowerCase(Locale.US);
        return path.toLowerCase(Locale.US).endsWith(fullExt);
    }

    public static String pathChangeExtension(String path, String oldExt, String newExt) {
        if (oldExt != null && Paths.pathHasExtension(path, oldExt)) {
            path = Strings.slice((String)path, (Integer)0, (Integer)(-oldExt.length() - 1));
        }
        if (newExt != null) {
            path = String.valueOf(path) + "." + newExt;
        }
        return path;
    }

    public static String getRelativePath(String absTgtPath, String absRelDir) {
        String[] stringArray;
        CharSequence[] absTargetParts;
        absTgtPath = absTgtPath.replace('\\', '/');
        absRelDir = absRelDir.replace('\\', '/');
        while (absTgtPath.contains("//")) {
            absTgtPath = absTgtPath.replace("//", "/");
        }
        while (absRelDir.contains("//")) {
            absRelDir = absRelDir.replace("//", "/");
        }
        if (absTgtPath.equals("/")) {
            CharSequence[] charSequenceArray = new String[1];
            v1 = charSequenceArray;
            charSequenceArray[0] = "";
        } else {
            v1 = absTargetParts = absTgtPath.split("/");
        }
        if (absRelDir.equals("/")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = absRelDir.split("/");
        }
        String[] absRelDirParts = stringArray;
        int idx = 0;
        while (idx < absTargetParts.length && idx < absRelDirParts.length && absTargetParts[idx].equals(absRelDirParts[idx])) {
            ++idx;
        }
        if (idx == 0 && absTargetParts.length > 0 && absRelDirParts.length > 0 && absTargetParts[0].endsWith(":") && absRelDirParts[0].endsWith(":")) {
            return absTargetParts.length == 1 && absTargetParts[0].endsWith(":") ? String.valueOf(absTargetParts[0]) + "/" : String.join((CharSequence)"/", absTargetParts);
        }
        List rsltParts = Lists.list();
        int i = idx;
        while (i < absRelDirParts.length) {
            rsltParts.add("..");
            ++i;
        }
        i = idx;
        while (i < absTargetParts.length) {
            rsltParts.add(absTargetParts[i]);
            ++i;
        }
        if (rsltParts.isEmpty()) {
            rsltParts.add(".");
        }
        return rsltParts.size() == 1 && ((String)rsltParts.get(0)).endsWith(":") ? String.valueOf((String)rsltParts.get(0)) + "/" : String.join((CharSequence)"/", rsltParts);
    }

    public static String getAbsFilePathDir(String absFilePath) {
        String rslt = absFilePath;
        int idx = Math.max(rslt.lastIndexOf(92), rslt.lastIndexOf(47));
        Assert.check((idx >= 0 ? 1 : 0) != 0);
        rslt = rslt.substring(0, idx);
        if (rslt.isEmpty()) {
            rslt = "/";
        } else if (rslt.endsWith(":") && !rslt.contains("\\") && !rslt.contains("/")) {
            rslt = String.valueOf(rslt) + "\\";
        }
        return rslt;
    }

    public static String getFileName(String filePath) {
        int idx = Math.max(filePath.lastIndexOf(92), filePath.lastIndexOf(47));
        return idx == -1 ? filePath : filePath.substring(idx + 1);
    }
}

