/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.console;

import java.io.InputStream;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.console.ConsolePageParticipant;
import org.eclipse.escet.common.app.framework.eclipse.themes.EclipseThemePreferenceChangeListener;
import org.eclipse.escet.common.app.framework.eclipse.themes.EclipseThemeUtils;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.EclipseConsoleAppStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class Console
extends IOConsole {
    private final IOConsoleInputStream inputStream = this.getInputStream();
    private final IOConsoleOutputStream outputStream = this.newOutputStream();
    private final IOConsoleOutputStream errorStream = this.newOutputStream();
    protected final AppStreams streams;
    private Application<?> application;
    private ConsolePageParticipant consolePageParticipant;
    private EclipseThemePreferenceChangeListener themeListener = new EclipseThemePreferenceChangeListener(e -> this.setStreamColors());

    public Console(String title) {
        super(title, null);
        this.setStreamColors();
        EclipseConsoleAppStream appOut = new EclipseConsoleAppStream(this.outputStream);
        EclipseConsoleAppStream appErr = new EclipseConsoleAppStream(this.errorStream);
        this.streams = new AppStreams((InputStream)this.inputStream, appOut, appErr);
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{this});
        manager.showConsoleView((IConsole)this);
    }

    private void setStreamColors() {
        if (EclipseThemeUtils.isDarkThemeInUse()) {
            this.inputStream.setColor(new Color(0, 200, 125));
            this.outputStream.setColor(new Color(240, 240, 240));
            this.errorStream.setColor(new Color(255, 97, 97));
        } else {
            this.inputStream.setColor(new Color(0, 200, 125));
            this.outputStream.setColor(new Color(0, 0, 0));
            this.errorStream.setColor(new Color(255, 0, 0));
        }
    }

    public void setConsolePageParticipant(ConsolePageParticipant participant) {
        this.consolePageParticipant = participant;
    }

    public AppStreams getStreams() {
        return this.streams;
    }

    public Application<?> getApplication() {
        return this.application;
    }

    public void setNameSync(final String name) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Console.super.setName(name);
            }
        });
    }

    public void setNameAsync(final String name) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Console.super.setName(name);
            }
        });
    }

    public void setApplication(Application<?> application) {
        this.application = application;
        application.getAppEnvData().setConsole(this);
    }

    public void cleanup() {
        if (this.consolePageParticipant != null) {
            this.consolePageParticipant.disable();
        }
        if (this.application != null) {
            this.application.getAppEnvData().setConsole(null);
        }
        this.application = null;
        this.consolePageParticipant = null;
    }

    protected void dispose() {
        this.themeListener.unregister();
        super.dispose();
    }
}

