/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.SWTUtils;
import org.eclipse.escet.common.app.framework.exceptions.ApplicationException;
import org.eclipse.escet.common.app.framework.io.MemAppStream;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.OptionDialogOption;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class OptionDialog
implements Runnable {
    private final OptionCategory options;
    private final Display display;
    protected final Shell shell;
    private SashForm pages;
    private Map<TreeItem, Composite> categoryPageMap = Maps.map();
    private Map<Option, OptionGroup> optionGroupMap = Maps.map();
    protected String[] cmdLine = null;

    protected OptionDialog(Display display, OptionCategory options) {
        this.options = options;
        this.display = display;
        this.shell = new Shell(display);
        this.show();
    }

    @Override
    public void run() {
        OptionDialog dlg = new OptionDialog(this.display, this.options);
        this.cmdLine = dlg.cmdLine;
    }

    public static String[] showDialog(OptionCategory options) {
        Display display = Display.getDefault();
        OptionDialogRunner runner = new OptionDialogRunner(display, options, AppEnv.getData());
        display.syncExec((Runnable)runner);
        if (runner.error != null) {
            throw runner.error;
        }
        return runner.cmdLine;
    }

    private void show() {
        this.shell.setText(this.options.getName());
        SWTUtils.resize(this.shell, 0.75);
        this.shell.setMinimumSize(640, 480);
        this.addComponents();
        SWTUtils.center(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        while (this.display.readAndDispatch()) {
        }
    }

    private void addComponents() {
        FormLayout shellLayout = new FormLayout();
        shellLayout.marginHeight = 8;
        shellLayout.marginWidth = 8;
        shellLayout.spacing = 8;
        this.shell.setLayout((Layout)shellLayout);
        SashForm split = new SashForm((Composite)this.shell, 256);
        Composite buttons = new Composite((Composite)this.shell, 0);
        FormData splitData = new FormData();
        splitData.top = new FormAttachment(0, 0);
        splitData.left = new FormAttachment(0, 0);
        splitData.right = new FormAttachment(100, 0);
        splitData.bottom = new FormAttachment((Control)buttons, 0);
        split.setLayoutData((Object)splitData);
        FormData buttonsData = new FormData();
        buttonsData.left = new FormAttachment(0, 0);
        buttonsData.right = new FormAttachment(100, 0);
        buttonsData.bottom = new FormAttachment(100, 0);
        buttons.setLayoutData((Object)buttonsData);
        FormLayout buttonsLayout = new FormLayout();
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 8;
        buttonsLayout.spacing = 8;
        buttons.setLayout((Layout)buttonsLayout);
        Button okButton = new Button(buttons, 8);
        Button cancelButton = new Button(buttons, 8);
        okButton.setText("OK");
        cancelButton.setText("Cancel");
        FormData okData = new FormData();
        okData.right = new FormAttachment((Control)cancelButton, 0);
        okButton.setLayoutData((Object)okData);
        FormData cancelData = new FormData();
        cancelData.right = new FormAttachment(100, 0);
        cancelButton.setLayoutData((Object)cancelData);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionDialog.this.saveCmdLine();
                OptionDialog.this.shell.close();
            }
        });
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(okButton);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        OptionDialog.this.shell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
        Tree tree = new Tree((Composite)split, 2052);
        this.pages = new SashForm((Composite)split, 256);
        split.setWeights(new int[]{1, 3});
        this.addCategories(tree, null, this.pages, this.options);
        this.addHelpCategory(tree, this.pages);
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Assert.check((boolean)(event.item instanceof TreeItem));
                TreeItem item = (TreeItem)event.item;
                OptionDialog.this.selectCategory(item);
            }
        });
        this.selectCategory(tree.getItem(0));
    }

    protected void selectCategory(TreeItem item) {
        Composite page = this.categoryPageMap.get(item);
        Assert.notNull((Object)page);
        this.pages.setMaximizedControl((Control)page);
    }

    private void addCategories(Tree tree, TreeItem item, SashForm pages, OptionCategory cat) {
        for (OptionCategory subcat : cat.getSubCategories()) {
            TreeItem newItem;
            if (item == null) {
                newItem = new TreeItem(tree, 0);
            } else {
                newItem = new TreeItem(item, 0);
                item.setExpanded(true);
            }
            newItem.setText(subcat.getName());
            final Composite page = new Composite((Composite)pages, 2048);
            page.setLayout((Layout)new FormLayout());
            final ScrolledComposite scroll = new ScrolledComposite(page, 512);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
            FormData scrollData = new FormData();
            scrollData.left = new FormAttachment(0, 0);
            scrollData.top = new FormAttachment(0, 0);
            scrollData.right = new FormAttachment(100, 0);
            scrollData.bottom = new FormAttachment(100, 0);
            scroll.setLayoutData((Object)scrollData);
            final Composite contents = new Composite((Composite)scroll, 0);
            scroll.setContent((Control)contents);
            FormLayout contentsLayout = new FormLayout();
            contentsLayout.marginWidth = 8;
            contentsLayout.marginHeight = 8;
            contentsLayout.spacing = 8;
            contents.setLayout((Layout)contentsLayout);
            OptionGroup<?> previous = null;
            int optCount = 0;
            for (Option<?> opt : subcat.getOptions()) {
                if (!opt.showInDialog) {
                    if (opt != Options.getInstance(OptionDialogOption.class)) continue;
                    Options.set(OptionDialogOption.class, Boolean.valueOf(false));
                    continue;
                }
                OptionGroup<?> optGrp = opt.createOptionGroup(contents);
                FormData grpData = new FormData();
                grpData.left = new FormAttachment(0, 0);
                grpData.right = new FormAttachment(100, 0);
                grpData.top = previous == null ? new FormAttachment(0, 0) : new FormAttachment(previous, 0);
                optGrp.setLayoutData(grpData);
                previous = optGrp;
                this.optionGroupMap.put(opt, optGrp);
                ++optCount;
            }
            if (optCount == 0) {
                Label noOpts = new Label(contents, 0);
                noOpts.setText("This option category has no options.");
            }
            page.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle bounds = page.getBounds();
                    Control[] controlArray = contents.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        Object layoutData = c.getLayoutData();
                        Assert.check((boolean)(layoutData instanceof FormData));
                        FormData grpData = (FormData)c.getLayoutData();
                        grpData.width = bounds.width - 32;
                        ++n2;
                    }
                    scroll.setMinSize(contents.computeSize(-1, -1));
                }
            });
            scroll.setMinSize(contents.computeSize(-1, -1));
            this.categoryPageMap.put(newItem, page);
            this.addCategories(tree, newItem, pages, subcat);
        }
    }

    private void addHelpCategory(Tree tree, SashForm pages) {
        TreeItem helpItem = new TreeItem(tree, 0);
        helpItem.setText("Help");
        this.addHelpAboutCategory(helpItem, pages);
        this.addHelpCmdLineCategory(helpItem, pages);
        this.addHelpLicenseCategory(helpItem, pages);
        helpItem.setExpanded(true);
    }

    private void addHelpAboutCategory(TreeItem parentItem, SashForm pages) {
        TreeItem item = new TreeItem(parentItem, 0);
        item.setText("About");
        Composite page = new Composite((Composite)pages, 2048);
        page.setLayout((Layout)new FormLayout());
        Text txt = new Text(page, 778);
        txt.setBackground(page.getBackground());
        txt.setFont(JFaceResources.getTextFont());
        FormData txtData = new FormData();
        txtData.left = new FormAttachment(0, 2);
        txtData.top = new FormAttachment(0, 2);
        txtData.right = new FormAttachment(100, 0);
        txtData.bottom = new FormAttachment(100, 0);
        txt.setLayoutData((Object)txtData);
        MemAppStream helpStream = new MemAppStream();
        AppEnv.getApplication().printHelpHeader(helpStream);
        if (AppEnv.getApplication().getHelpMessageNotes().length > 0) {
            helpStream.println();
            AppEnv.getApplication().printHelpNotes(helpStream);
        }
        helpStream.println();
        AppEnv.getApplication().printHelpCopyright(helpStream);
        txt.setText(helpStream.toString());
        this.categoryPageMap.put(parentItem, page);
        this.categoryPageMap.put(item, page);
    }

    private void addHelpCmdLineCategory(TreeItem parentItem, SashForm pages) {
        TreeItem item = new TreeItem(parentItem, 0);
        item.setText("Command line options");
        Composite page = new Composite((Composite)pages, 2048);
        page.setLayout((Layout)new FormLayout());
        Text txt = new Text(page, 778);
        txt.setBackground(page.getBackground());
        txt.setFont(JFaceResources.getTextFont());
        FormData txtData = new FormData();
        txtData.left = new FormAttachment(0, 2);
        txtData.top = new FormAttachment(0, 2);
        txtData.right = new FormAttachment(100, 0);
        txtData.bottom = new FormAttachment(100, 0);
        txt.setLayoutData((Object)txtData);
        MemAppStream helpStream = new MemAppStream();
        AppEnv.getApplication().printHelpHeader(helpStream);
        helpStream.println();
        AppEnv.getApplication().printHelpOptions(helpStream);
        helpStream.println();
        AppEnv.getApplication().printHelpExitCodes(helpStream);
        helpStream.println();
        AppEnv.getApplication().printHelpCopyright(helpStream);
        txt.setText(helpStream.toString());
        this.categoryPageMap.put(item, page);
    }

    private void addHelpLicenseCategory(TreeItem parentItem, SashForm pages) {
        TreeItem item = new TreeItem(parentItem, 0);
        item.setText("License information");
        Composite page = new Composite((Composite)pages, 2048);
        page.setLayout((Layout)new FormLayout());
        Text txt = new Text(page, 778);
        txt.setBackground(page.getBackground());
        txt.setFont(JFaceResources.getTextFont());
        FormData txtData = new FormData();
        txtData.left = new FormAttachment(0, 2);
        txtData.top = new FormAttachment(0, 2);
        txtData.right = new FormAttachment(100, 0);
        txtData.bottom = new FormAttachment(100, 0);
        txt.setLayoutData((Object)txtData);
        MemAppStream helpStream = new MemAppStream();
        AppEnv.getApplication().printHelpLicense(helpStream);
        txt.setText(helpStream.toString());
        this.categoryPageMap.put(item, page);
    }

    protected void saveCmdLine() {
        List parts = Lists.list();
        List opts = Sets.sortedgeneric(this.optionGroupMap.keySet(), (Comparator)Option.SORTER);
        for (Option opt : opts) {
            OptionGroup grp = this.optionGroupMap.get(opt);
            String[] stringArray = grp.getCmdLine();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                parts.add(part);
                ++n2;
            }
        }
        this.cmdLine = parts.toArray(new String[0]);
    }

    private static class OptionDialogRunner
    implements Runnable {
        private final Display display;
        private final OptionCategory options;
        private final AppEnvData data;
        public String[] cmdLine;
        public ApplicationException error;

        public OptionDialogRunner(Display display, OptionCategory options, AppEnvData data) {
            this.display = display;
            this.options = options;
            this.data = data;
        }

        @Override
        public void run() {
            Assert.check((!this.display.isDisposed() ? 1 : 0) != 0);
            AppEnv.registerThread(this.data, true);
            OptionDialog dlg = null;
            try {
                dlg = new OptionDialog(this.display, this.options);
            }
            catch (ApplicationException ex) {
                this.error = ex;
                return;
            }
            this.cmdLine = dlg.cmdLine;
        }
    }
}

