/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.io;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.dsm.Dsm;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class WriteLatexFigure {
    private WriteLatexFigure() {
    }

    public static void writeMatrixLatexFigureToStream(AppStream outHandle, Dsm dsm) {
        CodeBox codeBox = WriteLatexFigure.createMatrixLatexFigure(dsm);
        codeBox.write(outHandle);
    }

    public static CodeBox createMatrixLatexFigure(Dsm dsm) {
        MemoryCodeBox codeBox = new MemoryCodeBox();
        int size = dsm.adjacencies.getRowDimension();
        codeBox.add("\\begin{tikzpicture}[every node/.style={font=\\huge}, scale=0.3, transform shape]");
        codeBox.indent();
        codeBox.add("\\draw[black!40!white] (-.9, 0) grid (%s, %s);", new Object[]{size, (double)size + 0.9});
        WriteLatexFigure.writeClustersLatex(dsm, (CodeBox)codeBox);
        codeBox.add();
        codeBox.add("% Labels.");
        int i = 0;
        while (i < size) {
            WriteLatexFigure.writeLabelLatex(dsm.labels[i].toString(), i, true, size, (CodeBox)codeBox);
            codeBox.add();
            ++i;
        }
        int row = 0;
        while (row < size) {
            WriteLatexFigure.writeRowLatex(dsm, row, (CodeBox)codeBox);
            codeBox.add();
            ++row;
        }
        codeBox.dedent();
        codeBox.add("\\end{tikzpicture}");
        return codeBox;
    }

    private static void writeClustersLatex(Dsm dsm, CodeBox codeBox) {
        int size = dsm.adjacencies.getColumnDimension();
        codeBox.add("% Cluster lines.");
        codeBox.add("\\draw[line width=1pt, line cap=rect]");
        codeBox.indent();
        codeBox.add("(0, 0) -- (0, %s) -- (%s, %s) -- (%s, 0) -- cycle", new Object[]{size, size, size, size});
        for (Group gr : dsm.rootGroup.childGroups) {
            WriteLatexFigure.writeGroupLatex(gr, size, codeBox);
        }
        codeBox.dedent();
        codeBox.add(";");
    }

    private static void writeGroupLatex(Group group, int sizeDsm, CodeBox codeBox) {
        int base = group.getShuffledBase();
        int size = group.getShuffledSize();
        int x1 = base;
        int x2 = base + size;
        int y1 = sizeDsm - base;
        int y2 = sizeDsm - base - size;
        if (base >= 0) {
            codeBox.add("(%s, %s) -- (%s, %s) -- (%s, %s) -- (%s, %s) -- cycle", new Object[]{x1, y1, x1, y2, x2, y2, x2, y1});
        }
        for (Group child : group.childGroups) {
            WriteLatexFigure.writeGroupLatex(child, sizeDsm, codeBox);
        }
    }

    private static void writeLabelLatex(String label, int index, boolean labelsOnRow, int size, CodeBox codeBox) {
        label = label.replace("_", "\\_");
        String labelRow = labelsOnRow ? Strings.fmt((String)(String.valueOf(label) + " - %s"), (Object[])new Object[]{index + 1}) : Strings.fmt((String)"%s", (Object[])new Object[]{index + 1});
        String labelColumn = !labelsOnRow ? Strings.fmt((String)("%s - " + label), (Object[])new Object[]{index + 1}) : Strings.fmt((String)"%s", (Object[])new Object[]{index + 1});
        codeBox.add("%% Label %s.", new Object[]{index + 1});
        codeBox.add("\\node[anchor=east] at (-.1, %s) {" + labelRow + "};", new Object[]{(double)size - 0.5 - (double)index});
        codeBox.add("\\node[rotate=90, anchor=west] at (%s, %s) {" + labelColumn + "};", new Object[]{0.5 + (double)index, (double)size + 0.1});
        codeBox.add("\\node[fill=gray] at (%s, %s) {\\color{gray} $\\bullet$};", new Object[]{0.5 + (double)index, (double)size - 0.5 - (double)index});
    }

    private static void writeRowLatex(Dsm dsm, int row, CodeBox codeBox) {
        codeBox.add("%% Row %s.", new Object[]{row + 1});
        int size = dsm.adjacencies.getColumnDimension();
        List nonZeroElems = Lists.list();
        int j = 0;
        while (j < size) {
            if (row != j && dsm.adjacencies.getEntry(row, j) > 0.0) {
                nonZeroElems.add(j);
            }
            ++j;
        }
        String nonZeroElemsText = nonZeroElems.stream().map(String::valueOf).collect(Collectors.joining(","));
        codeBox.add("\\foreach \\x in {" + nonZeroElemsText + "}{");
        codeBox.indent();
        codeBox.add("\\node[fill=black] at (\\x + 0.5, %s) {$\\bullet$};", new Object[]{(double)(size - row) - 0.5});
        codeBox.dedent();
        codeBox.add("}");
    }
}

