/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.sequencing.graph;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.escet.common.dsm.sequencing.graph.Graph;
import org.eclipse.escet.common.dsm.sequencing.graph.GraphCreator;
import org.eclipse.escet.common.java.Strings;

public class GraphReader {
    private static final Pattern PAIR_PATTERN = Pattern.compile("[(]([^,)]+),([^)]+)[)]");

    private GraphReader() {
    }

    public static Graph readVertexPairs(Path fpath) {
        Graph g = new Graph();
        GraphCreator creator = g.getGraphCreator();
        creator.setupCreation();
        try {
            Files.lines(fpath).forEachOrdered(line -> GraphReader.addVertexPairs(creator, line));
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read file \"" + fpath + "\".", ex);
        }
        creator.finishCreation();
        return g;
    }

    public static Graph readVertexPairs(String pairs) {
        Graph g = new Graph();
        GraphCreator creator = g.getGraphCreator();
        creator.setupCreation();
        GraphReader.addVertexPairs(creator, pairs);
        creator.finishCreation();
        return g;
    }

    private static void addVertexPairs(GraphCreator creator, String line) {
        Matcher m = PAIR_PATTERN.matcher(line);
        while (m.find()) {
            String sourceName = Strings.trimLeft((String)Strings.trimRight((String)m.group(1)));
            String targetName = Strings.trimLeft((String)Strings.trimRight((String)m.group(2)));
            creator.addEdge(sourceName, targetName);
        }
    }
}

