/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.eclipse.ui;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.eclipse.ui.DummyEditorSite;
import org.eclipse.escet.common.eclipse.ui.FilePathEditorInput;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.ReflectionUtils;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public abstract class ControlEditor
extends EditorPart {
    protected boolean showGui = true;
    protected FilePathEditorInput input;
    protected Control contents;
    private final AtomicBoolean contentsDisposed = new AtomicBoolean(false);

    public final void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof FilePathEditorInput) {
            this.input = (FilePathEditorInput)input;
        } else if (input instanceof FileEditorInput) {
            FileEditorInput input2 = (FileEditorInput)input;
            String absPath = input2.getPath().toOSString();
            this.input = new FilePathEditorInput(absPath);
        } else if (input instanceof FileStoreEditorInput) {
            URI uri = ((FileStoreEditorInput)input).getURI();
            Assert.check((boolean)uri.isAbsolute());
            Assert.check((uri.getAuthority() == null ? 1 : 0) != 0);
            Assert.check((uri.getFragment() == null ? 1 : 0) != 0);
            Assert.check((uri.getHost() == null ? 1 : 0) != 0);
            Assert.check((uri.getPort() == -1 ? 1 : 0) != 0);
            Assert.check((uri.getQuery() == null ? 1 : 0) != 0);
            Assert.check((uri.getScheme() != null ? 1 : 0) != 0);
            Assert.check((boolean)uri.getScheme().equals("file"));
            Assert.check((uri.getUserInfo() == null ? 1 : 0) != 0);
            String absPath = uri.getPath();
            this.input = new FilePathEditorInput(absPath);
        } else {
            throw new RuntimeException("Unknown editor input: " + input);
        }
    }

    public final void createPartControl(Composite parent) {
        this.contents = this.createContents(parent);
        Assert.check((this.contents.getParent() == parent ? 1 : 0) != 0);
        this.contents.addDisposeListener(e -> {
            Control control = this.contents;
            synchronized (control) {
                this.contentsDisposed.set(true);
                this.contents.notifyAll();
            }
        });
    }

    protected abstract Control createContents(Composite var1);

    public void setFocus() {
        if (this.contents != null) {
            this.contents.setFocus();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("Save is not supported.");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("Save As is not supported.");
    }

    public boolean isAvailable() {
        return this.contents != null && !this.contents.isDisposed();
    }

    public void redraw() {
        final Control c = this.contents;
        if (c.isDisposed()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (c.isDisposed()) {
                    return;
                }
                c.redraw(0, 0, c.getBounds().width, c.getBounds().height, true);
            }
        });
    }

    public static <T extends ControlEditor> T show(String filePath, Class<T> cls, String functionality) {
        return ControlEditor.show(filePath, cls, functionality, true);
    }

    public static <T extends ControlEditor> T show(String filePath, final Class<T> cls, String functionality, final boolean showGui) {
        AppEnv.checkGuiAvailable((String)functionality);
        final IEditorPart[] rslt = new IEditorPart[1];
        final Throwable[] error = new Throwable[1];
        final Display display = Display.getDefault();
        final String absFilePath = Paths.resolve((String)filePath);
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!showGui) {
                    ControlEditor editor;
                    if (display.isDisposed()) {
                        return;
                    }
                    Shell shell = new Shell(display);
                    shell.setVisible(false);
                    try {
                        editor = (ControlEditor)((Object)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException("Failed to create editor.", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Failed to create editor.", e);
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException("Failed to create editor.", e);
                    }
                    editor.init(new DummyEditorSite(), new FilePathEditorInput(absFilePath));
                    try {
                        editor.createPartControl((Composite)shell);
                    }
                    catch (Throwable e) {
                        error[0] = e;
                    }
                    editor.showGui = false;
                    rslt[0] = editor;
                } else if (Platform.isRunning() && PlatformUI.isWorkbenchRunning()) {
                    IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    Assert.notNull((Object)dw);
                    IWorkbenchPage page = dw.getActivePage();
                    Assert.notNull((Object)page);
                    FilePathEditorInput input = new FilePathEditorInput(absFilePath);
                    try {
                        rslt[0] = page.openEditor((IEditorInput)input, cls.getName());
                    }
                    catch (PartInitException e) {
                        error[0] = e;
                    }
                    catch (NullPointerException e) {
                    }
                    catch (Throwable e) {
                        error[0] = e;
                    }
                } else {
                    ControlEditor editor;
                    Shell shell = new Shell(display);
                    shell.setLayout((Layout)new FillLayout());
                    shell.setText(absFilePath);
                    try {
                        editor = (ControlEditor)((Object)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException("Failed to create editor.", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Failed to create editor.", e);
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException("Failed to create editor.", e);
                    }
                    editor.init(new DummyEditorSite(), new FilePathEditorInput(absFilePath));
                    try {
                        editor.createPartControl((Composite)shell);
                        editor.setFocus();
                        shell.open();
                        rslt[0] = editor;
                    }
                    catch (Throwable e) {
                        error[0] = e;
                    }
                }
            }
        });
        if (!(rslt[0] != null && cls.isInstance(rslt[0]) || error[0] != null)) {
            error[0] = ControlEditor.getErrorFromEditorPart(rslt[0]);
        }
        if (error[0] != null) {
            String msg = Strings.fmt((String)"Failed to open editor \"%s\" for file \"%s\".", (Object[])new Object[]{cls.getName(), filePath});
            throw new InvalidInputException(msg, error[0]);
        }
        ControlEditor editor = (ControlEditor)rslt[0];
        return (T)((Object)editor);
    }

    protected static Throwable getErrorFromEditorPart(IEditorPart part) {
        if (!(part instanceof ErrorEditorPart)) {
            return null;
        }
        IStatus s = (IStatus)ReflectionUtils.getFieldValue((Object)part, (String)"error");
        return s.getException();
    }

    public void close() {
        if (!this.isAvailable()) {
            return;
        }
        final ControlEditor editor = this;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!editor.isAvailable()) {
                    return;
                }
                if (!ControlEditor.this.showGui) {
                    editor.contents.getShell().close();
                } else if (Platform.isRunning() && PlatformUI.isWorkbenchRunning()) {
                    boolean rslt = ControlEditor.this.getSite().getPage().closeEditor((IEditorPart)editor, false);
                    Assert.check((boolean)rslt);
                } else {
                    editor.contents.getShell().close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilClosed() {
        if (this.contents == null) {
            return;
        }
        Control control = this.contents;
        synchronized (control) {
            if (this.contentsDisposed.get()) {
                return;
            }
            try {
                this.contents.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

