/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.eclipse.ui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class CopyFilesNewProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage page;

    protected abstract String getInitialProjectName();

    protected abstract String getSourceFolderPath();

    protected String getTargetFolderPath() {
        return ".";
    }

    private IConfigurationElement getWizardConfig() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        String extensionPointId = "org.eclipse.ui.newWizards";
        IConfigurationElement[] elems = registry.getConfigurationElementsFor(extensionPointId);
        String wizardClsName = ((Object)((Object)this)).getClass().getName();
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            String elemClsName;
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getName().equals("wizard") && (elemClsName = elem.getAttribute("class")) != null && elemClsName.equals(wizardClsName)) {
                return elem;
            }
            ++n2;
        }
        String msg = Strings.fmt((String)"Configuration element for wizard \"%s\" not found.", (Object[])new Object[]{wizardClsName});
        throw new RuntimeException(msg);
    }

    private String getTitle() {
        String clsName = ((Object)((Object)this)).getClass().getName();
        IConfigurationElement elem = this.getWizardConfig();
        String name = elem.getAttribute("name");
        if (name == null) {
            String msg = Strings.fmt((String)"Wizard \"%s\" has no name.", (Object[])new Object[]{clsName});
            throw new RuntimeException(msg);
        }
        return name;
    }

    private String getDescription() {
        String clsName = ((Object)((Object)this)).getClass().getName();
        IConfigurationElement elem = this.getWizardConfig();
        IConfigurationElement[] children = elem.getChildren("description");
        if (children.length == 0) {
            String msg = Strings.fmt((String)"Wizard \"%s\" has no description.", (Object[])new Object[]{clsName});
            throw new RuntimeException(msg);
        }
        if (children.length > 1) {
            String msg = Strings.fmt((String)"Wizard \"%s\" has multiple descriptions.", (Object[])new Object[]{clsName});
            throw new RuntimeException(msg);
        }
        String descr = children[0].getValue();
        if (descr == null) {
            String msg = Strings.fmt((String)"Wizard \"%s\" has empty description.", (Object[])new Object[]{clsName});
            throw new RuntimeException(msg);
        }
        return descr;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        String pageName = ((Object)((Object)this)).getClass().getSimpleName();
        this.page = new MyNewProjectCreationPage(pageName);
        this.page.setTitle(this.getTitle());
        this.page.setDescription(this.getDescription());
        this.page.setInitialProjectName(this.getInitialProjectName());
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            CreateProjectOperation operation = new CreateProjectOperation();
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException operation) {
        }
        catch (Exception ex) {
            String name = ((Object)((Object)this)).getClass().getName();
            Status status = new Status(4, name, 0, String.valueOf(name) + " failed.", (Throwable)ex);
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            ILog log = Platform.getLog((Bundle)bundle);
            log.log((IStatus)status);
        }
        return true;
    }

    protected void copyFiles(java.nio.file.Path projectPath, IProgressMonitor monitor) throws IOException {
        String sourceFolderPath = this.getSourceFolderPath();
        String targetFolderPath = this.getTargetFolderPath();
        Assert.check((!sourceFolderPath.startsWith("/") ? 1 : 0) != 0);
        Assert.check((!targetFolderPath.startsWith("/") ? 1 : 0) != 0);
        Assert.check((!sourceFolderPath.contains("\\") ? 1 : 0) != 0);
        Assert.check((!targetFolderPath.contains("\\") ? 1 : 0) != 0);
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        Enumeration urlsToCopy = bundle.findEntries(sourceFolderPath, "*", true);
        List fileUrlsToCopy = Lists.list();
        while (urlsToCopy.hasMoreElements()) {
            URL urlToCopy = (URL)urlsToCopy.nextElement();
            if (urlToCopy.getPath().endsWith("/")) continue;
            fileUrlsToCopy.add(urlToCopy);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)fileUrlsToCopy.size());
        for (URL fileUrlToCopy : fileUrlsToCopy) {
            subMonitor.split(1);
            String pathToCopy = fileUrlToCopy.getPath();
            Assert.check((boolean)pathToCopy.startsWith("/" + sourceFolderPath + "/"));
            String relPath = pathToCopy.substring(1 + sourceFolderPath.length());
            while (relPath.startsWith("/")) {
                relPath = relPath.substring(1);
            }
            String projectFileSeparator = projectPath.getFileSystem().getSeparator();
            String localRelPath = relPath.replace("/", projectFileSeparator);
            String localTargetFolderPath = targetFolderPath.replace("/", projectFileSeparator);
            java.nio.file.Path targetPath = projectPath.resolve(localTargetFolderPath).resolve(localRelPath);
            targetPath = targetPath.normalize();
            java.nio.file.Path parentPath = targetPath.getParent();
            Files.createDirectories(parentPath, new FileAttribute[0]);
            Throwable throwable = null;
            Object var19_20 = null;
            try {
                BufferedInputStream istream = new BufferedInputStream(fileUrlToCopy.openStream());
                try {
                    try (BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(targetPath.toFile()));){
                        IOUtils.copy((InputStream)istream, (OutputStream)ostream);
                    }
                    if (istream == null) continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (istream != null) {
                        ((InputStream)istream).close();
                    }
                    throw throwable;
                }
                ((InputStream)istream).close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private final class CreateProjectOperation
    extends WorkspaceModifyOperation {
        private CreateProjectOperation() {
        }

        public void execute(IProgressMonitor monitor) throws InterruptedException {
            try {
                String msg;
                String title;
                Shell shell;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                subMonitor.subTask("Creating new project...");
                subMonitor.split(10);
                String projectName = CopyFilesNewProjectWizard.this.page.getProjectName();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                Assert.check((!project.exists() ? 1 : 0) != 0);
                subMonitor.split(10);
                IPath projectParent = CopyFilesNewProjectWizard.this.page.getLocationPath();
                java.nio.file.Path projectPath = Paths.get(projectParent.toOSString(), new String[0]).resolve(projectName);
                if (Files.exists(projectPath, new LinkOption[0]) && !MessageDialog.openQuestion((Shell)(shell = CopyFilesNewProjectWizard.this.page.getShell()), (String)(title = "Directory already exists"), (String)(msg = Strings.fmt((String)"Directory \"%s\" already exists. Are you sure you want to create a new project in that directory? Any existing files will be overwritten.", (Object[])new Object[]{projectPath})))) {
                    return;
                }
                subMonitor.split(10);
                Files.createDirectories(projectPath, new FileAttribute[0]);
                CopyFilesNewProjectWizard.this.copyFiles(projectPath, (IProgressMonitor)subMonitor.split(50));
                if (projectParent.equals((Object)workspace.getRoot().getLocation())) {
                    project.create((IProgressMonitor)subMonitor.split(10));
                } else {
                    IProjectDescription desc = workspace.newProjectDescription(project.getName());
                    desc.setLocation((IPath)new Path(projectPath.toString()));
                    project.create(desc, (IProgressMonitor)subMonitor.split(10));
                }
                project.open((IProgressMonitor)subMonitor.split(10));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MyNewProjectCreationPage
    extends WizardNewProjectCreationPage {
        public MyNewProjectCreationPage(String pageName) {
            super(pageName);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.validatePage();
            }
        }
    }
}

