/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public final class Strings {
    private static final Pattern WHITESPACE_CHAR_PAT = Pattern.compile("\\s");
    private static final String[] INDENT_CACHE = new String[60];
    public static final String NL;
    public static final Comparator<String> SORTER;

    static {
        int i = 0;
        while (i < INDENT_CACHE.length) {
            Strings.INDENT_CACHE[i] = StringUtils.leftPad((String)"", (int)i);
            ++i;
        }
        NL = System.getProperty("line.separator");
        SORTER = new StringComparator();
    }

    private Strings() {
    }

    public static String fmt(String format, Object ... args) {
        return String.format(null, format, args);
    }

    public static String indent(String text, int indentLength) {
        return String.valueOf(Strings.spaces(indentLength)) + text;
    }

    public static String spaces(int desiredLength) {
        if (desiredLength <= 0) {
            return "";
        }
        if (desiredLength < INDENT_CACHE.length) {
            return INDENT_CACHE[desiredLength];
        }
        StringBuilder stringBuilder = new StringBuilder(desiredLength);
        while (desiredLength > 0) {
            int addLength = Math.min(desiredLength, INDENT_CACHE.length - 1);
            stringBuilder.append(INDENT_CACHE[addLength]);
            desiredLength -= addLength;
        }
        return stringBuilder.toString();
    }

    public static String stringToJava(String s) {
        return s == null ? "<null>" : "\"" + StringEscapeUtils.escapeJava((String)s) + "\"";
    }

    public static String stringArrayToJava(String[] sa) {
        List rslt = Lists.listc(sa.length);
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            rslt.add(Strings.stringToJava(s));
            ++n2;
        }
        return String.join((CharSequence)", ", rslt);
    }

    public static String[] wrap(int lineLength, String ... texts) {
        List<String> rslt = Lists.list();
        String[] stringArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            while (text.length() > lineLength) {
                int i = text.lastIndexOf(32, lineLength);
                if (i <= 0) {
                    String msg = Strings.fmt("No whitespace in \"%s\".", text.length() < lineLength ? text : text.substring(0, lineLength + 1));
                    throw new IllegalArgumentException(msg);
                }
                rslt.add(text.substring(0, i));
                text = text.substring(i + 1);
            }
            rslt.add(text);
            ++n2;
        }
        return rslt.toArray(new String[0]);
    }

    public static String[] wrap(String ... texts) {
        return Strings.wrap(79, texts);
    }

    public static String wrapEx(int lineLength, String firstPrefix, String otherPrefix, String ... texts) {
        String pre1 = firstPrefix == null ? "" : firstPrefix;
        String pre2 = otherPrefix == null ? "" : otherPrefix;
        int maxPreLen = Math.max(pre1.length(), pre2.length());
        String[] lines = Strings.wrap(lineLength - maxPreLen, texts);
        boolean first = true;
        StringBuilder rslt = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            rslt.append(first ? pre1 : "\n" + pre2);
            first = false;
            rslt.append(line);
            ++n2;
        }
        return rslt.toString();
    }

    public static String wrapEx(String firstPrefix, String otherPrefix, String ... texts) {
        return Strings.wrapEx(79, firstPrefix, otherPrefix, texts);
    }

    public static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\n", "\\n").replace("\t", "\\t").replace("\"", "\\\"");
    }

    public static String unescape(String s) {
        StringBuilder b = new StringBuilder(s);
        int idx = b.indexOf("\\");
        while (idx != -1) {
            if (idx == b.length() - 1) {
                throw new IllegalArgumentException("String ends with escape character (premature end of string) in " + Strings.stringToJava(s));
            }
            char ss = b.charAt(idx + 1);
            switch (ss) {
                case '\\': {
                    b.replace(idx, idx + 2, "\\");
                    break;
                }
                case '\"': {
                    b.replace(idx, idx + 2, "\"");
                    break;
                }
                case 't': {
                    b.replace(idx, idx + 2, "\t");
                    break;
                }
                case 'n': {
                    b.replace(idx, idx + 2, "\n");
                    break;
                }
                default: {
                    String msg = Strings.fmt("Invalid escape sequence at position %d in %s.", idx, Strings.stringToJava(s));
                    throw new IllegalArgumentException(msg);
                }
            }
            ++idx;
            idx = b.indexOf("\\", idx);
        }
        return b.toString();
    }

    public static int[] getCodePoints(String s) {
        int length = s.length();
        int count = s.codePointCount(0, length);
        int[] rslt = new int[count];
        int i = 0;
        int offset = 0;
        while (offset < length) {
            int codepoint = s.codePointAt(offset);
            offset += Character.charCount(codepoint);
            rslt[i] = codepoint;
            ++i;
        }
        return rslt;
    }

    public static String codePointToStr(int codePoint) {
        return String.valueOf(Character.toChars(codePoint));
    }

    public static boolean isGraphicCodePoint(int codePoint) {
        switch (Character.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: 
            case 14: {
                return false;
            }
            case 0: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return false;
            }
        }
        Assert.check(!Character.isValidCodePoint(codePoint));
        return false;
    }

    public static String makeInitialUppercase(String s) {
        if (s.isEmpty()) {
            return s;
        }
        String p = s.substring(0, 1).toUpperCase(Locale.US);
        return String.valueOf(p) + s.substring(1);
    }

    public static String makeUppercase(String s) {
        return s.toUpperCase(Locale.US);
    }

    public static <T> String makeElementsChoiceText(Collection<T> elements, Function<T, String> strFunc) {
        Stream<String> converted = strFunc == null ? elements.stream().map(Object::toString) : elements.stream().map(strFunc::apply);
        StringBuilder sb = new StringBuilder();
        int numElements = elements.size();
        Assert.check(numElements > 0);
        int numAdded = 0;
        String[] stringArray = (String[])converted.sorted((n1, n2) -> n1.compareTo((String)n2)).toArray(String[]::new);
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String name = stringArray[n3];
            if (numAdded == 0) {
                sb.append(name);
            } else if (numAdded + 1 < numElements) {
                sb.append(", ");
                sb.append(name);
            } else {
                sb.append(" or ");
                sb.append(name);
            }
            ++numAdded;
            ++n3;
        }
        return sb.toString();
    }

    public static String duplicate(String str, int cnt) {
        if (cnt < 0) {
            throw new IllegalArgumentException("Negative cnt");
        }
        StringBuilder b = new StringBuilder(str.length() * cnt);
        int i = 0;
        while (i < cnt) {
            b.append(str);
            ++i;
        }
        return b.toString();
    }

    public static String trimLeft(String str) {
        return StringUtils.stripStart((String)str, null);
    }

    public static String trimRight(String str) {
        return StringUtils.stripEnd((String)str, null);
    }

    public static String slice(String str, Integer beginIndex, Integer endIndex) {
        int e;
        int len = str.length();
        int b = beginIndex == null ? 0 : beginIndex;
        int n = e = endIndex == null ? len : endIndex;
        if (b < 0) {
            b = len + b;
        }
        if (e < 0) {
            e = len + e;
        }
        if (b < 0) {
            b = 0;
        }
        if (e < 0) {
            e = 0;
        }
        if (b > len) {
            b = len;
        }
        if (e > len) {
            e = len;
        }
        if (b > e) {
            b = e;
        }
        return str.substring(b, e);
    }

    public static boolean containsWhitespace(String str) {
        return WHITESPACE_CHAR_PAT.matcher(str).find();
    }

    public static String str(Object obj) {
        return String.valueOf(obj);
    }

    public static String replaceRegex(String input, String regex, String replacement) {
        return input.replaceAll(regex, replacement);
    }

    protected static class StringComparator
    implements Comparator<String> {
        protected StringComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            int rslt = String.CASE_INSENSITIVE_ORDER.compare(arg0, arg1);
            if (rslt != 0) {
                return rslt;
            }
            return arg0.compareTo(arg1);
        }
    }
}

