/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.svg;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.eclipse.ui.MsgBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Exceptions;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.svg.SvgCanvas;
import org.eclipse.escet.common.svg.SvgException;
import org.eclipse.escet.common.svg.SvgUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class SvgViewer
extends ControlEditor {
    private final boolean showInitText;
    private final boolean showFileName;
    private Document document;
    private SvgCanvas canvas;
    private Text text;
    private SvgException svgLoadError;

    public SvgViewer() {
        this(false, true);
    }

    public SvgViewer(boolean showInitText, boolean showFileName) {
        this.showInitText = showInitText;
        this.showFileName = showFileName;
    }

    public Document getDocument() {
        if (this.document == null) {
            throw new IllegalStateException("Document not yet available.");
        }
        return this.document;
    }

    public SvgCanvas getSvgCanvas() {
        if (this.canvas == null) {
            throw new IllegalStateException("Canvas not yet available.");
        }
        return this.canvas;
    }

    public SvgException getSvgLoadError() {
        return this.svgLoadError;
    }

    public void initDone() {
        if (!this.showInitText) {
            throw new IllegalStateException("!showInitText");
        }
        if (this.canvas == null) {
            throw new IllegalStateException("no canvas");
        }
        Assert.notNull((Object)this.contents);
        Assert.notNull((Object)((Object)this.canvas));
        Assert.notNull((Object)this.text);
        final ScrolledComposite c1 = (ScrolledComposite)this.contents;
        final SvgCanvas c2 = this.canvas;
        final Text t = this.text;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!SvgViewer.this.isAvailable()) {
                    return;
                }
                c1.setContent((Control)c2);
                c2.setVisible(true);
                t.setVisible(false);
            }
        });
    }

    protected Control createContents(Composite parent) {
        String svgAbsPath = this.input.getAbsoluteFilePath();
        if (this.showFileName) {
            String fileName = svgAbsPath;
            int idx = Math.max(fileName.lastIndexOf(92), fileName.lastIndexOf(47));
            if (idx != -1) {
                fileName = fileName.substring(idx + 1);
            }
            this.setPartName(fileName);
        }
        Color white = parent.getDisplay().getSystemColor(1);
        parent.setBackground(white);
        parent.setLayout((Layout)new FormLayout());
        ScrolledComposite scroll = new ScrolledComposite(parent, 768);
        scroll.setBackground(white);
        FormData scrollData = new FormData();
        scrollData.left = new FormAttachment(0);
        scrollData.right = new FormAttachment(100);
        scrollData.top = new FormAttachment(0);
        scrollData.bottom = new FormAttachment(100);
        scroll.setLayoutData((Object)scrollData);
        scroll.setLayout((Layout)new FormLayout());
        this.text = new Text((Composite)scroll, 10);
        this.text.setText("Waiting for initialization to finish...");
        this.text.pack();
        this.text.setBackground(white);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0);
        textData.left = new FormAttachment(0);
        textData.right = new FormAttachment(100);
        this.text.setLayoutData((Object)textData);
        try {
            this.document = SvgUtils.loadSvgFile(svgAbsPath);
        }
        catch (SvgException ex) {
            this.svgLoadError = ex;
        }
        if (this.svgLoadError == null) {
            try {
                this.canvas = new SvgCanvas((Composite)scroll, this.document, this.showInitText);
            }
            catch (SvgException ex) {
                this.svgLoadError = ex;
            }
        }
        if (this.svgLoadError != null) {
            String msg = Strings.fmt((String)"Failed to load SVG image \"%s\".", (Object[])new Object[]{svgAbsPath});
            this.svgLoadError = new SvgException(msg, (Throwable)((Object)this.svgLoadError));
        }
        if (this.svgLoadError != null) {
            Color red = parent.getDisplay().getSystemColor(3);
            this.text.setText(Exceptions.exToStr((Throwable)((Object)this.svgLoadError)));
            this.text.pack();
            this.text.setForeground(red);
        }
        if (this.svgLoadError == null) {
            this.text.setVisible(this.showInitText);
            this.canvas.setVisible(!this.showInitText);
            scroll.setContent((Control)(this.showInitText ? this.text : this.canvas));
        } else {
            this.text.setVisible(true);
            scroll.setContent((Control)this.text);
        }
        if (this.svgLoadError == null) {
            Menu popupMenu = new Menu((Control)parent);
            final MenuItem saveItem = new MenuItem(popupMenu, 0);
            saveItem.setEnabled(this.isSaveAsAllowed());
            saveItem.setText("Save as...");
            scroll.setMenu(popupMenu);
            this.canvas.setMenu(popupMenu);
            popupMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    saveItem.setEnabled(SvgViewer.this.isSaveAsAllowed());
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            saveItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SvgViewer.this.doSaveAs();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        return scroll;
    }

    public boolean isSaveAsAllowed() {
        return this.document != null && this.canvas != null && !this.canvas.isDisposed() && this.canvas.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSaveAs() {
        IContainer[] dirs;
        String path = this.input.getAbsoluteFilePath();
        int idx = Math.max(path.lastIndexOf(92), path.lastIndexOf(47));
        Assert.check((idx > 0 ? 1 : 0) != 0);
        path = path.substring(0, idx);
        String fileName = Paths.getFileName((String)this.input.getAbsoluteFilePath());
        fileName = Paths.pathChangeExtension((String)fileName, (String)"svg", (String)"viz.svg");
        FileDialog fd = new FileDialog(this.contents.getShell(), 8192);
        fd.setText("Save SVG as");
        fd.setFilterPath(path);
        fd.setFilterExtensions(new String[]{"*.svg;*.png;*.jpg;*.gif"});
        fd.setFileName(fileName);
        fd.setOverwrite(true);
        String savePath = fd.open();
        if (savePath == null) return;
        if (savePath.trim().length() == 0) {
            return;
        }
        File saveFile = new File(savePath);
        Assert.check((boolean)saveFile.isAbsolute());
        if (!(savePath.endsWith(".svg") || savePath.endsWith(".png") || savePath.endsWith(".jpg") || savePath.endsWith(".gif"))) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save SVG as", (String)"Invalid file extension: use .svg, .png, .jpg, or .gif.");
            return;
        }
        if (savePath.endsWith(".svg")) {
            OutputStream tgtStream;
            Transformer transformer;
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                transformer = factory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save SVG as", (String)("Failed to save image." + Strings.NL + Strings.NL + Exceptions.exToStr((Throwable)e)));
                return;
            }
            try {
                tgtStream = new FileOutputStream(savePath);
            }
            catch (FileNotFoundException e) {
                String msg = Strings.fmt((String)"Failed to open \"%s\" for writing.", (Object[])new Object[]{savePath});
                throw new InputOutputException(msg, (Throwable)e);
            }
            tgtStream = new BufferedOutputStream(tgtStream);
            DOMSource src = new DOMSource(this.document);
            StreamResult tgt = new StreamResult(tgtStream);
            try {
                Document document = this.document;
                synchronized (document) {
                    try {
                        transformer.transform(src, tgt);
                    }
                    catch (TransformerException e) {
                        MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save SVG as", (String)("Failed to save image." + Strings.NL + Strings.NL + Exceptions.exToStr((Throwable)e)));
                        // MONITOREXIT @DISABLED, blocks:[2, 3, 27, 12, 15] lbl51 : MonitorExitStatement: MONITOREXIT : var12_18
                        try {
                            tgtStream.close();
                            return;
                        }
                        catch (IOException e2) {
                            String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{savePath});
                            throw new InputOutputException(msg, (Throwable)e2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    tgtStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{savePath});
                    throw new InputOutputException(msg, (Throwable)e);
                }
            }
            try {
                tgtStream.close();
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{savePath});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
        try {
            this.getSvgCanvas().saveImage(savePath);
        }
        catch (NullPointerException e) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save SVG as", (String)"Failed to save image.");
            return;
        }
        catch (IOException e) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save SVG as", (String)("Failed to save image." + Strings.NL + Strings.NL + Exceptions.exToStr((Throwable)e)));
            return;
        }
        if (!Platform.isRunning()) return;
        if (!PlatformUI.isWorkbenchRunning()) return;
        URI saveDirUri = saveFile.getParentFile().toURI();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] iContainerArray = dirs = root.findContainersForLocationURI(saveDirUri);
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer dir = iContainerArray[n2];
            try {
                dir.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }
}

