/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.interpreter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.interpreter.BreakException;
import org.eclipse.escet.tooldef.interpreter.ContinueException;
import org.eclipse.escet.tooldef.interpreter.ExecContext;
import org.eclipse.escet.tooldef.interpreter.ToolDefEval;
import org.eclipse.escet.tooldef.interpreter.ToolDefReturnValue;
import org.eclipse.escet.tooldef.metamodel.tooldef.Declaration;
import org.eclipse.escet.tooldef.metamodel.tooldef.Import;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ProjectionExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolParamExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.TupleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.VariableExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.AddressableDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.AssignmentStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.BreakStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ContinueStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ElifStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ExitStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ForStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.IfStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ReturnStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ToolInvokeStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.TupleAddressableDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Variable;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.VariableAddressableDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.WhileStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.runtime.ExitException;
import org.eclipse.escet.tooldef.runtime.ToolDefException;
import org.eclipse.escet.tooldef.runtime.ToolDefList;
import org.eclipse.escet.tooldef.runtime.ToolDefMap;
import org.eclipse.escet.tooldef.runtime.ToolDefRuntimeUtils;
import org.eclipse.escet.tooldef.runtime.ToolDefTuple;
import org.eclipse.escet.tooldef.runtime.builtins.BuiltInDataTools;

public class ToolDefExec {
    private ToolDefExec() {
    }

    public static ToolDefReturnValue execute(List<Declaration> statements, ExecContext ctxt) {
        for (Declaration statement : statements) {
            ToolDefReturnValue retValue = ToolDefExec.execute(statement, ctxt);
            if (retValue != null) {
                return retValue;
            }
            if (!ctxt.isTerminationRequested()) continue;
            return null;
        }
        return null;
    }

    private static ToolDefReturnValue execute(Declaration statement, ExecContext ctxt) {
        if (statement instanceof Import) {
            return null;
        }
        if (statement instanceof Script) {
            return null;
        }
        if (statement instanceof Tool) {
            return null;
        }
        if (statement instanceof TypeDecl) {
            return null;
        }
        if (statement instanceof AssignmentStatement) {
            return ToolDefExec.execute((AssignmentStatement)statement, ctxt);
        }
        if (statement instanceof BreakStatement) {
            return ToolDefExec.execute((BreakStatement)statement, ctxt);
        }
        if (statement instanceof ContinueStatement) {
            return ToolDefExec.execute((ContinueStatement)statement, ctxt);
        }
        if (statement instanceof ExitStatement) {
            return ToolDefExec.execute((ExitStatement)statement, ctxt);
        }
        if (statement instanceof ForStatement) {
            return ToolDefExec.execute((ForStatement)statement, ctxt);
        }
        if (statement instanceof IfStatement) {
            return ToolDefExec.execute((IfStatement)statement, ctxt);
        }
        if (statement instanceof ReturnStatement) {
            return ToolDefExec.execute((ReturnStatement)statement, ctxt);
        }
        if (statement instanceof ToolInvokeStatement) {
            return ToolDefExec.execute((ToolInvokeStatement)statement, ctxt);
        }
        if (statement instanceof Variable) {
            return ToolDefExec.execute((Variable)statement, ctxt);
        }
        if (statement instanceof WhileStatement) {
            return ToolDefExec.execute((WhileStatement)statement, ctxt);
        }
        throw new RuntimeException("Unknown statement: " + statement);
    }

    private static ToolDefReturnValue execute(AssignmentStatement statement, ExecContext ctxt) {
        ToolDefList values = new ToolDefList(statement.getValues().size());
        for (Expression valueExpr : statement.getValues()) {
            Object value;
            try {
                value = ToolDefEval.eval(valueExpr, ctxt);
            }
            catch (ToolDefException ex) {
                String msg = Strings.fmt((String)"Failed to evaluate assignment value \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)valueExpr)});
                throw new ToolDefException(msg, (Throwable)ex);
            }
            values.add(value);
            if (!ctxt.isTerminationRequested()) continue;
            return null;
        }
        Object value = values.size() == 1 ? values.get(0) : ToolDefRuntimeUtils.makeTuple((List)values);
        Map newValues = Maps.map();
        ToolDefExec.assign((List<Expression>)statement.getAddressables(), value, ctxt, (Map<PositionObject, Object>)newValues);
        for (Map.Entry entry : newValues.entrySet()) {
            ctxt.updateValue((PositionObject)entry.getKey(), entry.getValue());
        }
        return null;
    }

    private static void assign(List<Expression> addressables, Object value, ExecContext ctxt, Map<PositionObject, Object> newValues) {
        if (addressables.size() == 1) {
            Expression addr = addressables.get(0);
            if (addr instanceof TupleExpression) {
                TupleExpression taddr = (TupleExpression)addr;
                ToolDefExec.assign((List<Expression>)taddr.getElements(), value, ctxt, newValues);
            } else {
                ToolDefExec.assign(addr, value, ctxt, newValues);
            }
        } else {
            Assert.check((boolean)(value instanceof ToolDefTuple));
            ToolDefTuple tuple = (ToolDefTuple)value;
            List elems = ToolDefRuntimeUtils.unpackTuple((ToolDefTuple)tuple);
            Assert.check((addressables.size() == elems.size() ? 1 : 0) != 0);
            int i = 0;
            while (i < addressables.size()) {
                ToolDefExec.assign(Lists.list((Object)addressables.get(i)), elems.get(i), ctxt, newValues);
                ++i;
            }
        }
    }

    private static void assign(Expression addressable, Object newValue, ExecContext ctxt, Map<PositionObject, Object> newValues) {
        Variable obj;
        List projs = Lists.list();
        while (addressable instanceof ProjectionExpression) {
            ProjectionExpression paddr = (ProjectionExpression)addressable;
            projs.add(paddr);
            addressable = paddr.getChild();
        }
        Collections.reverse(projs);
        if (addressable instanceof VariableExpression) {
            obj = ((VariableExpression)addressable).getVariable();
        } else if (addressable instanceof ToolParamExpression) {
            obj = ((ToolParamExpression)addressable).getParam();
        } else {
            throw new RuntimeException("Unknown addr var ref: " + addressable);
        }
        Object curValue = ctxt.getValue((PositionObject)obj);
        List indices = Lists.listc((int)projs.size());
        int i = 0;
        while (i < projs.size()) {
            ProjectionExpression proj = (ProjectionExpression)projs.get(i);
            try {
                indices.add(ToolDefEval.eval(proj.getIndex(), ctxt));
            }
            catch (ToolDefException ex) {
                String msg = Strings.fmt((String)"Failed to evaluate projection index \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)proj.getIndex())});
                throw new ToolDefException(msg, (Throwable)ex);
            }
            if (ctxt.isTerminationRequested()) {
                return;
            }
            ++i;
        }
        List childTypes = Lists.listc((int)projs.size());
        for (ProjectionExpression proj : projs) {
            ToolDefType type = ToolDefTypeUtils.normalizeType((ToolDefType)proj.getChild().getType());
            childTypes.add(type);
        }
        Object fullNewValue = ToolDefExec.computeNewValue(curValue, indices, 0, newValue);
        Assert.check((!newValues.containsKey(obj) ? 1 : 0) != 0);
        newValues.put((PositionObject)obj, fullNewValue);
    }

    private static Object computeNewValue(Object curValue, List<Object> indices, int i, Object newValue) {
        if (i == indices.size()) {
            return newValue;
        }
        Object idx = indices.get(i);
        if (curValue instanceof ToolDefList) {
            List oldList = (List)curValue;
            int normalizedIdx = (Integer)idx;
            if (normalizedIdx < 0) {
                normalizedIdx = oldList.size() + normalizedIdx;
            }
            if (normalizedIdx < 0 || normalizedIdx >= oldList.size()) {
                String msg = Strings.fmt((String)"Index out of bounds: %s[%s].", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr((Object)oldList), ToolDefRuntimeUtils.valueToStr((Object)idx)});
                throw new ToolDefException(msg);
            }
            Object oldChild = oldList.get(normalizedIdx);
            Object newChild = ToolDefExec.computeNewValue(oldChild, indices, i + 1, newValue);
            ToolDefList newList = new ToolDefList((Collection)oldList);
            newList.set(normalizedIdx, newChild);
            return newList;
        }
        if (curValue instanceof ToolDefMap) {
            Map oldMap = (Map)curValue;
            if (i < indices.size() - 1 && !oldMap.containsKey(idx)) {
                String msg = Strings.fmt((String)"Key not found: %s[%s].", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr((Object)oldMap), ToolDefRuntimeUtils.valueToStr((Object)idx)});
                throw new ToolDefException(msg);
            }
            Object oldChild = oldMap.get(idx);
            Object newChild = ToolDefExec.computeNewValue(oldChild, indices, i + 1, newValue);
            ToolDefMap newMap = new ToolDefMap(oldMap);
            newMap.put(idx, newChild);
            return newMap;
        }
        if (curValue instanceof ToolDefTuple) {
            ToolDefTuple oldTuple = (ToolDefTuple)curValue;
            List oldElems = ToolDefRuntimeUtils.unpackTuple((ToolDefTuple)oldTuple);
            Object oldChild = oldElems.get((Integer)idx);
            Object newChild = ToolDefExec.computeNewValue(oldChild, indices, i + 1, newValue);
            ToolDefList newElems = new ToolDefList((Collection)oldElems);
            newElems.set((Integer)idx, newChild);
            return ToolDefRuntimeUtils.makeTuple((List)newElems);
        }
        throw new RuntimeException("Unknown projectable: " + curValue);
    }

    private static ToolDefReturnValue execute(BreakStatement statement, ExecContext ctxt) {
        throw new BreakException();
    }

    private static ToolDefReturnValue execute(ContinueStatement statement, ExecContext ctxt) {
        throw new ContinueException();
    }

    private static ToolDefReturnValue execute(ExitStatement statement, ExecContext ctxt) {
        int exitCode;
        if (statement.getExitCode() == null) {
            throw new ExitException(0);
        }
        try {
            exitCode = (Integer)ToolDefEval.eval(statement.getExitCode(), ctxt);
        }
        catch (ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to evaluate exit code \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)statement.getExitCode())});
            throw new ToolDefException(msg, (Throwable)ex);
        }
        throw new ExitException(exitCode);
    }

    private static ToolDefReturnValue execute(ForStatement statement, ExecContext ctxt) {
        Object source;
        try {
            source = ToolDefEval.eval(statement.getSource(), ctxt);
        }
        catch (ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to evaluate for statement source \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)statement.getSource())});
            throw new ToolDefException(msg, (Throwable)ex);
        }
        if (ctxt.isTerminationRequested()) {
            return null;
        }
        ToolDefType sourceType = statement.getSource().getType();
        if (!((sourceType = ToolDefTypeUtils.normalizeType((ToolDefType)sourceType)) instanceof ListType) && !(sourceType instanceof SetType)) {
            if (sourceType instanceof MapType) {
                source = BuiltInDataTools.entries((Map)((Map)source));
            } else {
                throw new RuntimeException("Unknown for source type: " + sourceType);
            }
        }
        Iterable iterable = (Iterable)source;
        for (Object elem : iterable) {
            ExecContext forCtxt = new ExecContext(ctxt);
            ToolDefExec.addForVariables((List<AddressableDecl>)statement.getAddressables(), elem, forCtxt);
            List body = Lists.cast((List)statement.getStatements());
            try {
                ToolDefReturnValue retValue = ToolDefExec.execute(body, forCtxt);
                if (retValue != null) {
                    return retValue;
                }
            }
            catch (BreakException ex) {
                break;
            }
            catch (ContinueException ex) {
                continue;
            }
            if (!ctxt.isTerminationRequested()) continue;
            return null;
        }
        return null;
    }

    private static void addForVariables(List<AddressableDecl> addressables, Object value, ExecContext ctxt) {
        if (addressables.size() == 1) {
            AddressableDecl addr = addressables.get(0);
            if (addr instanceof TupleAddressableDecl) {
                TupleAddressableDecl taddr = (TupleAddressableDecl)addr;
                ToolDefExec.addForVariables((List<AddressableDecl>)taddr.getElements(), value, ctxt);
            } else {
                Assert.check((boolean)(addr instanceof VariableAddressableDecl));
                VariableAddressableDecl vaddr = (VariableAddressableDecl)addr;
                Variable var = vaddr.getVariable();
                ctxt.addVariable(var, value);
            }
        } else {
            Assert.check((boolean)(value instanceof ToolDefTuple));
            ToolDefTuple tuple = (ToolDefTuple)value;
            List elems = ToolDefRuntimeUtils.unpackTuple((ToolDefTuple)tuple);
            Assert.check((addressables.size() == elems.size() ? 1 : 0) != 0);
            int i = 0;
            while (i < addressables.size()) {
                ToolDefExec.addForVariables(Lists.list((Object)addressables.get(i)), elems.get(i), ctxt);
                ++i;
            }
        }
    }

    private static ToolDefReturnValue execute(IfStatement statement, ExecContext ctxt) {
        boolean condition;
        try {
            condition = (Boolean)ToolDefEval.eval(statement.getCondition(), ctxt);
        }
        catch (ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to evaluate 'if' condition \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)statement.getCondition())});
            throw new ToolDefException(msg, (Throwable)ex);
        }
        if (ctxt.isTerminationRequested()) {
            return null;
        }
        if (condition) {
            ExecContext ifCtxt = new ExecContext(ctxt);
            List body = Lists.cast((List)statement.getThens());
            return ToolDefExec.execute(body, ifCtxt);
        }
        for (ElifStatement elif : statement.getElifs()) {
            try {
                condition = (Boolean)ToolDefEval.eval(elif.getCondition(), ctxt);
            }
            catch (ToolDefException ex) {
                String msg = Strings.fmt((String)"Failed to evaluate 'elif' condition \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)elif.getCondition())});
                throw new ToolDefException(msg, (Throwable)ex);
            }
            if (ctxt.isTerminationRequested()) {
                return null;
            }
            if (!condition) continue;
            ExecContext elifCtxt = new ExecContext(ctxt);
            List body = Lists.cast((List)elif.getThens());
            return ToolDefExec.execute(body, elifCtxt);
        }
        ExecContext elseCtxt = new ExecContext(ctxt);
        List body = Lists.cast((List)statement.getElses());
        return ToolDefExec.execute(body, elseCtxt);
    }

    private static ToolDefReturnValue execute(ReturnStatement statement, ExecContext ctxt) {
        ToolDefList values = new ToolDefList(statement.getValues().size());
        for (Expression valueExpr : statement.getValues()) {
            Object value;
            try {
                value = ToolDefEval.eval(valueExpr, ctxt);
            }
            catch (ToolDefException ex) {
                String msg = Strings.fmt((String)"Failed to evaluate return value \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)valueExpr)});
                throw new ToolDefException(msg, (Throwable)ex);
            }
            values.add(value);
        }
        if (ctxt.isTerminationRequested()) {
            return null;
        }
        ToolDefTuple value = null;
        if (values.size() == 1) {
            value = (ToolDefTuple)values.get(0);
        } else if (values.size() > 1) {
            value = ToolDefRuntimeUtils.makeTuple((List)values);
        }
        return new ToolDefReturnValue(value);
    }

    private static ToolDefReturnValue execute(ToolInvokeStatement statement, ExecContext ctxt) {
        ToolDefEval.eval((Expression)statement.getInvocation(), ctxt);
        return null;
    }

    private static ToolDefReturnValue execute(Variable var, ExecContext ctxt) {
        Object value;
        if (var.getValue() == null) {
            value = ToolDefRuntimeUtils.getDefaultValue((ToolDefType)var.getType());
        } else {
            try {
                value = ToolDefEval.eval(var.getValue(), ctxt);
            }
            catch (ToolDefException ex) {
                String msg = Strings.fmt((String)"Failed to evaluate initial value \"%s\" of variable \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)var.getValue()), ToolDefTextUtils.getAbsName((PositionObject)var)});
                throw new ToolDefException(msg, (Throwable)ex);
            }
        }
        ctxt.addVariable(var, value);
        return null;
    }

    private static ToolDefReturnValue execute(WhileStatement statement, ExecContext ctxt) {
        block8: {
            while (true) {
                boolean condition;
                try {
                    condition = (Boolean)ToolDefEval.eval(statement.getCondition(), ctxt);
                }
                catch (ToolDefException ex) {
                    String msg = Strings.fmt((String)"Failed to evaluate while condition \"%s\".", (Object[])new Object[]{ToolDefTextUtils.exprToStr((Expression)statement.getCondition())});
                    throw new ToolDefException(msg, (Throwable)ex);
                }
                if (ctxt.isTerminationRequested()) {
                    return null;
                }
                if (!condition) break block8;
                ExecContext whileCtxt = new ExecContext(ctxt);
                try {
                    List body = Lists.cast((List)statement.getStatements());
                    ToolDefReturnValue retValue = ToolDefExec.execute(body, whileCtxt);
                    if (retValue != null) {
                        return retValue;
                    }
                }
                catch (BreakException ex) {
                    break block8;
                }
                catch (ContinueException ex) {
                    continue;
                }
                if (ctxt.isTerminationRequested()) break;
            }
            return null;
        }
        return null;
    }
}

