/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.interpreter;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.HelpOption;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;
import org.eclipse.escet.tooldef.interpreter.ToolDefInterpreter;
import org.eclipse.escet.tooldef.interpreter.ToolDefInvokeOption;
import org.eclipse.escet.tooldef.io.ToolDefReader;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolInvokeExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ToolInvokeStatement;
import org.eclipse.escet.tooldef.parser.ToolDefInvokeParser;
import org.eclipse.escet.tooldef.typechecker.ToolDefTypeChecker;

public class ToolDefInterpreterApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ToolDefInterpreterApp app = new ToolDefInterpreterApp();
        app.run(args);
    }

    public ToolDefInterpreterApp() {
    }

    public ToolDefInterpreterApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "ToolDef interpreter";
    }

    public String getAppDescription() {
        return "The ToolDef interpreter executes ToolDef scripts.";
    }

    public void printHelpExitCodes(AppStream s) {
        super.printHelpExitCodes(s);
        HelpOption.outw((AppStream)s, (String)"In certain cases, the ToolDef script may produce an exit code different from the default exit code. For instance, in case an \"exit\" statement with a custom exit code is successfully executed, or in case the \"tooldef\" tool is used to execute a ToolDef script that produces a non-zero exit code and \"ignoreNonZeroExitCode\" is set to \"false\".", (Object[])new Object[0]);
    }

    protected int runInternal() {
        String whatIsExecuted;
        boolean dbgEnabled = OutputModeOption.getOutputMode() == OutputMode.DEBUG;
        String inputPath = InputFileOption.getPath();
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Reading ToolDef script file \"%s\".", (Object[])new Object[]{inputPath});
        }
        ToolDefReader reader = (ToolDefReader)new ToolDefReader().init();
        Script script = (Script)reader.read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        String scriptPath = Paths.resolve((String)inputPath);
        String invocationText = ToolDefInvokeOption.getInvocationText();
        ToolInvokeStatement invocation = invocationText == null ? null : this.getInvocation(invocationText, (ToolDefTypeChecker)reader.getTypeChecker());
        String string = whatIsExecuted = invocation == null ? "script" : "tool";
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Executing ToolDef %s.", (Object[])new Object[]{whatIsExecuted});
        }
        int exitCode = ToolDefInterpreter.execute(script, scriptPath, invocation, this);
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Finished executing ToolDef %s (exit code %d).", (Object[])new Object[]{whatIsExecuted, exitCode});
        }
        return exitCode;
    }

    private ToolInvokeStatement getInvocation(String invocationText, ToolDefTypeChecker tchecker) {
        ToolInvokeExpression invocationExpr;
        ToolDefInvokeParser parser = new ToolDefInvokeParser();
        try {
            invocationExpr = (ToolInvokeExpression)parser.parseString(invocationText, "/<invoke>", null, DebugMode.NONE);
        }
        catch (SyntaxException e) {
            String msg = Strings.fmt((String)"The tool invocation provided via the 'Tool invocation' option is invalid: \"%s\".", (Object[])new Object[]{invocationText});
            throw new InvalidOptionException(msg, (Throwable)e);
        }
        Assert.check((boolean)parser.getWarnings().isEmpty());
        ToolInvokeStatement invocationStatement = ToolDefConstructors.newToolInvokeStatement((ToolInvokeExpression)invocationExpr, null);
        List problems = tchecker.typeCheck(invocationStatement);
        List<SemanticProblem> errors = problems.stream().filter(p -> p.severity == SemanticProblemSeverity.ERROR).toList();
        if (!errors.isEmpty()) {
            String msg = String.valueOf(Strings.fmt((String)"The tool invocation provided via the 'Tool invocation' option is invalid: \"%s\":\n", (Object[])new Object[]{invocationText})) + errors.stream().map(p -> " - " + p.toString()).collect(Collectors.joining("\n"));
            throw new InvalidOptionException(msg);
        }
        return invocationStatement;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = ToolDefInterpreterApp.getGeneralOptionCategory();
        List interpreterOpts = Lists.list();
        interpreterOpts.add(Options.getInstance(InputFileOption.class));
        interpreterOpts.add(Options.getInstance(ToolDefInvokeOption.class));
        List interpreterSubCats = Lists.list();
        OptionCategory transCat = new OptionCategory("Interpreter", "Interpreter options.", interpreterSubCats, interpreterOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, transCat});
        OptionCategory options = new OptionCategory("ToolDef Interpreter Options", "All options for the ToolDef interpreter.", cats, Lists.list());
        return options;
    }
}

