/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheckViolation;
import org.eclipse.escet.cif.checkers.CifCheckViolationContext;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.emf.EMFPath;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifCheckViolations {
    private final Set<CifCheckViolation> violations = Sets.set();
    private final List<String> specLines;

    public CifCheckViolations(List<String> specLines) {
        this.specLines = specLines;
    }

    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    public Stream<CifCheckViolation> getViolations() {
        return this.violations.stream();
    }

    public void add(PositionObject reportObject, String message, Object ... args) {
        String line;
        String formattedMessage = Strings.fmt((String)message, (Object[])args);
        Assert.notNull((Object)reportObject);
        if (reportObject.getPosition() == null) {
            throw new NullPointerException(new EMFPath((EObject)reportObject, null).toString());
        }
        Position position = reportObject.getPosition();
        if (reportObject instanceof Specification) {
            line = null;
        } else {
            int lineNr = position.getStartLine();
            Assert.check((lineNr >= 1 ? 1 : 0) != 0, (Object)lineNr);
            Assert.check((lineNr <= this.specLines.size() ? 1 : 0) != 0, (Object)lineNr);
            line = this.specLines.get(lineNr - 1);
        }
        this.violations.add(new CifCheckViolation(reportObject, formattedMessage, line));
    }

    public List<String> createReport() {
        List lines = Lists.list();
        int violationMsgNr = 0;
        Map<String, List<CifCheckViolation>> violationsPerMessage = this.violations.stream().collect(Collectors.groupingBy(v -> v.getMessage()));
        for (String violationMessage : Sets.sortedstrings(violationsPerMessage.keySet())) {
            List<CifCheckViolation> violationsForMessage = violationsPerMessage.get(violationMessage);
            Set entireSpecs = violationsForMessage.stream().map(v -> v.getContext().isEntireSpec()).collect(Collectors.toSet());
            Assert.areEqual((Object)entireSpecs.size(), (Object)1);
            String violationMsg = Strings.fmt((String)"(%d/%d) %s.", (Object[])new Object[]{++violationMsgNr, violationsPerMessage.size(), violationMessage});
            String violationMsgHeader = Strings.duplicate((String)"-", (int)violationMsg.length());
            lines.add("");
            lines.add("  " + violationMsgHeader);
            lines.add("  " + violationMsg);
            lines.add("  " + violationMsgHeader);
            Map<CifCheckViolationContext, List<CifCheckViolation>> violationsPerContext = violationsForMessage.stream().collect(Collectors.groupingBy(v -> v.getContext()));
            List contexts = violationsPerContext.keySet().stream().sorted().toList();
            for (CifCheckViolationContext context : contexts) {
                if (context.isEntireSpec()) continue;
                lines.add(Strings.fmt((String)"   * In %s:", (Object[])new Object[]{context.toString()}));
                List<CifCheckViolation> violationsForContext = violationsPerContext.get(context);
                Map<Integer, List<CifCheckViolation>> violationsPerLineNr = violationsForContext.stream().collect(Collectors.groupingBy(v -> v.getReportObject().getPosition().getStartLine()));
                Iterator iterator = Sets.sortedgeneric(violationsPerLineNr.keySet()).iterator();
                while (iterator.hasNext()) {
                    int lineNr = (Integer)iterator.next();
                    List<CifCheckViolation> violationsForLine = violationsPerLineNr.get(lineNr);
                    String line = ((CifCheckViolation)Lists.first(violationsForLine)).getSpecLine().stripTrailing();
                    int lineLen = line.length();
                    line = line.stripLeading();
                    int strippedLineLen = line.length();
                    int strippedCount = lineLen - strippedLineLen;
                    lines.add("     - " + line);
                    StringBuilder markers = new StringBuilder();
                    for (CifCheckViolation violation : violationsForLine) {
                        int colNr = violation.getReportObject().getPosition().getStartColumn() - strippedCount;
                        if (markers.length() < colNr) {
                            markers.append(Strings.duplicate((String)" ", (int)(colNr - markers.length())));
                        }
                        markers.replace(colNr - 1, colNr, "^");
                    }
                    lines.add("       " + String.valueOf(markers));
                }
            }
        }
        return lines;
    }
}

