/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.java.CifWithArgWalker;
import org.eclipse.escet.cif.metamodel.java.CompositeCifWithArgWalker;
import org.eclipse.escet.cif.prettyprinter.CifPrettyPrinter;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;

public class CifChecker
extends CompositeCifWithArgWalker<CifCheckViolations> {
    private final boolean supportCompDefInst;

    public CifChecker(List<CifCheck> conditions) {
        this((CifCheck[])conditions.toArray(CifCheck[]::new));
    }

    public CifChecker(CifCheck ... conditions) {
        super((CifWithArgWalker[])conditions);
        this.supportCompDefInst = Arrays.stream(conditions).allMatch(chk -> chk.supportsCompDefInst());
    }

    public CifCheckViolations check(Specification spec, String absSpecPath) {
        Specification newSpec;
        Assert.check((this.supportCompDefInst || !CifScopeUtils.hasCompDefInst((Group)spec) ? 1 : 0) != 0, (Object)"At least one check does not support comp def/inst while the specification contains such a language construct.");
        Box box = CifPrettyPrinter.boxSpec((Specification)spec);
        CifReader reader = new CifReader();
        reader.init("<in-memory-cif-spec>", absSpecPath, false);
        reader.suppressWarnings = true;
        try {
            newSpec = (Specification)reader.read(box.toString());
        }
        catch (InvalidInputException | SyntaxException e) {
            throw new RuntimeException("Specification became invalid.", e);
        }
        CifCheckViolations violations = new CifCheckViolations(box.getLines());
        this.walkSpecification(newSpec, violations);
        return violations;
    }
}

