/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.EnumSet;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutOnlySpecificSupKindsCheck
extends CifCheck {
    private final EnumSet<SupKind> allowedKinds;

    public AutOnlySpecificSupKindsCheck(SupKind allowedKind) {
        this(allowedKind, allowedKind, allowedKind);
    }

    public AutOnlySpecificSupKindsCheck(SupKind allowedKind1, SupKind allowedKind2) {
        this(allowedKind1, allowedKind2, allowedKind2);
    }

    public AutOnlySpecificSupKindsCheck(SupKind allowedKind1, SupKind allowedKind2, SupKind allowedKind3) {
        this.allowedKinds = EnumSet.of(allowedKind1, allowedKind2, allowedKind3);
    }

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        if (!this.allowedKinds.contains(aut.getKind())) {
            violations.add((PositionObject)aut, "Automaton is a %s automaton rather than a %s automaton", CifTextUtils.kindToStr((SupKind)aut.getKind()), Strings.makeElementsChoiceText(this.allowedKinds, CifTextUtils::kindToStr));
        }
    }
}

