/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Function;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FuncNoSpecificStdLibCheck
extends CifCheck {
    private final EnumSet<NoSpecificStdLib> disalloweds;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$escet$cif$metamodel$cif$expressions$StdLibFunction;

    public FuncNoSpecificStdLibCheck(EnumSet<NoSpecificStdLib> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public FuncNoSpecificStdLibCheck(NoSpecificStdLib ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    /*
     * Unable to fully structure code
     */
    protected void preprocessStdLibFunctionExpression(StdLibFunctionExpression stdLibRef, CifCheckViolations violations) {
        func = stdLibRef.getFunction();
        funcCallExpr = (FunctionCallExpression)stdLibRef.eContainer();
        argTypes = funcCallExpr.getArguments().stream().map((Function<Expression, CifType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.eclipse.escet.cif.metamodel.cif.expressions.Expression ), (Lorg/eclipse/escet/cif/metamodel/cif/expressions/Expression;)Lorg/eclipse/escet/cif/metamodel/cif/types/CifType;)()).toList();
        switch (FuncNoSpecificStdLibCheck.$SWITCH_TABLE$org$eclipse$escet$cif$metamodel$cif$expressions$StdLibFunction()[func.ordinal()]) {
            case 29: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_INT)) {
                        if (argTypes.get(0) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_INT_RANGED) && (var7_6 = argTypes.get(0)) instanceof IntType) {
                            var6_16 = (IntType)var7_6;
                            (IntType)var7_6;
                            if (!CifTypeUtils.isRangeless((IntType)itype)) {
                                this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                            }
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_INT_RANGELESS) && (var9_26 = argTypes.get(0)) instanceof IntType) {
                            var8_36 = (IntType)var9_26;
                            (IntType)var9_26;
                            if (CifTypeUtils.isRangeless((IntType)itype)) {
                                this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                            }
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.ABS_REAL) && argTypes.get(0) instanceof RealType) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case 18: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ACOS)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 17: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ACOSH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 20: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ASIN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 19: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ASINH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 22: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ATAN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 21: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.ATANH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 30: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.BERNOULLI)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 31: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.BETA)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 32: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.BINOMIAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 5: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.CBRT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 6: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.CEIL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 33: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT_BOOL) && argTypes.get(0) instanceof BoolType) {
                        this.addExprViolationArgument(stdLibRef, "a boolean typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT_INT) && argTypes.get(0) instanceof IntType) {
                        this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.CONSTANT_REAL) && argTypes.get(0) instanceof RealType) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case 24: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.COS)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 23: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.COSH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 7: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)2);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_LIST_ARRAY) && (var7_7 = argTypes.get(0)) instanceof ListType) {
                        itype = (ListType)var7_7;
                        (ListType)var7_7;
                        if (CifTypeUtils.isArrayType((ListType)ltype)) {
                            this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_LIST_NON_ARRAY) && (var9_27 = argTypes.get(0)) instanceof ListType) {
                        itype = (ListType)var9_27;
                        (ListType)var9_27;
                        if (!CifTypeUtils.isArrayType((ListType)ltype)) {
                            this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_INT_RANGED) && (var11_46 = argTypes.get(1)) instanceof IntType) {
                        var10_51 = (IntType)var11_46;
                        (IntType)var11_46;
                        if (!CifTypeUtils.isRangeless((IntType)itype)) {
                            this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.DELETE_INT_RANGELESS) && (var13_56 = argTypes.get(1)) instanceof IntType) {
                        var12_61 = (IntType)var13_56;
                        (IntType)var13_56;
                        if (CifTypeUtils.isRangeless((IntType)itype)) {
                            this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                        }
                    }
                }
                return;
            }
            case 8: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_LIST)) {
                        if (argTypes.get(0) instanceof ListType) {
                            this.addExprViolationArgument(stdLibRef, "a list typed", violations);
                        }
                    } else {
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_LIST_ARRAY) && (var7_8 = argTypes.get(0)) instanceof ListType) {
                            ltype = (ListType)var7_8;
                            (ListType)var7_8;
                            if (CifTypeUtils.isArrayType((ListType)ltype)) {
                                this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                            }
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_LIST_NON_ARRAY) && (var9_28 = argTypes.get(0)) instanceof ListType) {
                            ltype = (ListType)var9_28;
                            (ListType)var9_28;
                            if (!CifTypeUtils.isArrayType((ListType)ltype)) {
                                this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                            }
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_SET) && argTypes.get(0) instanceof SetType) {
                        this.addExprViolationArgument(stdLibRef, "a set typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.EMPTY_DICT) && argTypes.get(0) instanceof DictType) {
                        this.addExprViolationArgument(stdLibRef, "a dictionary typed", violations);
                    }
                }
                return;
            }
            case 34: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.ERLANG)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 9: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.EXP)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 35: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.EXPONENTIAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 10: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.FLOOR)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 45: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.FORMAT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 36: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.GAMMA)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 37: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.GEOMETRIC)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 11: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.LN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 12: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.LOG)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 38: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.LOG_NORMAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 2: {
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM)) ** GOTO lbl201
                this.addExprViolationFunction(stdLibRef, violations);
                ** GOTO lbl238
lbl201:
                // 1 sources

                Assert.areEqual((Object)argTypes.size(), (Object)2);
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_INT)) ** GOTO lbl206
                if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType) {
                    this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                }
                ** GOTO lbl236
lbl206:
                // 1 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_INT_RANGED)) ** GOTO lbl221
                ltype = argTypes.get(0);
                if (!(ltype instanceof IntType)) ** GOTO lbl214
                ltype = (IntType)ltype;
                (IntType)ltype;
                if (!CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl220
lbl214:
                // 2 sources

                if (!((var9_29 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl221
                var7_9 = (IntType)var9_29;
                (IntType)var9_29;
                if (CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl221
lbl220:
                // 2 sources

                this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
lbl221:
                // 4 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_INT_RANGELESS)) ** GOTO lbl236
                var12_62 = argTypes.get(0);
                if (!(var12_62 instanceof IntType)) ** GOTO lbl229
                itype = (IntType)var12_62;
                (IntType)var12_62;
                if (CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl235
lbl229:
                // 2 sources

                if (!((var13_57 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl236
                var11_47 = (IntType)var13_57;
                (IntType)var13_57;
                if (!CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl236
lbl235:
                // 2 sources

                this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
lbl236:
                // 5 sources

                if (this.disalloweds.contains((Object)NoSpecificStdLib.MAXIMUM_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                    this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                }
lbl238:
                // 4 sources

                return;
            }
            case 1: {
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM)) ** GOTO lbl243
                this.addExprViolationFunction(stdLibRef, violations);
                ** GOTO lbl280
lbl243:
                // 1 sources

                Assert.areEqual((Object)argTypes.size(), (Object)2);
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_INT)) ** GOTO lbl248
                if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType) {
                    this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                }
                ** GOTO lbl278
lbl248:
                // 1 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_INT_RANGED)) ** GOTO lbl263
                ltype = argTypes.get(0);
                if (!(ltype instanceof IntType)) ** GOTO lbl256
                itype = (IntType)ltype;
                (IntType)ltype;
                if (!CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl262
lbl256:
                // 2 sources

                if (!((var9_30 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl263
                itype = (IntType)var9_30;
                (IntType)var9_30;
                if (CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl263
lbl262:
                // 2 sources

                this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
lbl263:
                // 4 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_INT_RANGELESS)) ** GOTO lbl278
                var12_63 = argTypes.get(0);
                if (!(var12_63 instanceof IntType)) ** GOTO lbl271
                itype = (IntType)var12_63;
                (IntType)var12_63;
                if (CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl277
lbl271:
                // 2 sources

                if (!((var13_58 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl278
                itype = (IntType)var13_58;
                (IntType)var13_58;
                if (!CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl278
lbl277:
                // 2 sources

                this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
lbl278:
                // 5 sources

                if (this.disalloweds.contains((Object)NoSpecificStdLib.MINIMUM_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                    this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                }
lbl280:
                // 4 sources

                return;
            }
            case 39: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.NORMAL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 40: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.POISSON)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 13: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.POP)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.POP_ARRAY) && (itype = argTypes.get(0)) instanceof ListType) {
                        itype = (ListType)itype;
                        (ListType)itype;
                        if (CifTypeUtils.isArrayType((ListType)ltype)) {
                            this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.POP_NON_ARRAY) && (var9_31 = argTypes.get(0)) instanceof ListType) {
                        ltype = (ListType)var9_31;
                        (ListType)var9_31;
                        if (!CifTypeUtils.isArrayType((ListType)ltype)) {
                            this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                        }
                    }
                }
                return;
            }
            case 3: {
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.POWER)) ** GOTO lbl313
                this.addExprViolationFunction(stdLibRef, violations);
                ** GOTO lbl350
lbl313:
                // 1 sources

                Assert.areEqual((Object)argTypes.size(), (Object)2);
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.POWER_INT)) ** GOTO lbl318
                if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType) {
                    this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                }
                ** GOTO lbl348
lbl318:
                // 1 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.POWER_INT_RANGED)) ** GOTO lbl333
                ltype = argTypes.get(0);
                if (!(ltype instanceof IntType)) ** GOTO lbl326
                ltype = (IntType)ltype;
                (IntType)ltype;
                if (!CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl332
lbl326:
                // 2 sources

                if (!((var9_32 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl333
                itype = (IntType)var9_32;
                (IntType)var9_32;
                if (CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl333
lbl332:
                // 2 sources

                this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
lbl333:
                // 4 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.POWER_INT_RANGELESS)) ** GOTO lbl348
                var12_64 = argTypes.get(0);
                if (!(var12_64 instanceof IntType)) ** GOTO lbl341
                itype = (IntType)var12_64;
                (IntType)var12_64;
                if (CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl347
lbl341:
                // 2 sources

                if (!((var13_59 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl348
                itype = (IntType)var13_59;
                (IntType)var13_59;
                if (!CifTypeUtils.isRangeless((IntType)itype)) ** GOTO lbl348
lbl347:
                // 2 sources

                this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
lbl348:
                // 5 sources

                if (this.disalloweds.contains((Object)NoSpecificStdLib.POWER_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                    this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                }
lbl350:
                // 4 sources

                return;
            }
            case 41: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.RANDOM)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 14: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ROUND)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 46: {
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.SCALE)) ** GOTO lbl363
                this.addExprViolationFunction(stdLibRef, violations);
                ** GOTO lbl436
lbl363:
                // 1 sources

                Assert.areEqual((Object)argTypes.size(), (Object)5);
                if (!this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_INT)) ** GOTO lbl368
                if (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType || argTypes.get(2) instanceof IntType || argTypes.get(3) instanceof IntType || argTypes.get(4) instanceof IntType) {
                    this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                }
                ** GOTO lbl434
lbl368:
                // 1 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_INT_RANGED)) ** GOTO lbl401
                var11_50 = argTypes.get(0);
                if (!(var11_50 instanceof IntType)) ** GOTO lbl376
                itype = (IntType)var11_50;
                (IntType)var11_50;
                if (!CifTypeUtils.isRangeless((IntType)itype0)) ** GOTO lbl400
lbl376:
                // 2 sources

                if (!((var12_65 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl382
                itype = (IntType)var12_65;
                (IntType)var12_65;
                if (!CifTypeUtils.isRangeless((IntType)itype1)) ** GOTO lbl400
lbl382:
                // 2 sources

                if (!((var13_60 = argTypes.get(2)) instanceof IntType)) ** GOTO lbl388
                ltype = (IntType)var13_60;
                (IntType)var13_60;
                if (!CifTypeUtils.isRangeless((IntType)itype2)) ** GOTO lbl400
lbl388:
                // 2 sources

                if (!((var14_66 = argTypes.get(3)) instanceof IntType)) ** GOTO lbl394
                var9_33 = (IntType)var14_66;
                (IntType)var14_66;
                if (!CifTypeUtils.isRangeless((IntType)itype3)) ** GOTO lbl400
lbl394:
                // 2 sources

                if (!((var15_67 = argTypes.get(4)) instanceof IntType)) ** GOTO lbl401
                itype = (IntType)var15_67;
                (IntType)var15_67;
                if (CifTypeUtils.isRangeless((IntType)itype4)) ** GOTO lbl401
lbl400:
                // 5 sources

                this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
lbl401:
                // 4 sources

                if (!this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_INT_RANGELESS)) ** GOTO lbl434
                var21_68 = argTypes.get(0);
                if (!(var21_68 instanceof IntType)) ** GOTO lbl409
                var16_69 = (IntType)var21_68;
                (IntType)var21_68;
                if (CifTypeUtils.isRangeless((IntType)itype0)) ** GOTO lbl433
lbl409:
                // 2 sources

                if (!((var22_70 = argTypes.get(1)) instanceof IntType)) ** GOTO lbl415
                var17_71 = (IntType)var22_70;
                (IntType)var22_70;
                if (CifTypeUtils.isRangeless((IntType)itype1)) ** GOTO lbl433
lbl415:
                // 2 sources

                if (!((var23_72 = argTypes.get(2)) instanceof IntType)) ** GOTO lbl421
                var18_73 = (IntType)var23_72;
                (IntType)var23_72;
                if (CifTypeUtils.isRangeless((IntType)itype2)) ** GOTO lbl433
lbl421:
                // 2 sources

                if (!((var24_74 = argTypes.get(3)) instanceof IntType)) ** GOTO lbl427
                var19_75 = (IntType)var24_74;
                (IntType)var24_74;
                if (CifTypeUtils.isRangeless((IntType)itype3)) ** GOTO lbl433
lbl427:
                // 2 sources

                if (!((var25_76 = argTypes.get(4)) instanceof IntType)) ** GOTO lbl434
                var20_77 = (IntType)var25_76;
                (IntType)var25_76;
                if (!CifTypeUtils.isRangeless((IntType)itype4)) ** GOTO lbl434
lbl433:
                // 5 sources

                this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
lbl434:
                // 5 sources

                if (this.disalloweds.contains((Object)NoSpecificStdLib.SCALE_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType || argTypes.get(2) instanceof RealType || argTypes.get(3) instanceof RealType || argTypes.get(4) instanceof RealType)) {
                    this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                }
lbl436:
                // 4 sources

                return;
            }
            case 4: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_INT)) {
                        if (argTypes.get(0) instanceof IntType) {
                            this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                        }
                    } else {
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_INT_RANGED) && (var7_14 = argTypes.get(0)) instanceof IntType) {
                            itype0 = (IntType)var7_14;
                            (IntType)var7_14;
                            if (!CifTypeUtils.isRangeless((IntType)itype)) {
                                this.addExprViolationArgument(stdLibRef, "a ranged integer typed", violations);
                            }
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_INT_RANGELESS) && (var9_34 = argTypes.get(0)) instanceof IntType) {
                            itype2 = (IntType)var9_34;
                            (IntType)var9_34;
                            if (CifTypeUtils.isRangeless((IntType)itype)) {
                                this.addExprViolationArgument(stdLibRef, "a rangeless integer typed", violations);
                            }
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIGN_REAL) && argTypes.get(0) instanceof RealType) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case 26: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.SIN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 25: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.SINH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 15: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)1);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_STRING) && argTypes.get(0) instanceof StringType) {
                        this.addExprViolationArgument(stdLibRef, "a string typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_LIST)) {
                        if (argTypes.get(0) instanceof ListType) {
                            this.addExprViolationArgument(stdLibRef, "a list typed", violations);
                        }
                    } else {
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_LIST_ARRAY) && (var7_15 = argTypes.get(0)) instanceof ListType) {
                            itype = (ListType)var7_15;
                            (ListType)var7_15;
                            if (CifTypeUtils.isArrayType((ListType)ltype)) {
                                this.addExprViolationArgument(stdLibRef, "an array list typed", violations);
                            }
                        }
                        if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_LIST_NON_ARRAY) && (var9_35 = argTypes.get(0)) instanceof ListType) {
                            itype = (ListType)var9_35;
                            (ListType)var9_35;
                            if (!CifTypeUtils.isArrayType((ListType)ltype)) {
                                this.addExprViolationArgument(stdLibRef, "a non-array list typed", violations);
                            }
                        }
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_SET) && argTypes.get(0) instanceof SetType) {
                        this.addExprViolationArgument(stdLibRef, "a set typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.SIZE_DICT) && argTypes.get(0) instanceof DictType) {
                        this.addExprViolationArgument(stdLibRef, "a dictionary typed", violations);
                    }
                }
                return;
            }
            case 16: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.SQRT)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 28: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.TAN)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 27: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_TRIGONOMETRY) || this.disalloweds.contains((Object)NoSpecificStdLib.TANH)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 42: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.TRIANGLE)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
            case 43: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.UNIFORM)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                } else {
                    Assert.areEqual((Object)argTypes.size(), (Object)2);
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.UNIFORM_INT) && (argTypes.get(0) instanceof IntType || argTypes.get(1) instanceof IntType)) {
                        this.addExprViolationArgument(stdLibRef, "an integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificStdLib.UNIFORM_REAL) && (argTypes.get(0) instanceof RealType || argTypes.get(1) instanceof RealType)) {
                        this.addExprViolationArgument(stdLibRef, "a real typed", violations);
                    }
                }
                return;
            }
            case 44: {
                if (this.disalloweds.contains((Object)NoSpecificStdLib.ALL_STOCHASTIC) || this.disalloweds.contains((Object)NoSpecificStdLib.WEIBULL)) {
                    this.addExprViolationFunction(stdLibRef, violations);
                }
                return;
            }
        }
        throw new AssertionError((Object)("Unknown std lib function: " + String.valueOf(func)));
    }

    private void addExprViolationFunction(StdLibFunctionExpression stdLibExpr, CifCheckViolations violations) {
        violations.add((PositionObject)stdLibExpr, "Standard library function \"%s\" is used", CifTextUtils.functionToStr((StdLibFunction)stdLibExpr.getFunction()));
    }

    private void addExprViolationArgument(StdLibFunctionExpression stdLibExpr, String argTxt, CifCheckViolations violations) {
        violations.add((PositionObject)stdLibExpr, "Standard library function \"%s\" is used on %s argument", CifTextUtils.functionToStr((StdLibFunction)stdLibExpr.getFunction()), argTxt);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$escet$cif$metamodel$cif$expressions$StdLibFunction() {
        if ($SWITCH_TABLE$org$eclipse$escet$cif$metamodel$cif$expressions$StdLibFunction != null) {
            return $SWITCH_TABLE$org$eclipse$escet$cif$metamodel$cif$expressions$StdLibFunction;
        }
        int[] nArray = new int[StdLibFunction.values().length];
        try {
            nArray[StdLibFunction.ABS.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ACOS.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ACOSH.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ASIN.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ASINH.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ATAN.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ATANH.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.BERNOULLI.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.BETA.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.BINOMIAL.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.CBRT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.CEIL.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.CONSTANT.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.COS.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.COSH.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.DELETE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.EMPTY.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ERLANG.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.EXP.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.EXPONENTIAL.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.FLOOR.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.FORMAT.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.GAMMA.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.GEOMETRIC.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.LN.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.LOG.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.LOG_NORMAL.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.MAXIMUM.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.MINIMUM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.NORMAL.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.POISSON.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.POP.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.POWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.RANDOM.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.ROUND.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.SCALE.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.SIGN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.SIN.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.SINH.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.SIZE.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.SQRT.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.TAN.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.TANH.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.TRIANGLE.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.UNIFORM.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StdLibFunction.WEIBULL.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$escet$cif$metamodel$cif$expressions$StdLibFunction = nArray;
        return nArray;
    }

    private static /* synthetic */ CifType lambda$0(Expression arg) {
        return CifTypeUtils.normalizeType((CifType)arg.getType());
    }

    public static enum NoSpecificStdLib {
        ALL_TRIGONOMETRY,
        ALL_STOCHASTIC,
        ABS,
        ABS_INT,
        ABS_INT_RANGED,
        ABS_INT_RANGELESS,
        ABS_REAL,
        ACOS,
        ACOSH,
        ASIN,
        ASINH,
        ATAN,
        ATANH,
        BERNOULLI,
        BETA,
        BINOMIAL,
        CBRT,
        CEIL,
        CONSTANT,
        CONSTANT_BOOL,
        CONSTANT_INT,
        CONSTANT_REAL,
        COS,
        COSH,
        DELETE,
        DELETE_LIST_ARRAY,
        DELETE_LIST_NON_ARRAY,
        DELETE_INT_RANGED,
        DELETE_INT_RANGELESS,
        EMPTY,
        EMPTY_LIST,
        EMPTY_LIST_ARRAY,
        EMPTY_LIST_NON_ARRAY,
        EMPTY_SET,
        EMPTY_DICT,
        ERLANG,
        EXP,
        EXPONENTIAL,
        FLOOR,
        FORMAT,
        GAMMA,
        GEOMETRIC,
        LN,
        LOG,
        LOG_NORMAL,
        MAXIMUM,
        MAXIMUM_INT,
        MAXIMUM_INT_RANGED,
        MAXIMUM_INT_RANGELESS,
        MAXIMUM_REAL,
        MINIMUM,
        MINIMUM_INT,
        MINIMUM_INT_RANGED,
        MINIMUM_INT_RANGELESS,
        MINIMUM_REAL,
        NORMAL,
        POISSON,
        POP,
        POP_ARRAY,
        POP_NON_ARRAY,
        POWER,
        POWER_INT,
        POWER_INT_RANGED,
        POWER_INT_RANGELESS,
        POWER_REAL,
        RANDOM,
        ROUND,
        SCALE,
        SCALE_INT,
        SCALE_INT_RANGED,
        SCALE_INT_RANGELESS,
        SCALE_REAL,
        SIGN,
        SIGN_INT,
        SIGN_INT_RANGED,
        SIGN_INT_RANGELESS,
        SIGN_REAL,
        SIN,
        SINH,
        SIZE,
        SIZE_STRING,
        SIZE_LIST,
        SIZE_LIST_ARRAY,
        SIZE_LIST_NON_ARRAY,
        SIZE_SET,
        SIZE_DICT,
        SQRT,
        TAN,
        TANH,
        TRIANGLE,
        UNIFORM,
        UNIFORM_INT,
        UNIFORM_REAL,
        WEIBULL;

    }
}

