/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BaseFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ExpressionsPackage;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class TypeNoSpecificTypesCheck
extends CifCheck {
    private static final EReference FCE_FUNC_REF = ExpressionsPackage.eINSTANCE.getFunctionCallExpression_Function();
    private final EnumSet<NoSpecificType> disalloweds;

    public TypeNoSpecificTypesCheck(NoSpecificType ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public TypeNoSpecificTypesCheck(EnumSet<NoSpecificType> disalloweds) {
        this.disalloweds = disalloweds;
    }

    protected void preprocessComponentDefType(ComponentDefType compDefType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.COMP_DEF_TYPES)) {
            violations.add((PositionObject)compDefType, "A component definition type is used", new Object[0]);
        }
    }

    protected void preprocessComponentType(ComponentType compType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.COMP_TYPES)) {
            violations.add((PositionObject)compType, "A component type is used", new Object[0]);
        }
    }

    protected void preprocessDictType(DictType dictType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.DICT_TYPES)) {
            violations.add((PositionObject)dictType, "A dictionary type is used", new Object[0]);
        }
    }

    protected void preprocessDistType(DistType distType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.DIST_TYPES)) {
            violations.add((PositionObject)distType, "A distribution type is used", new Object[0]);
        }
    }

    protected void preprocessEnumType(EnumType enumType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.ENUM_TYPES)) {
            violations.add((PositionObject)enumType, "An enumeration type is used", new Object[0]);
        }
    }

    protected void preprocessFuncType(FuncType funcType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.FUNC_TYPES)) {
            violations.add((PositionObject)funcType, "A function type is used", new Object[0]);
        } else if (this.disalloweds.contains((Object)NoSpecificType.FUNC_TYPES_AS_DATA) && !this.isUsedInFunctionCallContext(funcType)) {
            violations.add((PositionObject)funcType, "A function type is used to store functions or use functions as data values", new Object[0]);
        }
    }

    private boolean isUsedInFunctionCallContext(FuncType funcType) {
        if (!(funcType.eContainer() instanceof BaseFunctionExpression)) {
            return false;
        }
        BaseFunctionExpression baseFuncExpr = (BaseFunctionExpression)funcType.eContainer();
        return baseFuncExpr.eContainer() instanceof FunctionCallExpression && baseFuncExpr.eContainmentFeature() == FCE_FUNC_REF;
    }

    protected void preprocessIntType(IntType intType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.INT_TYPES)) {
            violations.add((PositionObject)intType, "An integer type is used", new Object[0]);
        } else if (this.disalloweds.contains((Object)NoSpecificType.INT_TYPES_RANGELESS) && CifTypeUtils.isRangeless((IntType)intType)) {
            violations.add((PositionObject)intType, "A rangeless integer type is used", new Object[0]);
        }
    }

    protected void preprocessListType(ListType listType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.LIST_TYPES)) {
            violations.add((PositionObject)listType, "A list type is used", new Object[0]);
        } else if (this.disalloweds.contains((Object)NoSpecificType.LIST_TYPES_NON_ARRAY) && !CifTypeUtils.isArrayType((ListType)listType)) {
            violations.add((PositionObject)listType, "A non-array list type is used", new Object[0]);
        }
    }

    protected void preprocessRealType(RealType realType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.REAL_TYPES)) {
            violations.add((PositionObject)realType, "A real type is used", new Object[0]);
        }
    }

    protected void preprocessSetType(SetType setType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.SET_TYPES)) {
            violations.add((PositionObject)setType, "A set type is used", new Object[0]);
        }
    }

    protected void preprocessStringType(StringType stringType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.STRING_TYPES)) {
            violations.add((PositionObject)stringType, "A string type is used", new Object[0]);
        }
    }

    protected void preprocessTupleType(TupleType tupleType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.TUPLE_TYPES)) {
            violations.add((PositionObject)tupleType, "A tuple type is used", new Object[0]);
        }
    }

    protected void preprocessVoidType(VoidType voidType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.VOID_TYPES)) {
            violations.add((PositionObject)voidType, "A void type is used", new Object[0]);
        }
    }

    public static enum NoSpecificType {
        COMP_DEF_TYPES,
        COMP_TYPES,
        DICT_TYPES,
        DIST_TYPES,
        ENUM_TYPES,
        FUNC_TYPES,
        FUNC_TYPES_AS_DATA,
        INT_TYPES,
        INT_TYPES_RANGELESS,
        LIST_TYPES,
        LIST_TYPES_NON_ARRAY,
        REAL_TYPES,
        SET_TYPES,
        STRING_TYPES,
        TUPLE_TYPES,
        VOID_TYPES;

    }
}

