/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.EnumsToConsts;
import org.eclipse.escet.cif.cif2cif.EnumsToInts;
import org.eclipse.escet.cif.cif2cif.LinearizeMerge;
import org.eclipse.escet.cif.cif2cif.MergeEnums;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyOthers;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.cif2plc.CifToPlcPreChecker;
import org.eclipse.escet.cif.cif2plc.NaryExpressionConverter;
import org.eclipse.escet.cif.cif2plc.options.ConvertEnums;
import org.eclipse.escet.cif.cif2plc.options.ConvertEnumsOption;
import org.eclipse.escet.cif.cif2plc.options.PlcConfigurationNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcFormalFuncInvokeArg;
import org.eclipse.escet.cif.cif2plc.options.PlcFormalFuncInvokeArgOption;
import org.eclipse.escet.cif.cif2plc.options.PlcFormalFuncInvokeFunc;
import org.eclipse.escet.cif.cif2plc.options.PlcFormalFuncInvokeFuncOption;
import org.eclipse.escet.cif.cif2plc.options.PlcMaxIterOption;
import org.eclipse.escet.cif.cif2plc.options.PlcNumberBitsOption;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputType;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputTypeOption;
import org.eclipse.escet.cif.cif2plc.options.PlcProjectNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcResourceNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcTaskCycleTimeOption;
import org.eclipse.escet.cif.cif2plc.options.PlcTaskNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcTaskPriorityOption;
import org.eclipse.escet.cif.cif2plc.options.RenameWarningsOption;
import org.eclipse.escet.cif.cif2plc.options.SimplifyValuesOption;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcArrayType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcConfiguration;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcDerivedType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcElementaryType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcEnumType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcGlobalVarList;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPou;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouInstance;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcProject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcResource;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcStructType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTask;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTypeDecl;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcValue;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifIntFuncUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.ConstantOrderer;
import org.eclipse.escet.cif.common.FuncLocalVarOrderer;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.common.StateInitVarOrderer;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToPlcTrans {
    private final PlcFormalFuncInvokeArg formalInvokeArg;
    private final PlcFormalFuncInvokeFunc formalInvokeFunc;
    private final boolean simplifyValues;
    private final boolean constantsAllowed;
    private PlcProject project;
    private PlcConfiguration config;
    private PlcResource resource;
    private PlcTask task;
    private PlcGlobalVarList globalConsts;
    private PlcGlobalVarList globalInputs;
    private PlcStructType stateStruct;
    private final String staticVarPrefix;
    private Map<PositionObject, String> objNames = Maps.map();
    private Set<String> names = Sets.set();
    private Map<InternalFunction, PlcPou> internalFuncs = Maps.map();
    private Map<TypeEqHashWrap, String> structNames = Maps.map();
    private Map<TypeEqHashWrap, Integer> arrayNrs = Maps.map();
    private Set<Integer> arrayLitCreateFuncGenerated = Sets.set();
    private Set<Integer> arrayProjFuncGenerated = Sets.set();
    private boolean normProjIdxGenerated = false;
    private int nextStructNr = 1;
    private int nextIfFuncNr = 1;
    private int maxNaryLevel = 0;
    private PlcElementaryType largeRealType;
    private PlcElementaryType largeIntType;

    private CifToPlcTrans() {
        this.simplifyValues = SimplifyValuesOption.simplifyValues();
        this.constantsAllowed = !this.simplifyValues || ConvertEnumsOption.getValue() == ConvertEnums.CONSTS;
        this.formalInvokeArg = PlcFormalFuncInvokeArgOption.getValue();
        this.formalInvokeFunc = PlcFormalFuncInvokeFuncOption.getValue();
        String string = this.staticVarPrefix = PlcOutputTypeOption.isS7Output() ? "\"DB\"." : "";
        if (PlcOutputTypeOption.isS7Output() && (this.formalInvokeArg == PlcFormalFuncInvokeArg.NONE || this.formalInvokeFunc != PlcFormalFuncInvokeFunc.ALL)) {
            String msg = Strings.fmt((String)"Formal function invocation is not enabled for all functions, while this is required for %s code. Please set the \"Formal function invocation (arguments based)\" and \"Formal function invocation (function kind based)\" options accordingly.", (Object[])new Object[]{PlcOutputTypeOption.getPlcOutputType().dialogText});
            throw new InvalidInputException(msg);
        }
        switch (PlcNumberBitsOption.getNumberBits()) {
            case AUTO: {
                this.largeIntType = PlcOutputTypeOption.getPlcOutputType().largeIntType;
                this.largeRealType = PlcOutputTypeOption.getPlcOutputType().largeRealType;
                break;
            }
            case BITS_32: {
                this.largeIntType = PlcElementaryType.DINT_TYPE;
                this.largeRealType = PlcElementaryType.REAL_TYPE;
                break;
            }
            case BITS_64: {
                this.largeIntType = PlcElementaryType.LINT_TYPE;
                this.largeRealType = PlcElementaryType.LREAL_TYPE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown number of bits: " + String.valueOf((Object)PlcNumberBitsOption.getNumberBits()));
            }
        }
    }

    public static PlcProject transform(Specification spec, String absSpecPath) {
        CifToPlcTrans trans = new CifToPlcTrans();
        new ElimComponentDefInst().transform(spec);
        new ElimStateEvtExclInvs().transform(spec);
        if (trans.simplifyValues) {
            new SimplifyValues().transform(spec);
            new ElimConsts().transform(spec);
        }
        new SimplifyOthers().transform(spec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        CifToPlcPreChecker checker = new CifToPlcPreChecker();
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF PLC code generator");
        new LinearizeMerge(true).transform(spec);
        new MergeEnums().transform(spec);
        if (trans.simplifyValues) {
            new SimplifyValues().transform(spec);
        }
        new AddDefaultInitialValues().transform(spec);
        if (ConvertEnumsOption.getValue() == ConvertEnums.INTS) {
            new EnumsToInts().transform(spec);
        } else if (ConvertEnumsOption.getValue() == ConvertEnums.CONSTS) {
            new EnumsToConsts().transform(spec);
        } else if (PlcOutputTypeOption.isS7Output()) {
            String msg = Strings.fmt((String)"Enumerations are not converted, while this is required for %s code. Please set the \"Convert enumerations\" option accordingly.", (Object[])new Object[]{PlcOutputTypeOption.getPlcOutputType().dialogText});
            throw new InvalidInputException(msg);
        }
        return trans.transformSpec(spec);
    }

    private PlcProject transformSpec(Specification spec) {
        this.initProject();
        List automata = Lists.listc((int)1);
        CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)automata);
        Assert.check((automata.size() == 1 ? 1 : 0) != 0);
        Automaton aut = (Automaton)Lists.first((List)automata);
        List declarations = Lists.list();
        CifCollectUtils.collectDeclarations((ComplexComponent)spec, (Collection)declarations);
        List stateVars = Lists.list();
        List constants = Lists.list();
        for (Declaration decl : declarations) {
            if (decl instanceof DiscVariable) {
                stateVars.add(decl);
            }
            if (decl instanceof ContVariable) {
                stateVars.add(decl);
            }
            if (decl instanceof Constant) {
                constants.add((Constant)decl);
            }
            this.transDecl(decl);
        }
        if (this.globalInputs.variables.isEmpty()) {
            OutputProvider.warn((String)"Generating PLC code for a specification without input variables may make it impossible to connect to input ports.");
        }
        if (stateVars.isEmpty()) {
            OutputProvider.warn((String)"Generating PLC code for a specification without state variables may make it impossible to connect to output ports.");
        }
        this.transConstants(constants);
        this.generateProgram(aut, stateVars);
        return this.project;
    }

    private void initProject() {
        this.project = new PlcProject(PlcProjectNameOption.getProjName());
        this.config = new PlcConfiguration(PlcConfigurationNameOption.getCfgName());
        this.resource = new PlcResource(PlcResourceNameOption.getResName());
        this.task = new PlcTask(PlcTaskNameOption.getTaskName(), PlcTaskCycleTimeOption.getTaskCycleTime(), PlcTaskPriorityOption.getTaskPrio());
        this.project.configurations.add(this.config);
        this.config.resources.add(this.resource);
        this.resource.tasks.add(this.task);
        this.globalInputs = new PlcGlobalVarList("INPUTS", false);
        this.resource.globalVarLists.add(this.globalInputs);
        if (this.constantsAllowed) {
            this.globalConsts = new PlcGlobalVarList("CONSTS", true);
            this.resource.globalVarLists.add(this.globalConsts);
        }
        PlcGlobalVarList globalTimers = new PlcGlobalVarList("TIMERS", false);
        this.resource.globalVarLists.add(globalTimers);
        PlcDerivedType tonType = new PlcDerivedType("TON");
        globalTimers.variables.add(new PlcVariable("timer0", tonType));
        globalTimers.variables.add(new PlcVariable("timer1", tonType));
        globalTimers.variables.add(new PlcVariable("curTimer", PlcElementaryType.INT_TYPE, null, new PlcValue("0")));
        this.stateStruct = new PlcStructType();
        PlcTypeDecl stateType = new PlcTypeDecl("STATE", this.stateStruct);
        this.project.typeDecls.add(stateType);
        PlcVariable stateTimeVar = new PlcVariable("curTime", this.largeRealType);
        this.stateStruct.fields.add(stateTimeVar);
    }

    private void generateProgram(Automaton aut, List<Declaration> stateVars) {
        String name;
        DiscVariable var;
        String conversionTxt;
        PlcPou main = new PlcPou("MAIN", PlcPouType.PROGRAM, null);
        this.project.pous.add(main);
        this.task.pouInstances.add(new PlcPouInstance("MAIN", main));
        main.localVars.add(new PlcVariable("cnt", this.largeIntType));
        main.localVars.add(new PlcVariable("first", PlcElementaryType.BOOL_TYPE, null, new PlcValue("TRUE")));
        main.localVars.add(new PlcVariable("curTimerValue", PlcElementaryType.TIME_TYPE));
        main.localVars.add(new PlcVariable("state0", PlcDerivedType.STATE_TYPE));
        main.localVars.add(new PlcVariable("curTime", this.largeRealType));
        main.localVars.add(new PlcVariable("loopsKilled", this.largeIntType));
        main.tempVars.add(new PlcVariable("lastTimerValue", PlcElementaryType.TIME_TYPE));
        main.tempVars.add(new PlcVariable("curDeltaTime", PlcElementaryType.TIME_TYPE));
        main.tempVars.add(new PlcVariable("curDeltaSecs", this.largeRealType));
        main.tempVars.add(new PlcVariable("state1", PlcDerivedType.STATE_TYPE));
        main.tempVars.add(new PlcVariable("progress", PlcElementaryType.BOOL_TYPE));
        main.tempVars.add(new PlcVariable("loopCount", PlcElementaryType.INT_TYPE));
        main.outputVars.add(new PlcVariable("timerValue0", PlcElementaryType.TIME_TYPE));
        main.outputVars.add(new PlcVariable("timerValue1", PlcElementaryType.TIME_TYPE));
        main.body.add();
        main.body.add("// Handle 'time' and cycle time.");
        main.body.add("%s := %s + 1;", new Object[]{this.genStaticVarRef("cnt"), this.genStaticVarRef("cnt")});
        main.body.add();
        String timer0Txt = PlcOutputTypeOption.isS7Output() ? "timer0.TON" : "timer0";
        String timer1Txt = PlcOutputTypeOption.isS7Output() ? "timer1.TON" : "timer1";
        main.body.add("%s(IN := %s = 0, PT := T#1D);", new Object[]{timer0Txt, this.genStaticVarRef("curTimer")});
        main.body.add("%s(IN := %s = 1, PT := T#1D);", new Object[]{timer1Txt, this.genStaticVarRef("curTimer")});
        main.body.add("timerValue0 := timer0.ET;");
        main.body.add("timerValue1 := timer1.ET;");
        main.body.add();
        main.body.add("lastTimerValue := %s;", new Object[]{this.genStaticVarRef("curTimerValue")});
        main.body.add("IF %s = 0 THEN", new Object[]{this.genStaticVarRef("curTimer")});
        main.body.indent();
        main.body.add("%s := timerValue0;", new Object[]{this.genStaticVarRef("curTimerValue")});
        main.body.dedent();
        main.body.add("ELSE");
        main.body.indent();
        main.body.add("%s := timerValue1;", new Object[]{this.genStaticVarRef("curTimerValue")});
        main.body.dedent();
        main.body.add("END_IF;");
        main.body.add("curDeltaTime := %s - lastTimerValue;", new Object[]{this.genStaticVarRef("curTimerValue")});
        if (PlcOutputTypeOption.isS7Output()) {
            String timeToInt = this.genFuncCall(Strings.fmt((String)"TIME_TO_%s", (Object[])new Object[]{this.largeIntType.name}), true, "IN", "curDeltaTime");
            conversionTxt = this.genFuncCall(Strings.fmt((String)"%s_TO_%s", (Object[])new Object[]{this.largeIntType.name, this.largeRealType.name}), true, "IN", timeToInt);
        } else {
            conversionTxt = this.genFuncCall(Strings.fmt((String)"TIME_TO_%s", (Object[])new Object[]{this.largeRealType.name}), true, "IN", "curDeltaTime");
        }
        main.body.add("curDeltaSecs := %s / 1000;", new Object[]{conversionTxt});
        main.body.add("%s := %s + curDeltaSecs;", new Object[]{this.genStaticVarRef("curTime"), this.genStaticVarRef("curTime")});
        main.body.add();
        main.body.add("IF %s MOD 10 = 0 THEN", new Object[]{this.genStaticVarRef("cnt")});
        main.body.indent();
        main.body.add("%s := 1 - %s;", new Object[]{this.genStaticVarRef("curTimer"), this.genStaticVarRef("curTimer")});
        main.body.add("%s := T#0S;", new Object[]{this.genStaticVarRef("curTimerValue")});
        main.body.add("%s(IN := %s = 0, PT := T#1D);", new Object[]{timer0Txt, this.genStaticVarRef("curTimer")});
        main.body.add("%s(IN := %s = 1, PT := T#1D);", new Object[]{timer1Txt, this.genStaticVarRef("curTimer")});
        main.body.add("timerValue0 := timer0.ET;");
        main.body.add("timerValue1 := timer1.ET;");
        main.body.dedent();
        main.body.add("END_IF;");
        main.body.add();
        main.body.add("IF %s THEN", new Object[]{this.genStaticVarRef("first")});
        main.body.indent();
        main.body.add("%s := FALSE;", new Object[]{this.genStaticVarRef("first")});
        main.body.add();
        main.body.add("// Initialize state variables for initial state.");
        stateVars = new StateInitVarOrderer().computeOrder(stateVars);
        for (Declaration stateVar : stateVars) {
            Expression value;
            if (stateVar instanceof DiscVariable) {
                var = (DiscVariable)stateVar;
                value = (Expression)Lists.first((List)var.getValue().getValues());
                main.body.add("%s.%s := %s;", new Object[]{this.genStaticVarRef("state0"), this.getPlcName((PositionObject)stateVar), this.transExpr(value, this.genStaticVarRef("state0"), false)});
                continue;
            }
            Assert.check((boolean)(stateVar instanceof ContVariable));
            var = (ContVariable)stateVar;
            value = var.getValue();
            main.body.add("%s.%s := %s;", new Object[]{this.genStaticVarRef("state0"), this.getPlcName((PositionObject)stateVar), this.transExpr(value, this.genStaticVarRef("state0"), false)});
        }
        main.body.dedent();
        main.body.add("ELSE");
        main.body.indent();
        main.body.add("// Update continuous variables for time delay.");
        for (Declaration stateVar : stateVars) {
            if (!(stateVar instanceof ContVariable)) continue;
            var = (ContVariable)stateVar;
            name = this.getPlcName((PositionObject)var);
            String fc = this.genFuncCall("deriv" + name, false, "state", this.genStaticVarRef("state0"));
            main.body.add("state1.%s := %s.%s + curDeltaSecs * %s;", new Object[]{name, this.genStaticVarRef("state0"), name, fc});
        }
        main.body.add();
        main.body.add("%s.curTime := %s;", new Object[]{this.genStaticVarRef("state0"), this.genStaticVarRef("curTime")});
        for (Declaration stateVar : stateVars) {
            if (!(stateVar instanceof ContVariable)) continue;
            var = (ContVariable)stateVar;
            name = this.getPlcName((PositionObject)var);
            main.body.add("%s.%s := state1.%s;", new Object[]{this.genStaticVarRef("state0"), name, name});
        }
        main.body.dedent();
        main.body.add("END_IF;");
        main.body.add();
        main.body.add("// Event loop.");
        main.body.add("WHILE TRUE DO");
        main.body.indent();
        main.body.add("progress := FALSE;");
        Assert.check((aut.getLocations().size() == 1 ? 1 : 0) != 0);
        Location loc = (Location)Lists.first((List)aut.getLocations());
        for (Edge edge : loc.getEdges()) {
            this.transEdge(edge, main);
        }
        int i = 1;
        while (i <= this.maxNaryLevel) {
            main.tempVars.add(new PlcVariable("b" + i, PlcElementaryType.BOOL_TYPE));
            ++i;
        }
        main.body.add();
        main.body.add("// Done with events?");
        main.body.add("IF NOT progress THEN");
        main.body.indent();
        main.body.add("EXIT;");
        main.body.dedent();
        main.body.add("END_IF;");
        Integer maxIter = PlcMaxIterOption.getMaxIter();
        if (maxIter != null) {
            main.body.add();
            main.body.add("// Protect against events that are always enabled.");
            main.body.add("loopCount := loopCount + 1;");
            main.body.add("IF loopCount >= %d THEN", new Object[]{maxIter});
            main.body.indent();
            main.body.add("%s := %s + 1;", new Object[]{this.genStaticVarRef("loopsKilled"), this.genStaticVarRef("loopsKilled")});
            main.body.add("EXIT;");
            main.body.dedent();
            main.body.add("END_IF;");
        }
        main.body.dedent();
        main.body.add("END_WHILE;");
    }

    private void transDecl(Declaration decl) {
        if (decl instanceof AlgVariable) {
            this.transAlgVar((AlgVariable)decl);
        } else if (decl instanceof Constant) {
            Assert.check((boolean)this.constantsAllowed);
        } else if (decl instanceof ContVariable) {
            this.transContVar((ContVariable)decl);
        } else if (decl instanceof DiscVariable) {
            this.transDiscVar((DiscVariable)decl);
        } else if (decl instanceof EnumDecl) {
            this.transEnum((EnumDecl)decl);
        } else if (!(decl instanceof Event)) {
            if (decl instanceof InternalFunction) {
                this.transFunction((InternalFunction)decl);
            } else {
                if (decl instanceof ExternalFunction) {
                    throw new RuntimeException("precond violation: " + String.valueOf(decl));
                }
                if (decl instanceof InputVariable) {
                    this.transInputVar((InputVariable)decl);
                } else if (!(decl instanceof TypeDecl)) {
                    throw new RuntimeException("Unknown decl: " + String.valueOf(decl));
                }
            }
        }
    }

    private void transAlgVar(AlgVariable var) {
        String name = this.getPlcName((PositionObject)var);
        PlcPou func = new PlcPou(name, PlcPouType.FUNCTION, this.transType(var.getType()));
        this.project.pous.add(func);
        func.inputVars.add(new PlcVariable("state", PlcDerivedType.STATE_TYPE));
        String valueTxt = this.transExpr(var.getValue(), "state", false);
        func.body.add("%s := %s;", new Object[]{name, valueTxt});
    }

    private void transConstants(List<Constant> constants) {
        constants = new ConstantOrderer().computeOrder(constants);
        for (Constant constant : constants) {
            this.transConstant(constant);
        }
    }

    private void transConstant(Constant constant) {
        String name = this.getPlcName((PositionObject)constant);
        PlcType type = this.transType(constant.getType());
        String valueTxt = this.transExpr(constant.getValue(), null, true);
        PlcValue value = new PlcValue(valueTxt);
        PlcVariable plcVar = new PlcVariable(name, type, null, value);
        this.globalConsts.variables.add(plcVar);
    }

    private void transContVar(ContVariable var) {
        String vname = this.getPlcName((PositionObject)var);
        PlcElementaryType plcType = this.largeRealType;
        PlcVariable plcVar = new PlcVariable(vname, plcType, "%Q*", null);
        this.stateStruct.fields.add(plcVar);
        String dname = "deriv" + vname;
        PlcPou func = new PlcPou(dname, PlcPouType.FUNCTION, plcType);
        this.project.pous.add(func);
        func.inputVars.add(new PlcVariable("state", PlcDerivedType.STATE_TYPE));
        func.body.add("%s := %s;", new Object[]{dname, this.transExpr(var.getDerivative(), "state", false)});
    }

    private void transDiscVar(DiscVariable var) {
        String name = this.getPlcName((PositionObject)var);
        PlcVariable plcVar = new PlcVariable(name, this.transType(var.getType()), "%Q*", null);
        this.stateStruct.fields.add(plcVar);
    }

    private void transInputVar(InputVariable var) {
        String name = this.getPlcName((PositionObject)var);
        PlcVariable plcVar = new PlcVariable(name, this.transType(var.getType()), "%I*", null);
        this.globalInputs.variables.add(plcVar);
    }

    private void transEnum(EnumDecl enumDecl) {
        List litNames = Lists.listc((int)enumDecl.getLiterals().size());
        for (EnumLiteral lit : enumDecl.getLiterals()) {
            litNames.add(this.getPlcName((PositionObject)lit));
        }
        PlcEnumType plcEnumType = new PlcEnumType(litNames);
        String name = this.getPlcName((PositionObject)enumDecl);
        this.project.typeDecls.add(new PlcTypeDecl(name, plcEnumType));
    }

    private PlcPou transFunction(InternalFunction func) {
        String pname;
        PlcPou pou = this.internalFuncs.get(func);
        if (pou != null) {
            return pou;
        }
        String name = this.getPlcName((PositionObject)func);
        CifType rtype = CifTypeUtils.makeTupleType((List)func.getReturnTypes(), null);
        pou = new PlcPou(name, PlcPouType.FUNCTION, this.transType(rtype));
        this.project.pous.add(pou);
        Set assignedParams = CifIntFuncUtils.getAssignedParameters((InternalFunction)func);
        for (FunctionParameter param : func.getParameters()) {
            boolean assigned = assignedParams.contains(param.getParameter());
            pname = this.getPlcName((PositionObject)param.getParameter());
            PlcType ptype = this.transType(param.getParameter().getType());
            PlcVariable pvar = new PlcVariable(pname, ptype);
            if (assigned) {
                pou.localVars.add(pvar);
            } else {
                pou.inputVars.add(pvar);
            }
            if (!assigned) continue;
            Object pname2 = pname;
            Assert.check((boolean)((String)pname2).startsWith("farg_"));
            pname2 = "farg2_" + pname.substring("farg_".length());
            PlcType ptype2 = this.transType(param.getParameter().getType());
            PlcVariable pvar2 = new PlcVariable((String)pname2, ptype2);
            pou.inputVars.add(pvar2);
            pou.body.add("%s := %s;", new Object[]{pname, pname2});
        }
        this.internalFuncs.put(func, pou);
        if (!func.getVariables().isEmpty()) {
            for (DiscVariable var : func.getVariables()) {
                String vname = this.getPlcName((PositionObject)var);
                PlcType vtype = this.transType(var.getType());
                pou.localVars.add(new PlcVariable(vname, vtype));
            }
            pou.body.add("// Initialize local variables.");
            List vars = new FuncLocalVarOrderer().computeOrder((Collection)func.getVariables());
            for (DiscVariable var : vars) {
                pname = this.getPlcName((PositionObject)var);
                pou.body.add("%s := %s;", new Object[]{pname, this.transExpr((Expression)Lists.first((List)var.getValue().getValues()), null, false)});
            }
            pou.body.add();
            pou.body.add("// Actual function body.");
        }
        this.transStatements(func, (List<FunctionStatement>)func.getStatements(), pou);
        return pou;
    }

    private void transStatements(InternalFunction func, List<FunctionStatement> stats, PlcPou pou) {
        for (FunctionStatement stat : stats) {
            this.transStatement(func, stat, pou);
        }
    }

    private void transStatement(InternalFunction func, FunctionStatement stat, PlcPou pou) {
        if (stat instanceof AssignmentFuncStatement) {
            Set addrVars;
            AssignmentFuncStatement asgn = (AssignmentFuncStatement)stat;
            Expression addr = asgn.getAddressable();
            try {
                addrVars = CifAddressableUtils.getRefs((Expression)addr);
            }
            catch (CifAddressableUtils.DuplVarAsgnException ex) {
                throw new RuntimeException("precond violation");
            }
            Map addrVarsMap = null;
            if (addrVars.size() > 1) {
                addrVarsMap = Maps.map();
                for (Declaration addrVar : addrVars) {
                    Assert.check((boolean)(addrVar instanceof DiscVariable));
                    DiscVariable var = (DiscVariable)addrVar;
                    String varName = this.getPlcName((PositionObject)addrVar);
                    PlcType varType = this.transType(var.getType());
                    String tmpName = pou.addTempVar(varType, varName);
                    addrVarsMap.put(var, tmpName);
                }
            }
            this.transAssignment(addr, asgn.getValue(), null, null, pou, "%s", addrVarsMap);
            if (addrVars.size() > 1) {
                for (Declaration addrVar : addrVars) {
                    Assert.check((boolean)(addrVar instanceof DiscVariable));
                    String varName = this.getPlcName((PositionObject)addrVar);
                    String tmpName = (String)addrVarsMap.get(addrVar);
                    pou.body.add("%s := %s;", new Object[]{varName, tmpName});
                }
            }
        } else if (stat instanceof BreakFuncStatement) {
            pou.body.add("EXIT;");
        } else {
            if (stat instanceof ContinueFuncStatement) {
                throw new RuntimeException("precond violation: " + String.valueOf(stat));
            }
            if (stat instanceof IfFuncStatement) {
                IfFuncStatement ifStat = (IfFuncStatement)stat;
                CodeBox c = pou.body;
                c.add("IF %s THEN", new Object[]{this.transPreds((List<Expression>)ifStat.getGuards(), null, false)});
                c.indent();
                this.transStatements(func, (List<FunctionStatement>)ifStat.getThens(), pou);
                c.dedent();
                for (ElifFuncStatement elifStat : ifStat.getElifs()) {
                    c.add("ELSIF %s THEN", new Object[]{this.transPreds((List<Expression>)elifStat.getGuards(), null, false)});
                    c.indent();
                    this.transStatements(func, (List<FunctionStatement>)elifStat.getThens(), pou);
                    c.dedent();
                }
                if (!ifStat.getElses().isEmpty()) {
                    c.add("ELSE");
                    c.indent();
                    this.transStatements(func, (List<FunctionStatement>)ifStat.getElses(), pou);
                    c.dedent();
                }
                c.add("END_IF;");
            } else if (stat instanceof ReturnFuncStatement) {
                ReturnFuncStatement rstat = (ReturnFuncStatement)stat;
                String name = this.getPlcName((PositionObject)func);
                EList values = rstat.getValues();
                Expression value = CifValueUtils.makeTuple((List)values, null);
                CodeBox c = pou.body;
                c.add("%s := %s;", new Object[]{name, this.transExpr(value, null, false)});
                c.add("RETURN;");
            } else if (stat instanceof WhileFuncStatement) {
                WhileFuncStatement wstat = (WhileFuncStatement)stat;
                CodeBox c = pou.body;
                c.add("WHILE %s DO", new Object[]{this.transPreds((List<Expression>)wstat.getGuards(), null, false)});
                c.indent();
                this.transStatements(func, (List<FunctionStatement>)wstat.getStatements(), pou);
                c.dedent();
                c.add("END_WHILE;");
            } else {
                throw new RuntimeException("Unknown func stat: " + String.valueOf(stat));
            }
        }
    }

    private PlcType transType(CifType type) {
        if (type instanceof BoolType) {
            return PlcElementaryType.BOOL_TYPE;
        }
        if (type instanceof IntType) {
            return PlcElementaryType.DINT_TYPE;
        }
        if (type instanceof RealType) {
            return this.largeRealType;
        }
        if (type instanceof TypeRef) {
            return this.transType(((TypeRef)type).getType().getType());
        }
        if (type instanceof TupleType) {
            String name = this.transTupleType((TupleType)type);
            return new PlcDerivedType(name);
        }
        if (type instanceof EnumType) {
            String name = this.getPlcName((PositionObject)((EnumType)type).getEnum());
            return new PlcDerivedType(name);
        }
        if (type instanceof StringType) {
            throw new RuntimeException("precond violation: " + String.valueOf(type));
        }
        if (type instanceof ListType) {
            int upper;
            ListType arrayType = (ListType)type;
            int lower = arrayType.getLower();
            Assert.check((lower == (upper = arrayType.getUpper().intValue()) ? 1 : 0) != 0);
            int size = lower;
            PlcType elemType = this.transType(arrayType.getElementType());
            return new PlcArrayType(0, size == 0 ? 0 : size - 1, elemType);
        }
        if (type instanceof SetType) {
            throw new RuntimeException("precond violation: " + String.valueOf(type));
        }
        if (type instanceof DictType) {
            throw new RuntimeException("precond violation: " + String.valueOf(type));
        }
        if (type instanceof DistType) {
            throw new RuntimeException("precond violation: " + String.valueOf(type));
        }
        if (type instanceof FuncType) {
            throw new RuntimeException("precond violation: " + String.valueOf(type));
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    private String transTupleType(TupleType tupleType) {
        TypeEqHashWrap typeWrap = new TypeEqHashWrap((CifType)tupleType, true, false);
        Object sname = this.structNames.get(typeWrap);
        if (sname == null) {
            String fieldName;
            int nr = this.nextStructNr++;
            sname = "TupleStruct_" + nr;
            this.structNames.put(typeWrap, (String)sname);
            PlcStructType structType = new PlcStructType();
            EList fields = tupleType.getFields();
            for (Field field : fields) {
                String fieldName2 = this.getPlcName((PositionObject)field);
                PlcType ftype = this.transType(field.getType());
                structType.fields.add(new PlcVariable(fieldName2, ftype));
            }
            PlcTypeDecl typeDecl = new PlcTypeDecl((String)sname, structType);
            this.project.typeDecls.add(typeDecl);
            Object fname = "make" + (String)sname;
            PlcPou func = new PlcPou((String)fname, PlcPouType.FUNCTION, new PlcDerivedType((String)sname));
            this.project.pous.add(func);
            for (Field field : fields) {
                fieldName = this.getPlcName((PositionObject)field);
                PlcType ftype = this.transType(field.getType());
                func.inputVars.add(new PlcVariable(fieldName, ftype));
            }
            func.localVars.add(new PlcVariable("rslt", new PlcDerivedType((String)sname)));
            for (Field field : fields) {
                fieldName = this.getPlcName((PositionObject)field);
                func.body.add("rslt.%s := %s;", new Object[]{fieldName, fieldName});
            }
            func.body.add("%s := rslt;", new Object[]{fname});
            int i = 0;
            while (i < fields.size()) {
                fname = Strings.fmt((String)"proj%d_%s", (Object[])new Object[]{i, sname});
                Field field = (Field)fields.get(i);
                func = new PlcPou((String)fname, PlcPouType.FUNCTION, this.transType(field.getType()));
                this.project.pous.add(func);
                func.inputVars.add(new PlcVariable("tuple", new PlcDerivedType((String)sname)));
                func.body.add("%s := tuple.%s;", new Object[]{fname, this.getPlcName((PositionObject)field)});
                ++i;
            }
        }
        return sname;
    }

    private int addArrayType(ListType arrayType) {
        TypeEqHashWrap typeWrap = new TypeEqHashWrap((CifType)arrayType, true, false);
        Integer arrayNr = this.arrayNrs.get(typeWrap);
        if (arrayNr == null) {
            arrayNr = this.arrayNrs.size();
            this.arrayNrs.put(typeWrap, arrayNr);
        }
        return arrayNr;
    }

    private String genArrayLitCreateFunc(ListType arrayType) {
        String elemName;
        int arrayNr = this.addArrayType(arrayType);
        String fname = "makeArray" + Strings.str((Object)arrayNr);
        if (this.arrayLitCreateFuncGenerated.contains(arrayNr)) {
            return fname;
        }
        this.arrayLitCreateFuncGenerated.add(arrayNr);
        PlcArrayType type = (PlcArrayType)this.transType((CifType)arrayType);
        PlcPou func = new PlcPou(fname, PlcPouType.FUNCTION, type);
        this.project.pous.add(func);
        int i = type.lower;
        while (i <= type.upper) {
            elemName = "elem" + Strings.str((Object)i);
            func.inputVars.add(new PlcVariable(elemName, type.elemType));
            ++i;
        }
        func.localVars.add(new PlcVariable("rslt", type));
        i = type.lower;
        while (i <= type.upper) {
            elemName = "elem" + Strings.str((Object)i);
            func.body.add("rslt[%d] := %s;", new Object[]{i, elemName});
            ++i;
        }
        func.body.add("%s := rslt;", new Object[]{fname});
        return fname;
    }

    private String genArrayProjFunc(ListType arrayType) {
        int arrayNr = this.addArrayType(arrayType);
        String fname = "projArray" + Strings.str((Object)arrayNr);
        if (this.arrayProjFuncGenerated.contains(arrayNr)) {
            return fname;
        }
        this.arrayProjFuncGenerated.add(arrayNr);
        PlcArrayType type = (PlcArrayType)this.transType((CifType)arrayType);
        PlcPou func = new PlcPou(fname, PlcPouType.FUNCTION, type.elemType);
        this.project.pous.add(func);
        func.inputVars.add(new PlcVariable("arr", type));
        func.inputVars.add(new PlcVariable("idx", PlcElementaryType.DINT_TYPE));
        String normProjIdxName = this.genNormProjIdxFunc();
        int size = arrayType.getLower();
        String normTxt = this.genFuncCall(normProjIdxName, false, Lists.list((Object[])new String[]{"idx", "size"}), Lists.list((Object[])new String[]{"idx", Strings.str((Object)size)}));
        func.body.add("%s := arr[%s];", new Object[]{fname, normTxt});
        return fname;
    }

    private String genNormProjIdxFunc() {
        String fname = "normProjIdx";
        if (this.normProjIdxGenerated) {
            return fname;
        }
        this.normProjIdxGenerated = true;
        PlcPou func = new PlcPou(fname, PlcPouType.FUNCTION, PlcElementaryType.DINT_TYPE);
        this.project.pous.add(func);
        func.inputVars.add(new PlcVariable("idx", PlcElementaryType.DINT_TYPE));
        func.inputVars.add(new PlcVariable("size", PlcElementaryType.DINT_TYPE));
        func.localVars.add(new PlcVariable("tmp", PlcElementaryType.DINT_TYPE));
        func.body.add("tmp := idx;");
        func.body.add("IF tmp < 0 THEN");
        func.body.indent();
        func.body.add("tmp := size + tmp;");
        func.body.dedent();
        func.body.add("END_IF;");
        func.body.add("%s := tmp;", new Object[]{fname});
        return fname;
    }

    private String transPreds(List<Expression> preds, String state, boolean init) {
        if (preds.isEmpty()) {
            return "TRUE";
        }
        List txts = Lists.listc((int)preds.size());
        for (Expression pred : preds) {
            txts.add(Strings.fmt((String)"(%s)", (Object[])new Object[]{this.transExpr(pred, state, init)}));
        }
        return String.join((CharSequence)" AND ", txts);
    }

    private String transExpr(Expression expr, String state, boolean init) {
        if (expr instanceof BoolExpression) {
            return ((BoolExpression)expr).isValue() ? "TRUE" : "FALSE";
        }
        if (expr instanceof IntExpression) {
            return Strings.str((Object)((IntExpression)expr).getValue());
        }
        if (expr instanceof RealExpression) {
            Object rslt = ((RealExpression)expr).getValue();
            int idx = ((String)rslt).indexOf(46);
            if (idx == -1) {
                idx = ((String)rslt).indexOf(101);
                if (idx == -1) {
                    idx = ((String)rslt).indexOf(69);
                }
                rslt = ((String)rslt).substring(0, idx) + ".0" + ((String)rslt).substring(idx);
            }
            return rslt;
        }
        if (expr instanceof StringExpression) {
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof TimeExpression) {
            Assert.notNull((Object)state);
            return state + ".curTime";
        }
        if (expr instanceof CastExpression) {
            CastExpression cexpr = (CastExpression)expr;
            CifType ctype = CifTypeUtils.normalizeType((CifType)cexpr.getChild().getType());
            CifType rtype = CifTypeUtils.normalizeType((CifType)cexpr.getType());
            if (ctype instanceof IntType && rtype instanceof RealType) {
                String childTxt = this.transExpr(cexpr.getChild(), state, init);
                return this.genFuncCall(Strings.fmt((String)"DINT_TO_%s", (Object[])new Object[]{this.largeRealType.name}), true, "IN", childTxt);
            }
            if (CifTypeUtils.checkTypeCompat((CifType)ctype, (CifType)rtype, (RangeCompat)RangeCompat.EQUAL)) {
                return this.transExpr(cexpr.getChild(), state, init);
            }
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            Expression child = uexpr.getChild();
            String childTxt = this.transExpr(child, state, init);
            UnaryOperator op = uexpr.getOperator();
            switch (op) {
                case INVERSE: {
                    return this.genFuncCall("NOT", true, null, childTxt);
                }
                case NEGATE: {
                    if (child instanceof IntExpression || child instanceof RealExpression) {
                        return Strings.fmt((String)"-%s", (Object[])new Object[]{childTxt});
                    }
                    return Strings.fmt((String)"-(%s)", (Object[])new Object[]{childTxt});
                }
                case PLUS: {
                    return childTxt;
                }
                case SAMPLE: {
                    throw new RuntimeException("precond violation");
                }
            }
            throw new RuntimeException("Unknown unop: " + String.valueOf(op));
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            String left = this.transExpr(bexpr.getLeft(), state, init);
            String right = this.transExpr(bexpr.getRight(), state, init);
            CifType ltype = CifTypeUtils.normalizeType((CifType)bexpr.getLeft().getType());
            CifType rtype = CifTypeUtils.normalizeType((CifType)bexpr.getRight().getType());
            BinaryOperator op = bexpr.getOperator();
            switch (op) {
                case IMPLICATION: {
                    return Strings.fmt((String)"%s OR (%s)", (Object[])new Object[]{this.genFuncCall("NOT", true, null, left), right});
                }
                case BI_CONDITIONAL: {
                    return Strings.fmt((String)"(%s) = (%s)", (Object[])new Object[]{left, right});
                }
                case DISJUNCTION: {
                    if (ltype instanceof BoolType) {
                        return Strings.fmt((String)"(%s) OR (%s)", (Object[])new Object[]{left, right});
                    }
                    throw new RuntimeException("precond violation");
                }
                case CONJUNCTION: {
                    if (ltype instanceof BoolType) {
                        return Strings.fmt((String)"(%s) AND (%s)", (Object[])new Object[]{left, right});
                    }
                    throw new RuntimeException("precond violation");
                }
                case LESS_THAN: {
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    return Strings.fmt((String)"(%s) < (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                }
                case LESS_EQUAL: {
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    return Strings.fmt((String)"(%s) <= (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                }
                case GREATER_THAN: {
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    return Strings.fmt((String)"(%s) > (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                }
                case GREATER_EQUAL: {
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    return Strings.fmt((String)"(%s) >= (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                }
                case EQUAL: {
                    if (ltype instanceof BoolType || ltype instanceof IntType || ltype instanceof RealType || ltype instanceof EnumType) {
                        return Strings.fmt((String)"(%s) = (%s)", (Object[])new Object[]{left, right});
                    }
                    throw new RuntimeException("precond violation");
                }
                case UNEQUAL: {
                    if (ltype instanceof BoolType || ltype instanceof IntType || ltype instanceof RealType || ltype instanceof EnumType) {
                        return Strings.fmt((String)"(%s) <> (%s)", (Object[])new Object[]{left, right});
                    }
                    throw new RuntimeException("precond violation");
                }
                case ADDITION: {
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    if (ltype instanceof IntType || ltype instanceof RealType) {
                        return Strings.fmt((String)"(%s) + (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                    }
                    throw new RuntimeException("precond violation");
                }
                case SUBTRACTION: {
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    if (ltype instanceof IntType || ltype instanceof RealType) {
                        return Strings.fmt((String)"(%s) - (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                    }
                    throw new RuntimeException("precond violation");
                }
                case MULTIPLICATION: {
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    return Strings.fmt((String)"(%s) * (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                }
                case DIVISION: {
                    if (ltype instanceof IntType && rtype instanceof IntType) {
                        Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, (CifType)CifConstructors.newRealType(), rtype);
                        String toName = Strings.fmt((String)"DINT_TO_%s", (Object[])new Object[]{this.largeRealType.name});
                        return Strings.fmt((String)"%s / (%s)", (Object[])new Object[]{this.genFuncCall(toName, true, "IN", (String)leftRight.left), leftRight.right});
                    }
                    Pair<String, String> leftRight = this.convertBinaryLeftRight(left, right, ltype, rtype);
                    return Strings.fmt((String)"(%s) / (%s)", (Object[])new Object[]{leftRight.left, leftRight.right});
                }
                case INTEGER_DIVISION: {
                    return Strings.fmt((String)"(%s) / (%s)", (Object[])new Object[]{left, right});
                }
                case MODULUS: {
                    return Strings.fmt((String)"(%s) MOD (%s)", (Object[])new Object[]{left, right});
                }
                case ELEMENT_OF: {
                    throw new RuntimeException("precond violation");
                }
                case SUBSET: {
                    throw new RuntimeException("precond violation");
                }
            }
            throw new RuntimeException("Unknown binop: " + String.valueOf(op));
        }
        if (expr instanceof IfExpression) {
            String fstate;
            int nr = this.nextIfFuncNr++;
            String name = "ifExprFunc" + nr;
            PlcType rtype = this.transType(expr.getType());
            PlcPou func = new PlcPou(name, PlcPouType.FUNCTION, rtype);
            this.project.pous.add(func);
            boolean funcDummyParam = false;
            if (state == null) {
                fstate = null;
                List refs = Lists.list();
                Set inputs = Sets.set();
                CifScopeUtils.collectRefExprs((Expression)expr, (List)refs);
                for (Expression ref : refs) {
                    DiscVariable var;
                    EObject parent;
                    if (!(ref instanceof DiscVariableExpression) || (parent = (var = ((DiscVariableExpression)ref).getVariable()).eContainer()) instanceof ComplexComponent) continue;
                    inputs.add(var);
                }
                for (Object input : inputs) {
                    PlcType type = this.transType(input.getType());
                    func.inputVars.add(new PlcVariable(this.getPlcName((PositionObject)input), type));
                }
                if (inputs.isEmpty()) {
                    funcDummyParam = true;
                    func.inputVars.add(new PlcVariable("dummy", PlcElementaryType.INT_TYPE));
                }
            } else {
                fstate = "state";
                func.inputVars.add(new PlcVariable("state", PlcDerivedType.STATE_TYPE));
            }
            IfExpression ifExpr = (IfExpression)expr;
            func.body.add("IF %s THEN", new Object[]{this.transPreds((List<Expression>)ifExpr.getGuards(), fstate, init)});
            func.body.indent();
            func.body.add("%s := %s;", new Object[]{name, this.transExpr(ifExpr.getThen(), fstate, init)});
            func.body.dedent();
            for (ElifExpression elifExpr : ifExpr.getElifs()) {
                func.body.add("ELSIF %s THEN", new Object[]{this.transPreds((List<Expression>)elifExpr.getGuards(), fstate, init)});
                func.body.indent();
                func.body.add("%s := %s;", new Object[]{name, this.transExpr(elifExpr.getThen(), fstate, init)});
                func.body.dedent();
            }
            func.body.add("ELSE");
            func.body.indent();
            func.body.add("%s := %s;", new Object[]{name, this.transExpr(ifExpr.getElse(), fstate, init)});
            func.body.dedent();
            func.body.add("END_IF;");
            if (state == null && funcDummyParam) {
                return this.genFuncCall(name, false, "dummy", "0");
            }
            if (state == null) {
                List paramNames = Lists.listc((int)func.inputVars.size());
                List paramValues = Lists.listc((int)func.inputVars.size());
                for (PlcVariable var : func.inputVars) {
                    paramNames.add(var.name);
                    paramValues.add(var.name);
                }
                return this.genFuncCall(name, false, paramNames, paramValues);
            }
            return this.genFuncCall(name, false, "state", state);
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            CifType ctype = CifTypeUtils.normalizeType((CifType)pexpr.getChild().getType());
            Expression child = pexpr.getChild();
            if (ctype instanceof TupleType) {
                Field field = CifValueUtils.getTupleProjField((ProjectionExpression)pexpr);
                TupleType ttype = (TupleType)field.eContainer();
                int idx = ttype.getFields().indexOf((Object)field);
                String fname = Strings.fmt((String)"proj%d_%s", (Object[])new Object[]{idx, this.transTupleType(ttype)});
                String childTxt = this.transExpr(child, state, init);
                return this.genFuncCall(fname, false, "tuple", childTxt);
            }
            if (ctype instanceof ListType) {
                ListType ltype = (ListType)ctype;
                String childTxt = this.transExpr(child, state, init);
                String idxTxt = this.transExpr(pexpr.getIndex(), state, init);
                if (child instanceof DiscVariableExpression || child instanceof ConstantExpression) {
                    int size = ltype.getLower();
                    String normProjIdxName = this.genNormProjIdxFunc();
                    String normTxt = this.genFuncCall(normProjIdxName, false, Lists.list((Object[])new String[]{"idx", "size"}), Lists.list((Object[])new String[]{idxTxt, Strings.str((Object)size)}));
                    return Strings.fmt((String)"%s[%s]", (Object[])new Object[]{childTxt, normTxt});
                }
                String fname = this.genArrayProjFunc(ltype);
                List argTxts = Lists.list((Object[])new String[]{"arr", "idx"});
                List valueTxts = Lists.list((Object[])new String[]{childTxt, idxTxt});
                return this.genFuncCall(fname, false, argTxts, valueTxts);
            }
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof SliceExpression) {
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            List argTxts = Lists.listc((int)fcexpr.getArguments().size());
            EList args = fcexpr.getArguments();
            for (Expression arg : args) {
                argTxts.add(this.transExpr(arg, state, init));
            }
            String argsTxt = String.join((CharSequence)", ", argTxts);
            Expression fexpr = fcexpr.getFunction();
            if (fexpr instanceof FunctionExpression) {
                Function func = ((FunctionExpression)fexpr).getFunction();
                Assert.check((boolean)(func instanceof InternalFunction));
                PlcPou funcPou = this.transFunction((InternalFunction)func);
                List paramNames = Lists.listc((int)funcPou.inputVars.size());
                for (PlcVariable param : funcPou.inputVars) {
                    paramNames.add(param.name);
                }
                return this.genFuncCall(funcPou.name, false, paramNames, argTxts);
            }
            if (fexpr instanceof StdLibFunctionExpression) {
                StdLibFunction stdlib = ((StdLibFunctionExpression)fexpr).getFunction();
                switch (stdlib) {
                    case ABS: {
                        return this.genFuncCall("ABS", true, null, argsTxt);
                    }
                    case CBRT: {
                        if (PlcOutputTypeOption.isS7Output()) {
                            return Strings.fmt((String)"(%s) ** (1.0/3.0)", (Object[])new Object[]{argsTxt});
                        }
                        return this.genFuncCall("EXPT", true, Lists.list((Object[])new String[]{"IN1", "IN2"}), Lists.list((Object[])new String[]{argsTxt, "1.0/3"}));
                    }
                    case CEIL: {
                        throw new RuntimeException("precond violation");
                    }
                    case DELETE: {
                        throw new RuntimeException("precond violation");
                    }
                    case EMPTY: {
                        throw new RuntimeException("precond violation");
                    }
                    case EXP: {
                        return this.genFuncCall("EXP", true, null, argsTxt);
                    }
                    case FLOOR: {
                        throw new RuntimeException("precond violation");
                    }
                    case FORMAT: {
                        throw new RuntimeException("precond violation");
                    }
                    case LN: {
                        return this.genFuncCall("LN", true, null, argsTxt);
                    }
                    case LOG: {
                        if (PlcOutputTypeOption.isS7Output()) {
                            return Strings.fmt((String)"%s / %s", (Object[])new Object[]{this.genFuncCall("LN", true, null, argsTxt), this.genFuncCall("LN", true, null, "10")});
                        }
                        return this.genFuncCall("LOG", true, null, argsTxt);
                    }
                    case MINIMUM: 
                    case MAXIMUM: {
                        CifType type0 = CifTypeUtils.normalizeType((CifType)((Expression)args.get(0)).getType());
                        CifType type1 = CifTypeUtils.normalizeType((CifType)((Expression)args.get(1)).getType());
                        if (!(type0 instanceof IntType && type1 instanceof IntType || type0 instanceof RealType && type1 instanceof RealType)) {
                            if (type0 instanceof IntType && type1 instanceof RealType) {
                                String toName = Strings.fmt((String)"DINT_TO_%s", (Object[])new Object[]{this.largeRealType.name});
                                argTxts.set(0, this.genFuncCall(toName, true, "IN", (String)argTxts.get(0)));
                            } else {
                                Assert.check((type0 instanceof RealType && type1 instanceof IntType ? 1 : 0) != 0);
                                String toName = Strings.fmt((String)"DINT_TO_%s", (Object[])new Object[]{this.largeRealType.name});
                                argTxts.set(1, this.genFuncCall(toName, true, "IN", (String)argTxts.get(1)));
                            }
                        }
                        return this.genFuncCall(stdlib == StdLibFunction.MAXIMUM ? "MAX" : "MIN", true, Lists.list((Object[])new String[]{"IN1", "IN2"}), argTxts);
                    }
                    case POP: {
                        throw new RuntimeException("precond violation");
                    }
                    case POWER: {
                        CifType type0 = CifTypeUtils.normalizeType((CifType)((Expression)args.get(0)).getType());
                        CifType type1 = CifTypeUtils.normalizeType((CifType)((Expression)args.get(1)).getType());
                        if (PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_400 || PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_300) {
                            String toName;
                            String argTxt0 = (String)argTxts.get(0);
                            String argTxt1 = (String)argTxts.get(1);
                            if (type0 instanceof IntType) {
                                toName = Strings.fmt((String)"%s_TO_%s", (Object[])new Object[]{this.largeIntType.name, this.largeRealType.name});
                                argTxt0 = this.genFuncCall(toName, true, "IN", argTxt0);
                            }
                            if (type1 instanceof IntType) {
                                toName = Strings.fmt((String)"%s_TO_%s", (Object[])new Object[]{this.largeIntType.name, this.largeRealType.name});
                                argTxt1 = this.genFuncCall(toName, true, "IN", argTxt1);
                            }
                            String resultTxt = Strings.fmt((String)"(%s) ** (%s)", (Object[])new Object[]{argTxt0, argTxt1});
                            FuncType functionType = (FuncType)CifTypeUtils.normalizeType((CifType)fexpr.getType());
                            CifType resultType = CifTypeUtils.normalizeType((CifType)functionType.getReturnType());
                            if (resultType instanceof IntType) {
                                String toName2 = Strings.fmt((String)"%s_TO_%s", (Object[])new Object[]{this.largeRealType.name, this.largeIntType.name});
                                resultTxt = this.genFuncCall(toName2, true, "IN", resultTxt);
                            }
                            return resultTxt;
                        }
                        if (PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1500 || PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1200) {
                            return Strings.fmt((String)"(%s) ** (%s)", (Object[])new Object[]{argTxts.get(0), argTxts.get(1)});
                        }
                        if (type0 instanceof IntType && type1 instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)type0)) && !CifTypeUtils.isRangeless((IntType)((IntType)type1))) {
                            String f0 = Strings.fmt((String)"DINT_TO_%s", (Object[])new Object[]{this.largeRealType.name});
                            String c1 = this.genFuncCall(f0, true, "IN", (String)argTxts.get(0));
                            String c2 = this.genFuncCall("EXPT", true, Lists.list((Object[])new String[]{"IN1", "IN2"}), Lists.list((Object[])new String[]{c1, (String)argTxts.get(1)}));
                            String f1 = Strings.fmt((String)"%s_TO_DINT", (Object[])new Object[]{this.largeRealType.name});
                            return this.genFuncCall(f1, true, "IN", c2);
                        }
                        if (type0 instanceof IntType && type1 instanceof RealType) {
                            String cf = Strings.fmt((String)"DINT_TO_%s", (Object[])new Object[]{this.largeRealType.name});
                            String f0 = this.genFuncCall(cf, true, "IN", (String)argTxts.get(0));
                            return this.genFuncCall("EXPT", true, Lists.list((Object[])new String[]{"IN1", "IN2"}), Lists.list((Object[])new String[]{f0, (String)argTxts.get(1)}));
                        }
                        return this.genFuncCall("EXPT", true, Lists.list((Object[])new String[]{"IN1", "IN2"}), argTxts);
                    }
                    case ROUND: {
                        throw new RuntimeException("precond violation");
                    }
                    case SCALE: {
                        throw new RuntimeException("precond violation");
                    }
                    case SIGN: {
                        throw new RuntimeException("precond violation");
                    }
                    case SIZE: {
                        throw new RuntimeException("precond violation");
                    }
                    case SQRT: {
                        return this.genFuncCall("SQRT", true, null, argsTxt);
                    }
                    case ACOS: {
                        return this.genFuncCall("ACOS", true, null, argsTxt);
                    }
                    case ASIN: {
                        return this.genFuncCall("ASIN", true, null, argsTxt);
                    }
                    case ATAN: {
                        return this.genFuncCall("ATAN", true, null, argsTxt);
                    }
                    case COS: {
                        return this.genFuncCall("COS", true, null, argsTxt);
                    }
                    case SIN: {
                        return this.genFuncCall("SIN", true, null, argsTxt);
                    }
                    case TAN: {
                        return this.genFuncCall("TAN", true, null, argsTxt);
                    }
                    case ACOSH: 
                    case ASINH: 
                    case ATANH: 
                    case COSH: 
                    case SINH: 
                    case TANH: {
                        throw new RuntimeException("precond violation");
                    }
                    case BERNOULLI: 
                    case BETA: 
                    case BINOMIAL: 
                    case CONSTANT: 
                    case ERLANG: 
                    case EXPONENTIAL: 
                    case GAMMA: 
                    case GEOMETRIC: 
                    case LOG_NORMAL: 
                    case NORMAL: 
                    case POISSON: 
                    case RANDOM: 
                    case TRIANGLE: 
                    case UNIFORM: 
                    case WEIBULL: {
                        throw new RuntimeException("precond violation");
                    }
                }
            }
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            List elemTxts = Lists.listc((int)lexpr.getElements().size());
            int i = 0;
            while (i < lexpr.getElements().size()) {
                Expression elem = (Expression)lexpr.getElements().get(i);
                String valueTxt = this.transExpr(elem, state, init);
                elemTxts.add(valueTxt);
                ++i;
            }
            if (init) {
                return Strings.fmt((String)"[%s]", (Object[])new Object[]{String.join((CharSequence)", ", elemTxts)});
            }
            ListType ltype = (ListType)CifTypeUtils.normalizeType((CifType)lexpr.getType());
            List argTxts = Lists.listc((int)lexpr.getElements().size());
            int i2 = 0;
            while (i2 < lexpr.getElements().size()) {
                argTxts.add(Strings.fmt((String)"elem%d", (Object[])new Object[]{i2}));
                ++i2;
            }
            String name = this.genArrayLitCreateFunc(ltype);
            return this.genFuncCall(name, false, argTxts, elemTxts);
        }
        if (expr instanceof SetExpression) {
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            List elemTxts = Lists.listc((int)texpr.getFields().size());
            int i = 0;
            while (i < texpr.getFields().size()) {
                Expression value = (Expression)texpr.getFields().get(i);
                String valueTxt = this.transExpr(value, state, init);
                elemTxts.add(valueTxt);
                ++i;
            }
            if (init) {
                TupleType ttype = (TupleType)CifTypeUtils.normalizeType((CifType)texpr.getType());
                List fieldTxts = Lists.listc((int)texpr.getFields().size());
                int i3 = 0;
                while (i3 < texpr.getFields().size()) {
                    Field field = (Field)ttype.getFields().get(i3);
                    String fieldTxt = this.getPlcName((PositionObject)field);
                    fieldTxts.add(Strings.fmt((String)"%s:=%s", (Object[])new Object[]{fieldTxt, elemTxts.get(i3)}));
                    ++i3;
                }
                return Strings.fmt((String)"(%s)", (Object[])new Object[]{String.join((CharSequence)", ", fieldTxts)});
            }
            TupleType ttype = (TupleType)CifTypeUtils.normalizeType((CifType)texpr.getType());
            List argTxts = Lists.listc((int)texpr.getFields().size());
            int i4 = 0;
            while (i4 < texpr.getFields().size()) {
                Field field = (Field)ttype.getFields().get(i4);
                String fieldTxt = this.getPlcName((PositionObject)field);
                argTxts.add(fieldTxt);
                ++i4;
            }
            String name = this.transTupleType(ttype);
            return this.genFuncCall("make" + name, false, argTxts, elemTxts);
        }
        if (expr instanceof DictExpression) {
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof ConstantExpression) {
            Assert.check((boolean)this.constantsAllowed);
            Constant constant = ((ConstantExpression)expr).getConstant();
            return this.getPlcName((PositionObject)constant);
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            EObject parent = var.eContainer();
            if (parent instanceof ComplexComponent) {
                Assert.notNull((Object)state);
                return state + "." + this.getPlcName((PositionObject)var);
            }
            return this.getPlcName((PositionObject)var);
        }
        if (expr instanceof AlgVariableExpression) {
            Assert.notNull((Object)state);
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            return this.genFuncCall(this.getPlcName((PositionObject)var), false, "state", state);
        }
        if (expr instanceof ContVariableExpression) {
            Assert.notNull((Object)state);
            ContVariableExpression cvexpr = (ContVariableExpression)expr;
            ContVariable var = cvexpr.getVariable();
            if (cvexpr.isDerivative()) {
                return this.genFuncCall("deriv" + this.getPlcName((PositionObject)var), false, "state", state);
            }
            return state + "." + this.getPlcName((PositionObject)var);
        }
        if (expr instanceof LocationExpression) {
            throw new RuntimeException("loc expr unexpected in lin spec");
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteral lit = ((EnumLiteralExpression)expr).getLiteral();
            return this.getPlcName((PositionObject)lit);
        }
        if (expr instanceof FunctionExpression) {
            throw new RuntimeException("precond violation");
        }
        if (expr instanceof InputVariableExpression) {
            InputVariable var = ((InputVariableExpression)expr).getVariable();
            return this.getPlcName((PositionObject)var);
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }

    private Pair<String, String> convertBinaryLeftRight(String left, String right, CifType ltype, CifType rtype) {
        if (PlcOutputTypeOption.getPlcOutputType() != PlcOutputType.S7_400 && PlcOutputTypeOption.getPlcOutputType() != PlcOutputType.S7_300) {
            return new Pair((Object)left, (Object)right);
        }
        if (ltype instanceof IntType && rtype instanceof IntType) {
            return new Pair((Object)left, (Object)right);
        }
        if (ltype instanceof RealType && rtype instanceof RealType) {
            return new Pair((Object)left, (Object)right);
        }
        if (ltype instanceof IntType) {
            String toName = Strings.fmt((String)"%s_TO_%s", (Object[])new Object[]{this.largeIntType.name, this.largeRealType.name});
            left = this.genFuncCall(toName, true, "IN", left);
            return new Pair((Object)left, (Object)right);
        }
        if (rtype instanceof IntType) {
            String toName = Strings.fmt((String)"%s_TO_%s", (Object[])new Object[]{this.largeIntType.name, this.largeRealType.name});
            right = this.genFuncCall(toName, true, "IN", right);
            return new Pair((Object)left, (Object)right);
        }
        throw new RuntimeException("precond violation: Binary expression left and right must be integer or real typed.");
    }

    private void transEdge(Edge edge, PlcPou pou) {
        Assert.check((edge.getEvents().size() == 1 ? 1 : 0) != 0);
        Expression eventRef = ((EdgeEvent)Lists.first((List)edge.getEvents())).getEvent();
        Event event = eventRef instanceof TauExpression ? null : ((EventExpression)eventRef).getEvent();
        String eventName = event == null ? "tau" : CifTextUtils.getAbsName((PositionObject)event);
        CodeBox c = pou.body;
        c.add();
        c.add("// Event \"%s\".", new Object[]{eventName});
        c.add("IF NOT progress THEN");
        c.indent();
        EList guards = edge.getGuards();
        Assert.check((guards.size() <= 1 ? 1 : 0) != 0);
        Expression guard = guards.isEmpty() ? null : (Expression)Lists.first((List)guards);
        boolean unrestricted = guards.isEmpty() ? true : CifValueUtils.isTriviallyTrue((Expression)guard, (boolean)false, (boolean)true);
        if (unrestricted) {
            String msg = Strings.fmt((String)"Event \"%s\" is unrestricted (always enabled), and would result in infinitely running PLC code.", (Object[])new Object[]{eventName});
            throw new InvalidInputException(msg);
        }
        guard = NaryExpressionConverter.convert(guard);
        c.add("IF %s THEN", new Object[]{this.transGuard(guard, 1, this.genStaticVarRef("state0"), pou)});
        c.indent();
        c.add("progress := TRUE;");
        c.add("state1 := %s;", new Object[]{this.genStaticVarRef("state0")});
        c.add();
        this.transUpdates((List<Update>)edge.getUpdates(), pou);
        c.add();
        c.add("%s := state1;", new Object[]{this.genStaticVarRef("state0")});
        c.dedent();
        c.add("END_IF;");
        c.dedent();
        c.add("END_IF;");
    }

    private String transGuard(Expression expr, int level, String state, PlcPou pou) {
        if (!(expr instanceof NaryExpressionConverter.NaryExpression)) {
            return this.transExpr(expr, state, false);
        }
        this.maxNaryLevel = Math.max(this.maxNaryLevel, level);
        NaryExpressionConverter.NaryExpression nexpr = (NaryExpressionConverter.NaryExpression)expr;
        int cnt = nexpr.children.size();
        int i = 0;
        while (i < cnt) {
            Expression child = nexpr.children.get(i);
            if (i > 0 && child instanceof NaryExpressionConverter.NaryExpression) {
                Object guard = "b" + Strings.str((Object)level);
                if (switch (nexpr.operator) {
                    case BinaryOperator.CONJUNCTION -> false;
                    case BinaryOperator.DISJUNCTION -> true;
                    default -> {
                        String msg = "Unexpected operator: " + String.valueOf(nexpr.operator);
                        throw new RuntimeException(msg);
                    }
                }) {
                    guard = this.genFuncCall("NOT", true, null, (String)guard);
                }
                pou.body.add("IF %s THEN", new Object[]{guard});
                pou.body.indent();
            }
            String crslt = this.transGuard(child, level + 1, state, pou);
            if (i == 0) {
                pou.body.add("b%d := %s;", new Object[]{level, crslt});
            } else {
                pou.body.add("b%d := b%d %s (%s);", new Object[]{level, level, switch (nexpr.operator) {
                    case BinaryOperator.CONJUNCTION -> "AND";
                    case BinaryOperator.DISJUNCTION -> "OR";
                    default -> {
                        String msg = "Unexpected operator: " + String.valueOf(nexpr.operator);
                        throw new RuntimeException(msg);
                    }
                }, crslt});
            }
            if (i > 0 && child instanceof NaryExpressionConverter.NaryExpression) {
                pou.body.dedent();
                pou.body.add("END_IF;");
            }
            ++i;
        }
        return "b" + level;
    }

    private void transUpdates(List<Update> updates, PlcPou pou) {
        for (Update update : updates) {
            this.transUpdate(update, pou);
        }
    }

    private void transUpdate(Update update, PlcPou pou) {
        if (update instanceof Assignment) {
            Assignment asgn = (Assignment)update;
            this.transAssignment(asgn.getAddressable(), asgn.getValue(), this.genStaticVarRef("state0"), "state1", pou, "%s", null);
        } else {
            Assert.check((boolean)(update instanceof IfUpdate));
            IfUpdate ifUpd = (IfUpdate)update;
            CodeBox c = pou.body;
            c.add("IF %s THEN", new Object[]{this.transPreds((List<Expression>)ifUpd.getGuards(), this.genStaticVarRef("state0"), false)});
            c.indent();
            this.transUpdates((List<Update>)ifUpd.getThens(), pou);
            c.dedent();
            for (ElifUpdate elifUpd : ifUpd.getElifs()) {
                c.add("ELSIF %s THEN", new Object[]{this.transPreds((List<Expression>)elifUpd.getGuards(), this.genStaticVarRef("state0"), false)});
                c.indent();
                this.transUpdates((List<Update>)elifUpd.getThens(), pou);
                c.dedent();
            }
            if (!ifUpd.getElses().isEmpty()) {
                c.add("ELSE");
                c.indent();
                this.transUpdates((List<Update>)ifUpd.getElses(), pou);
                c.dedent();
            }
            c.add("END_IF;");
        }
    }

    private void transAssignment(Expression addr, Expression value, String stateBefore, String stateAfter, PlcPou pou, String valueProjPat, Map<Declaration, String> varMap) {
        if (addr instanceof TupleExpression) {
            TupleExpression taddr = (TupleExpression)addr;
            TupleType ttype = (TupleType)CifTypeUtils.normalizeType((CifType)taddr.getType());
            int i = 0;
            while (i < ttype.getFields().size()) {
                Expression childAddr = (Expression)taddr.getFields().get(i);
                String projName = Strings.fmt((String)"proj%d_%s", (Object[])new Object[]{i, this.transTupleType(ttype)});
                String projTxt = this.genFuncCall(projName, false, "tuple", "%s");
                this.transAssignment(childAddr, value, stateBefore, stateAfter, pou, valueProjPat.replace("%s", projTxt), varMap);
                ++i;
            }
            return;
        }
        Object addrTxt = "";
        while (addr instanceof ProjectionExpression) {
            ProjectionExpression paddr = (ProjectionExpression)addr;
            CifType ctype = CifTypeUtils.normalizeType((CifType)paddr.getChild().getType());
            if (ctype instanceof TupleType) {
                Field field = CifValueUtils.getTupleProjField((ProjectionExpression)paddr);
                addrTxt = "." + this.getPlcName((PositionObject)field) + (String)addrTxt;
            } else if (ctype instanceof ListType) {
                ListType ltype = (ListType)ctype;
                int size = ltype.getLower();
                String normProjIdxName = this.genNormProjIdxFunc();
                String idxTxt = this.transExpr(paddr.getIndex(), stateBefore, false);
                String normTxt = this.genFuncCall(normProjIdxName, false, Lists.list((Object[])new String[]{"idx", "size"}), Lists.list((Object[])new String[]{idxTxt, Strings.str((Object)size)}));
                addrTxt = Strings.fmt((String)"[%s]%s", (Object[])new Object[]{normTxt, addrTxt});
            } else {
                throw new RuntimeException("Unexpected addr proj: " + String.valueOf(ctype));
            }
            addr = paddr.getChild();
        }
        String name = null;
        if (addr instanceof DiscVariableExpression) {
            v = ((DiscVariableExpression)addr).getVariable();
            if (varMap != null) {
                name = varMap.get(v);
            }
            if (name == null) {
                name = this.getPlcName((PositionObject)v);
            }
        } else if (addr instanceof ContVariableExpression) {
            v = ((ContVariableExpression)addr).getVariable();
            if (varMap != null) {
                name = varMap.get(v);
            }
            if (name == null) {
                name = this.getPlcName((PositionObject)v);
            }
        } else {
            throw new RuntimeException("Unknown addr: " + String.valueOf(addr));
        }
        addrTxt = name + (String)addrTxt;
        String valueTxt = Strings.fmt((String)valueProjPat, (Object[])new Object[]{this.transExpr(value, stateBefore, false)});
        pou.body.add("%s%s := %s;", new Object[]{stateAfter == null ? "" : stateAfter + ".", addrTxt, valueTxt});
    }

    private String getPlcName(PositionObject obj) {
        Object rslt = this.objNames.get(obj);
        if (rslt == null) {
            String prefix;
            if (obj instanceof Field) {
                Field field = (Field)obj;
                TupleType ttype = (TupleType)field.eContainer();
                int idx = ttype.getFields().indexOf((Object)field);
                return "field" + idx;
            }
            if (obj instanceof AlgVariable) {
                prefix = "alg";
            } else if (obj instanceof Constant) {
                Assert.check((boolean)this.constantsAllowed);
                prefix = "const";
            } else if (obj instanceof ContVariable) {
                prefix = "cvar";
            } else if (obj instanceof DiscVariable) {
                EObject parent = obj.eContainer();
                if (parent instanceof ComplexComponent) {
                    prefix = "dvar";
                } else if (parent instanceof InternalFunction) {
                    prefix = "fvar";
                } else {
                    Assert.check((boolean)(parent instanceof FunctionParameter));
                    prefix = "farg";
                }
            } else if (obj instanceof EnumDecl) {
                prefix = "enum";
            } else if (obj instanceof Function) {
                prefix = "func";
            } else if (obj instanceof InputVariable) {
                prefix = "ivar";
            } else if (obj instanceof EnumLiteral) {
                prefix = "elit";
            } else if (obj instanceof Field) {
                prefix = "tfld";
            } else {
                throw new RuntimeException("Unexpected named CIF obj: " + String.valueOf(obj));
            }
            Object candidate = CifTextUtils.getAbsName((PositionObject)obj, (boolean)false).replace('.', '_');
            while (((String)candidate).contains("__")) {
                candidate = ((String)candidate).replace("__", "_");
            }
            while (((String)candidate).endsWith("_")) {
                candidate = Strings.slice((String)candidate, (Integer)0, (Integer)-1);
            }
            if (((String)candidate).isEmpty()) {
                candidate = "x";
            }
            rslt = candidate = prefix + "_" + (String)candidate;
            int count = 1;
            while (this.names.contains(((String)rslt).toLowerCase(Locale.US))) {
                rslt = (String)candidate + Strings.str((Object)(++count));
            }
            if (!((String)rslt).equals(candidate) && RenameWarningsOption.isEnabled()) {
                OutputProvider.warn((String)"PLC name \"%s\" is renamed to \"%s\".", (Object[])new Object[]{candidate, rslt});
            }
            this.objNames.put(obj, (String)rslt);
            this.names.add(((String)rslt).toLowerCase(Locale.US));
        }
        return rslt;
    }

    private String genStaticVarRef(String varName) {
        return this.staticVarPrefix + varName;
    }

    private String genFuncCall(String funcName, boolean stdFunc, String argName, String valueTxt) {
        return this.genFuncCall(funcName, stdFunc, argName == null ? null : Lists.list((Object)argName), Lists.list((Object)valueTxt));
    }

    private String genFuncCall(String funcName, boolean stdFunc, List<String> argNames, List<String> valueTxts) {
        boolean useFormal;
        boolean formalAllowed = argNames != null;
        Assert.check((!formalAllowed || argNames.size() == valueTxts.size() ? 1 : 0) != 0);
        boolean useFormalArg = false;
        if (formalAllowed) {
            switch (this.formalInvokeArg) {
                case ALL: {
                    useFormalArg = true;
                    break;
                }
                case MULTI: {
                    useFormalArg = argNames.size() > 1;
                    break;
                }
                case NONE: {
                    useFormalArg = false;
                }
            }
        }
        boolean useFormalFunc = false;
        if (formalAllowed) {
            switch (this.formalInvokeFunc) {
                case ALL: {
                    useFormalFunc = true;
                    break;
                }
                case STD: {
                    useFormalFunc = stdFunc;
                    break;
                }
                case OTHERS: {
                    useFormalFunc = !stdFunc;
                }
            }
        }
        boolean bl = useFormal = formalAllowed && useFormalArg && useFormalFunc;
        if (!useFormal) {
            return Strings.fmt((String)"%s(%s)", (Object[])new Object[]{funcName, String.join((CharSequence)", ", valueTxts)});
        }
        Assert.check((boolean)useFormal);
        List argTxts = Lists.listc((int)argNames.size());
        int i = 0;
        while (i < argNames.size()) {
            argTxts.add(argNames.get(i) + ":=" + valueTxts.get(i));
            ++i;
        }
        return Strings.fmt((String)"%s(%s)", (Object[])new Object[]{funcName, String.join((CharSequence)", ", argTxts)});
    }
}

