/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2uppaal;

import java.util.List;
import org.eclipse.escet.cif.cif2uppaal.CifToUppaal;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.XmlSupport;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.w3c.dom.Document;

public class CifToUppaalApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifToUppaalApp app = new CifToUppaalApp();
        app.run(args, true);
    }

    public CifToUppaalApp() {
    }

    public CifToUppaalApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF to UPPAAL transformer";
    }

    public String getAppDescription() {
        return "Transforms CIF files to UPPAAL (*.xml) files.";
    }

    protected int runInternal() {
        Specification spec = (Specification)((CifReader)new CifReader().init()).read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".xml");
        outPath = Paths.resolve((String)outPath);
        Document doc = new CifToUppaal().transform(spec, absSpecPath);
        if (this.isTerminationRequested()) {
            return 0;
        }
        XmlSupport.writeFile((Document)doc, (String)"UPPAAL", (String)outPath);
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifToUppaalApp.getGeneralOptionCategory();
        List transOpts = Lists.list();
        transOpts.add(Options.getInstance(InputFileOption.class));
        transOpts.add(Options.getInstance(OutputFileOption.class));
        List transSubCats = Lists.list();
        OptionCategory transCat = new OptionCategory("Transformation", "Transformation options.", transSubCats, transOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, transCat});
        OptionCategory options = new OptionCategory("CIF to UPPAAL Transformer Options", "All options for the CIF to UPPAAL transformer.", cats, Lists.list());
        return options;
    }
}

