/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2yed;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.cif2yed.CifToYedColors;
import org.eclipse.escet.cif.cif2yed.options.SyntaxHighlightingOption;
import org.eclipse.escet.cif.cif2yed.options.TransparentEdgeLabelsOption;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.texteditor.CifCodeHighlighter;
import org.eclipse.escet.cif.texteditor.CifTextEditorLightTheme;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.setext.texteditorbase.themes.TextEditorTheme;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class CifToYedDiagram {
    private static final String GRAPHML_NS = "http://graphml.graphdrawing.org/xmlns";
    private static final String GRAPHML_SCHEMA_LOC = "http://graphml.graphdrawing.org/xmlns";
    private static final String Y_NS = "http://www.yworks.com/xml/graphml";
    private static final String Y_SCHEMA_LOC = "http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd";
    protected boolean highlight;
    private CifCodeHighlighter highlighter;
    private boolean useTransparentEdgeLabels;
    protected Document doc;
    protected Element rootGraph;
    private Graphics graphics;
    private FontMetrics metrics;

    public Document transform(Specification spec) {
        Assert.check((this.highlighter == null ? 1 : 0) != 0);
        this.highlight = SyntaxHighlightingOption.applyHighlighting();
        if (this.highlight) {
            AppEnv.checkGuiAvailable((String)"apply syntax highlighting in the CIF to yEd transformer");
            this.highlighter = new CifCodeHighlighter((TextEditorTheme)new CifTextEditorLightTheme());
        }
        Assert.ifAndOnlyIf((boolean)this.highlight, (this.highlighter != null ? 1 : 0) != 0);
        this.useTransparentEdgeLabels = TransparentEdgeLabelsOption.isEnabled();
        try {
            this.doc = this.createYedXmlDocument();
            Element root = this.doc.getDocumentElement();
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xmlns:y", Y_NS);
            root.setAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd");
            Element ngKeyElem = this.doc.createElement("key");
            root.appendChild(ngKeyElem);
            ngKeyElem.setAttribute("for", "node");
            ngKeyElem.setAttribute("id", "ng");
            ngKeyElem.setAttribute("yfiles.type", "nodegraphics");
            Element egKeyElem = this.doc.createElement("key");
            root.appendChild(egKeyElem);
            egKeyElem.setAttribute("for", "edge");
            egKeyElem.setAttribute("id", "eg");
            egKeyElem.setAttribute("yfiles.type", "edgegraphics");
            Element deKeyElem = this.doc.createElement("key");
            root.appendChild(deKeyElem);
            deKeyElem.setAttribute("for", "node");
            deKeyElem.setAttribute("id", "dn");
            deKeyElem.setAttribute("attr.name", "description");
            deKeyElem.setAttribute("attr.type", "string");
            this.rootGraph = null;
            BufferedImage img = new BufferedImage(1, 1, 1);
            this.graphics = img.getGraphics();
            this.metrics = this.graphics.getFontMetrics();
            this.addSpec(spec, root);
            this.graphics.dispose();
            Document document = this.doc;
            return document;
        }
        finally {
            if (this.highlighter != null) {
                this.highlighter.close();
                this.highlighter = null;
            }
        }
    }

    protected abstract void addSpec(Specification var1, Element var2);

    private Document createYedXmlDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document doc = domImpl.createDocument("http://graphml.graphdrawing.org/xmlns", "graphml", null);
        doc.setXmlVersion("1.0");
        doc.setXmlStandalone(false);
        return doc;
    }

    protected void addEdgeLabelBackground(Element label) {
        if (this.useTransparentEdgeLabels) {
            return;
        }
        label.setAttribute("backgroundColor", CifToYedColors.COMP_BG_OPENED_COLOR.color);
    }

    protected String highlight(String code) {
        if (!this.highlight) {
            return code;
        }
        return this.highlighter.toHtml(code);
    }

    protected double guessTextWidth(String text, int margin) {
        return this.guessTextSize(text, margin).getWidth();
    }

    protected Rectangle2D guessTextSize(String text, int margin) {
        String[] lines;
        Rectangle2D.Double size = new Rectangle2D.Double();
        String[] stringArray = lines = StringUtils.splitPreserveAllTokens((String)text, (char)'\n');
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Rectangle2D rect = this.metrics.getStringBounds(line, this.graphics);
            size.width = Math.max(size.width, rect.getWidth());
            size.height += rect.getHeight() + 1.0;
            ++n2;
        }
        size.width += (double)(margin * 2);
        size.height += (double)(margin * 2);
        if (size.width < 30.0) {
            size.width = 30.0;
        }
        if (size.height < 30.0) {
            size.height = 30.0;
        }
        return size;
    }
}

