/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.FunctionCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.common.FuncLocalVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class JavaFunctionCodeGen
extends FunctionCodeGen {
    public JavaFunctionCodeGen(InternalFunction function) {
        super(function);
    }

    public void generate(CodeBox code, CodeContext ctxt) {
        VariableInformation varInfo;
        String funcName = ctxt.getFunctionName(this.function);
        EList params = this.function.getParameters();
        List paramTxts = Lists.listc((int)params.size());
        for (FunctionParameter param : params) {
            DiscVariable var = param.getParameter();
            varInfo = ctxt.getReadVarInfo(new VariableWrapper((Declaration)var, false));
            String name = varInfo.targetRef;
            TypeInfo typeInfo = ctxt.typeToTarget(var.getType());
            String typeTxt = typeInfo.getTargetType();
            paramTxts.add(typeTxt + " " + name);
        }
        String origFuncName = ctxt.getOrigFunctionName(this.function);
        if (origFuncName == null) {
            origFuncName = this.function.getName();
        }
        code.add();
        code.add("/**");
        code.add(" * Evaluation for function \"%s\".", new Object[]{origFuncName});
        code.add(" *");
        int i = 0;
        while (i < params.size()) {
            DiscVariable param = ((FunctionParameter)params.get(i)).getParameter();
            varInfo = ctxt.getReadVarInfo(new VariableWrapper((Declaration)param, false));
            code.add(" * @param %s Function parameter \"%s\".", new Object[]{varInfo.targetRef, varInfo.name});
            ++i;
        }
        code.add(" * @return The return value of the function.");
        code.add(" */");
        TypeInfo retTi = ctxt.typeToTarget(this.getReturnType());
        code.add("public static %s %s(%s) {", new Object[]{retTi.getTargetType(), funcName, String.join((CharSequence)", ", paramTxts)});
        code.indent();
        this.addFunctionBody(this.function, code, ctxt);
        code.dedent();
        code.add("}");
    }

    private void addFunctionBody(InternalFunction func, CodeBox code, CodeContext ctxt) {
        Object localVars = func.getVariables();
        localVars = new FuncLocalVarOrderer().computeOrder((Collection)localVars);
        Assert.notNull((Object)localVars);
        Iterator iterator = localVars.iterator();
        while (iterator.hasNext()) {
            DiscVariable var = (DiscVariable)iterator.next();
            Assert.check((var.getValue() != null ? 1 : 0) != 0);
            Assert.check((var.getValue().getValues().size() == 1 ? 1 : 0) != 0);
            Expression value = (Expression)Lists.first((List)var.getValue().getValues());
            ExprCode valueCode = ctxt.exprToTarget(value, null);
            code.add((Box)valueCode.getCode());
            Destination dest = ctxt.makeDestination((Declaration)var);
            TypeInfo varTi = ctxt.typeToTarget(var.getType());
            varTi.declareInit(code, valueCode.getRawDataValue(), dest);
        }
        if (!localVars.isEmpty()) {
            code.add();
        }
        this.addFuncStatements((List<FunctionStatement>)func.getStatements(), code, ctxt);
        code.add("throw new RuntimeException(\"no return at end of func\");");
    }

    @Override
    protected IfElseGenerator getIfElseFuncGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    protected void generateBreakFuncStatement(CodeBox code) {
        code.add("if (true) break;");
    }

    @Override
    protected void generateContinueFuncStatement(CodeBox code) {
        code.add("if (true) continue;");
    }

    @Override
    protected void generateReturnFuncStatement(Expression retValue, CodeBox code, boolean safeScope, CodeContext ctxt) {
        ExprCode retCode = ctxt.exprToTarget(retValue, null);
        code.add((Box)retCode.getCode());
        code.add("if (true) return %s;", new Object[]{retCode.getData()});
    }

    @Override
    protected boolean generateWhileFuncStatement(ExprCode guardCode, CodeBox code, boolean safeScope) {
        if (!guardCode.hasCode()) {
            code.add("if (true) while (%s) {", new Object[]{guardCode.getData()});
            code.indent();
            return safeScope;
        }
        code.add("if (true) while (true) {");
        code.indent();
        code.add((Box)guardCode.getCode());
        code.add("if (!(%s)) break;", new Object[]{guardCode.getData()});
        return false;
    }

    @Override
    protected void generateEndWhileFuncStatement(CodeBox code) {
        code.dedent();
        code.add("}");
    }
}

