/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;

public class AnnotationEqHashWrap {
    public final Annotation annotation;
    private final Map<String, Object> argNamesToValues;
    private final int hashCode;

    public AnnotationEqHashWrap(Annotation annotation) {
        this.annotation = annotation;
        this.argNamesToValues = annotation.getArguments().stream().collect(Collectors.toMap(arg -> arg.getName(), arg -> AnnotationEqHashWrap.evalAnnoArgValue(arg.getValue())));
        this.hashCode = annotation.getName().hashCode() + this.argNamesToValues.hashCode();
    }

    private static Object evalAnnoArgValue(Expression value) {
        try {
            return CifEvalUtils.eval(value, false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException("Failed to evaluate annotation argument value.", e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        AnnotationEqHashWrap other = (AnnotationEqHashWrap)obj;
        return this.annotation.getName().equals(other.annotation.getName()) && this.argNamesToValues.equals(other.argNamesToValues);
    }
}

