/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;

public class CifTypeUtils {
    private CifTypeUtils() {
    }

    public static boolean checkTypeCompat(CifType type1, CifType type2, RangeCompat rangeCompat) {
        return CifTypeUtils.checkTypeCompat(type1, type2, rangeCompat, rangeCompat);
    }

    public static boolean checkTypeCompat(CifType type1, CifType type2, RangeCompat rangeCompatInt, RangeCompat rangeCompatList) {
        if (type1 instanceof BoolType && type2 instanceof BoolType) {
            return true;
        }
        if (type1 instanceof IntType && type2 instanceof IntType) {
            IntType itype1 = (IntType)type1;
            IntType itype2 = (IntType)type2;
            int lower1 = CifTypeUtils.getLowerBound(itype1);
            int lower2 = CifTypeUtils.getLowerBound(itype2);
            int upper1 = CifTypeUtils.getUpperBound(itype1);
            int upper2 = CifTypeUtils.getUpperBound(itype2);
            switch (rangeCompatInt) {
                case IGNORE: {
                    return true;
                }
                case CONTAINED: {
                    return lower1 <= lower2 && upper1 >= upper2;
                }
                case EQUAL: {
                    return lower1 == lower2 && upper1 == upper2;
                }
                case OVERLAP: {
                    return upper1 >= lower2 && lower1 <= upper2;
                }
            }
            String msg = "Unknown rangeCompatInt: " + String.valueOf((Object)rangeCompatInt);
            throw new RuntimeException(msg);
        }
        if (type1 instanceof TypeRef) {
            return CifTypeUtils.checkTypeCompat(((TypeRef)type1).getType().getType(), type2, rangeCompatInt, rangeCompatList);
        }
        if (type2 instanceof TypeRef) {
            return CifTypeUtils.checkTypeCompat(type1, ((TypeRef)type2).getType().getType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof EnumType && type2 instanceof EnumType) {
            EnumDecl enum1 = ((EnumType)type1).getEnum();
            EnumDecl enum2 = ((EnumType)type2).getEnum();
            return CifTypeUtils.areEnumsCompatible(enum1, enum2);
        }
        if (type1 instanceof RealType && type2 instanceof RealType) {
            return true;
        }
        if (type1 instanceof StringType && type2 instanceof StringType) {
            return true;
        }
        if (type1 instanceof ListType && type2 instanceof ListType) {
            ListType ltype1 = (ListType)type1;
            ListType ltype2 = (ListType)type2;
            int lower1 = CifTypeUtils.getLowerBound(ltype1);
            int lower2 = CifTypeUtils.getLowerBound(ltype2);
            int upper1 = CifTypeUtils.getUpperBound(ltype1);
            int upper2 = CifTypeUtils.getUpperBound(ltype2);
            switch (rangeCompatList) {
                case IGNORE: {
                    break;
                }
                case CONTAINED: {
                    if (lower1 <= lower2 && upper1 >= upper2) break;
                    return false;
                }
                case EQUAL: {
                    if (lower1 == lower2 && upper1 == upper2) break;
                    return false;
                }
                case OVERLAP: {
                    if (upper1 >= lower2 && lower1 <= upper2) break;
                    return false;
                }
                default: {
                    String msg = "Unknown rangeCompatList: " + String.valueOf((Object)rangeCompatList);
                    throw new RuntimeException(msg);
                }
            }
            return CifTypeUtils.checkTypeCompat(ltype1.getElementType(), ltype2.getElementType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof SetType && type2 instanceof SetType) {
            SetType stype1 = (SetType)type1;
            SetType stype2 = (SetType)type2;
            return CifTypeUtils.checkTypeCompat(stype1.getElementType(), stype2.getElementType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof FuncType && type2 instanceof FuncType) {
            int cnt2;
            CifType rtype2;
            CifType rtype1;
            FuncType ftype1 = (FuncType)type1;
            FuncType ftype2 = (FuncType)type2;
            RangeCompat returnCompatInt = rangeCompatInt;
            RangeCompat returnCompatList = rangeCompatList;
            if (returnCompatInt == RangeCompat.OVERLAP) {
                returnCompatInt = RangeCompat.CONTAINED;
            }
            if (returnCompatList == RangeCompat.OVERLAP) {
                returnCompatList = RangeCompat.CONTAINED;
            }
            if (!CifTypeUtils.checkTypeCompat(rtype1 = ftype1.getReturnType(), rtype2 = ftype2.getReturnType(), returnCompatInt, returnCompatList)) {
                return false;
            }
            int cnt1 = ftype1.getParamTypes().size();
            if (cnt1 != (cnt2 = ftype2.getParamTypes().size())) {
                return false;
            }
            int i = 0;
            while (i < ftype1.getParamTypes().size()) {
                CifType ptype2;
                CifType ptype1 = (CifType)ftype1.getParamTypes().get(i);
                if (!CifTypeUtils.checkTypeCompat(ptype1, ptype2 = (CifType)ftype2.getParamTypes().get(i), rangeCompatInt, rangeCompatList)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (type1 instanceof DictType && type2 instanceof DictType) {
            DictType dtype1 = (DictType)type1;
            DictType dtype2 = (DictType)type2;
            return CifTypeUtils.checkTypeCompat(dtype1.getKeyType(), dtype2.getKeyType(), rangeCompatInt, rangeCompatList) && CifTypeUtils.checkTypeCompat(dtype1.getValueType(), dtype2.getValueType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof TupleType && type2 instanceof TupleType) {
            int cnt2;
            TupleType ttype1 = (TupleType)type1;
            TupleType ttype2 = (TupleType)type2;
            int cnt1 = ttype1.getFields().size();
            if (cnt1 != (cnt2 = ttype2.getFields().size())) {
                return false;
            }
            int i = 0;
            while (i < ttype1.getFields().size()) {
                CifType ftype2;
                CifType ftype1 = ((Field)ttype1.getFields().get(i)).getType();
                if (!CifTypeUtils.checkTypeCompat(ftype1, ftype2 = ((Field)ttype2.getFields().get(i)).getType(), rangeCompatInt, rangeCompatList)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (type1 instanceof DistType && type2 instanceof DistType) {
            DistType dtype1 = (DistType)type1;
            DistType dtype2 = (DistType)type2;
            return CifTypeUtils.checkTypeCompat(dtype1.getSampleType(), dtype2.getSampleType(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof CompParamWrapType) {
            return CifTypeUtils.checkTypeCompat(((CompParamWrapType)type1).getReference(), type2, rangeCompatInt, rangeCompatList);
        }
        if (type2 instanceof CompParamWrapType) {
            return CifTypeUtils.checkTypeCompat(type1, ((CompParamWrapType)type2).getReference(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof CompInstWrapType) {
            return CifTypeUtils.checkTypeCompat(((CompInstWrapType)type1).getReference(), type2, rangeCompatInt, rangeCompatList);
        }
        if (type2 instanceof CompInstWrapType) {
            return CifTypeUtils.checkTypeCompat(type1, ((CompInstWrapType)type2).getReference(), rangeCompatInt, rangeCompatList);
        }
        if (type1 instanceof ComponentDefType && type2 instanceof ComponentType) {
            ComponentDef cdef1 = ((ComponentDefType)type1).getDefinition();
            Component comp2 = ((ComponentType)type2).getComponent();
            if (!(comp2 instanceof ComponentInst)) {
                return false;
            }
            ComponentInst inst = (ComponentInst)comp2;
            ComponentDef cdef2 = CifTypeUtils.getCompDefFromCompInst(inst);
            return cdef1 == cdef2;
        }
        if (type1 instanceof ComponentDefType && type2 instanceof ComponentDefType) {
            ComponentDef cdef2;
            ComponentDef cdef1 = ((ComponentDefType)type1).getDefinition();
            return cdef1 == (cdef2 = ((ComponentDefType)type2).getDefinition());
        }
        return type1 instanceof VoidType && type2 instanceof VoidType;
    }

    public static boolean areEnumsCompatible(EnumDecl enum1, EnumDecl enum2) {
        if (enum1.getLiterals().size() != enum2.getLiterals().size()) {
            return false;
        }
        List<String> lits1 = CifTypeUtils.getLiteralNames(enum1);
        List<String> lits2 = CifTypeUtils.getLiteralNames(enum2);
        return lits1.equals(lits2);
    }

    public static List<String> getLiteralNames(EnumDecl enumDecl) {
        List lits = Lists.listc((int)enumDecl.getLiterals().size());
        for (EnumLiteral lit : enumDecl.getLiterals()) {
            lits.add(lit.getName());
        }
        return lits;
    }

    public static int hashType(CifType type) {
        return CifTypeUtils.hashType(type, true, true);
    }

    public static int hashType(CifType type, boolean ignoreRanges) {
        return CifTypeUtils.hashType(type, ignoreRanges, ignoreRanges);
    }

    public static int hashType(CifType type, boolean ignoreRangesInt, boolean ignoreRangesList) {
        if (type instanceof BoolType) {
            return 1;
        }
        if (type instanceof RealType) {
            return 64;
        }
        if (type instanceof StringType) {
            return 512;
        }
        if (type instanceof VoidType) {
            return 4096;
        }
        if (type instanceof IntType) {
            int rslt = 8;
            if (!ignoreRangesInt) {
                IntType itype = (IntType)type;
                rslt ^= CifTypeUtils.getLowerBound(itype) + 13;
                rslt ^= CifTypeUtils.getUpperBound(itype) + 27;
            }
            return rslt;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            int rslt = 32768 + CifTypeUtils.hashType(ltype.getElementType(), ignoreRangesInt, ignoreRangesList);
            if (!ignoreRangesList) {
                rslt ^= CifTypeUtils.getLowerBound(ltype) + 13;
                rslt ^= CifTypeUtils.getUpperBound(ltype) + 27;
            }
            return rslt;
        }
        if (type instanceof SetType) {
            return 262144 + CifTypeUtils.hashType(((SetType)type).getElementType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof DictType) {
            return 0x200000 + CifTypeUtils.hashType(((DictType)type).getKeyType(), ignoreRangesInt, ignoreRangesList) + CifTypeUtils.hashType(((DictType)type).getValueType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof TupleType) {
            int rslt = 0x1000000;
            for (Field field : ((TupleType)type).getFields()) {
                rslt += CifTypeUtils.hashType(field.getType(), ignoreRangesInt, ignoreRangesList);
            }
            return rslt;
        }
        if (type instanceof DistType) {
            return 0x8000000 + CifTypeUtils.hashType(((DistType)type).getSampleType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            int rslt = 1 << 30 + CifTypeUtils.hashType(ftype.getReturnType(), ignoreRangesInt, ignoreRangesList);
            for (CifType ptype : ftype.getParamTypes()) {
                rslt += CifTypeUtils.hashType(ptype, ignoreRangesInt, ignoreRangesList);
            }
            return rslt;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hashType(((TypeRef)type).getType().getType(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof EnumType) {
            return CifTypeUtils.getLiteralNames(((EnumType)type).getEnum()).hashCode();
        }
        if (type instanceof CompParamWrapType) {
            return CifTypeUtils.hashType(((CompParamWrapType)type).getReference(), ignoreRangesInt, ignoreRangesList);
        }
        if (type instanceof CompInstWrapType) {
            return CifTypeUtils.hashType(((CompInstWrapType)type).getReference(), ignoreRangesInt, ignoreRangesList);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    public static boolean supportsValueEquality(CifType type) {
        if (type instanceof BoolType) {
            return true;
        }
        if (type instanceof IntType) {
            return true;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.supportsValueEquality(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return true;
        }
        if (type instanceof RealType) {
            return true;
        }
        if (type instanceof StringType) {
            return true;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.supportsValueEquality(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.supportsValueEquality(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.supportsValueEquality(dtype.getKeyType()) && CifTypeUtils.supportsValueEquality(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (CifTypeUtils.supportsValueEquality(field.getType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.supportsValueEquality(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.supportsValueEquality(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasComponentLikeType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasComponentLikeType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasComponentLikeType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasComponentLikeType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.hasComponentLikeType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.hasComponentLikeType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasComponentLikeType(dtype.getKeyType()) || CifTypeUtils.hasComponentLikeType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasComponentLikeType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return true;
        }
        if (type instanceof ComponentType) {
            return true;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasComponentLikeType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasComponentLikeType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasFunctionType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasFunctionType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasFunctionType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasFunctionType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            return true;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasFunctionType(dtype.getKeyType()) || CifTypeUtils.hasFunctionType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasFunctionType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasFunctionType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasFunctionType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasDistType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasDistType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasDistType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasDistType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.hasDistType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.hasDistType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasDistType(dtype.getKeyType()) || CifTypeUtils.hasDistType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasDistType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return true;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasDistType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasDistType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static boolean hasEnumType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return false;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.hasEnumType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return true;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return CifTypeUtils.hasEnumType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.hasEnumType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.hasEnumType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.hasEnumType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.hasEnumType(dtype.getKeyType()) || CifTypeUtils.hasEnumType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.hasEnumType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.hasEnumType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.hasEnumType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static CifType mergeTypes(CifType type1, CifType type2, Position position) {
        CifType origType1 = type1;
        type1 = CifTypeUtils.normalizeType(type1);
        type2 = CifTypeUtils.normalizeType(type2);
        if (type1 instanceof BoolType && type2 instanceof BoolType) {
            return CifConstructors.newBoolType((Position)PositionUtils.copyPosition((Position)position));
        }
        if (type1 instanceof IntType && type2 instanceof IntType) {
            IntType itype1 = (IntType)type1;
            IntType itype2 = (IntType)type2;
            IntType itype = CifConstructors.newIntType();
            itype.setPosition(PositionUtils.copyPosition((Position)position));
            if (!CifTypeUtils.isRangeless(itype1) && !CifTypeUtils.isRangeless(itype2)) {
                itype.setLower(Integer.valueOf(Math.min(itype1.getLower(), itype2.getLower())));
                itype.setUpper(Integer.valueOf(Math.max(itype1.getUpper(), itype2.getUpper())));
            }
            return itype;
        }
        if (type1 instanceof EnumType && type2 instanceof EnumType) {
            EnumDecl enum1 = ((EnumType)type1).getEnum();
            EnumDecl enum2 = ((EnumType)type2).getEnum();
            Assert.check((boolean)CifTypeUtils.areEnumsCompatible(enum1, enum2));
            return CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)origType1), position);
        }
        if (type1 instanceof RealType && type2 instanceof RealType) {
            return CifConstructors.newRealType((Position)PositionUtils.copyPosition((Position)position));
        }
        if (type1 instanceof StringType && type2 instanceof StringType) {
            return CifConstructors.newStringType((Position)PositionUtils.copyPosition((Position)position));
        }
        if (type1 instanceof ListType && type2 instanceof ListType) {
            ListType ltype1 = (ListType)type1;
            ListType ltype2 = (ListType)type2;
            ListType ltype = CifConstructors.newListType();
            ltype.setPosition(PositionUtils.copyPosition((Position)position));
            if (!CifTypeUtils.isRangeless(ltype1) && !CifTypeUtils.isRangeless(ltype2)) {
                ltype.setLower(Integer.valueOf(Math.min(ltype1.getLower(), ltype2.getLower())));
                ltype.setUpper(Integer.valueOf(Math.max(ltype1.getUpper(), ltype2.getUpper())));
            }
            CifType etype = CifTypeUtils.mergeTypes(ltype1.getElementType(), ltype2.getElementType(), position);
            ltype.setElementType(etype);
            return ltype;
        }
        if (type1 instanceof SetType && type2 instanceof SetType) {
            CifType etype = CifTypeUtils.mergeTypes(((SetType)type1).getElementType(), ((SetType)type2).getElementType(), position);
            SetType stype = CifConstructors.newSetType();
            stype.setPosition(PositionUtils.copyPosition((Position)position));
            stype.setElementType(etype);
            return stype;
        }
        if (type1 instanceof FuncType && type2 instanceof FuncType) {
            int cnt2;
            FuncType ftype1 = (FuncType)type1;
            FuncType ftype2 = (FuncType)type2;
            CifType rtype = CifTypeUtils.mergeTypes(ftype1.getReturnType(), ftype2.getReturnType(), position);
            int cnt1 = ftype1.getParamTypes().size();
            Assert.check((cnt1 == (cnt2 = ftype2.getParamTypes().size()) ? 1 : 0) != 0);
            List ptypes = Lists.listc((int)cnt1);
            int i = 0;
            while (i < cnt1) {
                ptypes.add(CifTypeUtils.mergeTypes((CifType)ftype1.getParamTypes().get(i), (CifType)ftype2.getParamTypes().get(i), position));
                ++i;
            }
            FuncType ftype = CifConstructors.newFuncType();
            ftype.setPosition(PositionUtils.copyPosition((Position)position));
            ftype.setReturnType(rtype);
            ftype.getParamTypes().addAll((Collection)ptypes);
            return ftype;
        }
        if (type1 instanceof DictType && type2 instanceof DictType) {
            DictType dtype1 = (DictType)type1;
            DictType dtype2 = (DictType)type2;
            CifType ktype = CifTypeUtils.mergeTypes(dtype1.getKeyType(), dtype2.getKeyType(), position);
            CifType vtype = CifTypeUtils.mergeTypes(dtype1.getValueType(), dtype2.getValueType(), position);
            DictType dtype = CifConstructors.newDictType();
            dtype.setPosition(PositionUtils.copyPosition((Position)position));
            dtype.setKeyType(ktype);
            dtype.setValueType(vtype);
            return dtype;
        }
        if (type1 instanceof TupleType && type2 instanceof TupleType) {
            int cnt2;
            TupleType ttype1 = (TupleType)type1;
            TupleType ttype2 = (TupleType)type2;
            int cnt1 = ttype1.getFields().size();
            Assert.check((cnt1 == (cnt2 = ttype2.getFields().size()) ? 1 : 0) != 0);
            List fields = Lists.listc((int)cnt1);
            int i = 0;
            while (i < cnt1) {
                Field field1 = (Field)ttype1.getFields().get(i);
                Field field2 = (Field)ttype2.getFields().get(i);
                CifType ftype = CifTypeUtils.mergeTypes(field1.getType(), field2.getType(), position);
                Field field = CifConstructors.newField();
                field.setPosition(PositionUtils.copyPosition((Position)position));
                field.setType(ftype);
                fields.add(field);
                ++i;
            }
            TupleType ttype = CifConstructors.newTupleType();
            ttype.setPosition(PositionUtils.copyPosition((Position)position));
            ttype.getFields().addAll((Collection)fields);
            return ttype;
        }
        if (type1 instanceof DistType && type2 instanceof DistType) {
            CifType stype = CifTypeUtils.mergeTypes(((DistType)type1).getSampleType(), ((DistType)type2).getSampleType(), position);
            DistType dtype = CifConstructors.newDistType();
            dtype.setPosition(PositionUtils.copyPosition((Position)position));
            dtype.setSampleType(stype);
            return dtype;
        }
        if (type1 instanceof VoidType && type2 instanceof VoidType) {
            return CifConstructors.newVoidType((Position)PositionUtils.copyPosition((Position)position));
        }
        String msg = "Unknown/unexpected types: " + String.valueOf(type1) + ", " + String.valueOf(type2);
        throw new RuntimeException(msg);
    }

    public static int getLowerBound(IntType type) {
        Integer rslt = type.getLower();
        return rslt == null ? Integer.MIN_VALUE : rslt;
    }

    public static int getLowerBound(ListType type) {
        Integer rslt = type.getLower();
        return rslt == null ? 0 : rslt;
    }

    public static int getUpperBound(IntType type) {
        Integer rslt = type.getUpper();
        return rslt == null ? Integer.MAX_VALUE : rslt;
    }

    public static int getUpperBound(ListType type) {
        Integer rslt = type.getUpper();
        return rslt == null ? Integer.MAX_VALUE : rslt;
    }

    public static boolean isRangeless(IntType type) {
        return type.getLower() == null;
    }

    public static boolean isRangeless(ListType type) {
        return type.getLower() == null;
    }

    public static boolean isArrayType(ListType type) {
        return type.getLower() != null && type.getUpper() != null && type.getLower().equals(type.getUpper());
    }

    public static boolean containsRangedType(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return !CifTypeUtils.isRangeless((IntType)type);
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.containsRangedType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof ListType) {
            return !CifTypeUtils.isRangeless((ListType)type) || CifTypeUtils.containsRangedType(((ListType)type).getElementType());
        }
        if (type instanceof SetType) {
            return CifTypeUtils.containsRangedType(((SetType)type).getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            if (CifTypeUtils.containsRangedType(ftype.getReturnType())) {
                return true;
            }
            for (CifType paramType : ftype.getParamTypes()) {
                if (!CifTypeUtils.containsRangedType(paramType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifTypeUtils.containsRangedType(dtype.getKeyType()) || CifTypeUtils.containsRangedType(dtype.getValueType());
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (!CifTypeUtils.containsRangedType(field.getType())) continue;
                return true;
            }
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.containsRangedType(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.containsRangedType(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static CifType normalizeType(CifType type) {
        if (type instanceof TypeRef) {
            return CifTypeUtils.normalizeType(((TypeRef)type).getType().getType());
        }
        if (type instanceof CompParamWrapType) {
            return CifTypeUtils.normalizeType(((CompParamWrapType)type).getReference());
        }
        if (type instanceof CompInstWrapType) {
            return CifTypeUtils.normalizeType(((CompInstWrapType)type).getReference());
        }
        return type;
    }

    public static CifType normalizeTypeRecursive(CifType type) {
        if (type instanceof BoolType) {
            return type;
        }
        if (type instanceof IntType) {
            return type;
        }
        if (type instanceof EnumType) {
            return type;
        }
        if (type instanceof RealType) {
            return type;
        }
        if (type instanceof StringType) {
            return type;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            CifType netype = CifTypeUtils.normalizeTypeRecursive(ltype.getElementType());
            ListType rslt = CifConstructors.newListType();
            rslt.setLower(ltype.getLower());
            rslt.setUpper(ltype.getUpper());
            rslt.setElementType((CifType)EMFHelper.deepclone((EObject)netype));
            return rslt;
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            CifType netype = CifTypeUtils.normalizeTypeRecursive(stype.getElementType());
            SetType rslt = CifConstructors.newSetType();
            rslt.setElementType((CifType)EMFHelper.deepclone((EObject)netype));
            return rslt;
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            CifType nrtype = CifTypeUtils.normalizeTypeRecursive(ftype.getReturnType());
            List nptypes = Lists.listc((int)ftype.getParamTypes().size());
            for (CifType ptype : ftype.getParamTypes()) {
                nptypes.add((CifType)EMFHelper.deepclone((EObject)CifTypeUtils.normalizeTypeRecursive(ptype)));
            }
            FuncType rslt = CifConstructors.newFuncType();
            rslt.setReturnType((CifType)EMFHelper.deepclone((EObject)nrtype));
            rslt.getParamTypes().addAll((Collection)nptypes);
            return rslt;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            CifType nktype = CifTypeUtils.normalizeTypeRecursive(dtype.getKeyType());
            CifType nvtype = CifTypeUtils.normalizeTypeRecursive(dtype.getValueType());
            DictType rslt = CifConstructors.newDictType();
            rslt.setKeyType((CifType)EMFHelper.deepclone((EObject)nktype));
            rslt.setValueType((CifType)EMFHelper.deepclone((EObject)nvtype));
            return rslt;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            List nfields = Lists.listc((int)ttype.getFields().size());
            for (Field field : ttype.getFields()) {
                Field nfield = CifConstructors.newField();
                nfield.setName(field.getName());
                CifType ftype = CifTypeUtils.normalizeTypeRecursive(field.getType());
                nfield.setType((CifType)EMFHelper.deepclone((EObject)ftype));
                nfields.add(nfield);
            }
            TupleType rslt = CifConstructors.newTupleType();
            rslt.getFields().addAll((Collection)nfields);
            return rslt;
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            CifType nstype = CifTypeUtils.normalizeTypeRecursive(dtype.getSampleType());
            DistType rslt = CifConstructors.newDistType();
            rslt.setSampleType((CifType)EMFHelper.deepclone((EObject)nstype));
            return rslt;
        }
        if (type instanceof ComponentType) {
            return type;
        }
        if (type instanceof ComponentDefType) {
            return type;
        }
        if (type instanceof TypeRef) {
            return CifTypeUtils.normalizeTypeRecursive(((TypeRef)type).getType().getType());
        }
        if (type instanceof CompInstWrapType) {
            CompInstWrapType wrapper = (CompInstWrapType)type;
            return CifTypeUtils.normalizeTypeRecursive(wrapper.getReference());
        }
        if (type instanceof CompParamWrapType) {
            CompParamWrapType wrapper = (CompParamWrapType)type;
            return CifTypeUtils.normalizeTypeRecursive(wrapper.getReference());
        }
        if (type instanceof VoidType) {
            return type;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static CifType unwrapType(CifType type) {
        if (type instanceof CompParamWrapType) {
            return CifTypeUtils.unwrapType(((CompParamWrapType)type).getReference());
        }
        if (type instanceof CompInstWrapType) {
            return CifTypeUtils.unwrapType(((CompInstWrapType)type).getReference());
        }
        return type;
    }

    public static Expression unwrapExpression(Expression expr) {
        if (expr instanceof CompParamWrapExpression) {
            return CifTypeUtils.unwrapExpression(((CompParamWrapExpression)expr).getReference());
        }
        if (expr instanceof CompInstWrapExpression) {
            return CifTypeUtils.unwrapExpression(((CompInstWrapExpression)expr).getReference());
        }
        return expr;
    }

    public static ComponentDef getCompDefFromCompInst(ComponentInst inst) {
        CifType type = inst.getDefinition();
        type = CifTypeUtils.unwrapType(type);
        Assert.check((boolean)(type instanceof ComponentDefType));
        return ((ComponentDefType)type).getDefinition();
    }

    public static boolean isAutRefExpr(Expression expr) {
        if (expr instanceof SelfExpression) {
            return true;
        }
        if ((expr = CifTypeUtils.unwrapExpression(expr)) instanceof ComponentExpression) {
            Component comp = ((ComponentExpression)expr).getComponent();
            return CifScopeUtils.isAutomaton(comp);
        }
        if (expr instanceof CompParamExpression) {
            CompParamExpression compParamExpr = (CompParamExpression)expr;
            CifType t = CifTypeUtils.normalizeType(compParamExpr.getType());
            Assert.check((boolean)(t instanceof ComponentDefType));
            ComponentDef cdef = ((ComponentDefType)t).getDefinition();
            return CifScopeUtils.isAutomaton((Component)cdef.getBody());
        }
        return false;
    }

    public static boolean isRefExpr(Expression expr) {
        return expr instanceof ConstantExpression || expr instanceof DiscVariableExpression || expr instanceof AlgVariableExpression || expr instanceof ContVariableExpression || expr instanceof LocationExpression || expr instanceof EventExpression || expr instanceof EnumLiteralExpression || expr instanceof FunctionExpression || expr instanceof InputVariableExpression || expr instanceof ComponentExpression || expr instanceof CompParamExpression || expr instanceof CompParamWrapExpression || expr instanceof CompInstWrapExpression || expr instanceof SelfExpression;
    }

    public static boolean isRefType(CifType type) {
        return type instanceof TypeRef || type instanceof EnumType || type instanceof ComponentType || type instanceof ComponentDefType || type instanceof CompParamWrapType || type instanceof CompInstWrapType;
    }

    public static boolean isContainerType(CifType type) {
        return (type = CifTypeUtils.normalizeType(type)) instanceof DictType || type instanceof ListType || type instanceof SetType || type instanceof TupleType;
    }

    public static boolean isDistFunction(StdLibFunction func) {
        switch (func) {
            case MINIMUM: 
            case MAXIMUM: 
            case POWER: 
            case SIGN: 
            case CBRT: 
            case CEIL: 
            case DELETE: 
            case EMPTY: 
            case EXP: 
            case FLOOR: 
            case LN: 
            case LOG: 
            case POP: 
            case ROUND: 
            case SIZE: 
            case SQRT: 
            case ACOSH: 
            case ACOS: 
            case ASINH: 
            case ASIN: 
            case ATANH: 
            case ATAN: 
            case COSH: 
            case COS: 
            case SINH: 
            case SIN: 
            case TANH: 
            case TAN: 
            case ABS: 
            case FORMAT: 
            case SCALE: {
                return false;
            }
            case BERNOULLI: 
            case BETA: 
            case BINOMIAL: 
            case CONSTANT: 
            case ERLANG: 
            case EXPONENTIAL: 
            case GAMMA: 
            case GEOMETRIC: 
            case LOG_NORMAL: 
            case NORMAL: 
            case POISSON: 
            case RANDOM: 
            case TRIANGLE: 
            case UNIFORM: 
            case WEIBULL: {
                return true;
            }
        }
        throw new RuntimeException("Unknown stdlib func: " + String.valueOf(func));
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean areStructurallySameType(CifType type1, CifType type2) {
        CifType cifType;
        CifType cifType2;
        CifType cifType3;
        CifType cifType4;
        CifType cifType5;
        DistType field1;
        CifType cifType6;
        CifType cifType7;
        CifType cifType8;
        CifType cifType9;
        CifType cifType10;
        if (!type1.getClass().equals(type2.getClass())) {
            return false;
        }
        if (type1 instanceof BoolType && type2 instanceof BoolType) {
            return true;
        }
        CifType cifType11 = type1;
        if (cifType11 instanceof IntType) {
            IntType intType = (IntType)cifType11;
            IntType cfr_ignored_0 = (IntType)cifType11;
            CifType cifType12 = type2;
            if (cifType12 instanceof IntType) {
                void itype2;
                void itype1;
                IntType intType2 = (IntType)cifType12;
                IntType cfr_ignored_1 = (IntType)cifType12;
                if (Objects.equals(itype1.getLower(), itype2.getLower()) && Objects.equals(itype1.getUpper(), itype2.getUpper())) {
                    return true;
                }
                return false;
            }
        }
        if ((cifType10 = type1) instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)cifType10;
            TypeRef cfr_ignored_2 = (TypeRef)cifType10;
            CifType cifType13 = type2;
            if (cifType13 instanceof TypeRef) {
                void typeRef2;
                void typeRef1;
                TypeRef typeRef3 = (TypeRef)cifType13;
                TypeRef cfr_ignored_3 = (TypeRef)cifType13;
                if (typeRef1.getType() == typeRef2.getType()) {
                    return true;
                }
                return false;
            }
        }
        if ((cifType9 = type1) instanceof EnumType) {
            EnumType enumType = (EnumType)cifType9;
            EnumType cfr_ignored_4 = (EnumType)cifType9;
            CifType cifType14 = type2;
            if (cifType14 instanceof EnumType) {
                void etype2;
                void etype1;
                EnumType enumType2 = (EnumType)cifType14;
                EnumType cfr_ignored_5 = (EnumType)cifType14;
                if (etype1.getEnum() == etype2.getEnum()) {
                    return true;
                }
                return false;
            }
        }
        if ((cifType8 = type1) instanceof ListType) {
            ListType listType = (ListType)cifType8;
            ListType cfr_ignored_6 = (ListType)cifType8;
            CifType cifType15 = type2;
            if (cifType15 instanceof ListType) {
                void ltype2;
                void ltype1;
                ListType listType2 = (ListType)cifType15;
                ListType cfr_ignored_7 = (ListType)cifType15;
                if (Objects.equals(ltype1.getLower(), ltype2.getLower()) && Objects.equals(ltype1.getUpper(), ltype2.getUpper()) && CifTypeUtils.areStructurallySameType(ltype1.getElementType(), ltype2.getElementType()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (type1 instanceof StringType && type2 instanceof StringType) {
            return true;
        }
        if (type1 instanceof RealType && type2 instanceof RealType) {
            return true;
        }
        CifType cifType16 = type1;
        if (cifType16 instanceof SetType) {
            SetType setType = (SetType)cifType16;
            SetType cfr_ignored_8 = (SetType)cifType16;
            CifType cifType17 = type2;
            if (cifType17 instanceof SetType) {
                void stype2;
                void stype1;
                SetType setType2 = (SetType)cifType17;
                SetType cfr_ignored_9 = (SetType)cifType17;
                return CifTypeUtils.areStructurallySameType(stype1.getElementType(), stype2.getElementType());
            }
        }
        if ((cifType7 = type1) instanceof FuncType) {
            FuncType funcType = (FuncType)cifType7;
            FuncType cfr_ignored_10 = (FuncType)cifType7;
            CifType cifType18 = type2;
            if (cifType18 instanceof FuncType) {
                void ftype2;
                void ftype1;
                FuncType funcType2 = (FuncType)cifType18;
                FuncType cfr_ignored_11 = (FuncType)cifType18;
                if (ftype1.getParamTypes().size() != ftype1.getParamTypes().size()) {
                    return false;
                }
                int i = 0;
                while (i < ftype1.getParamTypes().size()) {
                    if (!CifTypeUtils.areStructurallySameType((CifType)ftype1.getParamTypes().get(i), (CifType)ftype2.getParamTypes().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return CifTypeUtils.areStructurallySameType(ftype1.getReturnType(), ftype2.getReturnType());
            }
        }
        if (type1 instanceof VoidType && type2 instanceof VoidType) {
            return true;
        }
        CifType cifType19 = type1;
        if (cifType19 instanceof DictType) {
            DictType i = (DictType)cifType19;
            DictType cfr_ignored_12 = (DictType)cifType19;
            CifType cifType20 = type2;
            if (cifType20 instanceof DictType) {
                void dtype2;
                void dtype1;
                DictType dictType = (DictType)cifType20;
                DictType cfr_ignored_13 = (DictType)cifType20;
                if (CifTypeUtils.areStructurallySameType(dtype1.getKeyType(), dtype2.getKeyType()).booleanValue() && CifTypeUtils.areStructurallySameType(dtype1.getValueType(), dtype2.getValueType()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((cifType6 = type1) instanceof TupleType) {
            TupleType tupleType = (TupleType)cifType6;
            TupleType cfr_ignored_14 = (TupleType)cifType6;
            CifType cifType21 = type2;
            if (cifType21 instanceof TupleType) {
                void ttype2;
                void ttype1;
                TupleType tupleType2 = (TupleType)cifType21;
                TupleType cfr_ignored_15 = (TupleType)cifType21;
                if (ttype1.getFields().size() != ttype2.getFields().size()) {
                    return false;
                }
                int i = 0;
                while (i < ttype1.getFields().size()) {
                    field1 = (Field)ttype1.getFields().get(i);
                    Field field2 = (Field)ttype2.getFields().get(i);
                    if (!Objects.equals(field1.getName(), field2.getName())) {
                        return false;
                    }
                    if (!CifTypeUtils.areStructurallySameType(field1.getType(), field2.getType()).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        if ((cifType5 = type1) instanceof DistType) {
            DistType i = (DistType)cifType5;
            DistType cfr_ignored_16 = (DistType)cifType5;
            CifType cifType22 = type2;
            if (cifType22 instanceof DistType) {
                void dtype2;
                void dtype1;
                field1 = (DistType)cifType22;
                DistType cfr_ignored_17 = (DistType)cifType22;
                return CifTypeUtils.areStructurallySameType(dtype1.getSampleType(), dtype2.getSampleType());
            }
        }
        if ((cifType4 = type1) instanceof ComponentDefType) {
            ComponentDefType componentDefType = (ComponentDefType)cifType4;
            ComponentDefType cfr_ignored_18 = (ComponentDefType)cifType4;
            CifType cifType23 = type2;
            if (cifType23 instanceof ComponentDefType) {
                void cdtype2;
                void cdtype1;
                ComponentDefType componentDefType2 = (ComponentDefType)cifType23;
                ComponentDefType cfr_ignored_19 = (ComponentDefType)cifType23;
                if (cdtype1.getDefinition() == cdtype2.getDefinition()) {
                    return true;
                }
                return false;
            }
        }
        if ((cifType3 = type1) instanceof ComponentType) {
            ComponentType componentType = (ComponentType)cifType3;
            ComponentType cfr_ignored_20 = (ComponentType)cifType3;
            CifType cifType24 = type2;
            if (cifType24 instanceof ComponentType) {
                void ctype2;
                void ctype1;
                ComponentType componentType2 = (ComponentType)cifType24;
                ComponentType cfr_ignored_21 = (ComponentType)cifType24;
                if (ctype1.getComponent() == ctype2.getComponent()) {
                    return true;
                }
                return false;
            }
        }
        if ((cifType2 = type1) instanceof CompInstWrapType) {
            CompInstWrapType compInstWrapType = (CompInstWrapType)cifType2;
            CompInstWrapType cfr_ignored_22 = (CompInstWrapType)cifType2;
            CifType cifType25 = type2;
            if (cifType25 instanceof CompInstWrapType) {
                void ciwtype2;
                void ciwtype1;
                CompInstWrapType compInstWrapType2 = (CompInstWrapType)cifType25;
                CompInstWrapType cfr_ignored_23 = (CompInstWrapType)cifType25;
                if (ciwtype1.getInstantiation() == ciwtype2.getInstantiation() && CifTypeUtils.areStructurallySameType(ciwtype1.getReference(), ciwtype2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((cifType = type1) instanceof CompParamWrapType) {
            CompParamWrapType compParamWrapType = (CompParamWrapType)cifType;
            CompParamWrapType cfr_ignored_24 = (CompParamWrapType)cifType;
            CifType cifType26 = type2;
            if (cifType26 instanceof CompParamWrapType) {
                void cpwType2;
                void cpwType1;
                CompParamWrapType compParamWrapType2 = (CompParamWrapType)cifType26;
                CompParamWrapType cfr_ignored_25 = (CompParamWrapType)cifType26;
                if (cpwType1.getParameter() == cpwType2.getParameter() && CifTypeUtils.areStructurallySameType(cpwType1.getReference(), cpwType2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Unexpected types: " + String.valueOf(type1) + ", " + String.valueOf(type2));
    }

    public static CifType makeTupleType(List<CifType> fieldTypes, Position position) {
        Assert.check((!fieldTypes.isEmpty() ? 1 : 0) != 0);
        if (fieldTypes.size() == 1) {
            return CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)((CifType)Lists.first(fieldTypes))), position);
        }
        TupleType tupleType = CifConstructors.newTupleType();
        tupleType.setPosition(PositionUtils.copyPosition((Position)position));
        for (CifType fieldType : fieldTypes) {
            Field field = CifConstructors.newField();
            field.setPosition(PositionUtils.copyPosition((Position)position));
            field.setType(CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)fieldType), position));
            tupleType.getFields().add((Object)field);
        }
        return tupleType;
    }

    public static CifType makeTupleTypeFromValues(List<Expression> values, Position position) {
        Assert.check((!values.isEmpty() ? 1 : 0) != 0);
        if (values.size() == 1) {
            return CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)((Expression)Lists.first(values)).getType()), position);
        }
        TupleType tupleType = CifConstructors.newTupleType();
        tupleType.setPosition(PositionUtils.copyPosition((Position)position));
        for (Expression value : values) {
            Field field = CifConstructors.newField();
            field.setPosition(PositionUtils.copyPosition((Position)position));
            field.setType(CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)value.getType()), position));
            tupleType.getFields().add((Object)field);
        }
        return tupleType;
    }

    public static FuncType makeFunctionType(Function func, Position position) {
        FuncType type = CifConstructors.newFuncType();
        type.setPosition(PositionUtils.copyPosition((Position)position));
        for (FunctionParameter param : func.getParameters()) {
            CifType paramType = param.getParameter().getType();
            type.getParamTypes().add((Object)CifTypeUtils.changePositions((CifType)EMFHelper.deepclone((EObject)paramType), position));
        }
        type.setReturnType(CifTypeUtils.makeTupleType((List<CifType>)func.getReturnTypes(), position));
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CifType> T changePositions(T type, Position position) {
        if (position == null) {
            return type;
        }
        T t = type;
        if (t instanceof BoolType) {
            void bt;
            BoolType boolType = (BoolType)t;
            BoolType cfr_ignored_0 = (BoolType)t;
            bt.setPosition(PositionUtils.copyPosition((Position)position));
        } else {
            T t2 = type;
            if (t2 instanceof RealType) {
                void rt;
                RealType realType = (RealType)t2;
                RealType cfr_ignored_1 = (RealType)t2;
                rt.setPosition(PositionUtils.copyPosition((Position)position));
            } else {
                T t3 = type;
                if (t3 instanceof StringType) {
                    void st;
                    StringType stringType = (StringType)t3;
                    StringType cfr_ignored_2 = (StringType)t3;
                    st.setPosition(PositionUtils.copyPosition((Position)position));
                } else {
                    T t4 = type;
                    if (t4 instanceof VoidType) {
                        void vt;
                        VoidType voidType = (VoidType)t4;
                        VoidType cfr_ignored_3 = (VoidType)t4;
                        vt.setPosition(PositionUtils.copyPosition((Position)position));
                    } else {
                        T t5 = type;
                        if (t5 instanceof IntType) {
                            void it;
                            IntType intType = (IntType)t5;
                            IntType cfr_ignored_4 = (IntType)t5;
                            it.setPosition(PositionUtils.copyPosition((Position)position));
                        } else {
                            T t6 = type;
                            if (t6 instanceof ListType) {
                                void lt;
                                ListType listType = (ListType)t6;
                                ListType cfr_ignored_5 = (ListType)t6;
                                lt.setPosition(PositionUtils.copyPosition((Position)position));
                                CifTypeUtils.changePositions(lt.getElementType(), position);
                            } else {
                                T t7 = type;
                                if (t7 instanceof SetType) {
                                    void st;
                                    SetType setType = (SetType)t7;
                                    SetType cfr_ignored_6 = (SetType)t7;
                                    st.setPosition(PositionUtils.copyPosition((Position)position));
                                    CifTypeUtils.changePositions(st.getElementType(), position);
                                } else {
                                    T t8 = type;
                                    if (t8 instanceof DictType) {
                                        void dt;
                                        DictType dictType = (DictType)t8;
                                        DictType cfr_ignored_7 = (DictType)t8;
                                        dt.setPosition(PositionUtils.copyPosition((Position)position));
                                        CifTypeUtils.changePositions(dt.getKeyType(), position);
                                        CifTypeUtils.changePositions(dt.getValueType(), position);
                                    } else {
                                        T t9 = type;
                                        if (t9 instanceof TupleType) {
                                            void tt;
                                            TupleType tupleType = (TupleType)t9;
                                            TupleType cfr_ignored_8 = (TupleType)t9;
                                            tt.setPosition(PositionUtils.copyPosition((Position)position));
                                            for (Field field : tt.getFields()) {
                                                field.setPosition(PositionUtils.copyPosition((Position)position));
                                                CifTypeUtils.changePositions(field.getType(), position);
                                            }
                                        } else {
                                            T t10 = type;
                                            if (t10 instanceof DistType) {
                                                void dt;
                                                DistType field = (DistType)t10;
                                                DistType cfr_ignored_9 = (DistType)t10;
                                                dt.setPosition(PositionUtils.copyPosition((Position)position));
                                                CifTypeUtils.changePositions(dt.getSampleType(), position);
                                            } else {
                                                T t11 = type;
                                                if (t11 instanceof FuncType) {
                                                    void ft;
                                                    FuncType funcType = (FuncType)t11;
                                                    FuncType cfr_ignored_10 = (FuncType)t11;
                                                    ft.setPosition(PositionUtils.copyPosition((Position)position));
                                                    CifTypeUtils.changePositions(ft.getReturnType(), position);
                                                    for (CifType pt : ft.getParamTypes()) {
                                                        CifTypeUtils.changePositions(pt, position);
                                                    }
                                                } else {
                                                    T t12 = type;
                                                    if (t12 instanceof TypeRef) {
                                                        void tr;
                                                        TypeRef pt = (TypeRef)t12;
                                                        TypeRef cfr_ignored_11 = (TypeRef)t12;
                                                        tr.setPosition(PositionUtils.copyPosition((Position)position));
                                                    } else {
                                                        T t13 = type;
                                                        if (t13 instanceof EnumType) {
                                                            void et;
                                                            EnumType enumType = (EnumType)t13;
                                                            EnumType cfr_ignored_12 = (EnumType)t13;
                                                            et.setPosition(PositionUtils.copyPosition((Position)position));
                                                        } else {
                                                            T t14 = type;
                                                            if (t14 instanceof ComponentType) {
                                                                void ct;
                                                                ComponentType componentType = (ComponentType)t14;
                                                                ComponentType cfr_ignored_13 = (ComponentType)t14;
                                                                ct.setPosition(PositionUtils.copyPosition((Position)position));
                                                            } else {
                                                                T t15 = type;
                                                                if (t15 instanceof ComponentDefType) {
                                                                    void cdt;
                                                                    ComponentDefType componentDefType = (ComponentDefType)t15;
                                                                    ComponentDefType cfr_ignored_14 = (ComponentDefType)t15;
                                                                    cdt.setPosition(PositionUtils.copyPosition((Position)position));
                                                                } else {
                                                                    T t16 = type;
                                                                    if (t16 instanceof CompParamWrapType) {
                                                                        void cpwt;
                                                                        CompParamWrapType compParamWrapType = (CompParamWrapType)t16;
                                                                        CompParamWrapType cfr_ignored_15 = (CompParamWrapType)t16;
                                                                        cpwt.setPosition(PositionUtils.copyPosition((Position)position));
                                                                        CifTypeUtils.changePositions(cpwt.getReference(), position);
                                                                    } else {
                                                                        T t17 = type;
                                                                        if (t17 instanceof CompInstWrapType) {
                                                                            void ciwt;
                                                                            CompInstWrapType compInstWrapType = (CompInstWrapType)t17;
                                                                            CompInstWrapType cfr_ignored_16 = (CompInstWrapType)t17;
                                                                            ciwt.setPosition(PositionUtils.copyPosition((Position)position));
                                                                            CifTypeUtils.changePositions(ciwt.getReference(), position);
                                                                        } else {
                                                                            throw new RuntimeException("Unexpected type: " + String.valueOf(type));
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return type;
    }

    public static CifType getVariableType(Declaration decl) {
        if (decl instanceof AlgVariable) {
            AlgVariable algVar = (AlgVariable)decl;
            return algVar.getType();
        }
        if (decl instanceof Constant) {
            Constant constant = (Constant)decl;
            return constant.getType();
        }
        if (decl instanceof ContVariable) {
            return CifConstructors.newRealType();
        }
        if (decl instanceof DiscVariable) {
            DiscVariable discVar = (DiscVariable)decl;
            return discVar.getType();
        }
        if (decl instanceof InputVariable) {
            InputVariable inputVar = (InputVariable)decl;
            return inputVar.getType();
        }
        throw new RuntimeException("Unknown variable: " + String.valueOf(decl));
    }
}

