/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.CifPackage;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.automata.AutomataPackage;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DeclarationsPackage;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifValueUtils {
    private CifValueUtils() {
    }

    public static boolean isTriviallyTrue(Expression expr, boolean initial, boolean checkRefs) {
        Object value;
        if (!CifValueUtils.hasSingleValue(expr, initial, checkRefs)) {
            return false;
        }
        try {
            value = CifEvalUtils.eval(expr, initial);
        }
        catch (CifEvalException e) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static boolean isTriviallyTrue(List<Expression> exprs, boolean initial, boolean checkRefs) {
        for (Expression expr : exprs) {
            if (CifValueUtils.isTriviallyTrue(expr, initial, checkRefs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTriviallyFalse(Expression expr, boolean initial, boolean checkRefs) {
        Object value;
        if (!CifValueUtils.hasSingleValue(expr, initial, checkRefs)) {
            return false;
        }
        try {
            value = CifEvalUtils.eval(expr, initial);
        }
        catch (CifEvalException e) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        return false;
    }

    public static boolean isTriviallyFalse(List<Expression> exprs, boolean initial, boolean checkRefs) {
        for (Expression expr : exprs) {
            if (!CifValueUtils.isTriviallyFalse(expr, initial, checkRefs)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSingleValue(Expression expr, boolean initial, boolean checkRefs) {
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof TimeExpression) {
            return initial;
        }
        if (expr instanceof CastExpression) {
            Expression child = ((CastExpression)expr).getChild();
            if (CifTypeUtils.isAutRefExpr(child)) {
                Automaton aut;
                if (!checkRefs) {
                    return false;
                }
                CifType ctype = child.getType();
                CifType nctype = CifTypeUtils.normalizeType(ctype);
                if (nctype instanceof ComponentType) {
                    Component comp = ((ComponentType)nctype).getComponent();
                    aut = CifScopeUtils.getAutomaton(comp);
                } else {
                    Assert.check((boolean)(nctype instanceof ComponentDefType));
                    ComponentDef cdef = ((ComponentDefType)nctype).getDefinition();
                    aut = CifScopeUtils.getAutomaton((Component)cdef.getBody());
                }
                return aut.getLocations().size() == 1;
            }
            CastExpression cexpr = (CastExpression)expr;
            return CifValueUtils.hasSingleValue(cexpr.getChild(), initial, checkRefs);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            if (uexpr.getOperator() == UnaryOperator.SAMPLE) {
                return false;
            }
            return CifValueUtils.hasSingleValue(uexpr.getChild(), initial, checkRefs);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            return CifValueUtils.hasSingleValue(bexpr.getLeft(), initial, checkRefs) && CifValueUtils.hasSingleValue(bexpr.getRight(), initial, checkRefs);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            boolean guardsValue = true;
            for (Expression guard : ifExpr.getGuards()) {
                boolean guardValue;
                if (!CifValueUtils.hasSingleValue(guard, initial, checkRefs)) {
                    return false;
                }
                try {
                    guardValue = (Boolean)CifEvalUtils.eval(guard, initial);
                }
                catch (CifEvalException e) {
                    return false;
                }
                boolean bl = guardsValue = guardsValue && guardValue;
            }
            if (guardsValue) {
                return CifValueUtils.hasSingleValue(ifExpr.getThen(), initial, checkRefs);
            }
            for (ElifExpression elif : ifExpr.getElifs()) {
                guardsValue = true;
                for (Expression guard : elif.getGuards()) {
                    boolean guardValue;
                    if (!CifValueUtils.hasSingleValue(guard, initial, checkRefs)) {
                        return false;
                    }
                    try {
                        guardValue = (Boolean)CifEvalUtils.eval(guard, initial);
                    }
                    catch (CifEvalException e) {
                        return false;
                    }
                    boolean bl = guardsValue = guardsValue && guardValue;
                }
                if (!guardsValue) continue;
                return CifValueUtils.hasSingleValue(elif.getThen(), initial, checkRefs);
            }
            return CifValueUtils.hasSingleValue(ifExpr.getElse(), initial, checkRefs);
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            if (CifTypeUtils.isAutRefExpr(value)) {
                Automaton aut;
                if (!checkRefs) {
                    return false;
                }
                CifType ctype = value.getType();
                CifType nctype = CifTypeUtils.normalizeType(ctype);
                if (nctype instanceof ComponentType) {
                    Component comp = ((ComponentType)nctype).getComponent();
                    aut = CifScopeUtils.getAutomaton(comp);
                } else {
                    Assert.check((boolean)(nctype instanceof ComponentDefType));
                    ComponentDef cdef = ((ComponentDefType)nctype).getDefinition();
                    aut = CifScopeUtils.getAutomaton((Component)cdef.getBody());
                }
                if (aut.getLocations().size() != 1) {
                    return false;
                }
            } else if (!CifValueUtils.hasSingleValue(value, initial, checkRefs)) {
                return false;
            }
            for (SwitchCase cse : switchExpr.getCases()) {
                if (cse.getKey() != null && !CifValueUtils.hasSingleValue(cse.getKey(), initial, checkRefs)) {
                    return false;
                }
                if (CifValueUtils.hasSingleValue(cse.getValue(), initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            if (!CifValueUtils.hasSingleValue(pexpr.getChild(), initial, checkRefs)) {
                return false;
            }
            if (pexpr.getIndex() instanceof FieldExpression) {
                return true;
            }
            return CifValueUtils.hasSingleValue(pexpr.getIndex(), initial, checkRefs);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            if (!CifValueUtils.hasSingleValue(sexpr.getChild(), initial, checkRefs)) {
                return false;
            }
            if (sexpr.getBegin() != null && !CifValueUtils.hasSingleValue(sexpr.getBegin(), initial, checkRefs)) {
                return false;
            }
            return sexpr.getEnd() == null || CifValueUtils.hasSingleValue(sexpr.getEnd(), initial, checkRefs);
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            if (fcexpr.getFunction() instanceof StdLibFunctionExpression) {
                StdLibFunctionExpression stdlib = (StdLibFunctionExpression)fcexpr.getFunction();
                StdLibFunction func = stdlib.getFunction();
                if (CifTypeUtils.isDistFunction(func)) {
                    return false;
                }
            } else {
                return false;
            }
            for (Expression arg : fcexpr.getArguments()) {
                if (CifValueUtils.hasSingleValue(arg, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.hasSingleValue(elem, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.hasSingleValue(elem, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression elem : texpr.getFields()) {
                if (CifValueUtils.hasSingleValue(elem, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.hasSingleValue(pair.getKey(), initial, checkRefs)) {
                    return false;
                }
                if (CifValueUtils.hasSingleValue(pair.getValue(), initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ConstantExpression) {
            if (!checkRefs) {
                return false;
            }
            Constant constant = ((ConstantExpression)expr).getConstant();
            return CifValueUtils.hasSingleValue(constant.getValue(), initial, checkRefs);
        }
        if (expr instanceof DiscVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            if (CifValueUtils.hasSingleValue(var.getType())) {
                return true;
            }
            if (var.eContainer() instanceof FunctionParameter) {
                return false;
            }
            if (!initial) {
                return false;
            }
            if (var.getValue() == null) {
                if (CifTypeUtils.hasFunctionType(var.getType())) {
                    return false;
                }
                return !CifTypeUtils.hasDistType(var.getType());
            }
            if (var.getValue().getValues().size() != 1) {
                return false;
            }
            Expression value = (Expression)Lists.first((List)var.getValue().getValues());
            return CifValueUtils.hasSingleValue(value, initial, checkRefs);
        }
        if (expr instanceof AlgVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = var.getValue();
            if (value != null) {
                return CifValueUtils.hasSingleValue(value, initial, checkRefs);
            }
            if (var.eContainer() instanceof Parameter) {
                return CifValueUtils.hasSingleValue(var.getType());
            }
            ComplexComponent comp = (ComplexComponent)var.eContainer();
            for (Equation eq : comp.getEquations()) {
                if (eq.getVariable() != var) continue;
                return CifValueUtils.hasSingleValue(eq.getValue(), initial, checkRefs);
            }
            return false;
        }
        if (expr instanceof ContVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            ContVariable var = cexpr.getVariable();
            boolean isDer = cexpr.isDerivative();
            if (isDer) {
                Expression der = var.getDerivative();
                if (der != null) {
                    return CifValueUtils.hasSingleValue(der, initial, checkRefs);
                }
                ComplexComponent comp = (ComplexComponent)var.eContainer();
                for (Equation eq : comp.getEquations()) {
                    if (eq.getVariable() != var) continue;
                    return CifValueUtils.hasSingleValue(eq.getValue(), initial, checkRefs);
                }
                return false;
            }
            if (!initial) {
                return false;
            }
            if (var.getValue() == null) {
                return true;
            }
            return CifValueUtils.hasSingleValue(var.getValue(), initial, checkRefs);
        }
        if (expr instanceof TauExpression) {
            throw new RuntimeException("Tau expression in value context.");
        }
        if (expr instanceof LocationExpression) {
            if (!checkRefs) {
                return false;
            }
            Location loc = ((LocationExpression)expr).getLocation();
            EObject parent = loc.eContainer();
            if (parent instanceof Parameter) {
                return false;
            }
            Automaton aut = (Automaton)parent;
            return aut.getLocations().size() == 1;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event expression in value context.");
        }
        if (expr instanceof FieldExpression) {
            String msg = "Unexpected field expr: proj expr should handle it.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            String msg = "Stdlib functions can not be used as values.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof FunctionExpression) {
            return checkRefs;
        }
        if (expr instanceof InputVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            InputVariable var = ((InputVariableExpression)expr).getVariable();
            return CifValueUtils.hasSingleValue(var.getType());
        }
        if (expr instanceof ComponentExpression) {
            return false;
        }
        if (expr instanceof CompParamExpression) {
            return false;
        }
        if (expr instanceof CompInstWrapExpression) {
            Expression rexpr = ((CompInstWrapExpression)expr).getReference();
            return CifValueUtils.hasSingleValue(rexpr, initial, checkRefs);
        }
        if (expr instanceof CompParamWrapExpression) {
            Expression rexpr = ((CompParamWrapExpression)expr).getReference();
            return CifValueUtils.hasSingleValue(rexpr, initial, checkRefs);
        }
        if (expr instanceof ReceivedExpression) {
            if (!checkRefs) {
                return false;
            }
            return CifValueUtils.hasSingleValue(expr.getType());
        }
        if (expr instanceof SelfExpression) {
            return false;
        }
        throw new RuntimeException("Unknown expr: " + String.valueOf(expr));
    }

    public static boolean hasSingleValue(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            if (CifTypeUtils.isRangeless(itype)) {
                return false;
            }
            return itype.getLower().equals(itype.getUpper());
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof VoidType) {
            return false;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            if (CifTypeUtils.isRangeless(ltype)) {
                return false;
            }
            if (!ltype.getLower().equals(ltype.getUpper())) {
                return false;
            }
            return CifValueUtils.hasSingleValue(ltype.getElementType());
        }
        if (type instanceof SetType) {
            return false;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (CifValueUtils.hasSingleValue(field.getType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof DictType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CifType rtype = ((CompInstWrapType)type).getReference();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof CompParamWrapType) {
            CifType rtype = ((CompParamWrapType)type).getReference();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return true;
        }
        if (type instanceof EnumType) {
            return ((EnumType)type).getEnum().getLiterals().size() == 1;
        }
        if (type instanceof TypeRef) {
            CifType rtype = ((TypeRef)type).getType().getType();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof FuncType) {
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }

    public static Expression getDefaultValue(CifType type, List<InternalFunction> funcs) {
        if (type instanceof BoolType) {
            return CifValueUtils.makeFalse();
        }
        if (type instanceof IntType) {
            int uDistanceToZero;
            int lDistanceToZero;
            IntType itype = (IntType)type;
            int defaultValue = CifTypeUtils.isRangeless(itype) ? 0 : (itype.getLower() <= 0 && itype.getUpper() >= 0 ? 0 : ((lDistanceToZero = Math.abs(itype.getLower())) < (uDistanceToZero = Math.abs(itype.getUpper())) ? itype.getLower() : itype.getUpper()));
            return CifValueUtils.makeInt(defaultValue);
        }
        if (type instanceof TypeRef) {
            return CifValueUtils.getDefaultValue(((TypeRef)type).getType().getType(), funcs);
        }
        if (type instanceof EnumType) {
            EnumLiteralExpression rslt = CifConstructors.newEnumLiteralExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            rslt.setLiteral((EnumLiteral)Lists.first((List)enumDecl.getLiterals()));
            return rslt;
        }
        if (type instanceof RealType) {
            RealExpression rslt = CifConstructors.newRealExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setValue("0.0");
            return rslt;
        }
        if (type instanceof StringType) {
            StringExpression rslt = CifConstructors.newStringExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setValue("");
            return rslt;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            ListExpression rslt = CifConstructors.newListExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            if (!CifTypeUtils.isRangeless(ltype)) {
                int lower = ltype.getLower();
                int i = 0;
                while (i < lower) {
                    Expression elem = CifValueUtils.getDefaultValue(ltype.getElementType(), funcs);
                    rslt.getElements().add((Object)elem);
                    ++i;
                }
            }
            return rslt;
        }
        if (type instanceof SetType) {
            SetExpression rslt = CifConstructors.newSetExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            return rslt;
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            ftype.getReturnType();
            InternalFunction function = null;
            for (InternalFunction func : funcs) {
                FuncType t = CifConstructors.newFuncType();
                CifType rt = CifTypeUtils.makeTupleType((List<CifType>)func.getReturnTypes(), null);
                t.setReturnType(rt);
                for (FunctionParameter param : func.getParameters()) {
                    CifType pt = param.getParameter().getType();
                    t.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)pt)));
                }
                if (!CifTypeUtils.checkTypeCompat((CifType)t, (CifType)ftype, RangeCompat.EQUAL)) continue;
                function = func;
                break;
            }
            if (function == null) {
                function = CifConstructors.newInternalFunction();
                int i = 0;
                while (i < ftype.getParamTypes().size()) {
                    CifType ptype = (CifType)ftype.getParamTypes().get(i);
                    DiscVariable pvar = CifConstructors.newDiscVariable();
                    pvar.setName("p" + i);
                    pvar.setType((CifType)EMFHelper.deepclone((EObject)ptype));
                    FunctionParameter param = CifConstructors.newFunctionParameter();
                    param.setParameter(pvar);
                    function.getParameters().add((Object)param);
                    ++i;
                }
                CifType rtype = ftype.getReturnType();
                function.getReturnTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)rtype)));
                Expression retValue = CifValueUtils.getDefaultValue(ftype.getReturnType(), funcs);
                ReturnFuncStatement stat = CifConstructors.newReturnFuncStatement();
                stat.getValues().add((Object)retValue);
                function.getStatements().add((Object)stat);
                funcs.add(function);
            }
            FunctionExpression rslt = CifConstructors.newFunctionExpression();
            rslt.setFunction((Function)function);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)ftype));
            return rslt;
        }
        if (type instanceof DictType) {
            DictExpression rslt = CifConstructors.newDictExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            return rslt;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            TupleExpression rslt = CifConstructors.newTupleExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            for (Field field : ttype.getFields()) {
                Expression value = CifValueUtils.getDefaultValue(field.getType(), funcs);
                rslt.getFields().add((Object)value);
            }
            return rslt;
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            FuncType ftype = CifConstructors.newFuncType();
            ftype.setReturnType((CifType)EMFHelper.deepclone((EObject)type));
            ftype.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)dtype.getSampleType())));
            StdLibFunctionExpression func = CifConstructors.newStdLibFunctionExpression();
            func.setFunction(StdLibFunction.CONSTANT);
            func.setType((CifType)ftype);
            Expression arg = CifValueUtils.getDefaultValue(dtype.getSampleType(), funcs);
            FunctionCallExpression rslt = CifConstructors.newFunctionCallExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setFunction((Expression)func);
            rslt.getArguments().add((Object)arg);
            return rslt;
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    public static boolean isInitialExpr(Expression expr) {
        Expression parent = expr;
        EStructuralFeature feat = null;
        while (parent instanceof Expression) {
            feat = parent.eContainingFeature();
            parent = parent.eContainer();
        }
        Assert.notNull(feat);
        if (parent instanceof VariableValue) {
            DiscVariable var = (DiscVariable)parent.eContainer();
            return var.eContainer() instanceof ComplexComponent;
        }
        if (parent instanceof ContVariable && feat == DeclarationsPackage.Literals.CONT_VARIABLE__VALUE) {
            return true;
        }
        if (parent instanceof ComplexComponent && feat == CifPackage.Literals.COMPLEX_COMPONENT__INITIALS) {
            return true;
        }
        return parent instanceof Location && feat == AutomataPackage.Literals.LOCATION__INITIALS;
    }

    public static boolean isTimeConstant(Expression expr, Boolean isInputVarTimeConstant) {
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof TimeExpression) {
            return false;
        }
        if (expr instanceof CastExpression) {
            CastExpression cexpr = (CastExpression)expr;
            return CifValueUtils.isTimeConstant(cexpr.getChild(), isInputVarTimeConstant);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            return CifValueUtils.isTimeConstant(uexpr.getChild(), isInputVarTimeConstant);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            return CifValueUtils.isTimeConstant(bexpr.getLeft(), isInputVarTimeConstant) && CifValueUtils.isTimeConstant(bexpr.getRight(), isInputVarTimeConstant);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            for (Expression guard : ifExpr.getGuards()) {
                if (CifValueUtils.isTimeConstant(guard, isInputVarTimeConstant)) continue;
                return false;
            }
            if (!CifValueUtils.isTimeConstant(ifExpr.getThen(), isInputVarTimeConstant)) {
                return false;
            }
            for (ElifExpression elif : ifExpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    if (CifValueUtils.isTimeConstant(guard, isInputVarTimeConstant)) continue;
                    return false;
                }
                if (CifValueUtils.isTimeConstant(elif.getThen(), isInputVarTimeConstant)) continue;
                return false;
            }
            return CifValueUtils.isTimeConstant(ifExpr.getElse(), isInputVarTimeConstant);
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            if (!CifValueUtils.isTimeConstant(switchExpr.getValue(), isInputVarTimeConstant)) {
                return false;
            }
            for (SwitchCase cse : switchExpr.getCases()) {
                if (cse.getKey() != null && !CifValueUtils.isTimeConstant(cse.getKey(), isInputVarTimeConstant)) {
                    return false;
                }
                if (CifValueUtils.isTimeConstant(cse.getValue(), isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            if (!CifValueUtils.isTimeConstant(pexpr.getChild(), isInputVarTimeConstant)) {
                return false;
            }
            if (pexpr.getIndex() instanceof FieldExpression) {
                return true;
            }
            return CifValueUtils.isTimeConstant(pexpr.getIndex(), isInputVarTimeConstant);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            if (!CifValueUtils.isTimeConstant(sexpr.getChild(), isInputVarTimeConstant)) {
                return false;
            }
            if (sexpr.getBegin() != null && !CifValueUtils.isTimeConstant(sexpr.getBegin(), isInputVarTimeConstant)) {
                return false;
            }
            return sexpr.getEnd() == null || CifValueUtils.isTimeConstant(sexpr.getEnd(), isInputVarTimeConstant);
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            if (!(fcexpr.getFunction() instanceof StdLibFunctionExpression) && !CifValueUtils.isTimeConstant(fcexpr.getFunction(), isInputVarTimeConstant)) {
                return false;
            }
            for (Expression arg : fcexpr.getArguments()) {
                if (CifValueUtils.isTimeConstant(arg, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.isTimeConstant(elem, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.isTimeConstant(elem, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression elem : texpr.getFields()) {
                if (CifValueUtils.isTimeConstant(elem, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.isTimeConstant(pair.getKey(), isInputVarTimeConstant)) {
                    return false;
                }
                if (CifValueUtils.isTimeConstant(pair.getValue(), isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ConstantExpression) {
            return true;
        }
        if (expr instanceof DiscVariableExpression) {
            return true;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = var.getValue();
            if (value != null) {
                return CifValueUtils.isTimeConstant(value, isInputVarTimeConstant);
            }
            if (var.eContainer() instanceof Parameter) {
                throw new RuntimeException("unsupported alg param: " + String.valueOf(var));
            }
            List<Expression> values = CifEquationUtils.getValuesForAlgVar(var, false);
            for (Expression val : values) {
                if (CifValueUtils.isTimeConstant(val, isInputVarTimeConstant)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            if (cexpr.isDerivative()) {
                ContVariable var = cexpr.getVariable();
                Expression deriv = var.getDerivative();
                if (deriv != null) {
                    return CifValueUtils.isTimeConstant(deriv, isInputVarTimeConstant);
                }
                List<Expression> derivs = CifEquationUtils.getDerivativesForContVar(var, false);
                for (Expression d : derivs) {
                    if (CifValueUtils.isTimeConstant(d, isInputVarTimeConstant)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expr instanceof TauExpression) {
            throw new RuntimeException("Tau expression in value context.");
        }
        if (expr instanceof LocationExpression) {
            return true;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event expression in value context.");
        }
        if (expr instanceof FieldExpression) {
            String msg = "Unexpected field expr: proj expr should handle it.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            String msg = "Stdlib functions can not be used as values.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof FunctionExpression) {
            return true;
        }
        if (expr instanceof InputVariableExpression) {
            return isInputVarTimeConstant;
        }
        if (expr instanceof ComponentExpression) {
            return true;
        }
        if (expr instanceof CompParamExpression) {
            return true;
        }
        if (expr instanceof CompInstWrapExpression) {
            Expression rexpr = ((CompInstWrapExpression)expr).getReference();
            return CifValueUtils.isTimeConstant(rexpr, isInputVarTimeConstant);
        }
        if (expr instanceof CompParamWrapExpression) {
            Expression rexpr = ((CompParamWrapExpression)expr).getReference();
            return CifValueUtils.isTimeConstant(rexpr, isInputVarTimeConstant);
        }
        if (expr instanceof ReceivedExpression) {
            return true;
        }
        if (expr instanceof SelfExpression) {
            return true;
        }
        throw new RuntimeException("Unknown expr: " + String.valueOf(expr));
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean areStructurallySameExpression(Expression expr1, Expression expr2) {
        Expression expression;
        Expression expression2;
        Expression expression3;
        Expression expression4;
        Expression expression5;
        Expression expression6;
        Expression expression7;
        Expression expression8;
        Expression expression9;
        Expression expression10;
        Expression expression11;
        Expression expression12;
        Expression expression13;
        Expression expression14;
        Expression expression15;
        Expression expression16;
        Expression expression17;
        Expression expression18;
        Expression expression19;
        Expression expression20;
        Expression expression21;
        Expression expression22;
        Expression expression23;
        Expression expression24;
        Expression expression25;
        Expression expression26;
        Expression expression27;
        Expression expression28;
        if (!expr1.getClass().equals(expr2.getClass())) {
            return false;
        }
        Expression expression29 = expr1;
        if (expression29 instanceof BoolExpression) {
            BoolExpression boolExpression = (BoolExpression)expression29;
            BoolExpression cfr_ignored_0 = (BoolExpression)expression29;
            Expression expression30 = expr2;
            if (expression30 instanceof BoolExpression) {
                void bexpr2;
                void bexpr1;
                BoolExpression boolExpression2 = (BoolExpression)expression30;
                BoolExpression cfr_ignored_1 = (BoolExpression)expression30;
                if (bexpr1.isValue() == bexpr2.isValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression28 = expr1) instanceof IntExpression) {
            IntExpression intExpression = (IntExpression)expression28;
            IntExpression cfr_ignored_2 = (IntExpression)expression28;
            Expression expression31 = expr2;
            if (expression31 instanceof IntExpression) {
                void iexpr2;
                void iexpr1;
                IntExpression intExpression2 = (IntExpression)expression31;
                IntExpression cfr_ignored_3 = (IntExpression)expression31;
                if (iexpr1.getValue() == iexpr2.getValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression27 = expr1) instanceof RealExpression) {
            RealExpression realExpression = (RealExpression)expression27;
            RealExpression cfr_ignored_4 = (RealExpression)expression27;
            Expression expression32 = expr2;
            if (expression32 instanceof RealExpression) {
                void rexpr2;
                void rExpr1;
                RealExpression realExpression2 = (RealExpression)expression32;
                RealExpression cfr_ignored_5 = (RealExpression)expression32;
                return rExpr1.getValue().equals(rexpr2.getValue());
            }
        }
        if ((expression26 = expr1) instanceof StringExpression) {
            StringExpression stringExpression = (StringExpression)expression26;
            StringExpression cfr_ignored_6 = (StringExpression)expression26;
            Expression expression33 = expr2;
            if (expression33 instanceof StringExpression) {
                void sexpr2;
                void sexpr1;
                StringExpression stringExpression2 = (StringExpression)expression33;
                StringExpression cfr_ignored_7 = (StringExpression)expression33;
                return sexpr1.getValue().equals(sexpr2.getValue());
            }
        }
        if (expr1 instanceof TimeExpression && expr2 instanceof TimeExpression) {
            return true;
        }
        Expression expression34 = expr1;
        if (expression34 instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)expression34;
            CastExpression cfr_ignored_8 = (CastExpression)expression34;
            Expression expression35 = expr2;
            if (expression35 instanceof CastExpression) {
                void cexpr2;
                void cexpr1;
                CastExpression castExpression2 = (CastExpression)expression35;
                CastExpression cfr_ignored_9 = (CastExpression)expression35;
                if (!CifValueUtils.areStructurallySameExpression(cexpr1.getChild(), cexpr2.getChild()).booleanValue()) {
                    return false;
                }
                return CifTypeUtils.areStructurallySameType(cexpr1.getType(), cexpr2.getType());
            }
        }
        if ((expression25 = expr1) instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression25;
            UnaryExpression cfr_ignored_10 = (UnaryExpression)expression25;
            Expression expression36 = expr2;
            if (expression36 instanceof UnaryExpression) {
                void uexpr2;
                void uexpr1;
                UnaryExpression unaryExpression2 = (UnaryExpression)expression36;
                UnaryExpression cfr_ignored_11 = (UnaryExpression)expression36;
                if (uexpr1.getOperator() == uexpr2.getOperator() && CifValueUtils.areStructurallySameExpression(uexpr1.getChild(), uexpr2.getChild()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression24 = expr1) instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression24;
            BinaryExpression cfr_ignored_12 = (BinaryExpression)expression24;
            Expression expression37 = expr2;
            if (expression37 instanceof BinaryExpression) {
                void bexpr2;
                void bexpr1;
                BinaryExpression binaryExpression2 = (BinaryExpression)expression37;
                BinaryExpression cfr_ignored_13 = (BinaryExpression)expression37;
                if (bexpr1.getOperator() == bexpr2.getOperator() && CifValueUtils.areStructurallySameExpression(bexpr1.getLeft(), bexpr2.getLeft()).booleanValue() && CifValueUtils.areStructurallySameExpression(bexpr1.getRight(), bexpr2.getRight()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression23 = expr1) instanceof IfExpression) {
            IfExpression ifExpression = (IfExpression)expression23;
            IfExpression cfr_ignored_14 = (IfExpression)expression23;
            Expression expression38 = expr2;
            if (expression38 instanceof IfExpression) {
                void iexpr2;
                void iexpr1;
                IfExpression ifExpression2 = (IfExpression)expression38;
                IfExpression cfr_ignored_15 = (IfExpression)expression38;
                if (iexpr1.getGuards().size() != iexpr2.getGuards().size()) {
                    return false;
                }
                int i = 0;
                while (i < iexpr1.getGuards().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)iexpr1.getGuards().get(i), (Expression)iexpr2.getGuards().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                if (!CifValueUtils.areStructurallySameExpression(iexpr1.getThen(), iexpr2.getThen()).booleanValue()) {
                    return false;
                }
                if (iexpr1.getElifs().size() != iexpr2.getElifs().size()) {
                    return false;
                }
                i = 0;
                while (i < iexpr1.getElifs().size()) {
                    ElifExpression elif1 = (ElifExpression)iexpr1.getElifs().get(i);
                    ElifExpression elif2 = (ElifExpression)iexpr2.getElifs().get(i);
                    if (elif1.getGuards().size() != elif2.getGuards().size()) {
                        return false;
                    }
                    int j = 0;
                    while (j < elif1.getGuards().size()) {
                        if (!CifValueUtils.areStructurallySameExpression((Expression)elif1.getGuards().get(j), (Expression)elif2.getGuards().get(j)).booleanValue()) {
                            return false;
                        }
                        ++j;
                    }
                    if (!CifValueUtils.areStructurallySameExpression(elif1.getThen(), elif2.getThen()).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                if (!CifValueUtils.areStructurallySameExpression(iexpr1.getElse(), iexpr2.getElse()).booleanValue()) {
                    return false;
                }
                return true;
            }
        }
        if ((expression22 = expr1) instanceof SwitchExpression) {
            SwitchExpression i = (SwitchExpression)expression22;
            SwitchExpression cfr_ignored_16 = (SwitchExpression)expression22;
            Expression expression39 = expr2;
            if (expression39 instanceof SwitchExpression) {
                void sexpr2;
                void sexpr1;
                SwitchExpression elif1 = (SwitchExpression)expression39;
                SwitchExpression cfr_ignored_17 = (SwitchExpression)expression39;
                if (!CifValueUtils.areStructurallySameExpression(sexpr1.getValue(), sexpr2.getValue()).booleanValue()) {
                    return false;
                }
                if (sexpr1.getCases().size() != sexpr2.getCases().size()) {
                    return false;
                }
                int i2 = 0;
                while (i2 < sexpr1.getCases().size()) {
                    SwitchCase switchCase1 = (SwitchCase)sexpr1.getCases().get(i2);
                    SwitchCase switchCase2 = (SwitchCase)sexpr2.getCases().get(i2);
                    if (switchCase1.getKey() == null != (switchCase2.getKey() == null)) {
                        return false;
                    }
                    if (switchCase1.getKey() != null && !CifValueUtils.areStructurallySameExpression(switchCase1.getKey(), switchCase2.getKey()).booleanValue()) {
                        return false;
                    }
                    if (!CifValueUtils.areStructurallySameExpression(switchCase1.getValue(), switchCase2.getValue()).booleanValue()) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
        }
        if ((expression21 = expr1) instanceof ProjectionExpression) {
            ProjectionExpression i2 = (ProjectionExpression)expression21;
            ProjectionExpression cfr_ignored_18 = (ProjectionExpression)expression21;
            Expression expression40 = expr2;
            if (expression40 instanceof ProjectionExpression) {
                void pexpr2;
                void pexpr1;
                ProjectionExpression switchCase1 = (ProjectionExpression)expression40;
                ProjectionExpression cfr_ignored_19 = (ProjectionExpression)expression40;
                if (CifValueUtils.areStructurallySameExpression(pexpr1.getChild(), pexpr2.getChild()).booleanValue() && CifValueUtils.areStructurallySameExpression(pexpr1.getIndex(), pexpr2.getIndex()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression20 = expr1) instanceof SliceExpression) {
            SliceExpression sliceExpression = (SliceExpression)expression20;
            SliceExpression cfr_ignored_20 = (SliceExpression)expression20;
            Expression expression41 = expr2;
            if (expression41 instanceof SliceExpression) {
                void sexpr2;
                void sexpr1;
                SliceExpression sliceExpression2 = (SliceExpression)expression41;
                SliceExpression cfr_ignored_21 = (SliceExpression)expression41;
                if (sexpr1.getBegin() == null != (sexpr2.getBegin() == null)) {
                    return false;
                }
                if (sexpr1.getBegin() != null && !CifValueUtils.areStructurallySameExpression(sexpr1.getBegin(), sexpr2.getBegin()).booleanValue()) {
                    return false;
                }
                if (sexpr1.getEnd() == null != (sexpr2.getEnd() == null)) {
                    return false;
                }
                if (sexpr1.getEnd() != null && !CifValueUtils.areStructurallySameExpression(sexpr1.getEnd(), sexpr2.getEnd()).booleanValue()) {
                    return false;
                }
                return CifValueUtils.areStructurallySameExpression(sexpr1.getChild(), sexpr2.getChild());
            }
        }
        if ((expression19 = expr1) instanceof FunctionCallExpression) {
            FunctionCallExpression functionCallExpression = (FunctionCallExpression)expression19;
            FunctionCallExpression cfr_ignored_22 = (FunctionCallExpression)expression19;
            Expression expression42 = expr2;
            if (expression42 instanceof FunctionCallExpression) {
                void fcexpr2;
                void fcexpr1;
                FunctionCallExpression functionCallExpression2 = (FunctionCallExpression)expression42;
                FunctionCallExpression cfr_ignored_23 = (FunctionCallExpression)expression42;
                if (!CifValueUtils.areStructurallySameExpression(fcexpr1.getFunction(), fcexpr2.getFunction()).booleanValue()) {
                    return false;
                }
                int i = 0;
                while (i < fcexpr1.getArguments().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)fcexpr1.getArguments().get(i), (Expression)fcexpr2.getArguments().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if ((expression18 = expr1) instanceof ListExpression) {
            ListExpression i = (ListExpression)expression18;
            ListExpression cfr_ignored_24 = (ListExpression)expression18;
            Expression expression43 = expr2;
            if (expression43 instanceof ListExpression) {
                void lexpr2;
                void lexpr1;
                ListExpression listExpression = (ListExpression)expression43;
                ListExpression cfr_ignored_25 = (ListExpression)expression43;
                if (lexpr1.getElements().size() != lexpr2.getElements().size()) {
                    return false;
                }
                int i3 = 0;
                while (i3 < lexpr1.getElements().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)lexpr1.getElements().get(i3), (Expression)lexpr2.getElements().get(i3)).booleanValue()) {
                        return false;
                    }
                    ++i3;
                }
                return true;
            }
        }
        if ((expression17 = expr1) instanceof SetExpression) {
            SetExpression i3 = (SetExpression)expression17;
            SetExpression cfr_ignored_26 = (SetExpression)expression17;
            Expression expression44 = expr2;
            if (expression44 instanceof SetExpression) {
                void sexpr2;
                void sexpr1;
                SetExpression setExpression = (SetExpression)expression44;
                SetExpression cfr_ignored_27 = (SetExpression)expression44;
                if (sexpr1.getElements().size() != sexpr2.getElements().size()) {
                    return false;
                }
                int i = 0;
                while (i < sexpr1.getElements().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)sexpr1.getElements().get(i), (Expression)sexpr2.getElements().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if ((expression16 = expr1) instanceof TupleExpression) {
            TupleExpression i = (TupleExpression)expression16;
            TupleExpression cfr_ignored_28 = (TupleExpression)expression16;
            Expression expression45 = expr2;
            if (expression45 instanceof TupleExpression) {
                void texpr2;
                void texpr1;
                TupleExpression tupleExpression = (TupleExpression)expression45;
                TupleExpression cfr_ignored_29 = (TupleExpression)expression45;
                if (texpr1.getFields().size() != texpr2.getFields().size()) {
                    return false;
                }
                int i4 = 0;
                while (i4 < texpr1.getFields().size()) {
                    if (!CifValueUtils.areStructurallySameExpression((Expression)texpr1.getFields().get(i4), (Expression)texpr2.getFields().get(i4)).booleanValue()) {
                        return false;
                    }
                    ++i4;
                }
                return true;
            }
        }
        if ((expression15 = expr1) instanceof DictExpression) {
            DictExpression i4 = (DictExpression)expression15;
            DictExpression cfr_ignored_30 = (DictExpression)expression15;
            Expression expression46 = expr2;
            if (expression46 instanceof DictExpression) {
                void dexpr2;
                void dexpr1;
                DictExpression dictExpression = (DictExpression)expression46;
                DictExpression cfr_ignored_31 = (DictExpression)expression46;
                if (dexpr1.getPairs().size() != dexpr2.getPairs().size()) {
                    return false;
                }
                int i = 0;
                while (i < dexpr1.getPairs().size()) {
                    DictPair dictPair1 = (DictPair)dexpr1.getPairs().get(i);
                    DictPair dictPair2 = (DictPair)dexpr2.getPairs().get(i);
                    if (!CifValueUtils.areStructurallySameExpression(dictPair1.getKey(), dictPair2.getKey()).booleanValue() || !CifValueUtils.areStructurallySameExpression(dictPair1.getValue(), dictPair2.getValue()).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if ((expression14 = expr1) instanceof ConstantExpression) {
            ConstantExpression i = (ConstantExpression)expression14;
            ConstantExpression cfr_ignored_32 = (ConstantExpression)expression14;
            Expression expression47 = expr2;
            if (expression47 instanceof ConstantExpression) {
                void cexpr2;
                void cexpr1;
                ConstantExpression dictPair1 = (ConstantExpression)expression47;
                ConstantExpression cfr_ignored_33 = (ConstantExpression)expression47;
                if (cexpr1.getConstant() == cexpr2.getConstant()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression13 = expr1) instanceof DiscVariableExpression) {
            DiscVariableExpression discVariableExpression = (DiscVariableExpression)expression13;
            DiscVariableExpression cfr_ignored_34 = (DiscVariableExpression)expression13;
            Expression expression48 = expr2;
            if (expression48 instanceof DiscVariableExpression) {
                void dexpr2;
                void dexpr1;
                DiscVariableExpression discVariableExpression2 = (DiscVariableExpression)expression48;
                DiscVariableExpression cfr_ignored_35 = (DiscVariableExpression)expression48;
                if (dexpr1.getVariable() == dexpr2.getVariable()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression12 = expr1) instanceof AlgVariableExpression) {
            AlgVariableExpression algVariableExpression = (AlgVariableExpression)expression12;
            AlgVariableExpression cfr_ignored_36 = (AlgVariableExpression)expression12;
            Expression expression49 = expr2;
            if (expression49 instanceof AlgVariableExpression) {
                void aexpr2;
                void aexpr1;
                AlgVariableExpression algVariableExpression2 = (AlgVariableExpression)expression49;
                AlgVariableExpression cfr_ignored_37 = (AlgVariableExpression)expression49;
                if (aexpr1.getVariable() == aexpr2.getVariable()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression11 = expr1) instanceof ContVariableExpression) {
            ContVariableExpression contVariableExpression = (ContVariableExpression)expression11;
            ContVariableExpression cfr_ignored_38 = (ContVariableExpression)expression11;
            Expression expression50 = expr2;
            if (expression50 instanceof ContVariableExpression) {
                void cexpr2;
                void cexpr1;
                ContVariableExpression contVariableExpression2 = (ContVariableExpression)expression50;
                ContVariableExpression cfr_ignored_39 = (ContVariableExpression)expression50;
                if (cexpr1.getVariable() == cexpr2.getVariable() && cexpr1.isDerivative() == cexpr2.isDerivative()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof TauExpression && expr2 instanceof TauExpression) {
            return true;
        }
        Expression expression51 = expr1;
        if (expression51 instanceof LocationExpression) {
            LocationExpression locationExpression = (LocationExpression)expression51;
            LocationExpression cfr_ignored_40 = (LocationExpression)expression51;
            Expression expression52 = expr2;
            if (expression52 instanceof LocationExpression) {
                void lexpr2;
                void lexpr1;
                LocationExpression locationExpression2 = (LocationExpression)expression52;
                LocationExpression cfr_ignored_41 = (LocationExpression)expression52;
                if (lexpr1.getLocation() == lexpr2.getLocation()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression10 = expr1) instanceof EnumLiteralExpression) {
            EnumLiteralExpression enumLiteralExpression = (EnumLiteralExpression)expression10;
            EnumLiteralExpression cfr_ignored_42 = (EnumLiteralExpression)expression10;
            Expression expression53 = expr2;
            if (expression53 instanceof EnumLiteralExpression) {
                void elexpr2;
                void elexpr1;
                EnumLiteralExpression enumLiteralExpression2 = (EnumLiteralExpression)expression53;
                EnumLiteralExpression cfr_ignored_43 = (EnumLiteralExpression)expression53;
                if (elexpr1.getLiteral() == elexpr2.getLiteral()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression9 = expr1) instanceof EventExpression) {
            EventExpression eventExpression = (EventExpression)expression9;
            EventExpression cfr_ignored_44 = (EventExpression)expression9;
            Expression expression54 = expr2;
            if (expression54 instanceof EventExpression) {
                void eexpr2;
                void eexpr1;
                EventExpression eventExpression2 = (EventExpression)expression54;
                EventExpression cfr_ignored_45 = (EventExpression)expression54;
                if (eexpr1.getEvent() == eexpr2.getEvent()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression8 = expr1) instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression8;
            FieldExpression cfr_ignored_46 = (FieldExpression)expression8;
            Expression expression55 = expr2;
            if (expression55 instanceof FieldExpression) {
                void fexpr2;
                void fexpr1;
                FieldExpression fieldExpression2 = (FieldExpression)expression55;
                FieldExpression cfr_ignored_47 = (FieldExpression)expression55;
                return Objects.equals(fexpr1.getField().getName(), fexpr2.getField().getName());
            }
        }
        if ((expression7 = expr1) instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression stdLibFunctionExpression = (StdLibFunctionExpression)expression7;
            StdLibFunctionExpression cfr_ignored_48 = (StdLibFunctionExpression)expression7;
            Expression expression56 = expr2;
            if (expression56 instanceof StdLibFunctionExpression) {
                void slfexpr2;
                void slfexpr1;
                StdLibFunctionExpression stdLibFunctionExpression2 = (StdLibFunctionExpression)expression56;
                StdLibFunctionExpression cfr_ignored_49 = (StdLibFunctionExpression)expression56;
                if (slfexpr1.getFunction() == slfexpr2.getFunction()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression6 = expr1) instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression6;
            FunctionExpression cfr_ignored_50 = (FunctionExpression)expression6;
            Expression expression57 = expr2;
            if (expression57 instanceof FunctionExpression) {
                void fexpr2;
                void fexpr1;
                FunctionExpression functionExpression2 = (FunctionExpression)expression57;
                FunctionExpression cfr_ignored_51 = (FunctionExpression)expression57;
                if (fexpr1.getFunction() == fexpr2.getFunction()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression5 = expr1) instanceof InputVariableExpression) {
            InputVariableExpression inputVariableExpression = (InputVariableExpression)expression5;
            InputVariableExpression cfr_ignored_52 = (InputVariableExpression)expression5;
            Expression expression58 = expr2;
            if (expression58 instanceof InputVariableExpression) {
                void ivexpr2;
                void ivexpr1;
                InputVariableExpression inputVariableExpression2 = (InputVariableExpression)expression58;
                InputVariableExpression cfr_ignored_53 = (InputVariableExpression)expression58;
                if (ivexpr1.getVariable() == ivexpr2.getVariable()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression4 = expr1) instanceof ComponentExpression) {
            ComponentExpression componentExpression = (ComponentExpression)expression4;
            ComponentExpression cfr_ignored_54 = (ComponentExpression)expression4;
            Expression expression59 = expr2;
            if (expression59 instanceof ComponentExpression) {
                void cexpr2;
                void cexpr1;
                ComponentExpression componentExpression2 = (ComponentExpression)expression59;
                ComponentExpression cfr_ignored_55 = (ComponentExpression)expression59;
                if (cexpr1.getComponent() == cexpr2.getComponent()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression3 = expr1) instanceof CompParamExpression) {
            CompParamExpression compParamExpression = (CompParamExpression)expression3;
            CompParamExpression cfr_ignored_56 = (CompParamExpression)expression3;
            Expression expression60 = expr2;
            if (expression60 instanceof CompParamExpression) {
                void cexpr2;
                void cexpr1;
                CompParamExpression compParamExpression2 = (CompParamExpression)expression60;
                CompParamExpression cfr_ignored_57 = (CompParamExpression)expression60;
                if (cexpr1.getParameter() == cexpr2.getParameter()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression2 = expr1) instanceof CompInstWrapExpression) {
            CompInstWrapExpression compInstWrapExpression = (CompInstWrapExpression)expression2;
            CompInstWrapExpression cfr_ignored_58 = (CompInstWrapExpression)expression2;
            Expression expression61 = expr2;
            if (expression61 instanceof CompInstWrapExpression) {
                void ciwexpr2;
                void ciwexpr1;
                CompInstWrapExpression compInstWrapExpression2 = (CompInstWrapExpression)expression61;
                CompInstWrapExpression cfr_ignored_59 = (CompInstWrapExpression)expression61;
                if (ciwexpr1.getInstantiation() == ciwexpr2.getInstantiation() && CifValueUtils.areStructurallySameExpression(ciwexpr1.getReference(), ciwexpr2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if ((expression = expr1) instanceof CompParamWrapExpression) {
            CompParamWrapExpression compParamWrapExpression = (CompParamWrapExpression)expression;
            CompParamWrapExpression cfr_ignored_60 = (CompParamWrapExpression)expression;
            Expression expression62 = expr2;
            if (expression62 instanceof CompParamWrapExpression) {
                void cpwexpr2;
                void cpwexpr1;
                CompParamWrapExpression compParamWrapExpression2 = (CompParamWrapExpression)expression62;
                CompParamWrapExpression cfr_ignored_61 = (CompParamWrapExpression)expression62;
                if (cpwexpr1.getParameter() == cpwexpr2.getParameter() && CifValueUtils.areStructurallySameExpression(cpwexpr1.getReference(), cpwexpr2.getReference()).booleanValue()) {
                    return true;
                }
                return false;
            }
        }
        if (expr1 instanceof ReceivedExpression && expr2 instanceof ReceivedExpression) {
            return true;
        }
        if (expr1 instanceof SelfExpression && expr2 instanceof SelfExpression) {
            return CifScopeUtils.getScope((PositionObject)expr1).equals(CifScopeUtils.getScope((PositionObject)expr2));
        }
        throw new RuntimeException("Unexpected expressions: " + String.valueOf(expr1) + ", " + String.valueOf(expr2));
    }

    /*
     * WARNING - void declaration
     */
    public static int hashExpr(Expression expr) {
        Expression expression = expr;
        if (expression instanceof BoolExpression) {
            void bExpr;
            BoolExpression boolExpression = (BoolExpression)expression;
            BoolExpression cfr_ignored_0 = (BoolExpression)expression;
            return bExpr.isValue() ? 1231 : 1237;
        }
        Expression expression2 = expr;
        if (expression2 instanceof IntExpression) {
            void iExpr;
            IntExpression intExpression = (IntExpression)expression2;
            IntExpression cfr_ignored_1 = (IntExpression)expression2;
            return iExpr.getValue();
        }
        Expression expression3 = expr;
        if (expression3 instanceof RealExpression) {
            void rExpr;
            RealExpression realExpression = (RealExpression)expression3;
            RealExpression cfr_ignored_2 = (RealExpression)expression3;
            return rExpr.getValue().hashCode();
        }
        Expression expression4 = expr;
        if (expression4 instanceof StringExpression) {
            void sExpr;
            StringExpression stringExpression = (StringExpression)expression4;
            StringExpression cfr_ignored_3 = (StringExpression)expression4;
            return sExpr.getValue().hashCode();
        }
        Expression expression5 = expr;
        if (expression5 instanceof TimeExpression) {
            TimeExpression timeExpression = (TimeExpression)expression5;
            TimeExpression cfr_ignored_4 = (TimeExpression)expression5;
            return 1;
        }
        Expression expression6 = expr;
        if (expression6 instanceof CastExpression) {
            void cExpr;
            CastExpression castExpression = (CastExpression)expression6;
            CastExpression cfr_ignored_5 = (CastExpression)expression6;
            return CifTypeUtils.hashType(cExpr.getType()) + CifValueUtils.hashExpr(cExpr.getChild());
        }
        Expression expression7 = expr;
        if (expression7 instanceof UnaryExpression) {
            void uExpr;
            UnaryExpression unaryExpression = (UnaryExpression)expression7;
            UnaryExpression cfr_ignored_6 = (UnaryExpression)expression7;
            return uExpr.getOperator().hashCode() + CifValueUtils.hashExpr(uExpr.getChild());
        }
        Expression expression8 = expr;
        if (expression8 instanceof BinaryExpression) {
            void bExpr;
            BinaryExpression binaryExpression = (BinaryExpression)expression8;
            BinaryExpression cfr_ignored_7 = (BinaryExpression)expression8;
            return CifValueUtils.hashExpr(bExpr.getLeft()) + bExpr.getOperator().hashCode() + CifValueUtils.hashExpr(bExpr.getRight());
        }
        Expression expression9 = expr;
        if (expression9 instanceof IfExpression) {
            void iExpr;
            IfExpression ifExpression = (IfExpression)expression9;
            IfExpression cfr_ignored_8 = (IfExpression)expression9;
            int rslt = 8;
            for (Expression guard : iExpr.getGuards()) {
                rslt += CifValueUtils.hashExpr(guard);
            }
            rslt += CifValueUtils.hashExpr(iExpr.getThen());
            for (ElifExpression elifExpr : iExpr.getElifs()) {
                for (Expression guard : elifExpr.getGuards()) {
                    rslt += CifValueUtils.hashExpr(guard);
                }
                rslt += CifValueUtils.hashExpr(elifExpr.getThen());
            }
            return rslt += CifValueUtils.hashExpr(iExpr.getElse());
        }
        Expression expression10 = expr;
        if (expression10 instanceof SwitchExpression) {
            void sExpr;
            SwitchExpression rslt = (SwitchExpression)expression10;
            SwitchExpression cfr_ignored_9 = (SwitchExpression)expression10;
            int rslt2 = 64;
            rslt2 += CifValueUtils.hashExpr(sExpr.getValue());
            for (SwitchCase sCase : sExpr.getCases()) {
                if (sCase.getKey() != null) {
                    rslt2 += CifValueUtils.hashExpr(sCase.getKey());
                }
                rslt2 += CifValueUtils.hashExpr(sCase.getValue());
            }
            return rslt2;
        }
        Expression expression11 = expr;
        if (expression11 instanceof ProjectionExpression) {
            void pExpr;
            ProjectionExpression rslt2 = (ProjectionExpression)expression11;
            ProjectionExpression cfr_ignored_10 = (ProjectionExpression)expression11;
            return CifValueUtils.hashExpr(pExpr.getChild()) + CifValueUtils.hashExpr(pExpr.getIndex());
        }
        Expression expression12 = expr;
        if (expression12 instanceof SliceExpression) {
            void sExpr;
            SliceExpression sliceExpression = (SliceExpression)expression12;
            SliceExpression cfr_ignored_11 = (SliceExpression)expression12;
            int rslt = CifValueUtils.hashExpr(sExpr.getChild());
            if (sExpr.getBegin() != null) {
                rslt += CifValueUtils.hashExpr(sExpr.getBegin());
            }
            if (sExpr.getEnd() != null) {
                rslt += CifValueUtils.hashExpr(sExpr.getEnd());
            }
            return rslt;
        }
        Expression expression13 = expr;
        if (expression13 instanceof FunctionCallExpression) {
            void fcExpr;
            FunctionCallExpression rslt = (FunctionCallExpression)expression13;
            FunctionCallExpression cfr_ignored_12 = (FunctionCallExpression)expression13;
            int rslt3 = 512;
            rslt3 += CifValueUtils.hashExpr(fcExpr.getFunction());
            for (Expression argument : fcExpr.getArguments()) {
                rslt3 += CifValueUtils.hashExpr(argument);
            }
            return rslt3;
        }
        Expression expression14 = expr;
        if (expression14 instanceof ListExpression) {
            void lExpr;
            ListExpression rslt3 = (ListExpression)expression14;
            ListExpression cfr_ignored_13 = (ListExpression)expression14;
            int rslt = 4096;
            for (Expression element : lExpr.getElements()) {
                rslt += CifValueUtils.hashExpr(element);
            }
            return rslt;
        }
        Expression expression15 = expr;
        if (expression15 instanceof SetExpression) {
            void sExpr;
            SetExpression rslt = (SetExpression)expression15;
            SetExpression cfr_ignored_14 = (SetExpression)expression15;
            int rslt4 = 32768;
            for (Expression element : sExpr.getElements()) {
                rslt4 += CifValueUtils.hashExpr(element);
            }
            return rslt4;
        }
        Expression expression16 = expr;
        if (expression16 instanceof TupleExpression) {
            void tExpr;
            TupleExpression rslt4 = (TupleExpression)expression16;
            TupleExpression cfr_ignored_15 = (TupleExpression)expression16;
            int rslt = 262144;
            for (Expression field : tExpr.getFields()) {
                rslt += CifValueUtils.hashExpr(field);
            }
            return rslt;
        }
        Expression expression17 = expr;
        if (expression17 instanceof DictExpression) {
            void dExpr;
            DictExpression rslt = (DictExpression)expression17;
            DictExpression cfr_ignored_16 = (DictExpression)expression17;
            int rslt5 = 0x200000;
            for (DictPair pair : dExpr.getPairs()) {
                rslt5 += CifValueUtils.hashExpr(pair.getKey()) + CifValueUtils.hashExpr(pair.getValue());
            }
            return rslt5;
        }
        Expression expression18 = expr;
        if (expression18 instanceof ConstantExpression) {
            void cExpr;
            ConstantExpression rslt5 = (ConstantExpression)expression18;
            ConstantExpression cfr_ignored_17 = (ConstantExpression)expression18;
            return cExpr.getConstant().hashCode();
        }
        Expression expression19 = expr;
        if (expression19 instanceof DiscVariableExpression) {
            void dvExpr;
            DiscVariableExpression discVariableExpression = (DiscVariableExpression)expression19;
            DiscVariableExpression cfr_ignored_18 = (DiscVariableExpression)expression19;
            return dvExpr.getVariable().hashCode();
        }
        Expression expression20 = expr;
        if (expression20 instanceof AlgVariableExpression) {
            void aExpr;
            AlgVariableExpression algVariableExpression = (AlgVariableExpression)expression20;
            AlgVariableExpression cfr_ignored_19 = (AlgVariableExpression)expression20;
            return aExpr.getVariable().hashCode();
        }
        Expression expression21 = expr;
        if (expression21 instanceof ContVariableExpression) {
            void cExpr;
            ContVariableExpression contVariableExpression = (ContVariableExpression)expression21;
            ContVariableExpression cfr_ignored_20 = (ContVariableExpression)expression21;
            return cExpr.getVariable().hashCode() + (cExpr.isDerivative() ? 1231 : 1237);
        }
        if (expr instanceof TauExpression) {
            return 0x1000000;
        }
        Expression expression22 = expr;
        if (expression22 instanceof LocationExpression) {
            void lExpr;
            LocationExpression locationExpression = (LocationExpression)expression22;
            LocationExpression cfr_ignored_21 = (LocationExpression)expression22;
            return lExpr.getLocation().hashCode();
        }
        Expression expression23 = expr;
        if (expression23 instanceof EnumLiteralExpression) {
            void elExpr;
            EnumLiteralExpression enumLiteralExpression = (EnumLiteralExpression)expression23;
            EnumLiteralExpression cfr_ignored_22 = (EnumLiteralExpression)expression23;
            return elExpr.getLiteral().hashCode();
        }
        Expression expression24 = expr;
        if (expression24 instanceof EventExpression) {
            void eExpr;
            EventExpression eventExpression = (EventExpression)expression24;
            EventExpression cfr_ignored_23 = (EventExpression)expression24;
            return eExpr.getEvent().hashCode();
        }
        Expression expression25 = expr;
        if (expression25 instanceof FieldExpression) {
            void fExpr;
            FieldExpression fieldExpression = (FieldExpression)expression25;
            FieldExpression cfr_ignored_24 = (FieldExpression)expression25;
            int rslt = 0x8000000;
            String fieldName = fExpr.getField().getName();
            if (fieldName != null) {
                rslt += fieldName.hashCode();
            }
            return rslt;
        }
        Expression expression26 = expr;
        if (expression26 instanceof StdLibFunctionExpression) {
            void slfExpr;
            StdLibFunctionExpression rslt = (StdLibFunctionExpression)expression26;
            StdLibFunctionExpression cfr_ignored_25 = (StdLibFunctionExpression)expression26;
            return slfExpr.getFunction().hashCode();
        }
        Expression expression27 = expr;
        if (expression27 instanceof FunctionExpression) {
            void fExpr;
            FunctionExpression functionExpression = (FunctionExpression)expression27;
            FunctionExpression cfr_ignored_26 = (FunctionExpression)expression27;
            return fExpr.getFunction().hashCode();
        }
        Expression expression28 = expr;
        if (expression28 instanceof InputVariableExpression) {
            void iExpr;
            InputVariableExpression inputVariableExpression = (InputVariableExpression)expression28;
            InputVariableExpression cfr_ignored_27 = (InputVariableExpression)expression28;
            return iExpr.getVariable().hashCode();
        }
        Expression expression29 = expr;
        if (expression29 instanceof ComponentExpression) {
            void cExpr;
            ComponentExpression componentExpression = (ComponentExpression)expression29;
            ComponentExpression cfr_ignored_28 = (ComponentExpression)expression29;
            return cExpr.getComponent().hashCode();
        }
        Expression expression30 = expr;
        if (expression30 instanceof CompParamExpression) {
            void cpExpr;
            CompParamExpression compParamExpression = (CompParamExpression)expression30;
            CompParamExpression cfr_ignored_29 = (CompParamExpression)expression30;
            return cpExpr.getParameter().hashCode();
        }
        Expression expression31 = expr;
        if (expression31 instanceof CompInstWrapExpression) {
            void ciwExpr;
            CompInstWrapExpression compInstWrapExpression = (CompInstWrapExpression)expression31;
            CompInstWrapExpression cfr_ignored_30 = (CompInstWrapExpression)expression31;
            return ciwExpr.getInstantiation().hashCode() + CifValueUtils.hashExpr(ciwExpr.getReference());
        }
        Expression expression32 = expr;
        if (expression32 instanceof CompParamWrapExpression) {
            void cpwExpr;
            CompParamWrapExpression compParamWrapExpression = (CompParamWrapExpression)expression32;
            CompParamWrapExpression cfr_ignored_31 = (CompParamWrapExpression)expression32;
            return cpwExpr.getParameter().hashCode() + CifValueUtils.hashExpr(cpwExpr.getReference());
        }
        if (expr instanceof ReceivedExpression) {
            return 0x40000000;
        }
        if (expr instanceof SelfExpression) {
            return Integer.MIN_VALUE;
        }
        throw new RuntimeException("Unexpected expression: " + expr.toString());
    }

    public static Expression createConjunction(List<Expression> exprs) {
        return CifValueUtils.createConjunction(exprs, false);
    }

    public static Expression createConjunction(List<Expression> exprs, boolean optimize) {
        if (exprs.isEmpty()) {
            return CifValueUtils.makeTrue();
        }
        BinaryOperator operator = BinaryOperator.CONJUNCTION;
        List flattenedChildren = CifValueUtils.flattenBinExpr(exprs, operator);
        if (optimize) {
            List children = Lists.listc((int)flattenedChildren.size());
            for (Expression child : flattenedChildren) {
                boolean add = true;
                if (child instanceof BoolExpression) {
                    boolean value = ((BoolExpression)child).isValue();
                    if (!value) {
                        return child;
                    }
                    add = false;
                }
                if (!add) continue;
                children.add(child);
            }
            if (children.isEmpty()) {
                return CifValueUtils.makeTrue();
            }
            flattenedChildren = children;
        }
        int treeSize = flattenedChildren.size();
        return CifValueUtils.createBalancedBinaryTree(flattenedChildren, 0, treeSize, operator);
    }

    public static Expression createDisjunction(List<Expression> exprs) {
        return CifValueUtils.createDisjunction(exprs, false);
    }

    public static Expression createDisjunction(List<Expression> exprs, boolean optimize) {
        if (exprs.isEmpty()) {
            return CifValueUtils.makeFalse();
        }
        BinaryOperator operator = BinaryOperator.DISJUNCTION;
        List flattenedChildren = CifValueUtils.flattenBinExpr(exprs, operator);
        if (optimize) {
            List children = Lists.listc((int)flattenedChildren.size());
            for (Expression child : flattenedChildren) {
                boolean add = true;
                if (child instanceof BoolExpression) {
                    boolean value = ((BoolExpression)child).isValue();
                    if (value) {
                        return child;
                    }
                    add = false;
                }
                if (!add) continue;
                children.add(child);
            }
            if (children.isEmpty()) {
                return CifValueUtils.makeFalse();
            }
            flattenedChildren = children;
        }
        int treeSize = flattenedChildren.size();
        return CifValueUtils.createBalancedBinaryTree(flattenedChildren, 0, treeSize, operator);
    }

    public static List<Expression> flattenBinExpr(List<Expression> exprs, BinaryOperator operator) {
        if (exprs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayDeque<Expression> todos = new ArrayDeque<Expression>(exprs);
        List children = Lists.listc((int)todos.size());
        while (!todos.isEmpty()) {
            BinaryExpression btodo;
            Expression todo = todos.pollFirst();
            if (todo instanceof BinaryExpression && (btodo = (BinaryExpression)todo).getOperator() == operator) {
                todos.addFirst(btodo.getRight());
                todos.addFirst(btodo.getLeft());
                continue;
            }
            children.add(todo);
        }
        return children;
    }

    public static Expression createBalancedBinaryTree(List<Expression> exprs, int lower, int upper, BinaryOperator operator) {
        Assert.check((lower < upper ? 1 : 0) != 0);
        if (lower + 1 == upper) {
            return exprs.get(lower);
        }
        int size = upper - lower;
        int left = size / 2;
        int mid = lower + left;
        BinaryExpression rslt = CifConstructors.newBinaryExpression();
        rslt.setOperator(operator);
        rslt.setType((CifType)CifConstructors.newBoolType());
        rslt.setLeft(CifValueUtils.createBalancedBinaryTree(exprs, lower, mid, operator));
        rslt.setRight(CifValueUtils.createBalancedBinaryTree(exprs, mid, upper, operator));
        return rslt;
    }

    public static Expression makeInverse(Expression expr) {
        UnaryExpression rslt = CifConstructors.newUnaryExpression();
        rslt.setOperator(UnaryOperator.INVERSE);
        rslt.setType((CifType)CifConstructors.newBoolType());
        rslt.setChild(expr);
        return rslt;
    }

    public static BoolExpression makeFalse() {
        BoolExpression rslt = CifConstructors.newBoolExpression();
        rslt.setValue(false);
        rslt.setType((CifType)CifConstructors.newBoolType());
        return rslt;
    }

    public static BoolExpression makeTrue() {
        BoolExpression rslt = CifConstructors.newBoolExpression();
        rslt.setValue(true);
        rslt.setType((CifType)CifConstructors.newBoolType());
        return rslt;
    }

    public static Expression makeInt(int value) {
        if (value == Integer.MIN_VALUE) {
            Expression left = CifValueUtils.makeInt(value + 1);
            Expression right = CifValueUtils.makeInt(1);
            IntType binType = CifConstructors.newIntType();
            binType.setLower(Integer.valueOf(value));
            binType.setUpper(Integer.valueOf(value));
            BinaryExpression bin = CifConstructors.newBinaryExpression();
            bin.setOperator(BinaryOperator.SUBTRACTION);
            bin.setLeft(left);
            bin.setRight(right);
            bin.setType((CifType)binType);
            return bin;
        }
        int absValue = Math.abs(value);
        IntType absType = CifConstructors.newIntType();
        absType.setLower(Integer.valueOf(absValue));
        absType.setUpper(Integer.valueOf(absValue));
        IntExpression absExpr = CifConstructors.newIntExpression();
        absExpr.setValue(absValue);
        absExpr.setType((CifType)absType);
        if (value >= 0) {
            return absExpr;
        }
        IntType unType = CifConstructors.newIntType();
        unType.setLower(Integer.valueOf(value));
        unType.setUpper(Integer.valueOf(value));
        UnaryExpression un = CifConstructors.newUnaryExpression();
        un.setOperator(UnaryOperator.NEGATE);
        un.setChild((Expression)absExpr);
        un.setType((CifType)unType);
        return un;
    }

    public static Expression makeReal(double value) {
        Assert.check((boolean)Double.isFinite(value));
        double absValue = Math.abs(value);
        RealExpression absExpr = CifConstructors.newRealExpression();
        absExpr.setValue(CifMath.realToStr(absValue));
        absExpr.setType((CifType)CifConstructors.newRealType());
        if (value >= 0.0) {
            return absExpr;
        }
        UnaryExpression un = CifConstructors.newUnaryExpression();
        un.setOperator(UnaryOperator.NEGATE);
        un.setChild((Expression)absExpr);
        un.setType((CifType)CifConstructors.newRealType());
        return un;
    }

    public static Expression makeTuple(List<Expression> elements, Position position) {
        Assert.check((!elements.isEmpty() ? 1 : 0) != 0);
        if (elements.size() == 1) {
            return (Expression)Lists.first(elements);
        }
        TupleType tupleType = CifConstructors.newTupleType();
        tupleType.setPosition(PositionUtils.copyPosition((Position)position));
        for (Expression element : elements) {
            Field field = CifConstructors.newField();
            field.setPosition(PositionUtils.copyPosition((Position)position));
            field.setType((CifType)EMFHelper.deepclone((EObject)element.getType()));
            tupleType.getFields().add((Object)field);
        }
        TupleExpression tuple = CifConstructors.newTupleExpression();
        tuple.setPosition(PositionUtils.copyPosition((Position)position));
        tuple.getFields().addAll(elements);
        tuple.setType((CifType)tupleType);
        return tuple;
    }

    public static Field getTupleProjField(ProjectionExpression pexpr) {
        int idx;
        Expression iexpr = pexpr.getIndex();
        if (iexpr instanceof FieldExpression) {
            return ((FieldExpression)iexpr).getField();
        }
        try {
            idx = (Integer)CifEvalUtils.eval(iexpr, false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
        CifType ctype = CifTypeUtils.normalizeType(pexpr.getChild().getType());
        return (Field)((TupleType)ctype).getFields().get(idx);
    }

    /*
     * WARNING - void declaration
     */
    public static int getTupleProjIndex(ProjectionExpression pexpr) {
        TupleType tupType = (TupleType)CifTypeUtils.normalizeType(pexpr.getChild().getType());
        Expression indexExpr = pexpr.getIndex();
        Expression expression = indexExpr;
        if (expression instanceof FieldExpression) {
            void fe;
            FieldExpression fieldExpression = (FieldExpression)expression;
            FieldExpression cfr_ignored_0 = (FieldExpression)expression;
            return tupType.getFields().indexOf((Object)fe.getField());
        }
        try {
            return (Integer)CifEvalUtils.eval(indexExpr, false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    public static double getPossibleValueCount(CifType type) {
        if ((type = CifTypeUtils.normalizeType(type)) instanceof BoolType) {
            return 2.0;
        }
        if (type instanceof RealType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof StringType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            return enumDecl.getLiterals().size();
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            int lower = CifTypeUtils.getLowerBound(itype);
            int upper = CifTypeUtils.getUpperBound(itype);
            return (double)upper - (double)lower + 1.0;
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            double ecnt = CifValueUtils.getPossibleValueCount(stype.getElementType());
            return Math.pow(2.0, ecnt);
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            double kcnt = CifValueUtils.getPossibleValueCount(dtype.getKeyType());
            double vcnt = CifValueUtils.getPossibleValueCount(dtype.getValueType());
            return Math.pow(vcnt + 1.0, kcnt);
        }
        if (type instanceof ListType) {
            int upper;
            ListType ltype = (ListType)type;
            double ecnt = CifValueUtils.getPossibleValueCount(ltype.getElementType());
            int lower = CifTypeUtils.getLowerBound(ltype);
            if (lower == (upper = CifTypeUtils.getUpperBound(ltype))) {
                return Math.pow(ecnt, lower);
            }
            if (Double.isInfinite(ecnt)) {
                return ecnt;
            }
            double cnt = CifValueUtils.expSum(ecnt, (double)upper + 1.0);
            if (lower > 0) {
                cnt -= CifValueUtils.expSum(ecnt, lower);
            }
            return cnt;
        }
        if (type instanceof TupleType) {
            double cnt = 1.0;
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                cnt *= CifValueUtils.getPossibleValueCount(field.getType());
            }
            return cnt;
        }
        if (type instanceof FuncType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof DistType) {
            return Double.POSITIVE_INFINITY;
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    public static double expSum(double n, double m) {
        Assert.check((n >= 0.0 || Double.isInfinite(n) ? 1 : 0) != 0);
        Assert.check((m >= 0.0 || Double.isInfinite(m) ? 1 : 0) != 0);
        return n == 1.0 ? m : (1.0 - Math.pow(n, m)) / (1.0 - n);
    }

    /*
     * Unable to fully structure code
     */
    public static List<Expression> getPossibleValues(CifType type) {
        block20: {
            if ((type = CifTypeUtils.normalizeType(type)) instanceof BoolType) {
                return Lists.list((Object[])new BoolExpression[]{CifValueUtils.makeFalse(), CifValueUtils.makeTrue()});
            }
            if (type instanceof EnumType) {
                enumDecl = ((EnumType)type).getEnum();
                lits = enumDecl.getLiterals();
                values = Lists.listc((int)lits.size());
                for (EnumLiteral lit : lits) {
                    litRef = CifConstructors.newEnumLiteralExpression();
                    litRef.setLiteral(lit);
                    litRef.setType((CifType)EMFHelper.deepclone((EObject)type));
                    values.add(litRef);
                }
                return values;
            }
            if (type instanceof IntType) {
                itype = (IntType)type;
                lower = CifTypeUtils.getLowerBound(itype);
                upper = CifTypeUtils.getUpperBound(itype);
                cnt = (long)upper - (long)lower + 1L;
                values = Lists.listc((int)((int)cnt));
                i = lower;
                while (i <= upper) {
                    values.add(CifValueUtils.makeInt(i));
                    ++i;
                }
                return values;
            }
            if (!(type instanceof ListType)) break block20;
            ltype = (ListType)type;
            elemValues = CifValueUtils.getPossibleValues(ltype.getElementType());
            lower = CifTypeUtils.getLowerBound(ltype);
            upper = CifTypeUtils.getUpperBound(ltype);
            lists = Lists.listc((int)((int)CifValueUtils.getPossibleValueCount(type)));
            if (lower == 0) {
                emptyList = CifConstructors.newListExpression();
                emptyList.setType((CifType)EMFHelper.deepclone((EObject)type));
                lists.add(emptyList);
            }
            elemsValues = Lists.listc((int)upper);
            len = lower;
            ** GOTO lbl59
            {
                elemsValues.add(elemValues);
                do {
                    if (elemsValues.size() < len) continue block2;
                    iter = new ListProductIterator(elemsValues);
                    while (iter.hasNext()) {
                        elems = iter.next();
                        array = CifConstructors.newListExpression();
                        for (Expression elem : elems) {
                            array.getElements().add((Object)((Expression)EMFHelper.deepclone((EObject)elem)));
                        }
                        array.setType((CifType)EMFHelper.deepclone((EObject)ltype));
                        lists.add(array);
                    }
                    ++len;
lbl59:
                    // 2 sources

                } while (len <= upper);
            }
            return lists;
        }
        if (type instanceof SetType) {
            stype = (SetType)type;
            elemValues = CifValueUtils.getPossibleValues(stype.getElementType());
            powerset = CifValueUtils.powerSet(elemValues);
            sets = Lists.listc((int)powerset.size());
            for (List<Expression> elems : powerset) {
                sets.add(CifConstructors.newSetExpression(elems, null, (CifType)((CifType)EMFHelper.deepclone((EObject)type))));
            }
            return sets;
        }
        if (type instanceof DictType) {
            dtype = (DictType)type;
            keyValues = CifValueUtils.getPossibleValues(dtype.getKeyType());
            valueValues = CifValueUtils.getPossibleValues(dtype.getValueType());
            powerset = CifValueUtils.powerSet(keyValues);
            dicts = Lists.listc((int)((int)CifValueUtils.getPossibleValueCount(type)));
            emptyDict = CifConstructors.newDictExpression();
            emptyDict.setType((CifType)EMFHelper.deepclone((EObject)type));
            dicts.add(emptyDict);
            for (List<Expression> keys : powerset) {
                if (keys.isEmpty()) continue;
                combis = Lists.listc((int)keys.size());
                i = 0;
                while (i < keys.size()) {
                    combis.add(EMFHelper.deepclone(valueValues));
                    ++i;
                }
                iter = new ListProductIterator(combis);
                while (iter.hasNext()) {
                    singleDict = CifConstructors.newDictExpression();
                    singleDict.setType((CifType)EMFHelper.deepclone((EObject)type));
                    values = iter.next();
                    i = 0;
                    while (i < keys.size()) {
                        key = (Expression)EMFHelper.deepclone((EObject)keys.get(i));
                        value = (Expression)EMFHelper.deepclone((EObject)((Expression)values.get(i)));
                        pair = CifConstructors.newDictPair((Expression)key, null, (Expression)value);
                        singleDict.getPairs().add((Object)pair);
                        ++i;
                    }
                    dicts.add(singleDict);
                }
            }
            return dicts;
        }
        if (type instanceof TupleType) {
            ttype = (TupleType)type;
            fieldsValues = Lists.listc((int)ttype.getFields().size());
            cnt = 1;
            for (Field field : ttype.getFields()) {
                fieldValues = CifValueUtils.getPossibleValues(field.getType());
                fieldsValues.add(fieldValues);
                cnt *= fieldValues.size();
            }
            values = Lists.listc((int)cnt);
            iter = new ListProductIterator(fieldsValues);
            while (iter.hasNext()) {
                elems = iter.next();
                values.add(CifValueUtils.makeTuple(EMFHelper.deepclone((List)elems), null));
            }
            return values;
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    private static List<List<Expression>> powerSet(List<Expression> set) {
        int cnt = (int)Math.pow(2.0, set.size());
        List powerset = Lists.listc((int)cnt);
        BitSet combinations = new BitSet(set.size());
        do {
            List singleSet = Lists.listc((int)combinations.cardinality());
            int i = 0;
            while (i < set.size()) {
                if (combinations.get(i)) {
                    singleSet.add((Expression)EMFHelper.deepclone((EObject)set.get(i)));
                }
                ++i;
            }
            powerset.add(singleSet);
        } while (CifValueUtils.incBitSet(combinations, set.size()));
        return powerset;
    }

    private static boolean incBitSet(BitSet bitset, int bitCnt) {
        int i = 0;
        while (i < bitCnt) {
            boolean b = bitset.get(i);
            bitset.set(i, !b);
            if (!b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isLiteralExpr(Expression expr) {
        UnaryExpression uexpr;
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof FunctionExpression) {
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.isLiteralExpr(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.isLiteralExpr(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.isLiteralExpr(pair.getKey())) {
                    return false;
                }
                if (CifValueUtils.isLiteralExpr(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                if (CifValueUtils.isLiteralExpr(field)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof UnaryExpression && (uexpr = (UnaryExpression)expr).getOperator() == UnaryOperator.NEGATE) {
            Expression child = uexpr.getChild();
            if (child instanceof IntExpression) {
                return ((IntExpression)child).getValue() >= 0;
            }
            if (child instanceof RealExpression) {
                return true;
            }
        }
        return false;
    }
}

