/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.CifVarInfoBuilder;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.MvSpecBuilder;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ControllerCheckDeterminismChecker {
    public List<String> problems = Lists.list();
    private final AppEnvData env = AppEnv.getData();

    public void check(Specification spec) {
        List variables = Lists.list();
        CifCollectUtils.collectDiscAndInputVariables((ComplexComponent)spec, (Collection)variables);
        boolean READINDEX = false;
        boolean WRITEINDEX = true;
        CifVarInfoBuilder cifVarInfoBuilder = new CifVarInfoBuilder(1);
        cifVarInfoBuilder.addVariablesGroupOnVariable(variables);
        MvSpecBuilder builder = new MvSpecBuilder(cifVarInfoBuilder, 0, 1);
        this.verifyDeterminism((Group)spec, builder);
        if (this.env.isTerminationRequested()) {
            return;
        }
        Collections.sort(this.problems, Strings.SORTER);
        if (!this.problems.isEmpty()) {
            String msg = "CIF controller properties check application failed due to unsatisfied preconditions:\n - " + String.join((CharSequence)"\n - ", this.problems);
            throw new UnsupportedException(msg);
        }
    }

    private void verifyDeterminism(Group group, MvSpecBuilder builder) {
        for (Component comp : group.getComponents()) {
            if (this.env.isTerminationRequested()) {
                return;
            }
            if (comp instanceof Automaton) {
                this.verifyDeterminism((Automaton)comp, builder);
                continue;
            }
            if (comp instanceof Group) {
                this.verifyDeterminism((Group)comp, builder);
                continue;
            }
            throw new RuntimeException("Unexpected type of Component.");
        }
    }

    private void verifyDeterminism(Automaton aut, MvSpecBuilder builder) {
        for (Location loc : aut.getLocations()) {
            this.verifyDeterminism(loc, builder);
            if (!this.env.isTerminationRequested()) continue;
            return;
        }
    }

    private void verifyDeterminism(Location loc, MvSpecBuilder builder) {
        Map edgesPredsByEvent = Maps.map();
        for (Edge edge : loc.getEdges()) {
            for (EdgeEvent ee : edge.getEvents()) {
                Expression eventExpr = ee.getEvent();
                Assert.check((boolean)(eventExpr instanceof EventExpression));
                Event event = ((EventExpression)eventExpr).getEvent();
                if (!event.getControllable().booleanValue()) continue;
                List edgesPreds = (List)edgesPredsByEvent.get(event);
                if (edgesPreds == null) {
                    edgesPreds = Lists.list();
                    edgesPredsByEvent.put(event, edgesPreds);
                }
                edgesPreds.add(edge.getGuards());
            }
            if (!this.env.isTerminationRequested()) continue;
            return;
        }
        for (Map.Entry entry : edgesPredsByEvent.entrySet()) {
            List edgeGuards = (List)entry.getValue();
            if (edgeGuards.size() == 1) continue;
            List edgeGuardNodes = Lists.listc((int)edgeGuards.size());
            for (List edgeGuard : edgeGuards) {
                Node edgeGuardNode = builder.getExpressionConvertor().convert(edgeGuard).get(1);
                edgeGuardNodes.add(edgeGuardNode);
                if (!this.env.isTerminationRequested()) continue;
                return;
            }
            int i = 0;
            while (i < edgeGuardNodes.size() - 1) {
                int j = i + 1;
                while (j < edgeGuardNodes.size()) {
                    Node n = builder.tree.conjunct((Node)edgeGuardNodes.get(i), (Node)edgeGuardNodes.get(j));
                    if (this.env.isTerminationRequested()) {
                        return;
                    }
                    if (n != Tree.ZERO) {
                        String msg = Strings.fmt((String)"Unsupported %s: non-determinism detected for edge of controllable event \"%s\" with overlapping guards.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
                        this.problems.add(msg);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

