/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ControllerCheckPreChecker
extends CifWalker {
    public Set<String> problems = Sets.set();

    public void check(Specification spec) {
        this.walkSpecification(spec);
        if (!this.problems.isEmpty()) {
            String msg = "CIF controller properties check application failed due to unsatisfied preconditions:\n - " + String.join((CharSequence)"\n - ", Sets.sortedstrings(this.problems));
            throw new UnsupportedException(msg);
        }
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        List invPreds = Lists.listc((int)comp.getInvariants().size());
        for (Invariant inv : comp.getInvariants()) {
            invPreds.add(inv.getPredicate());
        }
        if (!CifValueUtils.isTriviallyTrue((List)invPreds, (boolean)false, (boolean)true)) {
            String msg = Strings.fmt((String)"Unsupported %s: state invariants in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            this.problems.add(msg);
        }
    }

    protected void preprocessEdge(Edge edge) {
        if (edge.getEvents().isEmpty()) {
            this.problems.add("Unsupported event \"tau\": event is not controllable or uncontrollable (implicit use of \"tau\").");
        }
    }

    protected void preprocessAssignment(Assignment asgn) {
        if (asgn.getAddressable() instanceof TupleExpression) {
            Location loc = this.getContainingLocation((EObject)asgn);
            String msg = Strings.fmt((String)"Unsupported %s: edges with multi-assignments are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        } else if (asgn.getAddressable() instanceof ProjectionExpression) {
            Location loc = this.getContainingLocation((EObject)asgn);
            String msg = Strings.fmt((String)"Unsupported %s: edges with partial variable assignments are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
    }

    private Location getContainingLocation(EObject obj) {
        while (!(obj instanceof Location)) {
            obj = obj.eContainer();
        }
        return (Location)obj;
    }

    protected void preprocessLocation(Location loc) {
        List invPreds = Lists.listc((int)loc.getInvariants().size());
        for (Invariant inv : loc.getInvariants()) {
            invPreds.add(inv.getPredicate());
        }
        if (!CifValueUtils.isTriviallyTrue((List)invPreds, (boolean)false, (boolean)true)) {
            String msg = Strings.fmt((String)"Unsupported %s: state invariants in locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
    }

    protected void preprocessEvent(Event event) {
        String msg;
        if (event.getControllable() == null) {
            msg = Strings.fmt((String)"Unsupported event \"%s\": event is not declared as controllable or uncontrollable.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            this.problems.add(msg);
        }
        if (event.getType() != null) {
            msg = Strings.fmt((String)"Unsupported event \"%s\": event is a channel (has a data type).", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            this.problems.add(msg);
        }
    }

    protected void preprocessTauExpression(TauExpression obj) {
        this.problems.add("Unsupported event \"tau\": event is not controllable or uncontrollable (explicit use of \"tau\").");
    }

    protected void preprocessContVariable(ContVariable var) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": continuous variables are currently unsupported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        this.problems.add(msg);
    }

    protected void preprocessFunction(Function func) {
        String msg = Strings.fmt((String)"Unsupported function \"%s\": user-defined functions are currently unsupported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
        this.problems.add(msg);
    }

    protected void preprocessEquation(Equation eqn) {
        String msg = Strings.fmt((String)"Unsupported equation \"%s\": equations are currently unsupported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)eqn)});
        this.problems.add(msg);
    }

    protected void preprocessDictType(DictType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": dictionary types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessDistType(DistType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": distribution types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessFuncType(FuncType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": function types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessIntType(IntType type) {
        if (CifTypeUtils.isRangeless((IntType)type)) {
            String msg = Strings.fmt((String)"Unsupported type \"%s\": rangeless integer types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
            this.problems.add(msg);
        }
    }

    protected void preprocessListType(ListType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": list types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessRealType(RealType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": real types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessSetType(SetType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": set types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessStringType(StringType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": string types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessTupleType(TupleType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": tuple types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessBinaryExpression(BinaryExpression expr) {
        BinaryOperator op = expr.getOperator();
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: {
                return;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) break;
                return;
            }
            case MODULUS: 
            case INTEGER_DIVISION: 
            case MULTIPLICATION: 
            case SUBTRACTION: 
            case ADDITION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || !(rtype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)rtype))) break;
                return;
            }
            case EQUAL: 
            case UNEQUAL: {
                return;
            }
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || !(rtype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)rtype))) break;
                return;
            }
            case SUBSET: 
            case ELEMENT_OF: 
            case DIVISION: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown bin op: " + String.valueOf(op));
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": binary operator \"%s\" is currently not supported, or is not supported for the operands that are used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((BinaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessCastExpression(CastExpression expr) {
        CifType rtype;
        CifType ctype = expr.getChild().getType();
        if (CifTypeUtils.checkTypeCompat((CifType)ctype, (CifType)(rtype = expr.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": cast expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessDictExpression(DictExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": dictionary expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessFunctionCallExpression(FunctionCallExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": function calls are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessListExpression(ListExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": list expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessProjectionExpression(ProjectionExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": projection expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessRealExpression(RealExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": real number expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSetExpression(SetExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": set expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSliceExpression(SliceExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": slice expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessStringExpression(StringExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": string literal expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessTimeExpression(TimeExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": the use of variable \"time\" is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessTupleExpression(TupleExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": tuple expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessUnaryExpression(UnaryExpression expr) {
        UnaryOperator op = expr.getOperator();
        switch (op) {
            case INVERSE: {
                return;
            }
            case NEGATE: 
            case PLUS: {
                CifType ctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
                if (!(ctype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)ctype))) break;
                return;
            }
            case SAMPLE: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown un op: " + String.valueOf(op));
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": unary operator \"%s\" is currently not supported, or is not supported for the operand that is used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((UnaryOperator)op)});
        this.problems.add(msg);
    }
}

