/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.CifVarInfoBuilder;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.MvSpecBuilder;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.multivaluetrees.VarInfo;
import org.eclipse.escet.common.multivaluetrees.VarInfoBuilder;
import org.eclipse.escet.common.multivaluetrees.VariableReplacement;
import org.eclipse.escet.common.multivaluetrees.VariableReplacementsBuilder;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class PrepareChecks {
    public static final int ORIGINAL_INDEX = 0;
    public static final int READ_INDEX = 1;
    public static final int WRITE_INDEX = 2;
    private static final int NUM_INDICES = 3;
    private final AppEnvData env = AppEnv.getData();
    private List<Automaton> automata;
    private Set<Event> controllableEvents = Sets.set();
    private List<Declaration> variables;
    private Map<Event, Node> globalGuardsByEvent = Maps.map();
    private Map<Event, Node> globalGuardedUpdatesByEvent;
    private Map<Event, Set<Declaration>> updatedVariablesByEvent = Maps.map();
    private MvSpecBuilder builder;

    public PrepareChecks(boolean computeGlobalGuardedUpdates) {
        this.globalGuardedUpdatesByEvent = computeGlobalGuardedUpdates ? Maps.map() : null;
    }

    public boolean compute(Specification spec) {
        this.automata = (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list());
        Set allControllableEvents = (Set)CifCollectUtils.collectControllableEvents((ComplexComponent)spec, (Collection)Sets.set());
        if (this.automata.isEmpty() || allControllableEvents.isEmpty()) {
            return true;
        }
        this.variables = (List)CifCollectUtils.collectDiscAndInputVariables((ComplexComponent)spec, (Collection)Lists.list());
        if (this.env.isTerminationRequested()) {
            return false;
        }
        CifVarInfoBuilder cifVarInfoBuilder = new CifVarInfoBuilder(3);
        cifVarInfoBuilder.addVariablesGroupOnVariable(this.variables);
        this.builder = new MvSpecBuilder(cifVarInfoBuilder, 1, 2);
        if (this.env.isTerminationRequested()) {
            return false;
        }
        for (Automaton aut : this.automata) {
            OutputProvider.dbg((String)"Analyzing %s...", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)aut)});
            Set controllableAutEvents = Sets.intersection((Set)CifEventUtils.getAlphabet((Automaton)aut), (Set)allControllableEvents);
            if (controllableAutEvents.isEmpty() || this.processAutomaton(aut, controllableAutEvents)) continue;
            return false;
        }
        return true;
    }

    private boolean processAutomaton(Automaton aut, Set<Event> controllableAutEvents) {
        Tree tree = this.builder.tree;
        Map autGuards = Maps.mapc((int)controllableAutEvents.size());
        Map autGuardedUpdates = this.globalGuardedUpdatesByEvent == null ? null : Maps.mapc((int)controllableAutEvents.size());
        OutputProvider.idbg();
        for (Event evt : controllableAutEvents) {
            OutputProvider.dbg((String)"Initializing the automaton data for event \"%s\"...", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)evt)});
            autGuards.put(evt, Tree.ZERO);
            if (autGuardedUpdates != null) {
                autGuardedUpdates.put(evt, Tree.ZERO);
            }
            if (!this.controllableEvents.contains(evt)) {
                this.controllableEvents.add(evt);
                this.globalGuardsByEvent.put(evt, Tree.ONE);
                if (this.globalGuardedUpdatesByEvent != null) {
                    this.globalGuardedUpdatesByEvent.put(evt, Tree.ONE);
                }
                this.updatedVariablesByEvent.put(evt, Sets.set());
            }
            if (!this.env.isTerminationRequested()) continue;
            OutputProvider.ddbg();
            return false;
        }
        for (Location loc : aut.getLocations()) {
            OutputProvider.dbg((String)"Processing edges from %s...", (Object[])new Object[]{CifTextUtils.getLocationText2((Location)loc)});
            for (Edge edge : loc.getEdges()) {
                Node guardedUpdate;
                Set controllableEdgeEvents = Sets.intersection((Set)CifEventUtils.getEvents((Edge)edge), controllableAutEvents);
                if (controllableEdgeEvents.isEmpty()) continue;
                Node guard = this.computeGuard(edge);
                if (this.env.isTerminationRequested()) {
                    OutputProvider.ddbg();
                    return false;
                }
                Node update = this.computeUpdate(edge, controllableEdgeEvents);
                if (this.env.isTerminationRequested()) {
                    OutputProvider.ddbg();
                    return false;
                }
                Node node = guardedUpdate = autGuardedUpdates == null ? null : tree.conjunct(guard, update);
                if (this.env.isTerminationRequested()) {
                    OutputProvider.ddbg();
                    return false;
                }
                for (Event evt : controllableEdgeEvents) {
                    Node autGuard = (Node)autGuards.get(evt);
                    autGuards.put(evt, tree.disjunct(autGuard, guard));
                    if (this.env.isTerminationRequested()) {
                        OutputProvider.ddbg();
                        return false;
                    }
                    if (autGuardedUpdates == null) continue;
                    Node autGuardedUpdate = (Node)autGuardedUpdates.get(evt);
                    autGuardedUpdates.put(evt, tree.disjunct(autGuardedUpdate, guardedUpdate));
                    if (!this.env.isTerminationRequested()) continue;
                    OutputProvider.ddbg();
                    return false;
                }
            }
        }
        for (Event autEvent : controllableAutEvents) {
            OutputProvider.dbg((String)"Updating global guards and updates for event \"%s\"...", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)autEvent)});
            Node globGuard = this.globalGuardsByEvent.get(autEvent);
            this.globalGuardsByEvent.put(autEvent, tree.conjunct(globGuard, (Node)autGuards.get(autEvent)));
            if (this.env.isTerminationRequested()) {
                OutputProvider.ddbg();
                return false;
            }
            if (autGuardedUpdates == null || this.globalGuardedUpdatesByEvent == null) continue;
            Node globalGuardedUpdate = this.globalGuardedUpdatesByEvent.get(autEvent);
            this.globalGuardedUpdatesByEvent.put(autEvent, tree.conjunct(globalGuardedUpdate, (Node)autGuardedUpdates.get(autEvent)));
            if (!this.env.isTerminationRequested()) continue;
            OutputProvider.ddbg();
            return false;
        }
        OutputProvider.ddbg();
        return true;
    }

    private Node computeGuard(Edge edge) {
        Node guard = Tree.ONE;
        for (Expression grd : edge.getGuards()) {
            Node node = this.builder.getExpressionConvertor().convert(grd).get(1);
            if (this.env.isTerminationRequested()) {
                return guard;
            }
            guard = this.builder.tree.conjunct(guard, node);
            if (!this.env.isTerminationRequested()) continue;
            return guard;
        }
        return guard;
    }

    private Node computeUpdate(Edge edge, Set<Event> controllableEdgeEvents) {
        Tree tree = this.builder.tree;
        Node updateNode = this.globalGuardedUpdatesByEvent == null ? null : Tree.ONE;
        Set assignedVariables = Sets.set();
        for (Update upd : edge.getUpdates()) {
            Assert.check((boolean)(upd instanceof Assignment));
            Assignment asg = (Assignment)upd;
            Assert.check((boolean)(asg.getAddressable() instanceof DiscVariableExpression));
            DiscVariable lhs = ((DiscVariableExpression)asg.getAddressable()).getVariable();
            assignedVariables.add(lhs);
            if (updateNode == null) continue;
            Node asgNode = this.builder.getExpressionConvertor().convertAssignment((Declaration)lhs, asg.getValue());
            if (this.env.isTerminationRequested()) {
                return updateNode;
            }
            updateNode = tree.conjunct(updateNode, asgNode);
            if (!this.env.isTerminationRequested()) continue;
            return updateNode;
        }
        if (updateNode != null) {
            for (Declaration otherVariable : this.variables) {
                if (assignedVariables.contains(otherVariable)) continue;
                VarInfo[] vinfos = this.builder.cifVarInfoBuilder.getVarInfos(otherVariable);
                updateNode = tree.conjunct(updateNode, tree.identity(vinfos[1], vinfos[2]));
                if (!this.env.isTerminationRequested()) continue;
                return updateNode;
            }
        }
        for (Event evt : controllableEdgeEvents) {
            this.updatedVariablesByEvent.get(evt).addAll(assignedVariables);
        }
        return updateNode;
    }

    public VariableReplacement[] createVarUpdateReplacements() {
        VariableReplacementsBuilder replBuilder = new VariableReplacementsBuilder((VarInfoBuilder)this.builder.cifVarInfoBuilder);
        for (Declaration updatedVar : this.variables) {
            replBuilder.addReplacement((Object)updatedVar, 1, 2);
        }
        return replBuilder.getReplacements();
    }

    public Node computeOriginalToReadIdentity() {
        Node result = Tree.ONE;
        int idx = this.variables.size() - 1;
        while (idx >= 0) {
            VarInfo[] vinfos = this.builder.cifVarInfoBuilder.getVarInfos(this.variables.get(idx));
            result = this.builder.tree.identity(vinfos[0], vinfos[1], result);
            if (this.env.isTerminationRequested()) {
                return result;
            }
            --idx;
        }
        return result;
    }

    public VarInfo[] getNonOriginalVariables() {
        int numVariables = this.builder.cifVarInfoBuilder.varInfos.size() / 3;
        VarInfo[] nonOriginalsVarInfos = new VarInfo[numVariables * 2];
        int nextFree = 0;
        for (VarInfo vinfo : this.builder.cifVarInfoBuilder.varInfos) {
            if (vinfo == null || vinfo.useKind == 0) continue;
            nonOriginalsVarInfos[nextFree] = vinfo;
            ++nextFree;
        }
        Assert.areEqual((Object)nextFree, (Object)nonOriginalsVarInfos.length);
        return nonOriginalsVarInfos;
    }

    public List<Automaton> getAutomata() {
        return Collections.unmodifiableList(this.automata);
    }

    public Set<Event> getControllableEvents() {
        return Collections.unmodifiableSet(this.controllableEvents);
    }

    public Map<Event, Node> getGlobalGuardsByEvent() {
        return Collections.unmodifiableMap(this.globalGuardsByEvent);
    }

    public Map<Event, Node> getGlobalGuardedUpdatesByEvent() {
        if (this.globalGuardedUpdatesByEvent == null) {
            throw new IllegalStateException("Computing global guarded updates is disabled.");
        }
        return Collections.unmodifiableMap(this.globalGuardedUpdatesByEvent);
    }

    public Map<Event, Set<Declaration>> getUpdatedVariablesByEvent() {
        return Collections.unmodifiableMap(this.updatedVariablesByEvent);
    }

    public MvSpecBuilder getBuilder() {
        return this.builder;
    }
}

