/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.confluence;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.PrepareChecks;
import org.eclipse.escet.cif.controllercheck.confluence.ConfluenceCheckConclusion;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.MvSpecBuilder;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.multivaluetrees.VarInfo;
import org.eclipse.escet.common.multivaluetrees.VariableReplacement;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ConfluenceChecker {
    private static final boolean DEBUG_GLOBAL = false;
    private static final boolean DEBUG_INDENPENCE = false;
    private static final boolean DEBUG_REVERSIBLE = false;
    private static final boolean DEBUG_UPDATE_EQUIVALENCE = false;
    private final AppEnvData env = AppEnv.getData();
    private Map<Event, Node> globalGuardsByEvent;
    private Map<Event, Node> globalGuardedUpdatesByEvent;
    private VariableReplacement[] varReplacements;
    private Node origToReadVariablesRelations;
    private VarInfo[] nonOriginalVarInfos;
    private MvSpecBuilder builder;

    public CheckConclusion checkSystem(PrepareChecks prepareChecks) {
        List<Automaton> automata = prepareChecks.getAutomata();
        Set<Event> controllableEvents = prepareChecks.getControllableEvents();
        if (automata.isEmpty() || controllableEvents.isEmpty()) {
            return new ConfluenceCheckConclusion(List.of());
        }
        this.globalGuardsByEvent = prepareChecks.getGlobalGuardsByEvent();
        this.globalGuardedUpdatesByEvent = prepareChecks.getGlobalGuardedUpdatesByEvent();
        this.varReplacements = prepareChecks.createVarUpdateReplacements();
        this.origToReadVariablesRelations = prepareChecks.computeOriginalToReadIdentity();
        this.nonOriginalVarInfos = prepareChecks.getNonOriginalVariables();
        this.builder = prepareChecks.getBuilder();
        Tree tree = this.builder.tree;
        List mutualExclusives = Lists.list();
        List updateEquivalents = Lists.list();
        List independents = Lists.list();
        List skippables = Lists.list();
        List reversibles = Lists.list();
        List cannotProves = Lists.list();
        Set skipInner = Sets.setc((int)this.globalGuardsByEvent.size());
        for (Map.Entry<Event, Node> entry1 : this.globalGuardsByEvent.entrySet()) {
            Event event1 = entry1.getKey();
            String evt1Name = CifTextUtils.getAbsName((PositionObject)event1);
            Node globalGuard1 = entry1.getValue();
            Node globalUpdate1 = this.globalGuardedUpdatesByEvent.get(event1);
            skipInner.add(event1);
            for (Map.Entry<Event, Node> entry2 : this.globalGuardsByEvent.entrySet()) {
                Node event21Done;
                Node event12Done;
                Event event2 = entry2.getKey();
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                if (skipInner.contains(event2)) continue;
                String evt2Name = CifTextUtils.getAbsName((PositionObject)event2);
                Node globalGuard2 = entry2.getValue();
                Node globalUpdate2 = this.globalGuardedUpdatesByEvent.get(event2);
                Node commonEnabledGuards = tree.conjunct(globalGuard1, globalGuard2);
                if (commonEnabledGuards == Tree.ZERO) {
                    mutualExclusives.add(this.makeSortedPair(evt1Name, evt2Name));
                    continue;
                }
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                commonEnabledGuards = tree.conjunct(this.origToReadVariablesRelations, commonEnabledGuards);
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                Node originalStates = tree.variableAbstractions(commonEnabledGuards, this.nonOriginalVarInfos);
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                Node event1Done = this.performEdge(commonEnabledGuards, globalUpdate1);
                Node event2Done = this.performEdge(commonEnabledGuards, globalUpdate2);
                if (event1Done != Tree.ZERO && event1Done == event2Done && this.allStateCovered(originalStates, event1Done)) {
                    updateEquivalents.add(this.makeSortedPair(evt1Name, evt2Name));
                    continue;
                }
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                Node event1Enabled2 = tree.conjunct(event1Done, globalGuard2);
                Node node = event12Done = event1Enabled2 == Tree.ZERO ? Tree.ZERO : this.performEdge(event1Enabled2, globalUpdate2);
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                Node event2Enabled1 = tree.conjunct(event2Done, globalGuard1);
                Node node2 = event21Done = event2Enabled1 == Tree.ZERO ? Tree.ZERO : this.performEdge(event2Enabled1, globalUpdate1);
                if (event12Done != Tree.ZERO && event12Done == event21Done && this.allStateCovered(originalStates, event12Done)) {
                    independents.add(this.makeSortedPair(evt1Name, evt2Name));
                    continue;
                }
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                if (event21Done != Tree.ZERO && event1Done == event21Done && this.allStateCovered(originalStates, event1Done)) {
                    skippables.add(this.makeSortedPair(evt1Name, evt2Name));
                    continue;
                }
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                if (event12Done != Tree.ZERO && event2Done == event12Done && this.allStateCovered(originalStates, event2Done)) {
                    skippables.add(this.makeSortedPair(evt1Name, evt2Name));
                    continue;
                }
                if (this.env.isTerminationRequested()) {
                    return null;
                }
                boolean foundReversible = false;
                for (Map.Entry<Event, Node> entry3 : this.globalGuardsByEvent.entrySet()) {
                    Event event3 = entry3.getKey();
                    if (event3 == event1 || event3 == event2) continue;
                    if (this.env.isTerminationRequested()) {
                        return null;
                    }
                    Node globalGuard3 = entry3.getValue();
                    Node globalUpdate3 = this.globalGuardedUpdatesByEvent.get(event3);
                    if (event21Done != Tree.ZERO) {
                        Node event213Done;
                        Node event21Enabled3 = tree.conjunct(event21Done, globalGuard3);
                        Node node3 = event213Done = event21Enabled3 == Tree.ZERO ? Tree.ZERO : this.performEdge(event21Enabled3, globalUpdate3);
                        if (event213Done != Tree.ZERO && event213Done == event1Done && this.allStateCovered(originalStates, event1Done)) {
                            foundReversible = true;
                            break;
                        }
                    }
                    if (this.env.isTerminationRequested()) {
                        return null;
                    }
                    if (event12Done != Tree.ZERO) {
                        Node event123Done;
                        Node event12Enabled3 = tree.conjunct(event12Done, globalGuard3);
                        Node node4 = event123Done = event12Enabled3 == Tree.ZERO ? Tree.ZERO : this.performEdge(event12Enabled3, globalUpdate3);
                        if (event123Done != Tree.ZERO && event123Done == event2Done && this.allStateCovered(originalStates, event2Done)) {
                            foundReversible = true;
                            break;
                        }
                    }
                    if (!this.env.isTerminationRequested()) continue;
                    return null;
                }
                if (foundReversible) {
                    reversibles.add(this.makeSortedPair(evt1Name, evt2Name));
                    continue;
                }
                cannotProves.add(this.makeSortedPair(evt1Name, evt2Name));
            }
        }
        if (this.env.isTerminationRequested()) {
            return null;
        }
        this.dumpMatches(mutualExclusives, "Mutual exclusive event pairs");
        this.dumpMatches(updateEquivalents, "Update equivalent event pairs");
        this.dumpMatches(independents, "Independent event pairs");
        this.dumpMatches(skippables, "Skippable event pairs");
        this.dumpMatches(reversibles, "Reversible event pairs");
        return new ConfluenceCheckConclusion(cannotProves);
    }

    private Node performEdge(Node state, Node update) {
        return this.builder.tree.adjacentReplacements(this.builder.tree.conjunct(state, update), this.varReplacements);
    }

    private boolean allStateCovered(Node originalStates, Node resultStates) {
        Node orignalResultStates = this.builder.tree.variableAbstractions(resultStates, this.nonOriginalVarInfos);
        return originalStates == orignalResultStates;
    }

    private Pair<String, String> makeSortedPair(String evt1Name, String evt2Name) {
        if (Strings.SORTER.compare(evt1Name, evt2Name) < 0) {
            return new Pair((Object)evt1Name, (Object)evt2Name);
        }
        return new Pair((Object)evt2Name, (Object)evt1Name);
    }

    private void dumpMatches(List<Pair<String, String>> pairs, String reasonText) {
        if (pairs.isEmpty()) {
            return;
        }
        pairs.sort(Comparator.comparing(p -> (String)p.left, Strings.SORTER).thenComparing(p -> (String)p.right, Strings.SORTER));
        OutputProvider.out();
        OutputProvider.out((String)(reasonText + ":"));
        OutputProvider.iout();
        OutputProvider.out((String)pairs.stream().map(Pair::toString).collect(Collectors.joining(", ")));
        OutputProvider.dout();
    }
}

